/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import org.catacombae.hfsexplorer.types.hfs.ExtKeyRec;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTIndexNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTIndexRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonHFSExtentIndexNode
extends CommonBTIndexNode<CommonHFSExtentKey> {
    protected CommonHFSExtentIndexNode(byte[] data, int offset, int nodeSize, CommonBTNode.FSType type) {
        super(data, offset, nodeSize, type);
    }

    public static CommonHFSExtentIndexNode createHFS(byte[] data, int offset, int nodeSize) {
        return new HFSImplementation(data, offset, nodeSize);
    }

    public static CommonHFSExtentIndexNode createHFSPlus(byte[] data, int offset, int nodeSize) {
        return new HFSPlusImplementation(data, offset, nodeSize);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HFSPlusImplementation
    extends CommonHFSExtentIndexNode {
        public HFSPlusImplementation(byte[] data, int offset, int nodeSize) {
            super(data, offset, nodeSize, CommonBTNode.FSType.HFS_PLUS);
        }

        @Override
        protected CommonBTIndexRecord<CommonHFSExtentKey> createBTRecord(int recordNumber, byte[] data, int offset, int length) {
            CommonHFSExtentKey key = CommonHFSExtentKey.create(new HFSPlusExtentKey(data, offset));
            return CommonBTIndexRecord.createHFSPlus(key, data, offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HFSImplementation
    extends CommonHFSExtentIndexNode {
        public HFSImplementation(byte[] data, int offset, int nodeSize) {
            super(data, offset, nodeSize, CommonBTNode.FSType.HFS);
        }

        @Override
        protected CommonBTIndexRecord<CommonHFSExtentKey> createBTRecord(int recordNumber, byte[] data, int offset, int length) {
            CommonHFSExtentKey key = CommonHFSExtentKey.create(new ExtKeyRec(data, offset));
            return CommonBTIndexRecord.createHFS(key, data, offset);
        }
    }
}

