# Ghidra 12.0.3 Change History (February 2026)

### New Features
* _Listing_. In order to mitigate possible security risks, auto comments will not longer render annotations in such a way as to make them valid annotation links.  Normal comments will continue to work as usual. (GP-6414)

### Improvements
* _Demangler_. The __Demangler GNU__ analyzer now has a timeout option. (GP-6408)
* _GUI_. Corrected Ghidra GUI to fail-fast in headless environment and avoid stack traces. (GP-6399)
* _Listing_. The `@execute` annotation is no longer supported. (GP-6413)

### Bugs
* _Data Types_. Corrected multi-user merge issues related to non-packed structures which could negatively affect merge results. (GP-6320, Issue #8776)
* _Debugger_. Fixed a `NullPointerException` that could occur upon closing the Debugger. (GP-6376)
* _Debugger:Breakpoints_. Fixed an issue where restarting a target (e.g., the `run` command from GDB's CLI) caused duplicate breakpoint entries and GUI glitches. (GP-6027)
* _Decompiler_. Fixed _"PTRSUB off of non structured pointer type"_ exceptions caused by `void *` data-type. (GP-6388, Issue #8887)
* _Decompiler_. Fixed source of _"Forced merge caused intersection"_ exceptions when decompiling optimized string copies. (GP-6393, Issue #8651)
* _Multi-User_. Revised Ghidra Server self-signed certificate generation to include all associated FQDNs and IP addresses as subject alternative names.  This will address the forced hostname check imposed with the release of JDK 21.0.10.  To benefit from this change the Ghidra Server will need to be upgraded to this release.  A client-side workaround is to set the following JVM property within `support/launch.properties` by adding the line: `VMARGS=-Djdk.rmi.ssl.client.enableEndpointIdentification=false`. (GP-6426, Issue #8940)
* _Processors_. Fixed bug in AARCH64 `sha1h` instruction to shift instead of rotate bits. (GP-4501, Issue #6398)
* _Processors_. Fixed 80251 disassembly errors for instructions referencing the SPX register. (GP-5905, Issue #8395)
* _Processors_. Fixed disassembly of MIPS16e2 `lui` instruction to only parse on extended words. (GP-6419)
* _Search_. Fixed a memory leak in the `Find References...` action. (GP-6395, Issue #8921)

### Notable API Changes
* _Data Types_. (GP-6320) Structure offset-based insert methods `Structure.insertAtOffset` will now skip forward over existing zero-length components at the insert offset before performing insert of new component.

# Ghidra 12.0.2 Change History (January 2026)

### New Features
* _Emulator_. Fixed the Emulator's evaluation of `inst_next2`. (GP-6134, Issue #8646)

### Improvements
* _Basic Infrastructure_. Upgraded `commons-lang3` , `log4j`, and `postgresql` jars. (GP-6243)
* _Debugger_. Several Address and Value columns are now displayed in fixed-width font: Register Value, Stack PC, Snapshot PC, and Watch Value. (GP-6025)
* _Debugger:Breakpoints_. Added __Expression__ column to __Breakpoints__ locations table. (GP-6026)
* _Documentation_. Updated Debugger tutorial to reflect the addition of the Comment column to the Watches panel, and the moving of the schedule display to trace tabs instead of the Threads panel title bar. (GP-6032)
* _Extensions_. Fixed a potential zip path traversal vulnerability when unzipping Ghidra Extension archives. (GP-6354)
* _Multi-User_. Upgraded yajsw to 13.18. (GP-6364)

### Bugs
* _Data Types_. Corrected a Union update notification issue which impacted proper archive sync indicators and related operations. (GP-6359, Issue #8884)
* _Debugger_. Fixed missing __Dynamic Listing__ entry in Window menu, when the Dynamic Listing is closed. (GP-6086, Issue #8604)
* _Debugger:Emulator_. Fixed a silent infinite-read loop during some situations in an emulator forked from a live target. (GP-6340)
* _Demangler_. Fixed Gnu Demangler failure to parse a global guard variable. (GP-6371, Issue #8900)
* _GUI_. Updated the Symbol Tree's filter to fix an issue that sometimes caused it to not get painted. (GP-6366, Issue #2448)
* _Processors_. Corrected AARCH64 `ldapr` instruction semantics to properly read memory. (GP-6358, Issue #6593)
* _Processors_. Corrected PowerPC VLE `se_blrl` instruction semantics. (GP-6379, Issue #6207)
* _Processors_. Corrected issue with ARM `ldrexd` instruction when the operands are the same register. (GP-6381, Issue #6590)

### Notable API Changes
* _Debugger:Emulator_. (GP-6340) Removed `PcodeTraceDataAccess.intersectUnknown` in favor of `intersectViewKnown` with sutract.
* _Emulator_. (GP-6134) Added `InstructionPrototype.hasNext2Dependency()`.

# Ghidra 12.0.1 Change History (January 2026)

### Improvements
* _Build_. Upgraded Ghidra's local copies of the `packaging`, `setuptools`, and `wheel` Python wheels. (GP-6284, Issue #8852)
* _CodeBrowser_. Fixed an issue with stack depth following across indirect function calls which would occur in windows external indirect calls. (GP-6315, Issue #8837)
* _Debugger:Emulator_. The emulator will now use the nearest snapshot, allowing it to resume more quickly after restarting Ghidra. (GP-6236, Issue #8767)
* _Debugger:Time_. Invalidated rows in Time Panel are now displayed in gray. This is to indicate that navigating to it will require re-emulation. (GP-6244)
* _Decompiler_. Added abstract interpretation via the Software and System Verification (SSV) group @ Università Ca' Foscari's Library for Static Analysis (LiSA).  This capability was meant for the previous release, as noted in the 12.0 Change History. (GP-6225)

### Bugs
* _Assembler_. Fixed issue preventing some PPC VLE instructions from assembling. (GP-6109, Issue #8624)
* _Assembler_. Fixed an issue with Assembler corrupting instructions that followed, especially when ISA mode is involved. (GP-6295, Issue #8826)
* _Debugger:Emulator_. Fixed some crash cases in Taint emulator regarding mismatched op sizes. (GP-6287)
* _Debugger:Emulator_. Fixed issues in P-code Stepper: Uniques table crashed if unique was not yet written. Stepping backward emptied p-code listing and uniques table. (GP-6294)
* _Debugger:Emulator_. Fixed a `NullPointerException` in the emulation service when forking from a live target. (GP-6298)
* _Decompiler_. Fixed a Decompiler bug that caused _"Deleting op with descendants"_ exceptions. (GP-6090, Issue #8594)
* _Decompiler_. Fixed Decompiler bug that occurred when splitting LOAD and STORE operations of laned registers. (GP-6130, Issue #8620)
* _Decompiler_. Fixed bug preventing the display of a nested field access when using an offset pointer. (GP-6133, Issue #8630)
* _Decompiler_. Fixed a Decompiler regression that caused _"Free varnode has multiple descendants"_ exceptions. (GP-6201, Issue #8743)
* _Decompiler_. Fixed a bug in the Decompiler producing _"PTRSUB off of non structured pointer type"_ exceptions. (GP-6224, Issue #8745)
* _Emulator_. Corrected regression error to pcode emulation for cases where named pcodeops were used (i.e., CALLOTHER pcodeop) and argument indexing within the java pcode implementation was incorrect. (GP-6229)
* _Emulator_. Fixed crash seen in P-code Stepper when reading a unique varnode before it is written. (GP-6253)
* _GUI_. Fixed a `NullPointerException` in function graph middle-mouse highlighter. (GP-6254, Issue #8798)
* _Importer:ELF_. Corrected improper ELF relocation processing for PowerPC-32 types `R_PPC_ADDR16_HA(6)` and `R_PPC_ADDR16_LO(4)`. (GP-6329)
* _Listing_. Fixed a Listing bug that caused text, copied from the memory block header, to be off by one character. (GP-6263, Issue #8797)
* _Processors_. Fixed operand consistency issue in M68000 processor. (GP-5334, Issue #4358)
* _Scripting_. Fixed issue in `RecoverClassesFromRTTIScript` where it could get into an infinite loop if the option to shorten template names in structures is set and there are exact template names in multiple parent namespaces. (GP-6183, Issue #8199)
* _Scripting_. Fixed a PyGhidra `AttributeError` when performing a `from pyghidra import *`. (GP-6241, Issue #8789)
* _Scripting_. Released PyGhidra 3.0.2, which contains fixes to `pyghidra.analysis_properties()` and exceptions being inadvertently squashed by some API functions. (GP-6283, Issue #8018)
* _Scripting_. PyGhidra should now always exit the Python processes cleanly, no longer being kept alive by a potentially running task monitor timer. (GP-6301, Issue #8858)
* _Sleigh_. Corrected Sleigh compiler regression error affecting unique subpiece semantics for certain cases which produced invalid unique varnode offsets. (GP-6237, Issue #8784)
* _Terminal_. Implemented `repeat the preceding graphics character (REP)` (`CSI Ps b`) terminal code logic, as such sequences were breaking the Terminal. (GP-6191)

### Notable API Changes
* _BSim_. (GP-6250) The `ghidra.net.ApplicationSSLSocketFactory` has been replaced by `ghidra.net.DefaultSSLSocketFactory`.  This is currently used by BSim when communicating with a <I>postgresql</I> server.
* _Debugger:Emulator_. (GP-6236) Added `TraceTimeManager.findSnapshotWithNearestPrefix()`. Several new methods in `TraceSchedule`, including: `hasPSteps`, `stepCount`, `dropLastStep`, `lastStep`, `truncateToSteps`.
* _Debugger:Emulator_. (GP-6298) Added `TraceSnapshot.isSnapOnly()` and `.isStale()`.
* _Emulator_. (GP-6229) The emulation support method for CALLOTHER `OpBehaviorOther.evaluate` implementations has dropped the first input varnode which was used to identify the `OpBehaviorOther` implementation.  Only the inputs which are specified by the arguments passed to the named pcodeop within the slapsec are now passed to this method.  NOTE: The actual API change occurred within Ghidra 11.3 with GP-4643 change.

# Ghidra 12.0 Change History (December 2025)

### New Features
* _Data Types_. Added `RGB16` and `RGB32` Color primitive datatypes which have been implemented as unsigned integer types and will render a color patch for Data within the Listing.  These default, respectively, to `RGB_565` and `ARGB_8888` encodings but can adopt a different RGB Encoding through the use of a Typedef and a default Setting. (GP-4310, Issue #6191)
* _Decompiler_. Implemented low-pcode-based abstract interpretation via the Università Ca’ Foscari's Library for Static Analysis (LiSA). (GP-5566)
* _Emulator_. Added an experimental Z3 Symbolic emulator with a summarization GUI. This feature is distributed as an installable extension. (GP-5727)
* _FileSystems_. Add support for zstd compression in GFileSystem via user-provided zstd or 7-Zip command line tools. (GP-5842)
* _Graphing_. Added a Function Graph tab to the Function Comparison widget.   This allows users to see two functions side-by-side in Function Graph views, such as when viewing BSim functions. (GP-3648, Issue #1154)
* _Graphing_. Created a new prototype __Data Graph__ graphing feature with nodes that display data structures and values and edges that link one data structure to another via a pointer reference. (GP-5481)
* _GUI_. Updated the Xrefs Table to allow the user to delete references to the current location. (GP-2140, Issue #4317)
* _GUI_. Added a shared project repository connection status indicator to the root node of the project data tree.   A popup menu action was also added to the root node allowing the connection to be established when in a disconnected state. (GP-5333)
* _GUI_. Added ability to toggle the displaying of function variables (parameters and locals) that are normally displayed just below the function signature. The variables display can be turned on/off globally or individually per function. (GP-5886, Issue #8385)
* _Importer_. Created an importer for the Decompiler debug format which is produced by the Decompiler. (GP-3947)
* _Importer_. Added an option to mirror the local filesystem when importing programs and their libraries. Programs and libraries that exist on the local filesystem as symbolic links will have both their corresponding link file and resolved program file mirrored in the project. (GP-5343, Issue #7430)
* _Importer_. Added a new loader for HP-UX PA-RISC __System Object Module__ (SOM) binaries. (GP-5942)
* _Processors_. Added support for the NDS32 Processor. (GP-6007, Issue #1778)
* _Project_. Added expanded support for project link-files with the introduction of internal project folder and file links.  The links behave similar to Linux symbolic links and allow a single folder or file to be referenced by alternative project paths.   The GUI Project Tree and related project file chooser have also been improved with the ability to expand folder-links like folders (subject to filter restrictions at the API level).  The main Project Tree will continue to rely on project views for following external folder-links.  Some of the project tree's recursive traversal actions do not follow folder-links (e.g., Expand All).  NOTE: Although Ghidra permits files and folders to have the same name, this should be avoided when utilizing link-files or Ghidra URLs due to the path ambiguity it can cause.  This change also introduces a new file storage format which can create issues within a project if opened with an older version of Ghidra.  While this version remains compatible with older Ghidra Server versions, adding link files to a repository will require a Ghidra Server upgrade to the latest version. (GP-3551)

### Improvements
* _Accessibility_. Fixed tooltips in the Symbol Tree to not read HTML markup to screen readers. (GP-5741, Issue #8228)
* _Analysis_. Added `ENDBR64` and `ENDBR32` to function start patterns for x86 gcc. (GP-5287)
* _Analysis_. Added support for Golang 1.24 and 1.25.  Changed method of bootstrapping Go type info to use json Go snapshot files instead of gdt files. (GP-5470)
* _Analysis_. Fixed PowerPC 64-bit thunk patterns using prepatterns analyzer pattern files. (GP-6120)
* _API_. Corrected ELF ppc64 import issues related to use of 32-bit-addressing language variants.  Improved handling of ELFv1 vs. ELFv2 binary markup.  Eliminated EXTERNAL `.pltgot.` symbols. (GP-3091, Issue #570)
* _API_. Updated various `SourceType` checks which should avoid use of equality checks in favor of priority checks when covering a range of sources. (GP-6008)
* _Basic Infrastructure_. The `support/launch.properties` now supports expansion of `${var}`-style environment variables. (GP-6022)
* _BSim_. Added `getmetadata` subcommand to `bsim` command-line utility. (GP-5748, Issue #8176)
* _BSim_. Updated BSim Elasticsearch extension support to version 8.19.7. (GP-6146, Issue #8611)
* _Calling Conventions_. Added a compiler specification for Apple platforms on ARM64. (GP-3139, Issue #2723, #8032)
* _Calling Conventions_. Corrected handling of  parameters for the AVR8 calling convention. Expanded abilities of Decompiler model rules for expressing calling conventions in XML cspec files. (GP-4356)
* _Calling Conventions_. Added `max_primitives` filter to homogeneous aggregate type in cspec files. (GP-5367)
* _Calling Conventions_. Added callfixups to x86 gcc compiler spec for pc_thunk functions using the `DI` register. (GP-5958, Issue #8416)
* _CodeBrowser_. Replaced __Dynamic Update__ checkbox in __Instruction Info__ window with a toolbar toggle action. (GP-5650)
* _CodeCompare_. Added actions to transfer variable and callee function names and datatypes from the dual Decompiler function comparison window. (GP-4007)
* _Data_. Improved the Listing's __Create Structure__ action, giving the ability to choose the data type category. (GP-5327, Issue #6713)
* _Data Types_. Added utility methods to the `DataTypeQueryService` for clients to have more flexibility in how they retrieve data types. (GP-5694, Issue #8157)
* _Debugger:Agents_. Upgraded to `protobuf-java 4.31.0` and `protobuf 6.31.0` for Python. (GP-5456)
* _Debugger:Agents_. Improved debug-connection failure-detection when the back-end terminates early. (GP-5700)
* _Debugger:Emulator_. Added Help for `PcodeStepperPlugin`. (GP-5772)
* _Debugger:Emulator_. Fixed an issue with emulation when the program has block/sections with brackets in the name. (GP-5897, Issue #8398)
* _Debugger:LLDB_. Fixed variable name typos in the `lldbsetuputils.ps1` script. (GP-5973, Issue #8498)
* _Debugger:Trace_. Removed legacy mode from the Trace database. (GP-5194)
* _Debugger:Watches_. Added a __Comment__ column to the __Watch__ window. (GP-5795, Issue #8302)
* _Decompiler_. The Decompiler now propagates constants through conditional branches in more situations. (GP-5950, Issue #8455)
* _Demangler_. Modified Microsoft Demangler to process virtual call modifiers and based pointers for 16-bit programs. (GP-5776)
* _Disassembly_. Added quick toggle action (`Ctrl-Shift-1`) for __PCode__ field in the Listing display. (GP-5930)
* _Documentation_. Fixed missing javadocs for Debugger-related APIs. (GP-5891)
* _DWARF_. The DWARF analyzer now records all source files, including source files without source map information. (GP-5773)
* _DWARF_. Added code for parsing DWARF `.debug_macro` sections and example script, `DWARFMacroScript`. (GP-5792)
* _DWARF_. Add support for specifying the charset of DWARF debug strings. (GP-5871, Issue #8346)
* _DWARF_. The DWARF analyzer can now create enums from macro information recorded in DWARF debug data (DWARF v5 only). (GP-5984)
* _ELF_. Added partial support for AARCH64 ELF loading of object modules with GOT allocation capability.  Added support for the following relocation types which rely on this revised relocation handler capability: `R_AARCH64_ADR_GOT_PAGE`, `R_AARCH64_P32_ADR_GOT_PAGE`, `R_AARCH64_P32_LD32_GOT_LO12_NC`, and `R_AARCH64_LD64_GOT_LO12_NC`. (GP-5815, Issue #8253)
* _Emulator_. Refactored the p-code emulator to use composition instead of inheritance for UI integration. This should simplify development of extended emulators and permit easier integration of those emulators with the UI. (GP-5879)
* _Emulator:JIT_. Added support for multi-precision integers (varnodes of size 9 or greater) to the JIT-accelerated p-code emulator. (GP-5214)
* _Exporter_. Updated the IDA Pro exporter to work with IDA Pro 9.x. (GP-5873, Issue #7392)
* _FID_. Updated the FID plugin to delay loading of FID DB resources.  This will improve the tool load time when there are many FID DB objects in use. (GP-6073, Issue #8593)
* _Graphing_. Update the Program Graph __Compact Hierarchical__ layout to have less space between nodes. (GP-4741)
* _GUI_. Added ability to remember last user ID specified for server login prompts such as the Ghidra Server authentication prompt. (GP-5579, Issue #7454)
* _GUI_. Added ability to reorder program tabs via drag-n-drop. (GP-5646, Issue #8099)
* _GUI_. Updated the Data Type Manager to increase performance in deleting data types. (GP-5654, Issue #8104)
* _GUI_. Updated the Structure Editor's __Find Uses of__ action to work on fields with no name or data type. (GP-5711, Issue #8171)
* _GUI_. Added modes to the drop-down text fields to control how matches are found.  Choices will now typically include __Starts With__ and __Contains__ modes. (GP-5720, Issue #4725, #8203)
* _GUI_. Update the Data Type Manager's __Collapse__ toolbar action to stop any post-filter state-restoring. (GP-5761, Issue #8244)
* _GUI_. Updated dialogs wth combo boxes to have consistent behavior when pressing the `Enter` key. (GP-5769, Issue #8280)
* _GUI_. Updated the Ghidra File Chooser to not lock the UI for folders that contain many files. (GP-5807, Issue #4725, #8284)
* _GUI_. Reduced some excessive Symbol Tree updates seen while performing auto-analysis. (GP-5826)
* _GUI_. Fixed bug in Memory Search where some GUI options were not initialized correctly to the last-used options. (GP-5883)
* _GUI_. Updated the __Next Instruction__ action to jump to the function entry point when the action is invoked from the function signature. (GP-5885, Issue #8385)
* _GUI_. Added full data type path to Decompiler and Listing hovers. (GP-5913)
* _GUI_. Created new theme value for the Decompiler's middle-mouse highlight color so that the Listing and Decompiler colors may change independently. (GP-5947)
* _GUI_. Added convenience methods to `TableColumnDescriptor` to create simple columns using only a name, column type, and a function to map from the row object to the column object. (GP-5963, Issue #7346)
* _GUI_. Added key-binding navigation support to the File Chooser. (GP-5964, Issue #6310, #7129, #7130)
* _GUI_. Updated the Tool Options' Key Binding view to have a simpler screen. (GP-5967, Issue #7024)
* _GUI_. Updated key-binding support to allow for usage of the right `Alt` key independently from the left `Alt` key. (GP-5978, Issue #8205)
* _GUI_. Added accelerator mnemonics to the Memory Search dialog to help reduce manual navigation issues. (GP-5979, Issue #8264)
* _Headless_. The user can now specify headless loader options independently of what loader is being used. The headless importer will ignore loader options that are unsupported by the active loader. (GP-5545)
* _Help_. Added Processor, Language, and Compiler specification file names to __About Program__ dialog. (GP-5716, Issue #8163)
* _Importer:COFF_. Added support for importing big-endian COFF binaries. (GP-5645, Issue #1398, #8042)
* _Importer:PE_. The PeLoader no longer fails to import if a Data Directory does not parse successfully. (GP-4881, Issue #6864)
* _Languages_. Corrected handling of small integer parameters and structured data-type parameters  for the PowerPC 64-bit default calling convention. (GP-4029)
* _Languages_. Added support for mixed integer/floating-point parameters and structured data-type parameters for MIPS calling conventions. (GP-4030)
* _MachineLearning_. Updated __RandomForestFunctionFinderPlugin__ with improved model training performance, the ability to apply a model to a program selection, and the addition of disassembly to the similar-starts table. (GP-4400)
* _PDB_. Modified handling of PDB thunks so that for when Ghidra does not consider the function to be a thunk, which would normally cause the thunk to get the same signature as the thunked function, the Demangler is enabled to set the proper function signature and name.  This affects C++-related functions, for example, such as vtordisps and adjustors. (GP-5713)
* _Processors_. Added initial implementation of ARM Neon `VLD`/`VSTn` instructions. (GP-5853)
* _Processors_. Added support for MIPS16e2 instructions. (GP-5902, Issue #8406)
* _Processors_. Refactored RISCV context and moved CSR registers into a CSR memory space to support custom instructions and RISCV variants.  Also added sample RISCV variant Andestar. (GP-5975)
* _Processors_. Corrected AArch64 `fmadd` operand semantics ordering. (GP-6121, Issue #8454, #8625)
* _ProgramDB_. Improved performance of Symbol Table and its storage of `ExternalLocation` data. (GP-5498)
* _Scripting_. Condensed the script categories into a better-organized subset of categories. (GP-3952)
* _Scripting_. Python scripts that do not declare a `@runtime` metadata comment now default to PyGhidra instead of Jython. Jython scripts will need to include the "`# @runtime Jython`" script header in order to continue running within the Jython environment. (GP-5415, Issue #7856)
* _Scripting_. Released PyGhidra 3.0.0. (GP-5637, Issue #6914, #6915)
* _Scripting_. Made a few speed improvements to the RecoverClassesFromRTTIScript. (GP-5831, Issue #8199)
* _Scripting_. Added new script methods to allow script writers to color the console output: `print(String, Color)` and `println(String, Color)`. (GP-5970, Issue #2849)
* _Scripting_. Fixed an issue in the `RecoverClassesFromRTTIScript` where pure virtual functions were not handled correctly in GCC programs. (GP-5993)
* _Sleigh_. Temporary (`unique`) variables can be accessed within a Sleigh language piece-wise using a direct varnode offset and length rather than masking which had inherent size limitations. (GP-5581)

### Bugs
* _Analysis_. Fixed an issue where __Apply Data Archives__ analyzer replaced functions that had the same `SourceType` priority. (GP-5661)
* _Analysis_. Fixed the Non-Returning Functions analyzer to consider external functions.  Also added check for the function called right before an `INT3` as possibly being non-returning. (GP-5763)
* _Analysis_. Fixed handling of `segment()` op in stack analysis when segment op is unknown stack segment SS. (GP-6078, Issue #8584)
* _Assembler_. Added help anchor for Assembler's exhaust-or-zero-fill toggle. (GP-4478)
* _Assembler_. Removed debug messaging from the assembler, speeding it up significantly. (GP-5800, Issue #8308, #8309)
* _Calling Conventions_. Corrected handling of long integer parameters and structured data-type parameters  for the RISCV 32-bit and 64-bit default calling conventions. (GP-5211)
* _Debugger_. Fixed issues related to register editing with lldb. (GP-6084, Issue #8598)
* _Debugger_. Fixed issue where register panel used stale register objects when switching between similar assembly languages. (GP-6105)
* _Decompiler_. Fixed _"Overlapping input varnodes"_ exceptions in the Decompiler caused by the use of the XMM0 register as a function input. (GP-5863)
* _Decompiler_. Allowed the __Rename Global__ action in the Decompiler to create a primary symbol if it didn't exist. (GP-5866, Issue #4864, #8121)
* _Decompiler_. Eliminated the unsound `SBORROW(0,x) => 0` simplification rule from Decompiler analysis. (GP-5934, Issue #8396, #8400)
* _Decompiler_. Fixed a bug that prevented overlapping functions from being correctly decompiled. (GP-5983)
* _Decompiler_. Fixed a bug in the Decompiler's __Force Union__ action that caused _"Could not recover p-code op"_ exceptions. (GP-5989, Issue #7466)
* _DWARF_. Improved DWARF location expression evaluation, which has bearing on a number of areas including the placement of local variables. (GP-4069, Issue #2322, #5311, #5982, #6974)
* _DWARF_. Fixed issue with importing 64-bit DWARF when subsections of the DWARF line info were marked as 32-bit. (GP-5931)
* _FID_. Added a temporary fix to identify the `security_check_cookie()` function in VS2022 binaries.  If the function is not identified, the return type is incorrectly recovered by the Decompiler. (GP-5998, Issue #2743)
* _Function_. Fixed thunk detection and thunk address calculation for thunks with an internal call/branch to the next instruction in order to load the current PC into an LR register. (GP-6072)
* _GUI_. Updated the Plate Comment field to render annotations' display text instead of raw annotation text. (GP-3756)
* _GUI_. Fixed potential deadlock in Ghidra tables that use the __Code Unit__ table column. (GP-5724, Issue #8208)
* _GUI_. Fixed bug that caused an incorrect tab to be selected when closing docked component provider tabs via the __x__ button. (GP-5821, Issue #8303)
* _GUI_. Fixed the Decompiler's __Edit Data Type__ action to correctly scroll the structure field being edited. (GP-6045, Issue #8522)
* _Languages_. Fixed issue with importing 32-bit RUST binaries for x86 Windows- and Unix-based systems. (GP-4711, Issue #6042)
* _Navigation_. Changed __Next Function__ / __Previous Function__ actions to skip functions that are not in memory. This prevents the actions from becoming _stuck_ until the user manually moves to an new address past the non-memory function. (GP-5712)
* _PDB_. Fixed an issue where the function arguments list record was a NOTYPE, which caused the analyzer to terminate. (GP-6010)
* _Processors_. Fixed ARM `vmvn` instruction semantics. (GP-4650, Issue #6544)
* _Processors_. Fixed SuperH4 `FSCA` instruction destination operand and FPU-register ABI-ordering for little-endian. (GP-5759, Issue #8192)
* _Processors_. Corrected 80251 `ANL` instruction variant disassembling as `ADD`. (GP-5903, Issue #8393)
* _Processors_. Fixed 80251 `ANL Areg,Data` source-mode disassembly bug. (GP-5904, Issue #8394)
* _Processors_. Added support for the eBPF `CALLX` instruction. (GP-5909, Issue #7972)
* _Processors_. Corrected PowerPC branch conditional instruction semantics. (GP-6049, Issue #8424)
* _Processors_. Fixed disassembly of various Xtensa big-endian instructions. (GP-6050, Issue #8537, #8544)
* _Processors_. Fixed pcode for SuperH `bclr` instruction. (GP-6065, Issue #8579)
* _Processors_. Fixed several issues including ARM `cpy` instruction setting the PC, incorrect function start pattern, and spurious references when saving the PC at function entry. (GP-6079)
* _Project_. Corrected issues related to failed attempts at removal of multiple folders from project tree via a selection. (GP-5907)
* _Project_. Improved project tree change listener to handle link status updates when such links reference non-visited regions of the project tree. (GP-5908)
* _Scripting_. Fixed the `GhidraScript.writer` member variable to properly get used in the various `GhidraScript.print*()` methods. (GP-5737)
* _Scripting_. Updated vxWorks symbol-table-finding script to better filter out runs of pointers when trying to locate the table.  Also, deleted old scripts and fixed demangling and labeling issues. (GP-5969, Issue #8024)
* _Scripting_. Jython scripts invoked via `runScript()` now have their local variables properly reset to a fresh state. (GP-5981)
* _Scripting_. Fixed a bug that prevented OSGi scripting bundles from running with newer versions of Java. (GP-6014)
* _Scripting_. Fixed a bug that prevented PyGhidra from redirecting output from  `print()` and `sys.stdout.write()` to the Ghidra GUI scripting console. (GP-6021, Issue #8524)
* _Scripting_. Fixed a bug in the the PyGhidra headless analyzer that resulted in the wrong exception being thrown when a script tries to import a module that isn't found. (GP-6132, Issue #8610)
* _Symbol Tree_. Updated the Symbol Tree to respond to external program path changes. (GP-5793)
* _Symbol Tree_. Fixed a bug where opening a folder in the Symbol Tree caused navigation to occur in the Listing. (GP-5914)

### Notable API Changes
* _API_. (GP-5600) The `AutoImporter` class has been deprecated. Use the new `ProgramLoader.Builder` class instead. The returned `Loaded` class should now be managed with a _try-with-resources_ pattern.  If a `DomainObject` is extracted from a `Loaded` object, it must be released independly of closing the `Loaded` object.
* _Assembler_. (GP-5800) Deleted `DbgTimer`.
* _Data Types_. (GP-5694) Deprecated `DataTypeQueryService.getDataType()`.   This method has been replaced by `promptForDataType()`.
* _Debugger:Agents_. (GP-5700) Launcher scripts `GHIDRA_HOME` now points to `<ghidra-install>/Ghidra`. `MODULE_HOME` now points to containing module root. Can request `MODULE_Xxx_HOME` pointing to module `Xxx` root by placing `@depends Xxx` in header.
* _Debugger:Trace_. (GP-5194) Objects mode is now the normal mode for Trace databases. The legacy mode has been removed. As a result, the root object must be created early, since other managers require it. Merged methods from `TraceObjectX` interfaces into `TraceX` (only those derived from `TraceObjectInterface`). To avoid confusion, renamed `TraceMethod` (in Java TraceRmi Client) to `TraceRmiMethod`. Renamed `TraceBreakpoint` to `TraceBreakpointLocation`. Added `TraceBreakpointSpecification`, `TraceBreakpointCommon`. Deleted `TraceAddressSpace` in favor of `AddressSpace`. Added `DebuggerCoordinates.isRegisterSpace()`. Space-based managers, e.g., `TraceMemoryManager`, no longer have special tables for register spaces. They all use the overlay-named-after-register-container convention. Added `TraceBaseCodeUnitsView.get(platform,snap,register,forward)`. Memory region management is moved from `TraceMemoryOperations` to `TraceMemoryManager`. Removed experimental and incomplete `TraceProgramView.getViewRegisters()` method and related. Removed `thread` parameter from `TraceLabelSymbolView.add/create`. Added variant of `TraceLabelSymbolView.add/create` that takes `platform(optional),thread,register` (and similar with getters in `TraceSymbolWithLocationView`). Added methods to `DefaultSchemaContext` and related builders to more easily build a context derived from an existing one. Added `TraceObjectManager.requireRootSchema()`. Added `TraceRegisterUtils.getRegisterContainer`, `getRegisterAddressSpace`, `getThread`, and `getFrameLevel`.
* _Debugger:Trace_. (GP-5926) Added `TraceReference.getToRange`. Added `TraceReferenceOperations.addMemoryReference(...AddressRange toRange...)`. Added `TraceReferenceOperations.getReference(...AddressRange toRange...)`. Added `TraceReferenceOperations.getReferencesToRange(...order)`.
* _Debugger:Watches_. (GP-5795) Added `WatchRow.get/setComment`.
* _Emulator_. (GP-5727) Added `SymZ3PcodeEmulator` and related.
* _Emulator_. (GP-5864) Added `EmulatorUtilities`.
* _Emulator_. (GP-5879) <B>Primary changes</B>: Added `PcodeEmulationCallbacks`, `PcodeStateCallbacks`, `ComposedPcodeEmulationCallbacks`. Added `Writer` and `TraceWriter`. Added `PieceHandler` and implementations for `byte[]`, `TaintVec`, and `SymValueZ3`. Added `TraceEmulationIntegration`. Added `DebuggerEmulationIntegration`. Deleted `TracePcodeMachine`, `DebuggerPcodeMachine` and all implementations. `PcodeMachine` is used with a `Writer`/callbacks instead. Deleted `TracePcodeExecutorStatePiece` and all implementations. `PcodeExecutorStatePiece` is used with callbacks instead. Deleted `AbstractDebuggerPcodeEmulatorFactory`. `EmulatorFactory` is used instead. Deleted `TraceEmulatorPartsFactory`, `DebuggerEmulatorPartsFactory` and all implementations. `EmulatorPartsFactory` is used instead. Changed constructor of `AbstractPcodeMachine` to require callbacks. Changed constructor of `AbstractLongOffsetPcodeExecutorStatePiece` and derivatives to require callbacks. Changed signature of `PcodeExecutorStatePiece.fork` to require callbacks. Changed signature of `EmulatorFactory.create` to accept a `Writer`. Changed signatures of several methods in `EmulatorPartsFactory` to accept callbacks. 
<BR><B>Secondary changes</B>: Added `PcodeTraceAccess.deriveForWrite(snap)`. Added `PcodeTracePropertyAccess.getEntry/put`. The `put` method is also modified to clear if `value` is null. Added `PcodeArithmetic.getDomain`. Added `PcodeExecutorStatePiece.streamPieces`. Added `AbstractPcodeExecutorState`. Added `PcodeExecutorStatePiece.get/setVarInternal`. Added `PcodeExecutorStatePiece.getNextEntryInternal`. Renamed `DebuggerPcodeEmulatorFactory` to `EmulatorFactory`. Changed signature of `PcodeDebuggerMemoryAccess.readFromStaticImages`. Several changes to `AbstractLongOffsetPcodeExecutorStatePiece` and its derivatives. See stock implementations for updates. In particular, removed all notion of "backing" including the type parameter `B`.
* _Emulator:JIT_. (GP-5214) Added `PcodeUseropDefinition.getOutputType()`. `AnnotatedPcodeUseropLibrary` allows `@PcodUserop` methods to take `int[]` parameters, including for the `@OpOutput` parameter.
* _FileSystems_. (GP-5825) Removed GFilesystem `LocalFileSystemSub` class.
* _FileSystems_. (GP-5842) Removed `throws IOException` from `ByteProvider.length()` method.
* _Graphing_. (GP-3648) The `CodeComparisonPanel` extension point has been renamed to `CodeComparisonViewer`.   Any clients subclassing `CodeComparisonPanel` will need to rename their parent class reference and also rename their extension to end with `CodeComparisonView` instead of `CodeComparisonPanel`.
* _GUI_. (GP-5769) Removed the `GhidraComboBox.setEnterKeyForwarding(boolean)` method.  Any clients calling this method with a value of `true` may simply delete the call to maintain the previous behavior,  Any clients calling this with a value of `false` will need to change how the combo box responds to `Enter` key presses in a way that preserves effect of not passing the `Enter` key press up to the parent container.
* _GUI_. (GP-5963) Added convenience methods to `TableColumnDescriptor` to create simple columns using only a name, column type, and a function to map from the row object to the column object.
* _Importer_. (GP-3947) Added `XmlElement.isStart(String string)`, which checks that the element is a starting element and also that its name matches the passed string.
* _Importer_. (GP-5343) The `Loader.load()` and `Loader.loadInto()` interface definitions have been simplified to take in a new `ImporterSettings` record.  The `Loader.getDefaultOptions()` definition has also been changed to accept a new `mirrorFsLayout` parameter.  These changes trickle down the loader class hierarchy, so all 3rd party loaders will need to be updated to work with Ghidra 12.0.
* _ProgramDB_. (GP-5498) Revised `ExternalManager` interface including removal of previously deprecated methods which have new method names.  The `getExternalLocations` now returns a `Set` of locations instead of a `List`.
* _ProgramDB_. (GP-5990) Eliminated the various forms of the `Listing.getCompositeData` method and associated map table from the Program database.  These methods were never used within Ghidra and were found to be the source of unnecessary overhead.For infrequent needs, a defined-data iterator can be used to identify locations where composites exist.  In addition, the following related Program and Trace events were eliminated: `ProgramEvent.COMPOSITE_ADDED`, `ProgramEvent.COMPOSITE_REMOVED`
`ChangeManager.DOCR_COMPOSITE_ADDED`, 
`ChangeManager.DOCR_COMPOSITE_REMOVED`,`ProgramEvent.COMPOSITE_ADDED`, `ProgramEvent.COMPOSITE_ADDED`.
* _Project_. (GP-3551) Made significant changes to `ProjectDataUtils` in support of folder and file links.  This utility's static methods should be used in place of directly instantiating `DomainFileIterator` or `DomainFolderIterator`.   Significant changes have been made to `ProjectData` storage and interface to accommodate expanded link-file support.  The `getFile` and `getFolder` methods have been overloaded with an optional filter to control treatment of such link-files where the pre-existing method forms will ignore external links.  Extensive changes have also been made to the Project Data Tree component which now has the ability to render and follow folder and file links.  Since a folder link exists as a `DomainFile`, and all link-files rely on unique content-types, additional logic is needed to follow such links.  `LinkFileInfo` can be obtained from a `DomainFile` although the use of `ProjectData` and `ProjectDataUtils` will simplify the use of link-files.
* _Scripting_. (GP-5737) Added a `GhidraScript.set()` method that takes a new `ScriptControls` object which provides more control over how scripts write to stdout and stderr.
* _Scripting_. (GP-5961) Deprecated `pyghidra.open_program` and `pyghidra.run_script`.

# Ghidra 11.4.3 Change History (December 2025)

### Improvements
* _Analysis_. Added the ability to restrict function start pattern matches per named section and added a pattern for thunks in the `.plt` so that they are marked up very early. (GP-5526)
* _Analysis_. Added several known PE-related, non-returning, named functions. (GP-5985)
* _Decompiler_. Restored the Decompiler's middle-mouse highlight functionality for if/else keywords. (GP-5951, Issue #8419)
* _Multi-User_. Updated `ghidraSvr` script and `server.conf` with improvements to restrict service wrapper memory consumption. (GP-6067)
* _Processors_. Added support for x86 SSE4a instructions. (GP-5906, Issue #8335)

### Bugs
* _Exporter_. Fixed missing reference type in the ASCII and HTML exporters. (GP-5957, Issue #8468)
* _PDB_. Fixed a `NullPointerException` that occurred during PDB load/analysis that was caused by a function null container class. (GP-6100, Issue #8596)
* _ProgramDB_. Corrected dynamic label bug which produced a stack overflow exception when a pointer reference loop existed. (GP-5995, Issue #8510)
* _Scripting_. Fixed OSGi-related errors that occurred when script-related directories were not readable. (GP-5965, Issue #8466)

# Ghidra 11.4.2 Change History (August 2025)

### Improvements
* _Build_. Ghidra now supports Gradle 9. (GP-5901)
* _Decompiler_. Improved Decompiler's analysis of switches where the guard condition has been duplicated across multiple basic blocks that all feed into the same switch calculation. (GP-5889)
* _Processors_. Added the SuperH GBR register to the unaffected list in the `.cspec` so that the Decompiler sees the value as preserved across subroutine calls. (GP-5912, Issue #4387)

### Bugs
* _Analysis_. Fixed switch recovery analysis speed degredation on functions with multiple potential switches. (GP-5917)
* _Decompiler_. Fixed a bug in the Decompiler's analysis of duplicated boolean expressions that could reverse the meaning of an expression. (GP-5915, Issue #8310)
* _Decompiler_. Fixed an uncaught exception in the Decompiler that resulted when `highSymbol` was null. (GP-5919, Issue #8413)
* _Exporter_. The `IntelHexExpoter` no longer fails due to falsely identifying a 32-bit program as 64-bit.  Additionally, the address space option is no longer hidden. (GP-5910, Issue #8409)
* _Importer:ELF_. Corrected ELF MIPS-64 packed REL relocation processing issue seen when the relocation type R_MIPS_REL32 is included (e.g., packed type 0x1203).  When 64-bit pointers are used, this relocation must read 8 bytes from memory instead of 4 bytes to produce the correct addend value. (GP-5918)
* _Importer:PE_. Fixed a regression that caused bad functions to be created in the middle of good functions in PE files with chained `IMAGE_FUNCTION_RUNTIME_ENTRY`s, and prevented some PE binaries from importing. (GP-5916, Issue #8414)
* _Importer:PE_. The `IMAGE_RESOURCE_DIRECTORY_ENTRY` data type is now correctly defined as a structure instead of a union. (GP-5935, Issue #8446)
* _PDB_. Fixed structure member issue, broken with 11.4 release, that could cause improper structure layout and Decompiler low-level errors. (GP-5928)
* _Processors_. Added additional SPE and APU instructions to e500 PowerPC variant. (GP-5945)

# Ghidra 11.4.1 Change History (July 2025)

### Improvements
* _Debugger_. Added a __Forcibly Close Transactions__ maintenance action to the __Connections__ window. (GP-5788, Issue #8298)
* _Debugger:GDB_. Added mapping from GDB's armv5te to Ghidra's ARM:LE:32:v5t. (GP-5738)
* _Decompiler_. Improved Decompiler analysis of small variables through the INT_LEFT operator. (GP-5718)
* _Importer:Mach-O_. Added support for importing and extracting from the iOS 26 BETA dyld_shared_cache. (GP-5767, Issue #8283)
* _Importer:PE_. PE `IMAGE_FUNCTION_RUNTIME_ENTRY`s are now all marked as functions. (GP-5811, Issue #8321)
* _Processors_. Fixed AAPCS calling convention and added soft float calling convention (`__stdcall_softfp`) for 32-bit ARM. (GP-4989, Issue #6958)
* _Scripting_. Added option to the RecoverClassesFromRTTIScript to not change vfunctions to thiscalls. (GP-5764, Issue #8163)
* _Scripting_. The new PyGhidra 2.2.1 no longer gets confused by the presense of a random `ghidra` or `java` directory on the current working directory. (GP-5810, Issue #8190)

### Bugs
* _Analysis_. The symbolic constant evaluation, `SymbolicPropogator`, has been changed to record pre/post values at the beginning and end of instructions by default.  This affected the `ResolveX86orX64LinuxSyscallsScript` and `GolangSymbolAnalyzer`. (GP-5804)
* _Analysis_. Fixed a potential infinite looping problem that could occur during MIPS or PPC constant analysis.  The issue could occur on undefined functions when __Assume T9 set to Function entry__ option is set. (GP-5833)
* _Analysis_. Adding MIPS64 instruction start patterns. (GP-5843)
* _Assembler_. Fixed an issue with Debugger __Patch Data__ action being misapplied to the static Listing. (GP-5859)
* _Assembler_. Fixed an issue with __Patch Instruction__ in certain Harvard architectures. (GP-5877, Issue #8382)
* _CodeCompare_. Corrected occasional `IndexOutOfBoundsException` in decompiled code comparison algorithm. (GP-5361, Issue #7028, #8125, #8289)
* _Debugger:Emulator_. The __Event Thread__, __PC__, and __Function__ columns are now populated for emulation traces. (GP-5796, Issue #8293)
* _Debugger:GDB_. Fixed an issue with zero-length modules. (GP-5789)
* _Debugger:Memory_. Fixed an issue with pc/watch-tracking in Debugger/Emulator's __Memory Bytes__ viewer. (GP-5852, Issue #8333)
* _Debugger:Modules_. Fixed `NullPointerException` on __Select Current Module__ action when the cursor is not in a module. (GP-5790)
* _Debugger:Objects_. Refrain from timing-out back-end actions when a Cancel button is displayed. The user can decide when it's had enough time. (GP-5553)
* _Debugger:Scripting_. Fixed `NullPointerException` in example `InstallCustomLibraryScript.java`. (GP-5799, Issue #8296)
* _Decompiler_. Fixed an error in the Decompiler's constant propagation that would occasionally prevent a function's parameters from being committed. (GP-5736, Issue #8183)
* _Decompiler_. Fixed a regression in the Decompiler's recovery of the return value for AARCH64 and ARM. (GP-5816)
* _Decompiler_. Fixed Decompiler bug where inlined functions cause _"Could not find op at target address"_ exceptions. (GP-5832, Issue #7383)
* _Decompiler_. Provided a fix for an infinite loop problem in the Decompiler caused by `RulePtrsubUndo`. (GP-5856, Issue #7997)
* _Eclipse Integration_. GhidraDev 5.0.1 fixes a bug that prevented Ghidra from discovering the Ghidra module project when launched with the PyGhidra run configuration. (GP-5836)
* _ELF_. Corrected severe ELF-relocation-processing bug for MIPS 64-bit. (GP-5827)
* _GUI_. Fixed the __Install Extensions__ dialog toolbar action enablement. (GP-5777, Issue #8294)
* _GUI_. Corrected regression problem with __Set Comments__ dialog which should keep last tab selected when re-opened. (GP-5797)
* _GUI_. Fixed the __Install Extensions__ dialog toolbar action enablement.  Previously, after pressing the plus toolbar button, the actions would get disabled and could not be re-enabled. (GP-5828, Issue #8294)
* _Importer:ELF_. Corrected ELF PowerPC 64-bit relocation-processing bugs that affected ELFv2 use and R_PPC64_JMP_SLOT relocation. (GP-5846)
* _Languages_. Fixed issue of missing characters at the end of instruction operands; for example, closing parenthesis added in a base sleigh instruction constructor. (GP-5752, Issue #8345)
* _PDB_. Fixed an issue where Microsoft symbol truncation led to improper namespace parsing and PDB analysis error.  Also made changes to Microsoft Demangler to make the prefix dot character an optional character for mangled data type strings. (GP-5861, Issue #8358)
* _Processors_. Fixed 6805 and HCS 08 X-indexed jump addresses. (GP-5336, Issue #7064, #7065)
* _Processors_. Added eBPF ISA v4 instructions. (GP-5592, Issue #7982)
* _Processors_. Corrected semantics for eBPF byte-swap instructions. (GP-5593, Issue #7985)
* _Processors_. Corrected operand encoding for x86 AVX512 `vex.1vvv` operands. (GP-5766)
* _Processors_. Corrected eBPF processor load instructions to correctly zero-extend. (GP-5857, Issue #7979)
* _Processors_. Corrected eBPF `call` instruction operand decoding. (GP-5858, Issue #7929)
* _References_. Fixed __Add Reference__ dialog to create memory references based on the word size of the address space. (GP-5865)
* _Scripting_. Fixed a timing issue that prevented `FlatProgramAPI.analyzeAll(Program)` from picking up analyzer options set in the script. (GP-5802, Issue #8287)
* _Scripting_. Fixed an issue that prevented Visual Studio Code projects from being recognized as Java projects. (GP-5820, Issue #8322)
* _Version Tracking_. Fixed a table column `UnsupportedOperationException` seen when using Version Tracking. (GP-5876, Issue #8094)

### Notable API Changes
* _Debugger_. (GP-5788) Added `Target.forciblyCloseTransactions()`.
* _Languages_. (GP-5752) Removed the second parameter of `InstructionPrototype.getSeparator()`, as it was unused.

# Ghidra 11.4 Change History (June 2025)

### New Features
* _Basic Infrastructure_. Implemented Dockerized Ghidra. See `docker/README.md` for information about how to build the docker image for Ghidra and how to run the Ghidra container. This feature includes `headless`, `ghidra-server`, `bsim-server`, `bsim`, `pyghidra`, and `gui` entrypoints. (GP-3579)
* _Debugger_. Added support for Meta's drgn debugger, undertaken as a test case to generate new Debugger documentation. (GP-326)
* _Debugger_. Added time overview to the Dynamic Listing. (GP-870)
* _Debugger_. Implemented remote options for dbgeng targets. (GP-4732)
* _Debugger_. Added event/exception handling for the dbgeng. (GP-4786)
* _Debugger_. Added support for `rr` via gdb. (GP-5452, Issue #3133)
* _Debugger:Agents_. Provided additional `catch` methods for gdb. (GP-5466)
* _Debugger:Listing_. Support for 32-bit pointers on WoW64 targets is now added. The pointer size is automatically determined by the PE header of the module containing the PC. (GP-616, Issue #4127)
* _Debugger:Time_. Added actions to __Debugger__ menu to set the display radix for snapshot keys and time schedules. (GP-5523)
* _Importer_. Provided new loader for the `Unix A.out` binary file format. (GP-3182, Issue #4943, #5004)
* _Search_. Added new Search-and-Replace feature. This feature make it easy to globally rename many different types of program elements and update related comments. (GP-5310)

### Improvements
* _Accessibility_. Provided accessible names for most dialog components. (GP-4555)
* _Analysis_. Added support for Golang closures and generic functions.  Added support for applying function signatures to core Golang library functions that were captured and stored in API snapshot files. (GP-2432, Issue #6367)
* _Analysis_. Improved speed of constant reference analysis and stack analysis. (GP-4512)
* _Analysis_. Improved decompilation of Golang functions by eliminating compiler-generated boilerplate calls to internal garbage-collection functions. (GP-5373, Issue #7484)
* _Analysis_. Updated the IMAGE_RUNTIME_FUNCTION_ENTRY structure for x86 programs to change the EndAddress type from an ImageBaseOffset32 to a DWORD.  This helps prevent references and code from being incorrectly created at the address after each listed function. (GP-5430)
* _Analysis_. Improved how Golang interface methods are modeled. (GP-5455, Issue #7529)
* _Analysis_. The __Rust String Analyzer__ no longer clears and converts strings defined in the header to character arrays. (GP-5643, Issue #8019)
* _API_. Updated some Decompiler locations to better navigate the Listing. (GP-5453, Issue #7518)
* _Basic Infrastructure_. Upgraded 3rd party jars for Bouncy Castle, Apache Commons Compress, Apache Commons Lang3, Apache Commons IO, and JUnit. (GP-5631)
* _BSim_. The BSim `support/make-postgres.sh` script now runs on linux_arm_64 and mac_arm_64 platforms. (GP-5282, Issue #7287)
* _BSim_. Made BSim installed by default. (GP-5435)
* _BSim_. Added checks to `AddProgramToH2BSimDatabaseScript` to prevent the generation of signatures when a program has unsaved changes or no functions. (GP-5562, Issue #7897)
* _BSim_. Function names in the BSim Overview Results table now update if they are changed in the program. (GP-5604, Issue #7903)
* _BSim_. Upgraded Postgres for BSim to version 15.13 and JDBC driver to 42.7.6.  This resolves issues with building PostgreSQL server on newer releases of Linux and compiler toolchains which compile with `-std=c23` option by default. (GP-5680, Issue #8122)
* _Byte Viewer_. Byteviewer now centers the cursor on the screen when going to a new offscreen location instead of putting the cursor at the top or bottom. (GP-2148)
* _Calling Conventions_. Corrected specifications for parameter and return storage of homogeneous float aggregate types in AARCH64.cspec. Made a number of improvements and corrections to AARCH64_win.cspec. (GP-5192, Issue #8016)
* _Data Types_. Improved handling of datatype removal and the impact it can have within Structure and Union components.  Previously, affected components were removed, causing unknown loss of information.  With this change, components will be preserved with the use of a `BadDataType`, allowing their size and field names to be preserved.  Each affected component comment will also be updated to indicate the name of the datatype that was removed.  A similar situation for a Structure bit-field will revert its base datatype to an appropriate primitive integer type if it had been based upon a deleted Enum or Typedef. (GP-2949)
* _Data Types_. Fixed issue where a datatype node in the datatype tree had a stale tool tip if a datatype it contained was renamed. (GP-5434)
* _Data Types_. Improved Structure Editor `unpack` action to include typedef of arrays and structures.  This change also corrects unpacking of structures which contain zero-length components. (GP-5527, Issue #7528)
* _Debugger_. Fixed issue where, when hovering over struct members, the left-hand side of assignment statements gave incorrect values. (GP-3450, Issue #5337)
* _Debugger_. Provided better launcher defaults. (GP-4611)
* _Debugger_. Added various Debugger launchers, especially Windows equivalents of existing Linux launchers.  Fixed launch logic for targets and arguments with spaces in their paths. (GP-5360, Issue #4977)
* _Debugger:Agents_. Integrated timeline for `dbgeng-trace` connector. Navigating in the __Time__ window or using the __Go-To Time__ action now issues the corresponding `!tt` command, and vice versa. (GP-4209)
* _Debugger:Agents_. Replaced the experimental pyTTD implementation with direct use of the Microsoft DLLs;  enables heap / memory visualization based on LINQ queries in the Memview Display. (GP-5407)
* _Debugger:Agents_. Added __Image__ option to __remote gdb__ and __remote lldb__ connectors. (GP-5538, Issue #7955)
* _Debugger:Agents_. The connectors will now prompt to automatically remedy some missing setup steps. (GP-5551)
* _Debugger:Breakpoints_. Added __Set Breakpoint__ drop-down action. (GP-4546)
* _Debugger:dbgeng.dll_. Added a few more options for dbgeng targets. (GP-5270)
* _Debugger:drgn_. Added type annotations to drgn. (GP-5511)
* _Debugger:Emulator_. Moved display of the current time (schedule) from Threads to the Listing's tabs. (GP-5265)
* _Debugger:Listing_. Fixed issue where Dynamic and Static Listings could get out of sync when another component directed navigation (i.e., not directly input-driven). (GP-5548)
* _Debugger:LLDB_. Added documentation to bootstrap pip into the Android NDK's lldb. (GP-5533)
* _Debugger:Memory_. The primary __Dynamic Listing__ and __Memory Bytes__ windows are now synchronized. (GP-3405)
* _Debugger:Stack_. Improved stack unwinder to handle the ARM `bx` instruction. (GP-3771, Issue #5658)
* _Debugger:Targets_. Added a __busy__ indicator to each connection and target. (GP-4080)
* _Debugger:Time_. Added __PC__, __Function__, and __Module__ columns to the __Time__ window. Changed default visibility and widths. (GP-5264)
* _Debugger:Time_. Added a __Time__ column to the __Time__ window. Hid the __Snap__ and __Snapshot__ columns by default. (GP-5499)
* _Debugger:Time_. Double-clicking or pressing `Enter` on a row in the __Time Selection__ dialog now confirms the dialog. (GP-5674)
* _Decompiler_. The Decompiler simplifies new situations where optimized code packs multiple variables into a single register. (GP-5240, Issue #7277)
* _Decompiler_. Updated Decompiler highlighting to ignore syntax tokens. (GP-5414, Issue #7527)
* _Decompiler_. Fixed a performance issue seen in the Decompiler when using a large number of custom global highlighters. (GP-5477, Issue #7520)
* _Decompiler_. Enabled optimizations for C++ source files when compiling native executables on Windows. (GP-5543, Issue #7953)
* _Decompiler_. Updated the Decompiler to now show a warning when executing DockingActions while the Decompiler is busy. (GP-5572, Issue #7893)
* _Documentation_. Updated BSim documentation to mention PostgreSQL support on arm64. (GP-5384, Issue #7387, #7388)
* _Documentation_. Renamed `InstallationGuide.md` to `GettingStarted.md`. (GP-5598)
* _DWARF_. DWARF analyzer now imports symbols found in external debug files. (GP-5570)
* _Emulator:JIT_. Fixed an issue with transition to THUMB on indirect branches. (GP-5301)
* _Exporter_. The C/C++ exporter now has an option to export declarations for referenced global variables (on by default). (GP-4123, Issue #2635)
* _Function Tags_. Added __Make Selection__ action to Function Tags Window. (GP-5354)
* _GhidraGo_. Improved GhidraGo CLI to print correct usage upon invalid/missing GhidraURL argument. (GP-5504)
* _Graphing_. Added __Truncate Function Name__ option to the Function Call Graph to control name truncation, which was previously always enabled. (GP-2307, Issue #1684)
* _GUI_. Added the ability to search for text in the Console. (GP-3858, Issue #2567, #7136)
* _GUI_. Added more data type filter options to the Data Types provider. (GP-3870, Issue #5734)
* _GUI_. Updated Listing Label hovers to show symbol type and source type. (GP-4393)
* _GUI_. Updated the Function Editor dialog to find the next editable table cell when initiating a table edit via `F2` on an uneditable cell. (GP-5316, Issue #7241)
* _GUI_. Added the __Copy Formatted__ action to most trees to allow a copy operation that maintains tree node indentation. (GP-5317, Issue #7417)
* _GUI_. Added an __Edit Structure Field__ action to allow changing the name, datatype, and comment for a structure (or union) at the same time. (GP-5326, Issue #7407)
* _GUI_. Improved function parameter/return custom storage editor to employ a filtered pull-down combo-box for register selection. (GP-5369)
* _GUI_. Symbol Tree - Improved event handling to maintain user view position; added an option for organization node group threshold; fixed missing nodes under classes; updated tree to maintain user selection. (GP-5474, Issue #7889, #7891)
* _GUI_. Updated the Decompiler's rename dialog to pick the correct parent namespace. (GP-5565, Issue #7507)
* _Importer_. The MapLoader now parses and applies the symbols found in the `Static symbols` section of a MAP file. (GP-5530, Issue #7945)
* _Importer:Mach-O_. The `dyld_shared_cache` filesystem no longer throws exceptions when trying to perform slide fixups on very large cache files. (GP-5357)
* _Importer:Mach-O_. The extracted dyld_shared_cache component loader now has options to automatically add common components that contribute to better analysis such as libobjc.dylib, constant data, and text stubs. (GP-5396, Issue #7289, #7469)
* _Importer:Mach-O_. The Mach-O loader now properly handles the `LC_REEXPORT_DYLIB` load command, transitively exporting the exported symbols from one library to another. (GP-5429, Issue #7537)
* _Importer:Mach-O_. Mach-O files contained within a Universal Binary container can now be directly imported without having to go through the File System Browser. Use the __Language__ field of the import dialog to select the architecture to import. (GP-5552)
* _Listing_. Changed Listing comment fields to now display offcut comments. Offcut comments are comments at addresses in the middle of an instruction or data item instead of at the start address. They are displayed in red to distinguish them from non-offcut comments. (GP-4037)
* _Navigation_. Added previously missing navigation history when using __Repeat Memory Search__ action. (GP-5440, Issue #7445)
* _PDB_. Added a post-analysis pop-up message for when PDB file could not be found. (GP-5697)
* _Performance_. Fixed performance issue with __Defined Strings__ table when other very large data types are present in the program. (GP-2941, Issue #3498, #5726, #8134)
* _Processors_. Added support for ARM Cortex stack limit register instructions (GP-4731, Issue #5255, #5256, #6667)
* _Processors_. Improved display of x87 floating-point operands. (GP-5030, Issue #6786)
* _Processors_. Updated appropriate x87 instructions to modify the FPU instruction pointer. (GP-5191, Issue #7205, #7508)
* _Processors_. Added support for ARM additional VFP system registers. (GP-5469, Issue #6573)
* _Processors_. Added implementation of additional x86 AVX512 instructions. (GP-5537)
* _Processors_. Improved pcode generated for certain x86 `PUSH FS` and `PUSH GS` variants. (GP-5638, Issue #6602)
* _ProgramDB_. Provided various locking-related speed improvements for multi-threaded access. (GP-5619)
* _Scripting_. Changed __In Tool__ option in the Script Manager table to automatically add actions to the global menu bar under a __Scripts__ menu if not already specified to be placed in another location specified by `@menupath`. (GP-5428)
* _Scripting_. Removed old prototype `GccAnalysisScript` since it is no longer maintained and has been long since replaced with the `RecoverClassesFromRTTIScript`. (GP-5451, Issue #7871)
* _Scripting_. PyGhidra can now open projects created with the Ghidra GUI by setting the `nested_project_location` optional parameter to `False`. (GP-5627, Issue #8040)
* _SourceMatching_. The actions to create SourceFile transforms now use file choosers. (GP-5255)
* _Version Tracking_. Made Version Tracking Wizard more efficient when choosing programs to be compared if either one is versioned or needs to be upgraded. (GP-4151)
* _Version Tracking_. Changed the minimum function length in the Auto Version Tracker for the duplicate instruction correlator to be larger to improve the correlator speed. Users can change this option in the Auto Version Tracking options folder. (GP-5762)

### Bugs
* _Analysis_. Fixed an issue with a missing magic value for Golang 1.20+ that could cause a failure in finding the root `moduledata` structure and subsequently all RTTI and function information in stripped PE binaries. (GP-5728, Issue #8213)
* _Basic Infrastructure_. Fixed a bug that prevented new installations of Ghidra from applying preferences found in older installed versions of Ghidra. (GP-5633, Issue #8107)
* _Calling Conventions_. Added compiler specification support for the ARM APCS calling convention. (GP-4923, Issue #7434)
* _Calling Conventions_. Corrected specifications of return storage locations of structures for the default prototypes in x86gcc.cspec and x86-64-win.cspec.  Made a number of improvements to the `MSABI` prototype in x86-64-gcc.cspec. (GP-5183)
* _Debugger_. Fixed a bug that occurred when editing memory after closing and re-opening a trace in another tool. (GP-5314, Issue #7413)
* _Debugger_. Fixed an issue where object key re-use caused incorrect merging of objects. Often, this led to stale values being used or displayed in parts of the UI. In particular, this caused breakpoints to appear at incorrect addresses. (GP-5379, Issue #7497)
* _Debugger_. Provided a fix such that Debugger image defaults are not applied if there is a program. (GP-5607)
* _Debugger:Breakpoints_. Fixed a bug with removing and re-adding the `BreakpointMarkerPlugin`. (GP-5364)
* _Debugger:Breakpoints_. Fixed an issue with breakpoint state consistency when the containing program image is not mapped. (GP-5671)
* _Debugger:dbgeng.dll_. Fixed a bug in the exception handler for dbgeng that caused stopping despite the settings. (GP-5606, Issue #8029)
* _Debugger:dbgeng.dll_. For dbgeng-backed targets, if reading the PE-header to determine x86/x64 mode times out, the error is now in the Debug Console instead of a popup dialog. This automatic memory read is now also modulated by the main Listing's __Auto-Read Target Memory__ setting. (GP-5678, Issue #8155)
* _Debugger:GDB_. Provided fix for signed/unsigned address errors in gdb. (GP-5331, Issue #6787)
* _Debugger:GDB_. Fixed an issue where gdb connector couldn't list sections if any had zero length. (GP-5612)
* _Debugger:Listing_. Fixed an issue with __Select All__ and similar actions in the __Dynamic Listing__. (GP-5438)
* _Debugger:Listing_. Fixed `NullPointerException` in tab panel when exiting. (GP-5540, Issue #7956)
* _Debugger:Memory_. Fixed a performance issue for long-lived (many snapshots) targets. (GP-5494, Issue #4940)
* _Debugger:Objects_. Fixed an issue where __Refresh__ actions on Model view expansion were getting mixed up. (GP-5425)
* _Debugger:Registers_. Fixed hang at launch when the __Registers__ table had a filter. (GP-5673)
* _Debugger:Targets_. Fixed an issue that required user to click the __trace tab__ when launching without an Image; e.g., to attach manually. (GP-5668)
* _Decompiler_. Upgraded taint analysis to interface with CTADL v0.11.0. (GP-5573)
* _Decompiler_. Fixed issue preventing decompilation of certain functions containing a FLOAT_NAN pcode op. (GP-5676, Issue #8092)
* _Demangler_. Fixed GnuDemangler to support the mangled TLS init function. (GP-5642, Issue #8105)
* _Documentation_. Fixed some typos in the Debugger Course. (GP-5670)
* _DWARF_. Fixed DWARF analyzer to handle Apple Mach-O truncation of DWARF5 section names.  Fixed DWARF analyzer to handle DW_TAG_atomic_type. (GP-5755)
* _Framework_. Fixed an issue where the installation directory was incorrectly reported in development mode. (GP-5698, Issue #8146)
* _GUI_. Fixed  a bug that caused the Symbol Tree to be blank when shown with a filter applied. (GP-5258, Issue #7365)
* _GUI_. Fixed a table filter bug that caused some escaped glob characters to prevent items from passing the filter. (GP-5337, Issue #7444)
* _GUI_. Fixed sporadic Decompiler function color bug that caused bad function colors to oscillate. (GP-5346, Issue #7453)
* _GUI_. Fixed an issue with program tabs when the panel is size-restricted. (GP-5578, Issue #7915)
* _GUI_. Fixed an issue where toolbar buttons sometimes got spaced far apart. (GP-5584, Issue #7984)
* _GUI_. Fixed bug in __Search Memory__ that created a bad component title which ultimately prevented the tool from saving. (GP-5597, Issue #8015)
* _GUI_. Fixed a bug that prevented the correct clearing of the `Esc` keybinding after restarting Ghidra. (GP-5599)
* _GUI_. Fixed a bug in GoTo dialog where entering a backslash (`\`) caused a stack trace. (GP-5615, Issue #8038)
* _GUI_. Fixed a bug on the Mac that caused `Ctrl-Mouse-Click` to clear the table selection when showing the popup menu. (GP-5618, Issue #7902)
* _GUI_. Fixed a bug that introduced duplicate data when renaming functions with a filter. (GP-5620, Issue #8031)
* _GUI_. Fixed the Data Type Manager's __Find Structures by Size...__ action so that it can find zero-length structures. (GP-5634, Issue #8096)
* _Importer:ELF_. Added ELF SH4 partial in-place relocation processing for R_SH_DIR32 and R_SH_REL32 relocations.  This was done in response to observed cases for VxWorks binaries. (GP-5605, Issue #8021)
* _Importer:Mach-O_. The `dyld_shared_cache` filesystem now exposes a complete set of files that encompass the cache's entire address space.  Performing an __Add To Program__ on broken references should no longer result in the address not being found. (GP-5349)
* _Importer:Mach-O_. Fixed an issue in the Mach-O loader that prevented uninitialized segments from being mapped into memory. (GP-5532, Issue #7949)
* _Importer:Mach-O_. Fixed a bug that resulted in incorrect external addresses of Mach-O undefined symbols. (GP-5554, Issue #5941)
* _Languages_. Corrected x86-16 Protected Mode / System Management Mode language upgrade issues which could cause problems.  This has been a long-standing problem which may have gone unnoticed but in some cases may have failed during the upgrade. (GP-5704, Issue #8140)
* _Multi-User:Merge_. Corrected various Multi-User Merge issues related to data types, including handling of missing/deleted datatypes, zero-length Structure components, and bit-field components. (GP-5421)
* _Multi-User:Merge_. Corrected various __Merge Tool__ Listing rendering issues related to external symbols. (GP-5480)
* _Multi-User:Merge_. Corrected possible exception during Bookmark merging. (GP-5626)
* _Processors_. Corrected patterns for x86 `INCSS`/`RDSSP` instructions. (GP-5267, Issue #6520)
* _Processors_. Corrected issue with AARCH64 `LDnR` instructions only writing to one register. (GP-5286, Issue #6470)
* _Processors_. Corrected `PUSHF` and `POPF` constructors in x86. (GP-5424, Issue #6601)
* _Processors_. Fixed instruction parsing for AARCH64 `dsb` instruction. (GP-5587, Issue #7996)
* _Processors_. Improved semantics for several AARCH64 Neon instructions. (GP-5622, Issue #5217)
* _Processors_. Fixed z80 `sub` instruction semantics. (GP-5659, Issue #8144)
* _Processors_. Corrected pcode for x86 `CVTTSD2SI` instruction. (GP-5665, Issue #8004, #8151)
* _Processors_. Corrected disassembly for several x86 AVX512 instructions missing immediate operands. (GP-5725)
* _Processors_. Corrected disassembly for RISC-V `max` and `minu` instructions. (GP-5729, Issue #8215)
* _Project_. Corrected project-folder-rename problem which was preventing subsequent use of decedent files.  This change also corrected related project file refresh and corrects invalid file index data which could prevent file creation after a combination of folder-renaming and file-versioning control actions. (GP-5660)
* _SARIF_. Corrected various SARIF import/export failures. (GP-5749)
* _Scripting_. Fixed a bug in the VxWorksSymTab_Finder script when run in headless mode. (GP-5682, Issue #8156)
* _Scripting_. Fixed a bug that prevented PyGhidra from properly using the user's already-active virtual environment. (GP-5710, Issue #8180)
* _Testing_. Updated pcodetest scripts to Python3. (GP-4995)

### Notable API Changes
* _API_. (GP-5458) `GhidraProject.openProject()` now throws `NotFoundException, NotOwnerException, LockException`.
* _API_. (GP-5591) Removed unused and unsupported `DataType.getDocs()` method.
* _Debugger_. (GP-2040) Deleted `AbstractAsyncServer`, `AsyncClaimQueue`, `AsyncLock`, `AsyncLoop`, `AsyncPairingCache`, `AsyncRace`, `AsyncSequence*`, `BitmaskSet`, `DebugByteChannel`, `TypeSpec` and related, without replacements.
* _Debugger_. (GP-3450) Added `UnwoundFrame.evaluate(Program, Varnode, AddressSetView)`.
* _Debugger_. (GP-5379) Most accessor methods on `TraceUniqueObject` derivatives now require a `snap` argument. For getters, this is the snap for which the value is sought. For setters, this implies the effect is from that snap onward. In most cases, the GUI's current snap is suitable. (The deprecated legacy-mode objects ignore the argument.) This required argument has cascaded throughout many other parts of the API: `DebuggerStaticMappingService`, `AutoMapSpec`, `MapProposal.MapEntry`, `DebuggerStaticMappingService`, `ProgramModuleIndexer`, `DebuggerObjectActionContext`, `DebugerSectionActionContext`, `BreakpointActionSet`, and `*EmuBreakpointActionItem`. Additionally, `getLifespan` and similar, including setters and "split-and-set," have been removed from most `TraceObjectUnique` derivatives. For cases where you need to check if the object is valid at a particular time, use `isValid(long)`. For cases where you need to enumerate (e.g., to plot) the life, use the underlying `TraceObject`. To truncate the life of an object, use `remove(long)`. For `TraceThread` in particular, the destruction snap is now considered part of its life, which is consistent with how every other object has been treated. Connectors should (and already have been) using `remove`, which sets the "destruction snap" to the one preceding the current.
* _Debugger:Agents_. (GP-4209) On the Python side: The ghidratrace package is now type-checked using mypy. As a result, the annotations used for the method registry now use `typing.Annotated` when parameters need additional description. `Client.create_trace()` now also requires a named parameter `extra`. On the Java side: Added `TraceTimeManager.findScratchSnapshot`. The trace-rmi protocol has also changed.
* _Debugger:Agents_. (GP-5538) Powershell is now supported as a debug launcher language on Windows.
* _Debugger:Breakpoints_. (GP-4546) TraceRmi methods with `action="break_ext"` now appear in the new drop-down. TraceRmi methods can now also specify their menu icon, as well as the text for their confirmation button in parameter dialogs. These are the `icon` and `ok_text` attributes, respectively. The `icon` attribute should be the id of an icon given in a theme.properties file.
* _Debugger:dbgeng.dll_. (GP-5678) Added `DebuggerListingService.getAutoReadMemorySpec()`. Moved `AutoReadMemorySpec` into the Debugger-api module. Created `AutoReadMemorySpecFactory` and refactored accordingly.
* _Debugger:Listing_. (GP-616) Added `Trace.getBaseDataTypeManager()` method.  Added `TracePlatform.getDataTypeManager()` method.  Added `TraceBasedDataTypeManager.getPlatform()` method.  `TraceDefinedDataView.create()` now takes optional `platform` argument.  Added `TraceVariableSnapProgramView.setPlatform()` method.  `DebuggerPlatformService.setCurrentMapperFor()` has an additional `focus` parameter.  Most methods in `DebuggerPlatformMapper` now take both `object` and `snap` parameters.  Added `AbstractDebuggerPlatformMapper.getDisassemblyPlatform()` method.  `DbgengX64DisassemblyInject.Mode` and related methods moved to `DbgengDebuggerPlatformOpinion`.
* _Debugger:Listing_. (GP-5548) Added `DebuggerStaticSyncService` interface and its Plugin implementation. Moved `DebuggerOpenProgramActionContext` into API project. Added `DebuggerConsolePlugin.clear()` method.
* _Debugger:Memory_. (GP-3405) Added `TraceHighlightEvent`.
Added `TrackingChangedPluginEvent`.
Added `AbstractLocation/Selection/HighlightPluginEvent`.
* _Debugger:Objects_. (GP-5425) Several protected abstract methods in `AbstractTarget` are removed without replacement. `Target.collectActions` now requires an argument specifying how its object arguments are gathered.
* _Debugger:Stack_. (GP-3771) Added `UnwindInfo.maskOfReturn`.
* _Debugger:Time_. (GP-5523) Added `TimeRadix` class. Added `TraceTimeManager.set/getTimeRadix` methods. `TraceSchedule.toString` and `.parse` methods now accept radix argument. `Span.toString` can now accept custom endpoint formatter.
* _Decompiler_. (GP-5477) Added new methods to the DecompilerHighlightService to allow function-specific highlights.
* _Framework_. (GP-5436) Deleted the Debug/Framework-AsyncComm project/module. Most of its few remaining classes were moved to Framework/Generic.
* _GUI_. (GP-5375) `GTree.forceNewNodeIntoView()` has been replaced by `GTree.whenNodeIsReady()`.
* _ProgramDB_. (GP-5742) Deprecated the use of `int` to indicate a CommentType in favor of the newly created enum.
* _Version Tracking_. (GP-4151) The Dialog Wizard API has been completely rewritten.

# Ghidra 11.3.2 Change History (April 2025)

### Improvements
* _Demangler_. Updated GNU Demangler text replacement to not replace some common namespace prefixes because in some cases doing so resulted in merging two unique namespaces into one. (GP-5503)
* _Processors_. Corrected several AARCH64 floating point comparisons. (GP-5402, Issue #7479, #7855)
* _Project_. In preparation for future project file types, project data error handling improvements have been made.  This will help to reduce project browsing issues when unsupported files types are encountered (locally or on newer server).  This may occur if newer file types are added to a project or shared repository and subsequently opened with an older version of Ghidra. (GP-5519)
* _Scripting_. Updated the RecoverClassesFromRTTIScript to correctly handle case when there are two valid vftable symbols on the same address. (GP-5461, Issue #7876)
* _Scripting_. Improved RecoverClassesFromRTTIScript ability to recognize the existence of RTTI in GCC binaries. (GP-5487, Issue #7904)
* _Scripting_. Added check to RecoverClassesFromRTTIScript to make sure vftable addresses are contained in valid memory blocks. (GP-5500, Issue #7927)
* _Scripting_. Improved RecoverClassesFromRTTIScript to do a better job validating GCC typeinfo structures by making sure there is space in memory before applying a typeinfo structure. (GP-5501)
* _Scripting_. Improved RecoverClassesFromRTTIScript to do a better job prevalidating GCC typeinfo structures by making sure the typeinfo-name member points to a string. (GP-5502)
* _Scripting_. Improved RecoverClassesFromRTTIScript's use of LowCodeBitMode addresses when validating virtual function starts. (GP-5505)
* _Scripting_. `pyghidra.open_program()` now accepts a `program_name` parameter, which can be used to override the program name derived from the `binary_path` parameter. (GP-5521)

### Bugs
* _Analysis_. Added population of SetThunkFunction dialog to the computed thunk location. Also added thunk function pattern for Powerpc `.plt` table linkage. (GP-5411)
* _Analysis_. Fixed issue where in some cases two vftable symbols (one plain and one with `'s`) were accidentally created at the same address. When running the RecoverClassesWithRTTIScript with the two symbols, this caused incorrect vftable structures to be applied. (GP-5422, Issue #7876)
* _Analysis_. Default switch case flow references have been removed from the switch instruction as they are reached normally by a conditional branch.  In addition, default case labels are now placed at the correct location. (GP-5583)
* _Basic Infrastructure_. Fixed an issue with external Ghidra extension classpath priority. (GP-5569, Issue #7977)
* _Data Types_. Corrected transaction error which could occur within Structure Editor when creating another structure from selected components. (GP-5412, Issue #7853)
* _Data Types_. Corrected a bug which caused an exception when typing into the Bitfield Editor datatype. (GP-5431, Issue #7865)
* _Data Types_. Added an optional __Ordinal__ column to the Union Editor. (GP-5485)
* _Data Types_. Corrected transaction error which can occur when launching the Structure Editor and one or more component-level datatype Settings have been previously applied. (GP-5556)
* _Data Types_. Corrected various issues within Structure Editor which prevented the Save, Undo, Redo buttons and status text from updating correctly. (GP-5557)
* _Data Types_. Corrected Union Editor shift up/down action bug which caused component datatype to be lost. (GP-5580, Issue #7994)
* _Debugger:Objects_. Fixed issue re-arranging columns in Elements table of Model panel when Plot column was disabled. (GP-4915)
* _Debugger:Watches_. Fixed issue where Watches didn't update on register changes. (GP-5383)
* _Debugger:Watches_. Fixed issue where watches referring to registers would cause errors when _previous_ coordinates had no thread. (GP-5394)
* _Emulator_. Fixed issue with StructuredSleigh where empty (nop) program caused compilation error. (GP-5459)
* _Emulator_. Fixed issue when branching from injected p-code in the emulator. (GP-5460)
* _Function_. Corrected Function parameter custom storage error which could occur when adding stack storage entries. (GP-5479, Issue #7900)
* _Importer_. Fixed a `ClassCastException` that could occur when extracting Mach-O files from a `dyld_shared_cache`.  The exception was due to the Mach-O having very large symbol table offsets. (GP-5371, Issue #7436)
* _Importer:ELF_. Corrected ELF MIPS import failure of DWARF debug file which could fail on processing of `.reginfo` section. (GP-5406)
* _Importer:ELF_. Fixed Tricore relocation `24REL` handling. (GP-5449, Issue #7868)
* _Importer:Mach-O_. Fixed an issue with processing Mach-O stub functions that could result in the wrong symbol being associated with a stub. (GP-5482, Issue #7899)
* _Importer:PE_. Fixed an exception that could occur when importing PE files with exactly eleven data directories. (GP-5558, Issue #7973, #7974)
* _MachineLearning_. Upgraded the MachineLearning extension's protobuf-java jar to 3.21.8 to avoid potential classpath conflicts with the Debugger. (GP-5534, Issue #7977)
* _Processors_. Fixed ARM `vselgt` conditional instruction semantics. (GP-4648, Issue #6531)
* _Processors_. Fixed ARM `vdup` instruction semantics. (GP-4649, Issue #5669, #6542)
* _Processors_. Fixed stack operand sizing for x86 `ENTER`, `LEAVE`, `IRETQ`, and `RETF` instructions. (GP-5011, Issue #6923)
* _Processors_. Fixed issue with MIPS16 processor using incorrect relative addresses on delayslot instructions. (GP-5131, Issue #862)
* _Processors_. Fixed invalid x86 `pop` instruction macros for some instruction variants. (GP-5299, Issue #7326)
* _Processors_. Fixed 6x09 `COM` instruction pcode. (GP-5305, Issue #5767, #6336)
* _Processors_. Fixed ARM Thumb missing the `strt` instruction. (GP-5386, Issue #7514)
* _Scripting_. Added `RecoverClassesFromRTTIScript` check to make sure GCC VMI typeinfo structures have valid number of bases in structure. (GP-5389, Issue #7516)
* _Scripting_. PyGhidra `open_program()` now handles locked projects better. (GP-5444, Issue #7536)
* _Search_. Corrected a problem with the Memory Search dialog which could prevent proper search of selected memory regions. (GP-5395)
* _SourceMatching_. Corrected parsing of certain DWARF source file paths. (GP-5561, Issue #7963)
* _Terminal_. Fixed issue with obtrusive scrolling when selecting text. (GP-5416)
* _Version Tracking_. Fixed NullPointerException that occured when clicking on Version Tracking match where either source or destination address was not in current program memory. (GP-5549, Issue #7964)

### Notable API Changes
* _Debugger:Emulator_. (GP-5517) Added Stack and Frames to the `pure emulation` trace object schema.
* _Debugger:Trace_. (GP-5522) `LifeSet.spans()` now returns a `NavigableSet`.
* _SourceMatching_. (GP-5561) SourceFileUtils.fixDwarfRelativePath has been renamed to SourceFileUtils.normalizeDwarfPath.

# Ghidra 11.3.1 Change History (February 2025)

### Improvements
* _Multi-User_. Allow a repository without an Admin in the ACL to instantiate during server startup.  The `svrAdmin -grant` command line tool may be used to assign a new Admin to a repository.  Currently, when a user is removed from the server they are removed from all repository ACLs which could leave a repository without an Admin which will fail on server startup. (GP-5368)

### Bugs
* _Basic Infrastructure_. Fixed a bug that prevented Ghidra from remembering the last-used JDK when the `JAVA_HOME` environment variable was set. (GP-5381, Issue #7503)
* _Debugger:LLDB_. Fixed an issue with local-lldb.bat. (GP-5347, Issue #4977)
* _Importer:ELF_. Packed relocations in MIPS 64-bit binaries are now applied correctly.  Previously, packed relocations would reference address `0x0`. (GP-5365)
* _Importer:ELF_. Corrected ELF Import bug which failed to pin absolute symbols and reported an Object Deleted error. (GP-5374)
* _Multi-User_. Corrected regression bug which would prevent Ghidra Server users from specifying a different login username. (GP-5362, Issue #7454)
* _Processors_. Added implementation for ARM `vld4` and `vst4` instructions. (GP-5268)
* _Scripting_. PyGhidra can now find modules that live in directories specified by the Bundle Manager. (GP-5298)
* _Scripting_. Fixed a PyGhidra issue that prevented accessing Java getters/setters as properties on non-public classes. (GP-5348, Issue #7450)
* _Scripting_. PyGhidra now respects the `application.settingsdir` property set in Ghidra's `launch.properties`. (GP-5372, Issue #7481)
* _SourceMatching_. Corrected implementation of DWARF source line `DW_LNS_const_add_pc` instruction. (GP-5353)

### Notable API Changes
* _Multi-User_. (GP-5362) Revised `PasswordDialog` constructors to simplify those used for password-only entry.

# Ghidra 11.3 Change History (February 2025)

### New Features
* _Analysis_. Added new logic to export facts and source/sink logic to Datalog. (GP-3443)
* _Data Types_. Added string translation option to use LibreTranslate to translate strings found in a binary. NOTE: This plugin is not enabled by default; the user needs to configure tool to include it if they want to use it. (GP-4877)
* _Debugger_. Added TraceRMI connector for JDI (Java/Dalvik targets). (GP-4760)
* _Debugger_. TraceRMI now supports debugging Java/Dalvik on Android. (GP-4893)
* _Debugger:Agents_. The deprecated Debugger plugins and connectors (e.g., IN-VM) have been removed. (GP-1978)
* _Debugger:LLDB_. Added support for debugging macOS kernels with lldb. (GP-5209)
* _Debugger:Targets_. Added support for local and eXDI-mode kernel debugging (dbgeng/dbgmodel). (GP-5185)
* _Emulator_. Added a high-performance p-code emulator using Just-in-Time translation to bytecode. (GP-4643)
* _Graphing_. Added two new __Flow Chart__ layouts for the function graph. These layouts organize code blocks into a tree structure and use orthogonal edge routing. One centers the parent block over the children and the other keeps the parent left aligned with its left most child. (GP-4988, Issue #1406)
* _GUI_. Updated the File chooser to allow users to edit the path field. (GP-3492, Issue #5291, #7150)
* _Importer_. Added a `Load Libraries` action that allows the user to load libraries after a program has already been imported. (GP-4919, Issue #396)
* _Scripting_. Integrated the DoD Cyber Crime Center's Pyhidra tool (renamed to PyGhidra) to provide a native CPython 3 interface to Ghidra. (GP-4816, Issue #6900)
* _Scripting_. Added a new button to the Script Manager that allows the user to edit scripts in Visual Studio Code.  Additionally, added a new action to the CodeBrowser under __Tools -> Create VSCode Module Project...__ that replaces the old `VSCodeProjectScript.java` script. (GP-5148)
* _Search_. Added an action to allow users to search Decompiled text from __Search -> Decompiled Text...__. (GP-4839, Issue #6795)
* _SourceMatching_. Added manager for source code and line number information to the Ghidra database. (GP-3883)
* _SourceMatching_. Added `SourceFilesTablePlugin` for viewing source file information and managing local paths. (GP-4190)

### Improvements
* _Analysis_. Corrected a vftable naming issue in RTTI Analyzer where programs with PDB information were not naming vftables with associated class name correctly. (GP-4687)
* _BSim_. Added a `status` command to `bsim_ctl`. (GP-5129, Issue #7102)
* _BSim_. Added ability to specify user login info with postgres/elastic BSim URLs for the `bsim` command line tool and API.  Updated BSim Server Manager GUI to allow user login name to be specified for postgres/elastic BSim server entries. (GP-5167)
* _BSim_. Updated BSim bundled postgresql server to 15.10 to resolve incompatibility with `openssl 3.2.2`. (GP-5212, Issue #6115, #7084)
* _BSim_. Tweaked BSim Dark Mode colors. (GP-5223, Issue #7312)
* _Build_. Fixed a build issue with Gradle 8.12. (GP-5226)
* _CodeBrowser_. Users can now apply bookmarks in the Listing to interior data of structures applied to memory. (GP-4820)
* _Data Types_. The Decompiler now propagates and displays names for enumeration data-types that have been partially truncated. (GP-2470)
* _Debugger_. Improved the behavior for Android targets. (GP-5034, Issue #6386)
* _Debugger:Agents_. Removed __raw gdb__ connector. Instead, just leave the __Image__ option blank in the __gdb__ connector. (GP-4906)
* _Debugger:Agents_. Added __Architecture__ and __Endian__ options to several gdb launchers. (GP-5005)
* _Debugger:GDB_. Added distinct launchers for qemu-system (vs. qemu-user). Windows only supports qemu-system. (GP-5051, Issue #7095)
* _Debugger:GDB_. Added __Pull all section mappings__ to the __qemu + gdb__ debug launcher. (GP-5089, Issue #7118)
* _Debugger:Listing_. __Load Emulator from Programs__ has been removed from the __Auto-Read Memory__ menus. It is now the default behavior for pure emulation, unless __Do Not Read Memory__ is selected. (GP-5134)
* _Decompiler_. Updated the Decompiler function name colors to match the Listing. (GP-5085, Issue #7053)
* _Decompiler_. Improved the Decompiler's handling of signed integer comparisons in the presence of the AARCH64 `ccmp` instruction. (GP-5158)
* _Demangler_. Added ability to process Microsoft C-style mangled function symbols. (GP-4898, Issue #1514)
* _Demangler_. Improved processing of anonymous namespaces in vxtables. (GP-5101)
* _Demangler_. The builtin `int` type in Swift binaries has been changed from 8 bytes to 4 bytes.  The Swift Demangler now demangles the `Swift.Int` type to `__int64` (or `__int32` on 32-bit programs) to avoid conflicts with non-Swift structures and functions that may be found in the program. (GP-5182, Issue #6784)
* _Eclipse Integration_. GhidraDev 5.0.0 has been released which supports creating and launching new Ghidra module and scripting projects with PyGhidra support (using the PyDev Eclipse plugin). (GP-5138)
* _FileSystems_. Updated to dex2jar-2.4.24 and asm-9.7.1 libraries. (GP-5220)
* _Function_. Now prevent function auto-storage assignment for DEFAULT (`undefined`) datatype.  Changed Demangler to produce undefined-typedef in place of a DWORD-typedef when producing a default-named datatype.  Demangler will still create an empty named Structure in many cases.  Decompiler will no longer assign the `undefined` datatype to variables. (GP-4886)
* _Graphing_. Added an action to toggle between the Listing and Function Graph views (`Ctrl-Space`). (GP-4947)
* _Graphing_. Added options for which corner the Function Graph Satellite view is docked within the main Graph window. (GP-4996)
* _GUI_. Updated theming to allow users to change the table's base font and monospaced fonts separately. (GP-4873, Issue #6853)
* _GUI_. Changed the Linux default theme from `Nimbus` to `Flat Light`. (GP-4973)
* _GUI_. Updated Key Binding assignment to allow users to choose `Backspace` and `Enter`. (GP-5007, Issue #6972)
* _GUI_. Upgraded FlatLaf to 3.5.4. (GP-5027)
* _GUI_. Added options to the __Clear With Options...__ action to allow just clearing instructions or data instead of having to do both or neither. (GP-5084, Issue #7082)
* _GUI_. Users can now pick a language by double-clicking in the Importer Dialog. (GP-5097, Issue #7135)
* _GUI_. Updated the `Flat Dark` table inactive selection color. (GP-5108, Issue #7134)
* _GUI_. Users can now press the `Escape` key to close windows that contain only a single component provider. (GP-5114, Issue #7136)
* _GUI_. Updated table and tree filters to support `Ctrl-F` to place focus on the cursor.  Also added an action to hide and show the filter. (GP-5115, Issue #7136)
* _GUI_. The Function Call Tree plugin now distinguishes between call references and non-call references. (GP-5116)
* _GUI_. Changed actions that _show_ a component provider into toggle actions that _hide_ the provider if already visible. (GP-5117, Issue #7136)
* _GUI_. Added a `Downloads` folder to the File Chooser. (GP-5118, Issue #7121)
* _GUI_. Added the Unresolved Reference color to the Theme Configuration. (GP-5157)
* _GUI_. Added support for expressions in address input fields. (GP-5196, Issue #7227)
* _Importer_. Fixed a performance issue when loading libraries on Windows. (GP-5208)
* _Importer:COFF_. The MS Common Object File Format (COFF) loader now recognizes AARCH64 binaries. (GP-5153)
* _Importer:COFF_. Added relocation handlers for ARM and AARCH64 COFF files. (GP-5154)
* _Importer:ELF_. The ElfLoader imagebase option can now contain a leading `0x`. (GP-4955, Issue #6912)
* _Languages_. Added support for golang 1.23. (GP-4870)
* _Listing_. Added ability to copy data values and referenced data values to the clipboard via the copy special action. (GP-5036)
* _Listing_. Hovering on addresses in the Listing now show offsets in both decimal and hexadecimal. (GP-5176, Issue #7239)
* _Navigation_. Improved GoTo Dialog to support full namespace paths with wildcards. (GP-4930)
* _PDB_. Improved PDB composite reconstruction when padding components are required to facilitate proper packing. (GP-5037, Issue #1030)
* _PDB_. Enabled the processing of some older PDB component versions by fixing up previously written code intended for processing them. (GP-5072, Issue #7100)
* _PDB_. Improved searching for PDB files. (GP-5174, Issue #7200)
* _Processors_. Made a number of improvements to the TI_MSP430 compiler spec. (GP-4202)
* _Scripting_. `GhidraScript.askFile()` no longer throws an `IllegalArgumentException` in headless mode when passing in a valid path argument to a file that does not yet exist. (GP-5010, Issue #7025)
* _Scripting_. Upgraded Jython to 2.7.4. (GP-5210)
* _Search_. Added a button to the Instruction Pattern Search dialog that allows users to add more instructions to the current set of patterns. (GP-2418)
* _SourceMatching_. Added source file mapping for golang. (GP-4196)
* _SourceMatching_. Added `OpenSourceFileAtLineInVSCodeScript.java` and `OpenSourceFileAtLineInEclipseScript.java` for communicating source map information to vscode and eclipse. (GP-5217)
* _Terminal_. Added keys to adjust font size. Fixed theme changes should take immediate effect. (GP-5003)

### Bugs
* _Analysis_. Fixed issue in RTTIAnalyzer introduced with previous fix to incorrect anonymous PDB namespaces. Leaving the old name as a secondary label caused RTTI Script to assume two different classes with same Listing contents. (GP-5146, Issue #3213)
* _Analysis_. Fixed issue where a TEB Analyzer failure reverts entire analysis. (GP-5338)
* _Assembler_. Improved `WildcardAssembler` to have less stringent requirements for input `contextreg` values. (GP-5288, Issue #7195)
* _BSim_. Corrected various bugs related to BSim elasticsearch use. (GP-1830)
* _BSim_. Corrected various bugs affecting BSim Elasticsearch use. (GP-5207)
* _BSim_. Corrected BSim apply signature when source calling convention is unknown (e.g., custom) to destination. (GP-5216, Issue #7310)
* _BSim_. Corrected `NullPointerException` in `BSimFeatureVisualizer`. (GP-5252, Issue #7311)
* _Byte Viewer_. Fixed bug that cleared the Byte Viewer __Address__ column when changing fonts. (GP-4998)
* _CParser_. Parsing header files with the CParser will now stop parsing when a `#error` directive is encountered.  Numerous parsing errors involving comment parsing have been fixed. (GP-5025, Issue #7001)
* _CParser_. Added CParser support for `__vectorcall`, `__rustcall`, and `__pascal` calling conventions. (GP-5150)
* _Debugger_. Fixed issue toggling and deleting breakpoints and watchpoints in lldb. (GP-5271)
* _Debugger:dbgeng.dll_. Provided fix for missing stack values for some variants of `dbgmodel.dll`. (GP-5195)
* _Debugger:GDB_. Added a __Refresh__ action for stack frames other than just the topmost one. (GP-5169)
* _Debugger:GDB_. Fixed endianness of register value display in Model tree. (GP-5230)
* _Debugger:Listing_. Fixed issue with obtrusive and spurious auto-seek events. (GP-5266)
* _Debugger:Mappings_. Fixed issue with registers not displaying because of a conflict in language/compiler opinion between the back and front ends, particularly affecting gdb with Windows x64 targets. (GP-5232)
* _Debugger:Memory_. Fixed an issue with manually adding a Region from the UI. (GP-5164, Issue #7176)
* _Debugger:Memory_. Fixed Auto-Read memory when using Force Full View. (GP-5180, Issue #7176)
* _Debugger:Modules_. Fixed `NullPointerException` from `TraceModule.getBase().getAddressSpace()` commonly seen when launching and mapping Windows targets. (GP-5102, Issue #7153)
* _Debugger:Objects_. Fixed issue where __Model__ tree pane didn't update after editing a register in the CLI. (GP-5229)
* _Debugger:Registers_. Fixed issue where registers could not be edited. (GP-5213)
* _Debugger:Trace_. Fixed unflushed object stream in `Saveable TracePropertyMap`. (GP-5121)
* _Decompiler_. Fixed occurrence of _"Unable to create datatype associated with symbol"_ exceptions when using the __Override Signature__ action. (GP-5006, Issue #3694)
* _Decompiler_. Fixed a bug where the Decompiler failed to resolve references into structures that were recursively defined. (GP-5038)
* _Decompiler_. Fixed a Decompiler bug encountered when renaming a token that caused middle-mouse highlights to persists. (GP-5040, Issue #7077)
* _Decompiler_. Fixed possible infinite loop when inlining recursive functions in the Decompiler. (GP-5073, Issue #5824)
* _Decompiler_. Fixed crash in the Decompiler triggered while recovering a heap string written at a negative offset relative to the pointer. (GP-5130)
* _Decompiler_. Fixed infinite loop in the Decompiler triggered by data-types with a nested structure containing an array. (GP-5184, Issue #7212)
* _Diff_. Fixed missing parameters in the Diff Tool Listing view. (GP-5155)
* _Eclipse Integration_. Fixed an issue with the GhidraDev Eclipse plugin's __Import Ghidra Module Source__ feature that prevented the module's extension points from being discovered by Ghidra when launched with the project's run/debug configuration. (GP-5125, Issue #7047)
* _Framework_. Fixed an exception that occurred when closing the Front End tool. (GP-4962, Issue #6937)
* _Function_. Corrected Function custom storage editor's handling of compound storage checking for big-endian programs. (GP-5198)
* _Function Compare_. Fixed bug in LocalBsimQueryScript where showing new function comparison windows would stop working after you closed the comparison window the first time. (GP-5329)
* _GUI_. Corrected Function custom storage editor datatype selection which failed to properly clone datatype to program's data organization. (GP-4913)
* _GUI_. Updated the Ghidra Script table so all columns are resizable. (GP-4983, Issue #6918)
* _GUI_. Fixed table selection bug in the Memory Map provider when a table filter is applied. (GP-4984)
* _GUI_. Fixed fast scrolling behavior sometimes seen when using the `Flat Light` or `Dark` themes. (GP-4993, Issue #6952)
* _GUI_. Fixed entropy legend labels to be visible in all themes. (GP-5103)
* _GUI_. Fixed a bug that caused the table Column Filter Dialog to not update when new columns were added. (GP-5289, Issue #7175)
* _GUI_. Fixed the Escape key sometimes not working in Tree and Table cell editors. (GP-5313, Issue #7241)
* _Importer:PE_. Provided a fix related to an incorrect length for Windows PE `IMAGE_DEBUG_MISC` processing. (GP-5199, Issue #7285)
* _Importer:PE_. Fixed a `NullPointerException` that could occur when processing debug COFF symbol information. (GP-5321, Issue #7411)
* _Multi-User_. Corrected Ghidra versioning bug where server may not be updated with latest checkout details following a checkout update.  This could allow file versions to be deleted from the repository when they still have corresponding checkout(s).  To correct existing checkout data, all project files should be checked-in, without keeping checked-out, then re-checkout if necessary to correct the repository metadata. (GP-5123)
* _Multi-User_. Corrected Ghidra Server concurrent modification error which could occur during client repository disposal.   Improved control of java path used by `ghidraSvr` script and other Ghidra launch scripts through the use of `JAVA_HOME` environment variable. (GP-5161)
* _Processors_. Added EVEX writemask to pcode for x86 AVX-512 instructions. (GP-4660)
* _Processors_. Corrected ARM VFPv2 instructions which were not disassembling correctly. (GP-5181, Issue #7259)
* _ProgramDB_. Corrected issue related to locally stored Program user data that may not handle language version upgrades properly. (GP-5205)
* _ProgramTree_. Fixed `NullPointerException` when restoring a program tree window in which a tab was previously closed. (GP-5279)

### Notable API Changes
* _Debugger:Agents_. (GP-1978) The entirety of `DebuggerObjectModel` and most of its related paraphernalia have been removed. Other parts have been refactored into other components. `DebuggerObjectModel` / `TraceRecorder` is replaced by `TraceRmi` / `Target`. `TargetObject` is replaced by `TraceObject`. Some `TargetObject` interfaces, e.g., `TargetDeletable`, do not have replacement `TraceObject` interfaces. Instead, they are implied by applicable `RemoteMethods`. Others, e.g., `TargetAccessConditioned`, are removed without replacement.  `DataType`- and `Symbol`-related objects are removed. They have not been used. If needed later, the intent is to provide rmi-based access to the trace's symbol table and data type manager. `TargetObjectSchema` is replaced by `TraceObjectSchema`. `TraceObjectKeyPath` is renamed `KeyPath`. `PathUtils` and many uses of `List<String>` have been replaced by `KeyPath`. `AnnotatedSchemaContext` and related are removed. `SshPtyFactory` and related are removed.
* _Emulator_. (GP-4643) Added `JitPcodeEmulator` and many, many related classes. `PcodeArithmetic`: changed `modBeforeStore` and `modAfterLoad` to include `AddressSpace` and `PcodeOp` parameters.  `SleighInstructionDecoder.decodeInstruction` now returns a `PseudoInstruction`. PcodeExecutor: added `getIntConst`, `getLoadStoreSpace`, `getLoadStoreOffset`, `getStoreValue`, `getBranchTarget`, `getConditionalBranchPredicate`, `getIndirectBranchTarget`, `getUseropName`, `getCallotherOpNumber`.
* _BSim_. (GP-5167) Changed BSim API to convey non-default username via the `BSimServerInfo` class or the `userinfo` field of postgres/elastic BSim URLs.  The user argument has been dropped to the `FunctionDatabase.changePassword` method which will always change the password for the connected user.   Renamed `FunctionDatabase.Error` class to `FunctionDatabase.BSimError` to avoid naming conflict with `java.lang.Error`.
* _Data Types_. (GP-3625) Added `FileDataTypeManager` static methods for creating a Data Type Archive with a specific processor and compiler specification.  Improved `CParserUtils` parse methods to separate the cases where parsing into an existing Data Type Manager versus parsing into a new Data Type Archive where a processor and compiler specification may specified.
* _Debugger:Listing_. (GP-5134) `DebuggerListingProvider#setAutoReadMemorySpec` and related no longer accept `LoadEmulatorAutoReadMemorySpec`. Added `AutoReadMemorySpec#getEffective`.
* _Decompiler_. (GP-5085) Updated `DecompileOptions` to remove the `getFunctionColor()` method. There is no replacement for this method as the function color is now being set in the Listing Settings menu and is coordinated across the Listing and Decompile panes.
* _Demangler_. (GP-4898) Within the `Demangler` interface, Ghidra 9.2-deprecated methods were removed, Ghidra 11.3-deprecations were set on other methods, and  new methods were created.  The new methods and much of the Demangler fabric now makes use of a `MangledContext` in place of a `String`.  This allows greater flexibility in controlling how symbols get demangled.  These changes have been reflected in abstract and non-abstract methods in `AbstractDemanglerAnalzyer`.  Users of deprecated methods within `Demangler` and `DemanglerUtil` should migrate to newer methods (see javadoc).
* _GUI_. (GP-5007) Added a new widget, the `docking.KeyEntryPanel`, as a drop-in replacement for clients using the `docking.KeyEntryTextField`.  This is not a required change.
* _GUI_. (GP-5196) The static method `evaluateToLong(String s)` in `AddressEvaluator` has been moved to a new class called `ExpressionEvaluator`. Also, the `AddressInput` field component has been changed to accept Programs instead of just an AddressFactory (which is still supported) so that any dialog using an `AddressInput` component can now accept symbol names, memory block names, and mathematical expressions.
* _Importer_. (GP-5208) GFileSystems now need to implement `lookup(path, comparator)`.   Classes that fail to provide an implementation will fall back to using `lookup(path)`, and an error will be logged.
* _Search_. (GP-4911) The API script method `findBytes()` no longer supports finding matches that span gaps in the memory blocks. The internal classes for performing memory searches were completely re-written in Ghidra release 11.2. In release 11.3, the old classes were removed and uses of them in the `findBytes()` method were replaced with the new memory search code. The new search API currently does not support matches that span non-contiguous memory and it isn't clear if that is actually useful; so for now, that method was deprecated and no longer finds matches in gaps even if the boolean is true. In the unlikely event someone actually uses this, please contact the Ghidra team.
* _Assembler_. (GP-5288) Added `AssemblyResolvedPatterns.withContext`.  Added `ContextCommit.getWordIndex` and `getMask`.
* _BSim_. (GP-1830) Dropped use of `json-simple` library in favor of `gson`.
* _Debugger_. (GP-5271) Added `TraceBreakpoint.isAlive(long snap)`.  Deprecated `TraceBreakpoint.getLifespan()`.  Added `TraceObject.isAlive(long snap)`.
* _Debugger:Listing_. (GP-5266) Renamed `DebuggerCoordinates.equalsIgnoreRecorderAndView` to `equalsIgnoreTargetAndView`.  Added `DebuggerCoordinates.differsOnlyByPatch`.  Added `TraceSchedule.differsOnlyByPatch`.  Added `Sequence.differsOnlyByPatch`.
* _Debugger:Memory_. (GP-5164) Renamed `DebuggerAddRegionDialog#setName` to `setPath`.

# Ghidra 11.2.1 Change History (November 2024)

### New Features
* _Debugger:GDB_. Added GDB batch scripts for Windows. Also, updated ssh+gdb scripts to take path to ssh as an option. (GP-4957, Issue #7069)

### Improvements
* _Analysis_. Updated RTTI Analyzer to fix incorrect PDB symbols in anonymous namespaces when the PDB does not have complete namespace information and RTTI structures do. (GP-5053, Issue #3213)
* _Decompiler_. Added support for detecting optimized strings loaded from labeled memory. (GP-4979, Issue #6925, #6985)

### Bugs
* _Analysis_. Clearing of bad flow after a call that is found to be non-returning will no longer clear DLL Import table entries or defined data beyond `Undefined<n>`. (GP-4696, Issue #6636)
* _BSim_. Fixed the Elasticsearch `lsh.zip` plug-in for the `BSimElasticPlugin` extension. (GP-5043, Issue #7051, #7054)
* _BSim_. Corrected `synchronous_commit` setting for BSim postgresql database and eliminated some warnings in the postgresql logs. We now ensure that all DB connections are closed properly when the Ghidra process exits normally to avoid unnecessary server logging of failed DB connection errors. (GP-5082, Issue #6951)
* _DB_. Corrected issue closing `FileDataTypeManager` affecting use of DataType Archives on Windows platforms which could produce an error during resource cleanup. (GP-5090)
* _Debugger_. Fixed issue launching debuggers on Windows where the installation path contains spaces. (GP-5015, Issue #6999)
* _Debugger:Emulator_. Fixed issue with stale disassembly in Emulator. (GP-4483)
* _Debugger:Emulator_. Fixed Emulator to heed UI-driven patches to the program counter. (GP-4889, Issue #6867)
* _Debugger:Trace_. Fixed bug in Listing with __Force Full View__ enabled. (GP-2032)
* _Decompiler_. Fixed a bug in the Decompiler causing _"Case block has become detached from switch"_ exceptions. (GP-4899, Issue #6819)
* _Decompiler_. Fixed bug that could cause an infinite loop in the Decompiler on functions accessing a 1-byte structure. (GP-4972, Issue #6969)
* _Decompiler_. Fixed infinite loop in the Decompiler associated with overlapping fields in a structure. (GP-4985, Issue #6991)
* _Emulator_. Fixed issue with slow stepping that occurred in the Emulator after an interrupt. (GP-4231, Issue #6109)
* _Importer:Mach-O_. Fixed an exception that could occur in the MachoLoader when an External Program had a space in its name/path. (GP-4997, Issue #6989)
* _Importer:PE_. Fixed an _exception_ that could occur while parsing PE `Control Flow Guard` structures, preventing the binary from successfully importing. (GP-5009, Issue #6960)
* _Scripting_. Fixed a typo in `VSCodeProjectScript.java` that resulted in the `Extensions/Ghidra/Skeleton` directory not being found. (GP-4971, Issue #6971)
* _Scripting_. Added vxworks external symbol markup, which was previously ignored. (GP-5000)

# Ghidra 11.2 Change History (September 2024)

### New Features
* _Basic Infrastructure_. Ghidra now requires JDK 21 to run. (GP-4122)
* _Build_. A Gradle wrapper script is now included at `support/gradle/gradlew(.bat)` which can be used to perform all Gradle commands without the need for prior Gradle installation. The Gradle wrapper requires an Internet connection to work. Offline Gradle installations on the PATH continue to work the same way as before. (GP-4486, Issue #455)
* _Debugger_. Provided new launchers/features for the traceRMI version of dbgeng, including extended launch options, kernel debugging, and remote process server connections. (GP-4686)
* _Debugger_. The Debugger Python components now require Python 3.9 to Python 3.12. (GP-4842)
* _Decompiler_. The Decompiler now supports the automatic recovery of _stack strings_. (GP-3307, Issue #1380, #2285, #6431, #6592)
* _Decompiler_. Added a __Search All__ button to the Decompiler __Find__ dialog. This button will show all results of the search in a table. (GP-3491, Issue #5317, #538)
* _GUI_. Added __Create Table__ action to the __Symbol Tree__ and __Symbol Table__ to create a new temporary table of symbols. (GP-4574)
* _GUI_. Added a __Find Uses of__ field action to the Enum Editor. (GP-4577, Issue #6475)
* _GUI_. Added support for `Ctrl-A` to select _all_ in the Python window. (GP-4605, Issue #6502)
* _Headless_. Added a JShell launcher with the full Ghidra classpath. (GP-4876)
* _Processors_. Added Intel MC16/60 and MC16/80 processor specifications. (GP-4879)
* _Scripting_. Added `VSCodeProjectScript`, which can create a new Visual Studio Code project that is setup to do Ghidra scripting and module development, with similar capabilities to the Eclipse GhidraDev plugin. (GP-4795)
* _Search_. Updated the Memory Search feature to show results in the query window and added two new features: (1) dynamic updating of results that change, stay the same, increment, or decrement; and (2) combining results from successive searches using boolean set operations. (GP-4559)

### Improvements
* _Analysis_. Refactored Sparc processor detection and mitigation of Call/Return behavior due to an instruction in the delay slot that changes the `o7` link register. Also fixed 64/32 relocations, sparc calling conventions, and added several missing instructions and hidden structure return pointer location. (GP-3808, Issue #5646, #6300)
* _Analysis_. Added support for Golang 1.15 and 1.16. Versions supported are now 1.15-1.22. (GP-4482)
* _Analysis_. Added a new `MIDIDataType` and audio player for embedded MIDI scores. (GP-4516, Issue #6337)
* _Analysis_. Refactored eBPF analyzers and expanded on applied BPF Helper functions. (GP-4682)
* _Analysis_. Updated the `RTTIAnalyzer` to improve its determination of the end of virtual function tables. (GP-4748)
* _BSim_. Added BSim database `connect`/`disconnect` actions to BSim Server Manager. This will allow an idle connection to be disconnected without the need to exit Ghidra or removing a server entry, which, in the case of a local H2 database, will allow another process to use it. (GP-4867, Issue #6703)
* _Byte Viewer_. Extended HexInteger to other integral data types. (GP-4709, Issue #6658, #6659)
* _CodeCompare_. Added ability to add functions to the last function comparison window. (GP-4634)
* _Data Types_. Added __Edit Data Type__ action that allows users to edit a chosen data type from anywhere in the tool by using the `Ctrl-Shift-D` keyboard shortcut. (GP-4148, Issue #5975, #6576)
* _Data Types_. Added __Undo__/__Redo__ popup menu actions for Archives within datatype tree. (GP-4719)
* _Data Types_. Added __Undo__/__Redo__ support to the structure and union datatype editors as well as other minor improvements. (GP-4740)
* _Data Types_. Improved performance of various structure editor behaviors including setting the structure size. (GP-4949, Issue #6504, #6936)
* _Debugger_. Provided more complete compiler matching using `ldefs` language definition files. (GP-4675)
* _Debugger:Agents_. Deprecated Framework-Debugging module and Model-based debug connectors, moving toward removal. (GP-4801)
* _Debugger:Agents_. User may now use binary (0b prefix), octal (0 prefix), or hex (0x prefix) in integer-valued launcher option fields. (GP-4847)
* _Debugger:Registers_. Changed how __Go To [address]__ actions are presented with regard to __Force Full View__. (GP-3898, Issue #5817)
* _Decompiler_. Added __Go To Next/Previous Highlight__ actions to allow navigating Decompiler middle-mouse highlights. (GP-3494, Issue #538)
* _Decompiler_. Improved Function Editor to facilitate partial changes which limit impact to Decompiler results (e.g., only change calling convention) and avoid locking full function signature. (GP-4324)
* _Decompiler_. Improved multi-threaded decompilation performance and possibly disassembly by removing some unnecessary locking. (GP-4712, Issue #6649, #6650)
* _Decompiler_. Provided initial support for recovering optimized heap strings in the Decompiler. (GP-4733)
* _Decompiler_. The Decompiler now forces casting to a signed value when converting integers to floating-point. (GP-4871, Issue #6760)
* _Demangler_. Added support for GNU Demangler output simplification. (GP-3810, Issue #5725)
* _Demangler_. Improved Microsoft Demangler to include handling of `noexcept` attributes and certain type name suffixes. (GP-4626)
* _Demangler_. Modified MDMang: added calling conventions and custom data type; added end, empty parameter, and unnamed template types; modified reference modifiers and guard name processing; fixed empty member pointer qualification; and worked around LLVM embedded object issue. (GP-4663)
* _Demangler_. Changed application of MDMang `` `anonymous namespace'`` strings to their underlying anonymous name to avoid namespace conflicts. (GP-4717, Issue #6661)
* _Demangler_. Added `char8_t` primitive type to DemangledDataType. (GP-4823)
* _Demangler_. Updated the GNU Demangler to support global constructors and destructors. (GP-4825, Issue #6791)
* _Documentation_. Added discussions of program specification extensions and instruction length modification to the advanced Ghidra class slides, along with miscellaneous clarifications and improvements. (GP-3774, Issue #5667, #5702)
* _DWARF_. Added DWARF analyzer option to ignore parameter storage location info and to use calling convention default layout instead. Also added DWARF analyzer option to specify the calling convention name for functions created by the analyzer. (GP-4150)
* _Eclipse Integration_. The latest Eclipse GhidraDev plugin (4.0.0) now requires Eclipse 2023-12 or later running under JDK 21 or later. (GP-4846)
* _Function Compare_. Added actions to compare functions from the Listing, Decompiler, and Functions Table. (GP-4619)
* _GUI_. Updated the Listing and Byte Viewer title bars to show the number of addresses or bytes selected while dragging. (GP-1359, Issue #2482)
* _GUI_. Added __Show Namespace__ action to the Function Call Trees to display the function's namespace in each node. (GP-3251, Issue #5115)
* _GUI_. Add __Filter Thunks__ action to the Function Call Trees to hide think functions. (GP-3252, Issue #5116)
* _GUI_. Added the __Simplified Name__ column to the Symbol Table. (GP-3377, Issue #6125)
* _GUI_. Added the ability to Snapshot the Symbol Tree. (GP-3849)
* _GUI_. Added the structure member comment to the Decompiler tooltip window. (GP-4661)
* _GUI_. Added single option in the Front End Tool to control whether or not cursors blink in any field panel or text component. (GP-4676, Issue #6570)
* _GUI_. The __Edit Data Type__ action in the Decompiler will now select the structure field row when launching the editor. (GP-4728, Issue #5717)
* _GUI_. New Listing fields and `Copy Special` actions have been added for imagebase offset, memory block offset, and function offset (disabled by default). (GP-4855, Issue #6794)
* _Headless_. Improved handling of headless command-line arguments when the optional list of arguments passed to a pre/post script contain arguments that start with a dash. (GP-4707, Issue #6639)
* _Importer_. Added a new __Add Library Search Path__ action to files and folders in the File System Browser that will allow library files to be loaded from within a GFileSystem. (GP-4563)
* _Importer_. Added a new `-librarySearchPaths` command line argument to the headless analyzer, which allows a semicolon-delimited list of library search paths to be specified. (GP-4564)
* _Importer_. OMF records are now marked up. (GP-4722)
* _Importer:ELF_. Improved ELF handling of unresolved symbols during relocation-processing to prevent import failure. (GP-4737, Issue #6673)
* _Multi-User_. Upgraded `yajsw` to 13.12. (GP-4860)
* _PDB_. Changed the PDB symbol server search config dialog to allow marking symbol servers as trusted/untrusted instead of using the symbol server's connection type. (GP-4735)
* _PDB_. Improved PDB class namespaces determination and standardized some naming between PDB and MDMang. (GP-4773)
* _PDB_. Added `char8_t` primitive type to PDB Universal analyzer. (GP-4822)
* _PDB_. Modified PDB MSDIA interpretation of malformed datatype fields with no underlying datatype. (GP-4827, Issue #6744)
* _Processors_. Fixed several PPC EVX instructions that were not affecting the destination register as a return value assigned from a pseudoOp call. (GP-4702)
* _Processors_. Added PSPEC label description tag and `addr="next"` which allows for a large number of contiguous labels placed at an address based on the previous label without specifying the exact address of each label. (GP-4742)
* _Processors_. Processor specs now accept the `volatile` attribute in  tags. (GP-4849, Issue #6755)
* _ProgramTree_. Updated the Program Tree default double-click behavior. Double-clicking now navigates instead of replacing the view. This can be changed in the tool options. (GP-4691)
* _Scripting_. GhidraScripts can now declare an `@runtime` metadata comment to specify which GhidraScriptProvider is required to run them (e.g., `Jython`). This will allow different GhidraScriptProviders that use the same script file extension (e.g., `.py`) to coexist. (GP-4706)
* _Scripting_. Improved `RecoverClassesFromRTTIScript` heuristics for determining class constructors and destructors. (GP-4764)
* _Scripting_. Changed `RecoverClassesFromRTTIScript` virtual function definitions from using the formal signature (i.e., no `this` param) to using `void *this` param. This will improve the Decompiler output while continuing to not force a particular class structure on the generic definition's `this` param. (GP-4812)
* _Scripting_. `RecoverClassesFromRTTIScript` now caches `vfunction` list in order to speed up processing. (GP-4863, Issue #6834)
* _Scripting_. Fixed a recursion issue in RecoverClassesFromRTTIScript. (GP-4865, Issue #6832, #6833)
* _Scripting_. Changed PasteCopiedListingBytesScript to handle hexdump format and listing bytes field split to multiple lines. (GP-4928)
* _Terminal_. Added __Select All__ action to __Terminal__ window. (GP-4631, Issue #6502)
* _Version Tracking_. The Version Tracking Matches table now has table column filters and now allows users to delete matches from the table (although this is not recommended). (GP-4410, Issue #6066, #6281)

### Bugs
* _Basic Infrastructure_. Fixed a ClassSearcher exception that could occur when launching Ghidra in `single jar mode`. (GP-4844, Issue #6809)
* _Data Types_. Corrected concurrency exception related to use of `EnumDataType.getNames()` method. (GP-4797, Issue #6765)
* _Data Types_. Fixed `StructureDB.delete(Set ordinals)` and `UnionDB.delete(Set ordinals)` method implementations which failed to properly remove component records from database and update remaining components correctly. This method is used by the Structure and Union editors when removing components. (GP-4814)
* _Data Types_. Fixed issue in the Data Type Chooser dialog that caused inconsistent auto-complete behavior. (GP-4854)
* _Debugger_. Fixed catchpoint-related errors in GDB versions <= 10. (GP-4745, Issue #6666)
* _Debugger_. Provided an initial fix for dealing with error induced by the occurrence of `continue` during another GDB command. (GP-4750, Issue #6678)
* _Debugger_. Fixed potential register description errors when `info registers all` or `info registers general` are invalid. (GP-4757)
* _Debugger_. Added `attach` script for dbgeng (WinDbg). (GP-4784, Issue #6735)
* _Debugger_. Fixed an issue with Listing display when trace overlay spaces are present. This issue had affected the dbgmodel connector. (GP-4788)
* _Debugger_. Removed test logic that was accidentally left in place. (GP-4841, Issue #6802)
* _Debugger_. Fix for potentially missing `Attributes` field from older versions of dbgmodel. (GP-4856, Issue #6825)
* _Debugger_. The default Emulator was updated to remove TraceRmi launchers. Users should delete and re-import Emulator.tool, or remove the TraceRmiPlugin manually. (GP-4953)
* _Debugger:Emulator_. Fixed memory-space issues, especially in RegistersProvider. (GP-4781)
* _Debugger:Emulator_. Changed stack allocation to adhere to SP in program register context at PC. (GP-4834, Issue #6427)
* _Debugger:GDB_. Fixed issue with GDB continuing instead of stepping over (or out of) library function calls. (GP-4858, Issue #6822)
* _Debugger:Mappings_. Fixed launchers to adhere to __Modules__ window's __Auto-Map__ setting. Fixed `DebuggerStaticMappingService` to update properly on changes. (GP-4713, Issue #6662)
* _Debugger:Mappings_. Fixed/rewrote buggy `StaticMappingService`. (GP-4868)
* _Debugger:Memory_. Fixed stale __Force Full View__ menu toggle when tabbing between traces. (GP-4835)
* _Debugger:Registers_. Fixed issue preventing __Registers__ panel from displaying frames other than 0. (GP-4850)
* _Debugger:Watches_. Fixed issue in Watches where evaluation of concatenations failed. The error reported was _"index -1 in array of size 2"_ or similar. (GP-4952)
* _Decompiler_. Fixed analysis of floating-point expressions in the Decompiler that could sometimes cause loss of precision in constants. (GP-2559, Issue #4586, #5785, #6708)
* _Decompiler_. Fixed a bug causing the Decompiler to fail to resolve array references properly in nested structures. (GP-4887)
* _Decompiler_. Fixed a corner case in the Decompiler for optimized division simplification where the division operands are extended from different-sized variables. (GP-4890, Issue #6648)
* _Decompiler_. Corrected a use after free vulnerability in Sleigh decompiler backend. (GP-4929, Issue #6890)
* _Diff Tool_. Fixed the __Save Default Diff Apply Settings__ action in the __Diff Apply Settings__ window. (GP-4670)
* _Eclipse Integration_. Fixed a GhidraDev issue that could result in a `NullPointerException` within `GhidraHelpService` when launching Ghidra. (GP-3490, Issue #6734)
* _Function_. Fixed an issue with incomplete function body creation due to the removal of a branching reference when the branch destination was to the next instruction and the instruction flowType had no fallthrough. (GP-4926)
* _GUI_. Fixed the Structure Editor `Tab` key traversal. (GP-4716, Issue #5738)
* _GUI_. Fixed issue in add references dialog where moving the mouse sometimes reset the address space combo box back to the default ram space. (GP-4779)
* _GUI_. Fixed minor rendering issues with combo boxes when using the Metal Look and Feel. (GP-4818)
* _GUI_. Fixed __Structure Editor__ sometimes not getting focus when opening. (GP-4857, Issue #6782)
* _GUI_. Fixed an exception in the Stack editor when editing and using the down arrow. (GP-4891, Issue #6883)
* _GUI_. Fixed incorrect cell being edited on `Tab` key press while editing in the Enum Editor. (GP-4892, Issue #6873)
* _Importer_. Fixed an `IndexOutOfBoundsException` that could occur when loading OMF binaries. (GP-4884, Issue #6862)
* _Importer:ELF_. Corrected regression bug where ELF Importer was ignoring option to disable relocation processing. (GP-4799, Issue #6751)
* _Importer:ELF_. Added missing mips opinion for R3/4 n32 automatic processor identification during import. (GP-4939)
* _Listing_. Fixed bug in the GoTo dialog where it wouldn't find a label if you had more than one namespace in the path. (GP-4761, Issue #6699)
* _Multi-User_. Fixed regression causing Version Control status not updated after check-in. (GP-4921)
* _PDB_. Supplied work-around for class that contains inner member with same class name as containing class name; pertaining to LLVM lambdas. (GP-4595)
* _PDB_. Fixed a bug in the processing of PDB MSDIA names passed from the native `pdb.exe` processing component. Members that had a bit-field type or that had a namespace delimiter in the name were affected. (GP-4843, Issue #6788)
* _Processors_. Fixed PIC16 `PCLATH` and `RP0` code flow and data reference issues. (GP-4596, Issue #3239, #6466)
* _Processors_. Fixed ARM `ldaexd` instruction semantics. (GP-4645, Issue #6526)
* _Processors_. Fixed ARM `sha1su0.32` instruction semantics. (GP-4646, Issue #6529)
* _Processors_. Fixed ARM `sha1su1.32` instruction semantics. (GP-4647, Issue #6530)
* _Processors_. Corrected `CMOV` semantics when destination and source overlap. (GP-4714, Issue #6523)
* _Processors_. Fixed bug in SPARC `sdivcc` instruction. (GP-4747, Issue #6689)
* _Processors_. Fixed m68000 `ext` instruction not updating flags. (GP-4749, Issue #6679, #6690)
* _Processors_. Fixed extension of immediates for certain variants of the x86 `SBB` instruction. (GP-4754, Issue #6521)
* _Processors_. Corrected semantics for x86 `PEXTR` instructions which write to memory. (GP-4769, Issue #6511)
* _Processors_. Corrected semantics of x86 `CMPPS` instruction. (GP-4772, Issue #6512)
* _Processors_. Added semantics for several x86 AVX instructions in use by GCC: `VCVTTSx2Sx`, `VDIVSx`, `VINSTERT128`, and `VEXTRACT128`. (GP-4776)
* _Processors_. Corrected semantics of x86 `PACKUSWB` instruction. (GP-4777, Issue #6514)
* _Processors_. Added missing float-to-integer cast operation, `trunc()`, to x86 `CVTSD2SI` instruction. (GP-4778, Issue #6513)
* _Processors_. Fixed aliasing issues in certain x86 SIMD instructions. (GP-4783, Issue #6524)
* _Processors_. Fixed incorrect `.sla` file reference in PPC e500mc processor specification. (GP-4826)
* _Processors_. Fixed issue with the M68000 `fmovem.l` instruction using FPCR in place of FPIAR. (GP-4845, Issue #6810)
* _Processors_. Fixed sparc 32/64-bit multiply instructions. (GP-4912, Issue #6287, #6346)
* _ProgramDB_. Corrected `NullPointerException` when setting instruction length override for a non-fallthrough instruction. (GP-4775)
* _References_. Fixed spurious replacement of small constants when the low byte of an offset matches the low byte of the reference address. Also turned the option to manipulate constants with masks and shifts to be off by default. (GP-4667, Issue #1564)
* _Scripting_. Added check in the `RecoverClassesFromRTTIScript` to make sure `ClassHierarchyDescriptor` symbols are in a non-Global namespace before trying to promote their namespace to a class namespace. If such symbols are found in the Global namespace it indicates potential issues with either the RTTI data or the processing of the RTTI data; in these cases, no class recovery will be done for the associated classes. (GP-4763, Issue #6704)
* _Scripting_. Fixed `NullPointerException` in `PropagateExternalParametersScript`. (GP-4883, Issue #6841)
* _Scripting_. Fixed CodeUnitInsertionException error in RecoverClassesFromRTTIScript.java script. (GP-4932, Issue #6848)

### Notable API Changes
* _Search_. (GP-4559)
The MemorySearchService has been changed. This had been a very specific service API created to support just one plugin and was not generally useful. The three existing methods have been consolidated into one method. The old service has been marked as deprecated and may be removed in future releases. If, in the unlikely event that anyone is using this service, please contact the Ghidra team to discuss your use case.
* _Data Types_. (GP-4949)
Added API method `Structure.setLength(int length)` which allows the size of a non-packed structure to be set.
* _Debugger:Agents_. (GP-4847)
`LaunchConfigurator.configureLauncher()` is changed such that `arguments` now requires `ValStr<?>` instead of just `?` for its values. This affects both the new Trace-RMI launchers and the deprecated object-model launchers.

# Ghidra 11.1.2 Change History (July 2024)

### New Features
* _Basic Infrastructure_. Ghidra native components (Decompiler, GNU Demangler, etc.) now run properly on Windows ARM using x86 emulation. Building natively for Windows ARM is not yet supported (Gradle limitation). (GP-4738)

### Improvements
* _Data Types_. Corrected resolution of typedefs whose name matches the underlying type name. (GP-4751, Issue #6493)
* _Processors_. Made minor semantic changes to the X86 processor specification for several AVX instructions as well as changes to UDF undefined instructions. (GP-4724)

### Bugs
* _Data Types_. Fixed Structure bug where DB may not be updated properly with length change induced by certain operations (e.g., `insertBitFieldAt`). (GP-4756)
* _Data Types_. Fixed formatting of float value `-0.0` within assembly Listing view. (GP-4759, Issue #6677)
* _Debugger_. Added `.bat` launchers for GDB and LLDB on Windows. (GP-4677)
* _Debugger_. Fixed GDB `show version` parse error. (GP-4698, Issue #6646)
* _Debugger_. Fixed an issue with handling of memory read errors in GDB TraceRMI connector. (GP-4701, Issue #6647)
* _Debugger_. Fixed GDB endianness calculation. (GP-4704, Issue #6656)
* _Debugger:GDB_. Provided fall-back to refresh all registers when `general` is not recognized by GDB as a register group. (GP-4710, Issue #6635)
* _Importer:ELF_. Fixed ELF X86-64 GOT allocation bug which could cause exception during import. Also added unverified ELF relocation support for `R_X86_64_GOT64` and `R_X86_64_PLTOFF64`. (GP-4758, Issue #6691)
* _Importer:Mach-O_. Fixed an issue with importing Mach-O binaries that have an empty `__chain_starts` section. (GP-4695)
* _Importer:Mach-O_. Fixed a regression in the MachoLoader that prevented some KDK binaries from being loaded. (GP-4699)
* _Multi-User:Merge_. Fixed assertion error which occured for multi-user merge of register context within overlay memory blocks. (GP-4508, Issue #6403)
* _Processors_. Fixed AARCH64 Windows stack alignment. (GP-4752, Issue #6680)

# Ghidra 11.1.1 Change History (June 2024)

### Bugs
* _Debugger_. Fixes an error in `dbgeng` launcher. (GP-4674)
* _Debugger:GDB_. Fixed issue with using QEMU launchers in Trace RMI (`ClassCastException` from `String` to `PathIsFile`) (GP-4690, Issue #6634)
* _Decompiler_. Fixed a bug in the Decompiler that could cause it to drop a control-flow edge from a switch's case statement that looped back to the switch. (GP-4582, Issue #6282)
* _Decompiler_. Fixed bug causing "Undefined Pullsub" exceptions. (GP-4672, Issue #6614)
* _Decompiler_. Corrected Decompiler process issue which can occur when analysis is cancelled. Issue would incorrectly popup error indicating _"Decompiler executable may not be compatible with your system..."_. (GP-4689)
* _GUI_. Fixed mouse button 4/5 processing failure that caused the left-click to stop working. (GP-4681, Issue #6624)
* _Processors_. Added support for the Z80 processor undocumented registers. (GP-2881, Issue #4485)
* _Processors_. Fixed 6805 branch conditional instruction semantics. (GP-4585, Issue #6482)
* _Project_. Fixed a severe regression bug introduced with Ghidra 11.1 which could prevent a user from completing a project file add-to-version-control, checkin or merge when they currently have the file open in a tool. The corresponding open project file would remain in a bad state following the operation. (GP-4692)

# Ghidra 11.1 Change History (June 2024)

### New Features
* _Assembler_. Added the `WildcardAssembler` module and API for allowing the masking of operands. (GP-4287, Issue #6118)
* _Basic Infrastructure_. Replaced the __Show VM Memory__ dialog with an upgraded __Runtime Information__ dialog. The dialog contains more information which can aid in debugging, including version information, classpath, defined properties, environment variables, and more. (GP-3844, Issue #5760)
* _Debugger_. Added a Trace RMI launcher for Windows targets on Linux using Wine. (GP-3891)
* _Debugger_. Added Trace RMI connector for Microsoft Time-Travel Debugging. (GP-4182)
* _Debugger:Agents_. Added TraceRMI protocol to provide access to the trace database API over protobufs. This is a simpler alternative to GADP. Implemented TraceRMI client for Python3; added TraceRMI plugins for GDB, LLDB, and WinDbg (dbgeng). Added services, APIs and GUI components for managing TraceRMI connections. (GP-3816)
* _Debugger:dbgeng.dll_. Extended dbgeng Trace RMI connector to support dbgmodel. (GP-4290)
* _Debugger:GDB_. Added Trace RMI connector for QEMU with GDB. (GP-3838)
* _Debugger:GDB_. Added `raw` GDB and Python 3 connectors. (GP-4439)
* _DWARF_. Added DWARF5 support. (GP-2798, Issue #4088)
* _Eclipse Integration_. The GhidraDev Eclipse plugin has a new wizard for importing an existing Ghidra module source directory. This will work best with Ghidra module projects created against Ghidra 11.1 or later. (GP-707, Issue #284)
* _FileSystems_. Added a new `GFileSystem` for Mach-O file sets (i.e., the kernelcache). (GP-3770, Issue #4827)
* _FileSystems_. Added support for SquashFS FileSystems. (GP-3946)
* _FileSystems_. Added support for decompressing LZFSE files (iOS/macOS kernelcache) to the File System Browser. (GP-4391)
* _GhidraGo_. Remote and local GhidraURL's that locate DomainFolders are now acceptable input for GhidraGo. Both result in opening the read-only view for the project and selecting the DomainFolder in the FrontEnd. If the local URL refers to the currently active project, the domain folder will be selected within that. (GP-4433)
* _Languages_. Improved Swift support by adding Swift Demangler, Swift cspecs, Swift opinions, and by applying type metadata where possible. (GP-3535)
* _Version Tracking_. Added ability for Version Tracking Session files to be checked into a version control repository. Versioned use is restricted to exclusive checkout use only since there no ability to merge VT Session data. (GP-4085)

### Improvements
* _Accessibility_. Improved filter options dialog for accessibility. (GP-2264)
* _Accessibility_. Fixed several focus traversal issues. Also, added convenience actions for moving to next/previous window (`Ctrl-F3`/`Shift-Ctrl-F3`) and next/previous component provider (`Ctrl-J`/`Shift-Ctrl-J`). (GP-4227)
* _Accessibility_. Added quick action dialog to make actions accessible and more convenient for users who prefer to use keyboard more than mouse. `Ctrl-3` will bring up the dialog. (GP-4267)
* _Accessibility_. Added accessible names to most main provider components. (GP-4275)
* _Accessibility_. Improved analyzer enablement so that checkboxes can be changed via the keyboard using the spacebar. (GP-4375, Issue #6261)
* _Accessibility_. Improved export options window to allow changing checkboxes via keyboard using the spacebar. (GP-4414, Issue #6279)
* _Accessibility_. Improved keyboard navigation in __Add Reference__ dialog. (GP-4491, Issue #5761)
* _Accessibility_. Improved Accessibility for assorted __Memory Map__ dialogs. (GP-4511)
* _Analysis_. Sped up switch recovery analysis on AArch64 objectiveC binaries where `BRK` instruction is used throughout the code for exceptions. (GP-4364)
* _Analysis_. Added pattern to recognize PPC `get_pc_thunk_lr` position-independent-code-related function. (GP-4474)
* _Analysis_. The speed of the __Create Address Tables__ analyzer has been improved for large runs of addresses. (GP-4477)
* _API_. Created builder for `DomainObjectListeners` to express even-handling logic more concisely. (GP-4222)
* _API_. Revised `DomainObject` java interface while eliminating separate `UndoableDomainObject` and `Undoable` java interface classes. Revised tool-based foreground `Command`-processing to defer event-flushing into a background task. Additional `execute` methods were added to `PluginTool` which allow lambda functions to be used in the place of a `Command` object. (GP-4390)
* _Assembler_. Added context hints to __Patch Instruction__ (Assembler) results. (GP-3993)
* _Assembler_. Context is re-flowed and instructions re-disassembled following the __Patch Instruction__ action. (GP-4014)
* _Assembler_. By virtue of API changes, the Assembler is now more extensible by plugins for advanced use cases. (GP-4185)
* _Basic Infrastructure_. Ghidra now supports the XDG Base Directory Specification. Default locations of the user settings, cache, and temporary directories have moved to more standardized platform-specific locations. See comments in the `support/launch.properties` file for more detailed information on how these directories are determined and overridden. (GP-1164, Issue #908)
* _Basic Infrastructure_. Improved the start up time of Ghidra by only loading `ExtensionPoints` when they are first requested. (GP-4515)
* _Build_. Fixed compilation of `TreeValueSortedMap` for Java 21. (GP-3923, Issue #6083)
* _Build_. Ghidra will now run on FreeBSD with user-built native components using the `support/buildNatives` script. See the Installation Guide for more information on building native components. NOTE: `bash` is required to be installed in order for Ghidra to launch on FreeBSD. Additionally, the Debugger is not currently supported on FreeBSD. (GP-4235, Issue #6117)
* _Byte Viewer_. Added the ability to resize the __Address__ column in the ByteViewer window. (GP-2147)
* _Data_. Added `writable` Mutability data setting to allow chosen data within a read-only memory block to deviate from the block setting. Decompiler was updated to respect this setting. (GP-4505)
* _Data Types_. Improved datatype resolution and conflict handling as well as datatype name sorting. (GP-3632)
* _Debugger_. Domain Object event ID numbers have been refactored to be enums. (GP-2076)
* _Debugger_. Removed TargetRecorder-dependent methods from FlatDebuggerAPI. Moved them to deprecated FlatDebuggerRecorderAPI. Ported FlatDebuggerAPI to Target interface. Added FlatDebuggerRmiAPI. (GP-3872)
* _Debugger_. Moved launch and control command progress monitors to the __Debug Console__. (GP-3997)
* _Debugger_. The __Sections Table__ pane can now be toggled on and off in the __Modules__ window. (GP-4156)
* _Debugger_. Upgraded to most current release of llvm/lldb (17.x). (GP-4385)
* _Debugger_. Added Trace RMI connector for GDB `target remote`. (GP-4437)
* _Debugger_. Made modifications to accommodate remote embedded targets. (GP-4441)
* _Debugger_. Released Trace RMI as the default Debugger back end. (GP-4485)
* _Debugger_. Made modifications to enable traceRMI dialog-driven methods. (GP-4527)
* _Debugger:Agents_. Released version 11.1 of Trace RMI python packages and protocol. (GP-4487)
* _Debugger:Agents_. The launch failure dialog now previews the last two lines of each Terminal. Selecting __Keep__ will automatically bring those terminals to the front. (GP-4637)
* _Debugger:Emulator_. Pure emulation use cases can now involve thread creation and destruction and they can be recorded linearly in a trace. (GP-4374)
* _Debugger:Listing_. Added context menu to location label in __Dynamic Listing__ and __Memory Bytes__ windows. (GP-4311)
* _Debugger:Listing_. Progress for memory reads now displays in the __Debug Console__ window. (GP-4399)
* _Debugger:Mappings_. Moved initial mapping failure at launch to the __Debug Console__, rather than popping the launch failure dialog. (GP-4636)
* _Debugger:Memory_. Made __Memory__ window more consistent with __Dynamic Listing__ window in terms of appearance and operation. (GP-1625)
* _Debugger:Stack_. Added __Module__ column to __Stack__ window. (GP-4093)
* _Debugger:Threads_. Moved trace selection tabs to __Dynamic Listing__. (GP-1608)
* _Debugger:Threads_. Added __PC__, __Function__, __Module__, and __SP__ columns to the __Threads__ table. (GP-4236)
* _Debugger:Threads_. Removed __Synchronize Target Activation__ toggle. Time navigation is now prohibited in Target control mode, especially using the Plot column header. (GP-4334)
* _Decompiler_. Added __Edit Signature Override__ action to Decompiler. Improved cleanup of unused override signature datatypes. (GP-4263, Issue #6000)
* _Decompiler_. The Decompiler is now able to simplify additional forms of 64-bit optimized integer division. (GP-4300, Issue #5733)
* _Decompiler_. Added additional Decompiler support for recovering the addresses of calls and other global symbols for MIPS binaries compiled with Position-Independent Code (PIC) options. (GP-4370)
* _Decompiler_. The Decompiler now displays array index constants using the configured `Integer format`, rather than always using base 10. (GP-4394, Issue #6019)
* _Disassembly_. Created `FixOffcutInstructionScript` that attempts to automatically fix an offcut instruction and its references in a restricted fashion. This script can be bound to a hotkey for a user to quickly attempt fixups throughout a program. Also, updated the set instruction length override action to automatically suggest a reasonable length, based on offcut flows, and to disassemble these flows if used. (GP-4034, Issue #5928)
* _Disassembly_. Fixed storage of default disassembly context to the program database. Programs with no stored context, which is most, will disassemble faster. (GP-4535)
* _Disassembly_. Improved disassembly speed and use of instructions for any purpose by delaying check of instruction overrides until needed. (GP-4536)
* _Documentation_. Updated Debugger training materials for Trace RMI. (GP-3887)
* _Eclipse Integration_. Upgraded the GhidraDev Eclipse plugin to make it compatible with Ghidra 11.1. (GP-4176)
* _Eclipse Integration_. The Ghidra Eclipse preferences and formatter files are now included in the release under `support/eclipse/`. (GP-4233, Issue #5999)
* _Framework_. Updated system actions to allow for user-defined key bindings. (GP-4317)
* _GUI_. Added tool option to remove quotes from strings before putting into clipboard. (GP-3871, Issue #1155)
* _GUI_. Simplified the dialog for switching themes. (GP-4172, Issue #6024)
* _GUI_. Updated the Help Info keybinding to `Ctrl-Shift-F1` in order for components to allow `Ctrl-F1` to work for showing tooltips. (GP-4304)
* _GUI_. Added a __Copy Special__ action to the Listing to copy the byte source offset of the selected address. (GP-4318, Issue #6195)
* _GUI_. Updated Key Binding options for actions to allow users to set mouse bindings. (GP-4436, Issue #208)
* _Importer_. Added ability to import/export multiple program trees using SARIF. (GP-4079)
* _Importer_. The MzLoader can now load binaries whose file size is less than the size that is reported in its header. (GP-4260, Issue #6029)
* _Importer_. The Importer post-load message log is now echoed to the application.log file. This behavior can be disabled in the `support/launch.properties` file by uncommenting the `VMARGS=-Ddisable.loader.logging=true` line. (GP-4313)
* _Importer_. The PeLoader now pads memory blocks with zeros instead of creating an uninitialized block with the same name. (GP-4347, Issue #6238)
* _Importer_. Fixed an issue in the MzLoader where the default Program Tree was out of sync with the Memory Map. (GP-4432, Issue #6277)
* _Importer:COFF_. COFF headers are now marked up. (GP-4184)
* _Importer:ELF_. Added relocation handlers for the TI_MSP430 and TI_MSP430X processors. (GP-4152)
* _Importer:ELF_. Added ELF Import option to enable/disable the creation of undefined data for data symbols with known sizes. This option is enabled by default. (GP-4178)
* _Importer:ELF_. Transitioned to new `AbstractElfRelocationHandler` implementation which uses `ElfRelocationType` enums specific to each handler. (GP-4239)
* _Importer:ELF_. Relaxed ELF `PT_DYNAMIC` restriction to allow it to be processed when not covered by a `PT_LOAD`. (GP-4291, Issue #5784)
* _Importer:Mach-O_. Improved handling of Mach-O `DYLD_CHAINED_PTR_ARM64E_KERNEL` chained pointer fixups. (GP-4259, Issue #6144, #6145)
* _Importer:Mach-O_. The `dyld_shared_cache` loader now implements pointer fixups for newer versions that use `dyld_cache_slide_info5`. (GP-4380)
* _Importer:Mach-O_. The MachoLoader now does a better job at importing binaries with corrupted load commands. (GP-4561, Issue #6271)
* _Languages_. Added support for structured data-type parameters for x86 64-bit System V ABI. (GP-4031)
* _Languages_. Added Golang 1.21 support. (GP-4183, Issue #6072)
* _Languages_. Added support for Apple Silicon and AARCH64 Golang binaries. (GP-4465)
* _Languages_. Added support for Golang 1.22. Versions supported are now 1.17-1.22. (GP-4579)
* _Listing_. Added options to wrap operand fields on semicolons. This is to better support processors that have more than one instruction at an address. (GP-4289)
* _Memory_. Added `Artificial` memory block flag intended to identify those blocks that the Debugger should not map into a running target. (GP-4125)
* _Memory_. Removed lock contention on reading and update of memory AddressSet cache. (GP-4534)
* _Multi-User_. Significantly improved shared project directory performance when directories contain a very large number of files. (GP-4456)
* _PDB_. Modified `LoadPdbTask` to schedule `EntryPointAnalyzer`. (GP-4244)
* _PDB_. Modified `PdbUniversalAnalyzer` to do work into multiple phases so that this work can benefit from work done in interim analyzers. (GP-4245)
* _PDB_. Reduced number of data type conflicts by delaying the resolve step in the multi-phased resolve process. Also refactored the multi-phased resolve, removing placeholder types. (GP-4246)
* _PDB_. Stubbed additional larger-than-64-bit pointers to ensure they do not cause problem when used. (GP-4264)
* _PDB_. Improved mechanism for setting primary symbols; reduced memory footprint by removing primary symbol map and using the now-more-performant ghidra primary symbol methods. (GP-4335, Issue #3497)
* _Processors_. Added subset of Tricore relocations as well as function start patterns. (GP-3110, Issue #1449)
* _Processors_. Corrected errors in the MSP430 SLEIGH specification. (GP-4401, Issue #4120)
* _Processors_. Corrected implementation of `ZR` (aka `R0`) register access for MCS-96 processor. (GP-4407, Issue #6181)
* _Processors_. Added callfixup for `__chkstk()` found in windows AARCH64 binaries. (GP-4513)
* _ProgramDB_. Improved locking behavior of Instructions and Data when retrieving bytes from memory. (GP-4568)
* _Project_. Added an abstract `GhidraURLQueryTask` and related `GhidraURLQuery` utlity class to failitate proper GhidraURL queries and to avoid replication of code. (GP-4447)
* _Scripting_. Python scripts now have access to the `this` variable, which is a reference to its parent GhidraScript object. It may be necessary to refer to `this` in certain scenarios, such as when releasing the consumer of a Program object returned by `askProgram()`. (GP-4157)
* _Scripting_. Updated `RecoverClassesFromRTTIScript`'s GCC class recovery to handle copy relocations. (GP-4396)
* _Scripting_. Added script to paste address/bytes copied as text from a Ghidra Listing. (GP-4480)
* _Scripting_. Upgraded OSGi-related jars. (GP-4550)
* _Sleigh_. Compiled SLEIGH (`.sla`) files are now stored in a compressed format to save disk space and shorten language load times. (GP-4285)
* _Testing_. Upgraded jacoco to version 0.8.11. (GP-4262)
* _Version Tracking_. Added __Function Compare__ action to the __Version Tracking__ main match table and associated match tables. (GP-4251, Issue #6010)

### Bugs
* _Analysis_. Improved recovery of additional windows resource references in certain cases by handling the decompiler produced `MULTI_EQUAL` pcode operation. (GP-7)
* _Analysis_. Exported symbols are now checked that they are not symbols internal to a function before creating a function. (GP-4506)
* _Data_. Corrected improper Data pointer stacking behavior when applying a pointer data type onto an existing pointer. (GP-4181)
* _Data Types_. Corrected various Data settings issues where Listing display failed to update properly with settings change. (GP-4212, Issue #5922)
* _Data Types_. Corrected transaction error when disassociating a datatype from an archive not open for update. (GP-4524, Issue #6424)
* _Data Types_. Fixed searching for references to structure fields when the field is referenced in a local structure that is then passed to an external function. This has a major effect on Windows programs. (GP-4592, Issue #5652)
* _Data Types_. Corrected data type source archive transaction error when performing bulk archive revert, update, and disassociate actions. (GP-4615, Issue #6503)
* _Debugger_. Fixed module map to ignore artificial blocks, especially `tdb` on Windows. (GP-4072, Issue #5994)
* _Debugger_. Fixed thread-specific stepping in dbgmodel. (GP-4279)
* _Debugger:Emulator_. Fixed issue where step command is ignored after the emulator encounters an error; e.g., undefined userop. (GP-4248, Issue #6086)
* _Debugger:Listing_. __GoTo__ in Dynamic Listing can now find symbols with external linkage; e.g., IAT entries. (GP-3408)
* _Debugger:Listing_. Fixed issue with incorrect byte values in Debugger's snapshot comparison listing. (GP-4528)
* _Debugger:Memory_. Fixed error message regarding closed programs in the navigation history when using the __Memory__ (dynamic hex) viewer. (GP-4100)
* _Decompiler_. Corrected issue with Decompiler return/param commit which could cause return details to revert to default state. (GP-4434, Issue #6318)
* _Decompiler_. Fixed Decompiler bug causing erroneous `case` labels for some switches contained in an `if` block. (GP-4514, Issue #6128)
* _Demangler_. Fixed out-of-memory issue in MDMang due to infinite loop. (GP-4641, Issue #6586)
* _FID_. Corrected FID error caused by Functions defined where no memory block resides. (GP-4584, Issue #6453)
* _Graphing_. Fixed `NullPointerException` in the `ChkDominanceAlgorithm`. (GP-4530)
* _GUI_. Fixed Listing to navigate to requested address when opening from a URL. (GP-4281, Issue #6166)
* _GUI_. Fixed Memory Search results to select all matched address when making a selection from the results table. (GP-4538, Issue #6415)
* _GUI_. Fixed stack overflow in Bundle Manager window when trying to remove all bundles. (GP-4604)
* _Importer_. Fixed the handling of non-default address spaces, specific to SARIF. (GP-4097)
* _Importer_. Fixed `NullPointerException`s in the SARIF handlers. (GP-4510)
* _Importer_. Fixed an issue in the MzLoader that would prevent some 16-bit MZ binaries from loading correctly. (GP-4575, Issue #5970)
* _Importer_. Fixed a regression that prevented library search paths from getting saved. (GP-4594)
* _Importer:Mach-O_. The MachoLoader no longer throws an exception when importing DWARF dSYM companion files. (GP-4417, Issue #6302)
* _Importer:PE_. Fixed an `EOFException` in the PeLoader that could occur when data directories point to section padding bytes. (GP-4496, Issue #6380)
* _Importer:PE_. Fixed an issue with the provided `.exports` files not getting properly used in some scenarios. (GP-4628)
* _Languages_. Corrected handling of operand-size override prefix with x86 `MOVSX`/`MOVZX` instructions. (GP-4629, Issue #6525)
* _Multi-User_. Corrected potential deadlock condition within Ghidra Server. (GP-4531)
* _PDB_. Removed PDB symbol server URLs from default list that don't publish PDBs. (GP-4266, Issue #3109, #6152)
* _PDB_. Fixed issue preventing VS6 PDB from being processed due to unexpected unavailable `DebugData` streams. (GP-4571, Issue #6464)
* _Processors_. Added support for x86 AVX512 instructions (GP-1561, Issue #2209, #4704, #6458)
* _Processors_. Added PIC16F `movlb` variant instruction form to processor module. (GP-3723)
* _Processors_. Fixed Xtensa `bany` semantics and added simplifying cases for `sext` instruction. (GP-4254, Issue #6113)
* _Processors_. Corrected register sizing for the x86 `str` instruction. (GP-4272, Issue #6156)
* _Processors_. Fixed bug in the M68000 processor with instructions referencing immediate byte values displaying erroneous two-byte values. (GP-4377, Issue #4191, #6260)
* _Processors_. Fixed operand ordering in x86 `FDIVP` instruction. (GP-4381, Issue #6266)
* _Processors_. Made several bug fixes for SuperH processor module. (GP-4498, Issue #5967, #6013)
* _Processors_. Fixed AARCH64 `ldst` instruction to properly support register writeback. (GP-4499)
* _Processors_. Fixed Tricore `st.da` instruction writing half-words instead of words. (GP-4552, Issue #6456)
* _Processors_. Updated x86-64 `RCL` and `RCR` instructions to set `CF` correctly. (GP-4576, Issue #6423)
* _References_. Updated `EditMemoryReferencePanel` to enable inclusion of `OTHER` overlay spaces for address specification. (GP-4345, Issue #6245)
* _Version Tracking_. Improved Version Tracking __Implied Match__ determination to make sure the destination location is a function if the source location is a function. (GP-4283)

# Ghidra 11.0.3 Change History (April 2024)

### Improvements
* _Decompiler_. Fixed v850 Decompiler treatment of global `GP` and `TP` registers as separate registers. (GP-4479, Issue #3515)
* _Languages_. Added thunk patterns for use of `BTI C/CJ` instruction at start of AARCH64 thunk functions. (GP-3917)
* _Processors_. Added p0/p8 registers as prefer split to Tricore.cspec (GP-4507, Issue #3515)

### Bugs
* _Build_. Corrected build problem that causes module src.zip files to be omitted from distribution when a `externalGhidraExtension` is present. This did not impact the current Public release since it does not include any such modules. (GP-4492)
* _Decompiler_. Fixed bug causing switch analysis to lay down jump tables with extra entries. (GP-4416)
* _Processors_. Fixed regression in Tricore calling convention for parameters and returns that are a smaller datatype than the full register size. (GP-4468, Issue #6354)
* _Scripting_. Fixed `NullPointerException` in the `RecoverClassFromRTTIScript` that happened for Windows programs when a class had a hierarchy at least four levels deep, with a single inheritance chain, and with the root being a virtual class. (GP-4459, Issue #6348)
* _Version Tracking_. Corrected potential Exception within address correlators that check function parameters. (GP-4490)

# Ghidra 11.0.2 Change History (March 2024)

### Improvements
* _Accessibility_. Eliminated redundant screen-reading of text with cursor-up and cursor-down movements in the Decompiler view. (GP-4297, Issue #6177)
* _Debugger:GDB_. Fixed an issue connecting to GDB on some builds of Windows. (GP-4392, Issue #6107)
* _Decompiler_. The Decompiler now treats software breakpoints as indirect calls that do not take parameters and do not return. (GP-4332)
* _Decompiler_. Improved detection of switch variables when their path crosses a call. (GP-4369)
* _Headless_. Updated analyzer options to not create Java Swing components in headless mode. (GP-4309)
* _Importer:ELF_. Revised ELF PowerPC relocation processing for `R_PPC_ADDR16_LO` and `R_PPC_ADDR16_HA` to address FreeBSD conventions. (GP-4397)
* _Multi-User_. Updated Ghidra Server `server.conf` to facilitate specification of enabled TLS cipher suites. Enabled cipher suites have been constrained by default, consistent with RFC 9151. (GP-4330)
* _Multi-User_. Made minor improvement to shared project performance when populating folders containing a large number of files. This was done by caching the FileID associated with each remote project file. (GP-4455)
* _Processors_. Added support for ARM v8-M Custom Datapath Extension. (GP-1791)
* _Scripting_. Added check to `RecoverClassesFromRTTIScript` to not run if there are unhandled relocations in GCC programs for the necessary RTTI symbols. (GP-4371)

### Bugs
* _Analysis_. Fixed analysis lockup if the fall-through of an instruction is overridden to itself. (GP-4312, Issue #6179)
* _Analysis_. Loosened MIPS jump target function-start pattern. (GP-4442, Issue #3677, #4193)
* _BSim_. Corrected BSim command `listexes --limit` option processing. (GP-4362, Issue #6246)
* _Build_. Removed unused log4j-jcl 2.16.0 jar dependency. Updated postgresql JDBC driver jar to 42.6.2. (GP-4449)
* _Debugger_. Removed leading slash in executable path for Windows launch options. (GP-4331)
* _Debugger:GDB_. Fixed issue parsing breakpoints with command lists, especially with __Use existing session (new-ui)__. (GP-4368, Issue #6257)
* _Debugger:Listing_. Auto-disassembly now ignores `UNKNOWN` memory (fixed regression) and re-disassembles if PC lands offcut in an existing instruction. (GP-4278)
* _Debugger:Recorder_. Changed register-recording errors to go to log only, not popup. (GP-4305)
* _Decompiler_. The Decompiler will now convert an indirect branch into a return operation if the branch target can be traced to the formal return address storage location. (GP-4226)
* _Decompiler_. Fixed bug causing _"Could not find op at target address"_ exception when applying `SwitchOverride` script. (GP-4314)
* _Decompiler_. Fixed bug that could cause the Decompiler display to drop characters with a multi-byte UTF8 encoding. (GP-4360)
* _Function Compare_. Corrected handling of thunked functions in the __Compare Matching Callees__ action. (GP-4354, Issue #6159)
* _GUI_. Fixed an `IllegalArgumentException` that occurred when trying to expand data over a selection in the Listing that spanned addresses from multiple address spaces. (GP-701)
* _GUI_. Fixed screen reader support of tooltips by using the lower-case html tag; some readers could not process an upper-case tag. (GP-4296, Issue #6176)
* _GUI_. Fixed Data Types tree broken `Cut` operation when the tree is filtered. (GP-4373, Issue #6137)
* _GUI_. Fixed Structure Editor exception when searching with some columns removed. (GP-4426)
* _Headless_. Fixed exception looking for extensions when running Headless Ghidra using the single Ghidra Jar mode. (GP-4294, Issue #6178)
* _Importer_. Fixed an uncaught `InvalidPathException` that could occur when loading libraries during import. (GP-4326, Issue #5894)
* _Importer:COFF_. Fixed an `EOFException` in the CoffLoader that could occur when parsing symbols. (GP-4344, Issue #6236)
* _Importer:Mach-O_. The `dyld_shared_cache` loader no longer throws an exception when importing newer versions that use `dyld_cache_slide_info5`. (GP-4457)
* _Memory_. Fixed an issue with the GUI sometimes showing incorrect file byte offsets for memory blocks that have been joined. (GP-4357)
* _Processors_. Fixed AARCH64 instructions which could overwrite source registers during reads (`ldaxp`, `ldnp`, `ldp`, `ldpsw`, `ldxp`). (GP-3851, Issue #5791)
* _Processors_. Fixed 6809 `clr` instruction not clearing the carry flag. (GP-3889, Issue #5838)
* _Processors_. Fixed several ARM instructions which could potentially overwrite a source register before reading. (GP-3892, Issue #5822)
* _Processors_. Fixed Z80 8-bit `INC` instructions' setting of the carry flag. (GP-4273, Issue #2247, #2277)
* _Processors_. Improved Tricore calling conventions. (GP-4319, Issue #5757)
* _Processors_. Corrected semantics for Tricore `dextr` instruction. (GP-4418, Issue #5756, #6303)
* _Processors_. Fixed semantics of PowerPC `lwax` instruction. (GP-4419)
* _Version Tracking_. Fixed broken Version Tracking tag filter. (GP-4336)
* _Version Tracking_. Fixed `MemoryAccessException` in Version Tracking Data Correlator when data is partially contained in uninitialized memory. (GP-4339, Issue #6238)

# Ghidra 11.0.1 Change History (January 2024)

### Improvements
* _BSim_. The `make-postgresql.sh` script now uses the `uname` command instead of the `arch` command to increase system compatibility. (GP-4174, Issue #6051)
* _Decompiler_. The Decompiler has been improved to recognize a broader class of boolean expressions when identifying and collapsing duplicate predicates. An emphasis was given to ARM executables for this change. (GP-3941, Issue #5611)

### Bugs
* _Analysis_. Fixed `IndexOutOfBoundsException` when decompiling AARCH64 functions with empty structure parameters. (GP-4169, Issue #6047, #6068, #6120)
* _BSim_. Modified `bsim` and `bsim_ctl` command line option specification to use the form `--option value` or `--option=value` instead of `option=value`. Also corrected some bugs associated with command processing. (GP-4173, Issue #6054)
* _Data_. Corrected default reference creation for pointers added to byte-mapped memory blocks when a valid address can be produced. (GP-4203, Issue #6081)
* _Debugger:Agents_. Trace RMI clients are now included in the distribution. (GP-4198)
* _Debugger:Listing_. Fixed `NullPointerException` in `TraceDisassembleCommand`. (GP-4257)
* _Decompiler_. Fixed rare bug that could cause the Decompiler to crash during construction of Static Single Assignment (SSA) form. (GP-4201, Issue #6034)
* _Function_. Corrected issues related to Function custom storage transition when auto-void-return-storage is used. This situation can occur when the Rust calling convention spec-extension is used. (GP-4234)
* _Function Compare_. Fixed bug causing an `IndexOutOfBoundsException` in the __Decompiler Diff View__ panel when comparing functions. (GP-4253)
* _Importer:ELF_. Corrected x86-64 ELF GOT allocation for object module import for `R_X86_64_GOTPCRELX` and `R_X86_64_REX_GOTPCRELX` relocations. (GP-4228)
* _Importer:ELF_. Corrected ELF x86-64 import error affecting `*.o` files with the reported error _"GLOBAL_OFFSET_TABLE already allocated"_. (GP-4265)
* _Importer:PE_. The PE loader can now loader PE files with an `OptionalHeader.Magic` value of 0. (GP-4215, Issue #6093)
* _Processors_. Fixed issues with HC05/HC08 processors including invalid registers and addressing modes. (GP-3181, Issue #4444)
* _Processors_. Fixed issue with PowerPC VLE branch instructions not displaying the `cr` register used. (GP-3787, Issue #5246)
* _Processors_. Fixed issue with PowerPC VLE load/store instructions showing incorrect index. (GP-3788, Issue #5245)
* _Processors_. Moved several PowerPC 4xx instructions to 4xx-only processor module. (GP-3789, Issue #5243)
* _Processors_. Corrected address calculation for HCS12 `call` instructions referencing the `PPAGE` register. (GP-4104)
* _Processors_. Added support for the x86 `MOVDIR64B` instruction. (GP-4105, Issue #5997)
* _Processors_. Corrected Loongarch CSR register list and added `csr77`. (GP-4163, Issue #6033)
* _Processors_. Fixed addresses for Tricore TC176x `CAN_MO` registers. (GP-4204, Issue #5712)
* _Processors_. Renamed pcodeops for x86 `fbstp` and `fbld` instructions. (GP-4249, Issue #2426)
* _Version Tracking_. Fixed `NullPointerException` in Auto Version Tracking implied-match creation. (GP-4268)

# Ghidra 11.0 Change History (December 2023)

### New Features
* _Analysis_. Added initial Rust support, including the handling of mangled names and calling conventions. (GP-2412)
* _BSim_. Introduced BSim support (see `docs/GhidraClass/BSim/`). (GP-4009)
* _Calling Conventions_. Added support for the `Indirect result location register` for ARM64 calling conventions. (GP-3938, Issue #951)
* _CodeBrowser_. Added a right-click __Copy__ action in the CodeBrowser's Listing that copies a _Local_ or _Shared_ `GhidraURL` to the program. The `GhidraURL` points to the specific address at which the cursor is located within the program. (GP-3626)
* _Data Types_. Added __Search -> For Encoded Strings...__ dialog that simplifies finding and creating strings with various charsets and alphabets. (GP-2628, Issue #1582, #2106)
* _Debugger:Breakpoints_. Added breakpoint indicators to Function Graph when active in Debugger. (GP-2737, Issue #5532)
* _Debugger:dbgeng.dll_. Implemented Trace RMI connector/plugin for the dbgeng.dll. (GP-3754)
* _Debugger:dbgeng.dll_. Introduced Trace RMI launch script for dbgeng.dll. (GP-3823)
* _Debugger:GDB_. Introduced launchers for Debugger targets using new Trace RMI framework. Introduced Trace RMI launch script for GDB. (GP-3818)
* _Debugger:Targets_. API: Added `Target` interface to abstract `TraceRecorder` and `TraceRmi`. (GP-2740)
* _Debugger:Targets_. Created __Connections__ panel for Trace RMI. (GP-3836)
* _FileSystems_. Added a `GFileSystem` supporting the CaRT file format. (GP-3748, Issue #5568)
* _GhidraGo_. Implemented GhidraGo, an experimental feature that, when enabled, causes Ghidra to listen for GhidraURLs. The only supported GhidraURLs for GhidraGo currently link to a Ghidra DomainFile handled by the CodeBrowser. The readme for GhidraGo includes instructions on setting up a protocol handler for GhidraURLs. GhidraGo will open Ghidra if a Ghidra is not already running, but Ghidra must be configured to listen (i.e., it has the GhidraGo plugin enabled). (GP-2774)
* _GUI_. Added __Select -> Create Table From Ranges__ action to create a table based on the address ranges in a selection. (GP-2297)
* _GUI_. Added a new `GTree` filter setting that allows users to filter on the node's path. (GP-2419)
* _Importer:Mach-O_. `dyld_shared_cache` components extracted from Ghidra's `DyldCacheFileSystem` can now be added together on-demand with the __Add To Program__ feature. Broken references can be automatically resolved by right-clicking on them and clicking __References -> Add To Program__. (GP-3753, Issue #5023)
* _Processors_. Added support for the Loongson processor architecture. (GP-3211, Issue #5083)
* _Version Tracking_. Added a new Version Tracking correlator based on BSim function similarity. (GP-4076)

### Improvements
* _Analysis_. Golang improvements: Added the __Golang String Analyzer__ that finds and marks up Golang strings. Improved Golang type and interface method markup. Improved Golang function parameter recovery. Using Golang package information to organize Golang type and symbol elements into namespaces. Using Golang run time type information to override the types of objects that are created by calls to malloc-like built-in functions. (GP-2109)
* _Analysis_. Made minor fixes to ARM aggressive instruction finder for stack trace and speed improvement. (GP-3855)
* _API_. Added a program caching system for use by clients that want to open programs, do some work, and then close them without them appearing in the tool. Prior to this, all programs that were opened were kept open by the tool until the user manually closed them. (GP-3979)
* _API_. Updated `ApplyFunctionSignatureCmd` and `FunctionUtility.updateFunction` to optionally allow all applied composites to be cleaned (i.e., force to not-yet-defined state) before being applied. In addition, a datatype conflict handler may now be specified which can control how conflicts of applied datatypes should be handled. (GP-4051)
* _Basic Infrastructure_. Upgraded to FlatLaf 3.2.1. (GP-3645, Issue #5539)
* _Basic Infrastructure_. Upgraded Guava to 32.1.3. (GP-4053)
* _Build_. The Ghidra Software Bill of Materials (SBOM) now includes entries for Ghidra's module jars. Jar descriptions are also now provided when available. (GP-3824, Issue #5513)
* _CodeCompare_. The Decompiler Diff View now supports searching via `Ctrl-F`. (GP-4000)
* _CodeCompare_. Fixed Function Comparison Window to not initially show the same function in both windows. (GP-4005)
* _Debugger_. Introduced a plugin/service that supports proper Terminal Emulation (in contrast to the current Interpreter Panel plugin). (GP-1977)
* _Debugger_. Added process name to Objects display. (GP-3895, Issue #5817)
* _Debugger_. Added console display for exceptions. (GP-3896, Issue #5817)
* _Debugger:Emulator_. Fixed issue starting the Emulator when the PC is in an overlay space. (GP-3904)
* _Debugger:GDB_. Changed Trace RMI plugin for GDB to better obtain module base addresses. (GP-3725)
* _Debugger:Registers_. Go-To actions from __Registers__ panel now honor __Force Full View__ setting from __Regions__ panel. (GP-3886, Issue #5817)
* _Decompiler_. Tokens labeling switch `case` values in the Decompiler window now support navigation and hovering and can be used to rename or retype the switch variable. (GP-3680, Issue #5286)
* _Decompiler_. Added toggle buttons to quickly change the __Eliminate unreachable code__ and __Respect readonly flags__ Decompiler settings. These settings are local to the Decompiler view and will not persist in the tool. (GP-3919)
* _Decompiler_. Added formatting options for braces, `{` and `}`, in Decompiler output. (GP-3965, Issue #1240, #1937, #1938, #4914, #81)
* _Demangler_. Updated the GNU Demangler binary used by Ghidra to version 2.41. (GP-3577)
* _Demangler_. Revised signature source type applied by GNU demanglers to `ANALYSIS` instead of `IMPORTED`. (GP-4139)
* _Exporter_. The C/C++ exporter now includes equate definitions if data types are being emitted. (GP-3010, Issue #4878)
* _Extensions_. Added a classpath isolation option for Extensions (settable in `launch.properties`). (GP-3623)
* _FileSystems_. The `dyld_shared_cache` filesystem can now extract files for stubs and standalone data. (GP-3860)
* _GUI_. Updated the tool windows to remember when they are fully maximized. (GP-2840, Issue #293, #3788)
* _GUI_. Updated data type tooltips and previews to show size in hex as well as decimal. (GP-3763, Issue #5682)
* _GUI_. Added __Collapse__ and __Expand__ actions to trees. (GP-3812, Issue #5731)
* _GUI_. Added `askValues()` method to `GhidraScripts` which allows the script to show a dialog for entering multiple values with a single dialog. (GP-3924)
* _GUI_. Fixed issue with program graph issuing location events in response to receiving location events. (GP-4021)
* _Importer_. Improved library-import log messages. (GP-3910)
* _Importer:ELF_. Completed additional changes to ELF Header code to eliminate unsupported mutability. (GP-3620)
* _Importer:Mach-O_. When loading __System Libraries From Disk__ on macOS, the dyld_shared_cache will be searched for in more default locations. (GP-3909)
* _Importer:Mach-O_. The MachoLoader now uses binding information (if present) to associate libraries with imported symbol name without the need for those libraries to be already present/loaded in the project. (GP-3912)
* _Importer:Mach-O_. The MachoLoader can now load binaries with obfuscated segment and section names. (GP-3926, Issue #3876)
* _Languages_. Removed use of PC as having a valid value in SuperH and M68000. (GP-4049, Issue #5891)
* _Listing_. Added options for disabling various EOL Auto-Comments. (GP-3531)
* _Listing_. Corrected operand markup of offcut instruction references which failed to respect the __Display Namespace__ operand field option. (GP-3985, Issue #5886)
* _Memory_. Updated overlay address space support to allow multiple memory blocks to reside within a single overlay space. (GP-3903)
* _PDB_. Changed the PDB data types processing to use a resolve-as-you-go model, eliminating the dependency graph and the need for holding onto the PDB types within the processing model. The benefits of this change are being made available by other improvements. In addition, changes have been made to improve the accuracy of some data types. (GP-3715)
* _PDB_. In order to reduce memory consumption, modified PdbReader to load certain components and data structures only when needed and provided some iterators to consumers such as PDB Universal Analyzer. (GP-3995)
* _Processors_. Added language module for the Tensilica Xtensa processor. (GP-1062, Issue #1407, #5442)
* _SARIF_. Added support for SARIF data export/import. (GP-3832)
* _Version Tracking_. Updated `AutoVersionTrackingScript` to create implied matches if option is chosen by the user. (GP-3765)
* _Version Tracking_. Improved and sped up the `AutoVersionTracking` algorithm to determine and apply good matches from the possible matches returned from the `DuplicateFunctionMatchCorrelator`. (GP-3854, Issue #5857)
* _Version Tracking_. Added numerous options to Auto Version Tracking that can change which correlators are used and control their individual options. (GP-3934)
* _Version Tracking_. Auto Version Tracking now applies implied matches if the minimum number of votes and maximum number of conflicts conditions are met, as determined by the chosen options. (GP-3953)
* _Version Tracking_. Updated Auto Version Tracking to check related associations for already-accepted matches before accepting new matches. (GP-4008, Issue #4875)
* _Version Tracking_. Improved default Version Tracking session name generated by new session wizard. (GP-4091)

### Bugs
* _Analysis_. Fixed `StackOverflowError` encountered when processing self-referencing Golang slices. (GP-3906, Issue #5847)
* _Analysis_. Fixed function body computation for functions with instructions that branch into delay slots; for example, the Fujitsu FR processor. This affects both function creation and the computation of an Undefined Function for the Decompiler when no function is currently defined. (GP-3962, Issue #5866)
* _Analysis_. Fixed evaluator check before using it in constant analysis. (GP-3970)
* _Build_. Fixed `nodepJar` task dependencies for Gradle 8. (GP-3977, Issue #5902)
* _Data Types_. Corrected self-referencing data type resolution issue for function definitions which could result in datatype errors. (GP-4078, Issue #5927)
* _Debugger_. Fixed when __Control Target__ can be selected. (GP-4099)
* _Debugger:Agents_. Fixed GADP agent launch scripts to pass arguments through. (GP-4132, Issue #6016)
* _Debugger:dbgeng.dll_. Fixed an error that resulted in quotes being stripped from command-line arguments for dbgeng/dbgmodel. (GP-3846, Issue #5789)
* _Debugger:dbgeng.dll_. Created better updating strategy for dbgeng/model memory. (GP-3899, Issue #5817)
* _Debugger:Emulator_. Fixed issue with resuming after performing p-code steps in the Emulator. (GP-3706)
* _Debugger:GDB_. Made fixes in preparation for changes coming in gdb-14. (GP-3690)
* _Debugger:GDB_. Fixed line ending for Cygwin GDB. (GP-3825, Issue #5755)
* _Debugger:Objects_. Fixed Elements table in Model provider to display array contents. (GP-3932)
* _Debugger:Registers_. Fixed copied values from __Registers__ panel to conform to display settings. (GP-3874, Issue #5820)
* _Decompiler_. Fixed bug in conditional constant propagation that could affect switch recovery. (GP-3840, Issue #5514)
* _Decompiler_. Fixed improper rendering of expressions involving pointer-to-array data-types in Decompiler output. (GP-3842, Issue #5591)
* _Decompiler_. Fixed bug causing _"Could not finish collapsing block structure"_ exceptions. (GP-3911)
* _Decompiler_. Fixed _"`<unionfacetsymbol>` does not have a union type"_ exception caused by deleting a union data-type. (GP-3942, Issue #5636)
* _Decompiler_. Fixed bug in the brace-highlighting action for the Decompiler window that could cause it not to be able to find matching braces. (GP-3945, Issue #5643)
* _Decompiler_. Fixed bug in Decompiler that could cause crashes when analyzing NaN operations. (GP-3981)
* _Decompiler_. Fixed a bug that causes the Decompiler to fail on some systems with a _"Datatype must have a valid id"_ exception. (GP-4020)
* _Decompiler_. Fixed an infinite loop in the Decompiler caused by small parameters getting passed to subfunctions via larger registers containing stale values in their upper bytes. (GP-4102, Issue #5934)
* _Decompiler_. Fixed a bug that could cause the Decompiler to crash when printing pieces of a dynamic symbol. (GP-4119, Issue #6005)
* _Demangler_. Fixed GNU Demangler analysis live-lock issue. (GP-4071, Issue #5987)
* _Documentation_. Fixed field constraint example in the Sleigh documentation. (GP-4046, Issue #5933)
* _Eclipse Integration_. Ghidra can now launch Eclipse Ubuntu snap installations from the Script Manager. (GP-3473)
* _Eclipse Integration_. The GhidraDev Eclipse plugin now prevents unsupported versions of PyDev from being used. Supported versions are 6.3.1 - 9.3.0. PyDev 10.0 and later no longer support Python 2. (GP-4062, Issue #5980)
* _Eclipse Integration_. The GhidraDev Eclipse plugin no longer throws an `IOException` when performing a __Link Ghidra__ action on a Ghidra project whose original Ghidra installation moved. (GP-4063, Issue #5981)
* _Exporter_. Proper C-syntax is now used on structs exported to a header file when they contain a pointer to an array field. (GP-3608, Issue #5248)
* _GUI_. Fixed the Data Types __Exact Match__ filter to not include the archive name. (GP-3764, Issue #5685)
* _GUI_. Updated `GTableHeaderRenderer` to fix an incorrect cast to `Component`. (GP-3819, Issue #5539)
* _GUI_. Fixed bug in the Find Dialog that caused incorrect text to be selected when pressing `Enter` for a previous match. (GP-3856)
* _GUI_. Fixed `JTextArea` not responding to theme font changes. (GP-3908)
* _GUI_. Fixed incorrect Version Tracking foreground color in the Markup Items Table. (GP-3933, Issue #5865)
* _GUI_. Updated how the tool saves window size information to allow better toggling between full-screen modes. (GP-3958, Issue #5879, #5890)
* _GUI_. Fixed the Listing's Auto Comment color for the CDE/Motif theme. (GP-3959, Issue #5903)
* _GUI_. Fixed Structure Editor bugs. Also updated the search to use the default field name as part of the search-matching. (GP-3967, Issue #5715)
* _GUI_. Fixed an issue in the Function Editor dialog that caused incorrect parameter values to be assigned when cancelling an edit. (GP-4041)
* _GUI_. Updated the Note Bookmark dialog to allow users to press `Enter` to close the dialog when the Category field is focused. (GP-4048, Issue #5962)
* _GUI_. Fixed an issue that caused importing a file via drag-and-drop to silently fail on some Linux distributions. (GP-4066)
* _GUI_. Fixed an `IndexOutOfBoundsException` that sometimes occurred while adding new entries to the Bundle Manager table or while opening a CodeBrowser tool that included an open Bundle Manager window. (GP-4075, Issue #5956)
* _Headless_. The Headless Analyzer can now recurse into supported `GFileSystem` container files when a recursion depth of one or more is specified on the command line. (GP-3273, Issue #5167)
* _Importer_. Importing libraries that are referenced by absolute path (such as with Mach-O) now get saved to the project with their folder structure intact. This fixes a potential `DuplicateKeyException` that could occur when using a __Recursive Library Load Depth__ greater than `1`, and removes any ambiguity that could occur when linking a program to its libraries. (GP-3922)
* _Importer_. Fixed an uncaught `InvalidPathException` that could occur when loading libraries during import. (GP-4050, Issue #5894)
* _Importer:ELF_. Corrected ELF object module GOT allocation for x86-64 object modules during relocation processing. (GP-4118, Issue #5961)
* _Importer:Mach-O_. The `MachoLoader` now creates thunks on stubs. (GP-3248, Issue #3146)
* _Importer:PE_. Fixed an exception that could sometimes occur when parsing PE files containing debug line number information. (GP-3963, Issue #5899)
* _Languages_. Corrected MIPS pcode for `di` and `ei` instructions. (GP-3875)
* _Languages_. Corrected stack pointer update in `alloca_probe` x64 windows callfixup. (GP-3915, Issue #5844)
* _Languages_. Updated x86 register addressing for `ST` and `MM` registers to achieve proper overlap. The upper 16-bits of the `ST` registers still remain unaffected by MMX instructions which write to the `MM` registers. (GP-3956)
* _Multi-User_. Corrected potential `NullPointerException` in Ghidra Server command proceesor. (GP-4056, Issue #5974)
* _PDB_. Fixed memory performance issue created in 10.4. (GP-3890)
* _Processors_. Implemented x86 `FINTRZ` instruction. (GP-3387, Issue #5205)
* _Processors_. Corrected x86 `POP` instructions with operands that use the stack pointer. (GP-3677, Issue #4282)
* _Processors_. Fixed missing ARM `cbz` instruction in the manual index file. (GP-3724)
* _Processors_. Added test-register support back into the x86 processor module. (GP-3784, Issue #5662)
* _Processors_. Fixed issue with 6x09 processor module `STU` instruction storing the `X` register instead of the `U` register. (GP-3786, Issue #5671)
* _Processors_. Added ELF relocation support to Loongarch processor module (GP-3804)
* _Processors_. Replaced or implemented count-leading-zeroes and count-leading-ones instructions with proper pcode operator in several languages. (GP-3879, Issue #5790)
* _Processors_. Changed MIPS `TEQ zero, zero` into a trap, always-goto flow. (GP-3948)
* _Processors_. Several fixes for some PowerPC VLE instructions (GP-3999, Issue #2843)
* _Processors_. Added the x86 MMX register `MXCSR` to the compiler global list so that manipulations persist in the decompiled output. (GP-4018)
* _Processors_. Fixed RISC-V custom-0 instruction patterns. (GP-4047, Issue #5932)
* _Processors_. Fixed PIC24 `DOEND` register offset (GP-4054, Issue #5213)
* _Processors_. Minor fix for the AVR8 `DES` instruction semantics. (GP-4055, Issue #5235)
* _Project_. Corrected issue with `ProjectLocator` when using projects located in root directory. (GP-3914, Issue #5802)
* _Scripting_. `FixOldSTVariableStorageScript.java` Ghidra script has been made available for users to run against x86 Programs created prior to Ghidra 10.0.3. This script will fixup `ST0... ST7` variable storage addresses which were not properly migrated during an x86 language revision. (GP-3949, Issue #5640)
* _Search_. Fixed incorrect template implementation of `GenericByteSequencePattern`. (GP-4024)
* _Sleigh_. Fixed a bug in the Sleigh compiler preventing the declaration of bit-range symbols when their size was not a multiple of 8 bits. (GP-8, Issue #1144, #660)
* _Sleigh_. Added pure 32-bit PowerPC e500mc processor variant (GP-3068)
* _Sleigh_. Fixed stacktrace when a pcode pseudoOp has more than eight parameters. (GP-3986)
* _Version Tracking_. Fixed Version Tracking __Undo__ issue where running a correlator and accepting matches then undoing the results and then rerunning the correlator resulted in incorrectly blocked matches. (GP-3827)
* _Version Tracking_. Fixed bug in Version Tracking matches table that prevented saved filters from being applied. (GP-3901)

# Ghidra 10.4 Change History (September 2023)

### New Features
* _Analysis_. Swift Type Metadata is now marked up. (GP-2085)
* _FileSystems_. Added cramfs support. (GP-3328)
* _FileSystems_. The File System Browser now supports the __Add To Program__ action. (GP-3730)
* _Importer_. Created parsers and analyzers for Device Tree Blob (DTB) and Flattened Device Tree (FDT) binaries. (GP-1436)
* _Listing_. Added ability to reduce an instruction's length to facilitate overlapping instructions. This can now be accomplished by specifying an instruction length override on the first instruction and disassembling the bytes which follow it. The need for this has been observed with x86 where there may be a flow around a `LOCK` prefix byte. (GP-3256)

### Improvements
* _Analysis_. Added support for Golang 1.17 binaries. (GP-3288)
* _Analysis_. Added call fixups for GCC's spectre-mitigating thunks in x86 and x64. (GP-3320, Issue #299)
* _Analysis_. Added support for Golang 1.19 and 1.20. (GP-3504)
* _Analysis_. Developed additional ARM function start/end patterns. (GP-3805)
* _Analysis_. Fixed PPC Analyzer to create the correct size undefined data type for a read/write reference. (GP-3845, Issue #5425)
* _API_. __Undo__/__Redo__ now show lists of transactions that can be undone or redone. (GP-3521)
* _Build_. Fixed the `buildHelp` gradle task to correctly check for up-to-date inputs. (GP-3430)
* _Data Types_. Added ability to establish source archive association when non-sourced data type dependencies get copied into an archive during a commit operation. (GP-3796, Issue #5675)
* _Debugger_. Fixed __Copy Into New Program__ action to use Dynamic Listing for its default context. This means the Dynamic Listing does not have to have focus for those actions to be enabled. (GP-1528)
* _Debugger:Modules_. Changed mapper to use proper local `ghidra://` URLs. No more "!" in them. (GP-3695)
* _Debugger:Trace_. Removed the `TraceFunction` part of the Trace API. (GP-3351)
* _Decompiler_. Removed the limitation preventing the Decompiler from analyzing functions where the `this` parameter refers to a placeholder class structure. (GP-3590, Issue #5403, #5475)
* _Decompiler_. Added Decompiler support for return value storage at an explicit stack offset relative to the callee's stack pointer. (GP-3613, Issue #1962)
* _Decompiler_. Added a `callfixup` for `__RTC_CheckEsp` in `x86win.cspec` and updated `GraphASTScript.java`. (GP-3752, Issue #5657)
* _FileSystems_. Libraries extracted from the `dyld_shared_cache` filesystem now have chained fixups applied. (GP-1574)
* _FileSystems_. Libraries extracted from the `dyld_shared_cache` filesystem now contain an optimized `__LINKEDIT` segment, resulting in a significantly smaller binary. (GP-3587, Issue #4175)
* _FileSystems_. Libraries extracted from the `dyld_shared_cache` filesystem now contain local symbol information, which reduces the occurrence of `<redacted>` primary symbols. (GP-3728)
* _GUI_. Added accessibility support to the FieldPanel component, which is the base component for the Listing, Byte Viewer, and Decompiler. (GP-2129)
* _GUI_. Simplified the Listing's Plate Field word wrapping. (GP-3425, Issue #5299)
* _GUI_. Added the __Address w/ Offset__ Copy Special action. (GP-3515, Issue #5364)
* _GUI_. Added a filter for the Memory Map provider table. (GP-3755)
* _Importer:ELF_. Added support for ELF `R_AARCH64_MOVW_UABS_Gn` relocations. (GP-3435, Issue #3545, #3546, #5292)
* _Importer:Mach-O_. Libraries can now be loaded from both local directories and GFileSystems. This enables loading, for example, Mach-O libraries directly from within the dyld_shared_cache file(s). (GP-2277, Issue #4162)
* _Importer:Mach-O_. Improved markup for Mach-O load command data. (GP-3565)
* _Importer:Mach-O_. Added more options to the `DyldCacheLoader` so its performance can be better controlled by the user. (GP-3566)
* _Importer:Mach-O_. The `MachoLoader` now supports threaded binding (`BIND_OPCODE_THREADED`). (GP-3701, Issue #5558)
* _Languages_. Updating the PowerPC index to reference the latest manuals. (GP-3296)
* _PDB_. Improved disassembly and function creation in presence of non-returning functions. (GP-3604)
* _Processors_. Added instruction manual indices for ColdFire instructions. (GP-3327)
* _Processors_. Addressed unnecessary x86 `LOAD` ops preventing certain decompiler transformations. (GP-3822, Issue #5433)
* _Scripting_. Updated `RecoverClassesFromRTTIScript` to improve class structure creation for GCC programs. (GP-3464, Issue #5642)
* _Scripting_. Updated `RecoverClassesFromRTTIScript` to make sure all class thiscall functions are using the class structure created by the script. (GP-3777)
* _Sleigh_. Replaced implementations of `_fxsave` and `_fxsave64` with defined p-code ops in `ia.sinc`. (GP-3733, Issue #5208)
* _Version Tracking_. Changed Auto Version Tracking duplicate function match to not process overly large duplicate match sets that can be extremely time-consuming. (GP-3527)

### Bugs
* _Analysis_. Changed function body creation when functions overlap to favor contiguous functions. Previously, overlapping functions bodies were arbitrary based on order of creation. (GP-2823)
* _Analysis_. Allow values that have the low bit set to be pointers if they are at the top of a function on ARM and MIPS. (GP-3766)
* _API_. Added Function body restrictions to ensure it is contained within a single address space. (GP-567, Issue #2577, #5051)
* _API_. Fixed issue where front end plugins were not having their dispose methods called when exiting Ghidra (GP-3343)
* _Data Types_. Fixed alignment of 8-byte datatypes for 32-bit Windows data organization. (GP-3449)
* _Data Types_. Eliminated use of data type aligned-length when adding components to a non-packed structure. This should allow arbitrary component placement when packing is disabled. (GP-3726, Issue #5602)
* _Data Types_. Corrected problem with the decode of subnormal floating point values. (GP-3775, Issue #5647)
* _Decompiler_. The Decompiler no longer automatically simplifies away code performing NaN tests. (GP-3019, Issue #4588)
* _Decompiler_. Fixed a bug in the Decompiler where assignments to local variables on the stack could be incorrectly reordered before calls. (GP-3429, Issue #5237)
* _Decompiler_. Fixed variable merging bug in the Decompiler that could cause _"Unable to merge address forced indirect"_ exceptions. (GP-3682, Issue #5588)
* _Decompiler_. Fixed bug causing segmentation faults in the Decompiler triggered by Golang binaries. (GP-3783)
* _Demangler_. Fixed minor GNU Demangler parsing bug that caused `&&` to get added to function pointers. (GP-3650)
* _Eclipse Integration_. Exporting a Ghidra Module Extension with the GhidraDev Eclipse plugin produces an intermediate `build` directory within the project. This build directory now gets automatically cleaned up to avoid Ghidra runtime/debugging issues. (GP-3523, Issue #5327)
* _Eclipse Integration_. The Ghidra Front-End GUI now prevents installation of extension source (unbuilt) directories. (GP-3852)
* _Framework_. Fixed issue preventing Enum Editor actions from appearing in the Key Bindings options. (GP-3708, Issue #5638, #5639)
* _Graphing_. Changed graph DOT exporter to rename our `Name` attribute to a `label` attribute, which is what DOT graphs use for display. Also, cleaned up vertex label display when in `compact` mode and added the vertex id in the tooltip. (GP-3779, Issue #5678)
* _GUI_. The __Comments__ dialog now uses the selected comment text when adding a new annotation. (GP-3560, Issue #5439)
* _Importer_. User can now correctly __Add To Program__ with Microsoft `Module-definition (.def)` files. Several parsing bugs with this file format were also fixed. (GP-3826, Issue #5676)
* _Importer:ELF_. Made significant improvements to ELF RISCV relocation support. (GP-3707, Issue #3816)
* _Importer:ELF_. Corrected ELF `R_RISCV_RVC_BRANCH` relocation processing. (GP-3792, Issue #5701)
* _Importer:ELF_. Updated ELF Loader to convert non-displayable ASCII symbol name characters to ASCII Control Characters (e.g., `^A`) instead of discarding symbol with an error. Import log will report use of modified name when this occurs. (GP-3793, Issue #5619)
* _Importer:Mach-O_. Improved support for loading Apple watchOS binaries. (GP-3630)
* _Misc_. Fixed bug in table sorting where data could be corrupted if the sort was cancelled before it completed. (GP-3685)
* _Processors_. Fixed issue with M68000 reading from memory multiple times per instruction. (GP-3219, Issue #2492)
* _Processors_. Fixed mnemonic for PowerPC VLE `e_sthu` instruction. (GP-3434, Issue #5247)
* _ProgramDB_. Data may now be created in a Byte-Mapped Memory Block using a Dynamic datatype. This was previously disallowed due to an ambiguous initialized-memory check. (GP-3208)
* _Project_. Changed project data store close/dispose behavior to resolve issues with open programs getting disconnected by closing of associated project store. Changed `GhidraScript.askProgram` to always require proper use of `Program.release(Object consumer)` by scripts which use it. Script's failure to release a program will prevent proper resource disposal. (GP-3697)
* _Scripting_. Fixed `ShowConstUse` script back-tracking through `MultiEqual` pcode operations to handle multiple inputs to the same location. (GP-3503, Issue #5242)
* _Search_. Fixed `findBytes()` to honor the search limit when used regular expressions. (GP-3797, Issue #5672)

# Ghidra 10.3.3 Change History (August 2023)

### Improvements
* _Analysis_. Fixed potential infinite loop in clear flow and repair if the function found to be non-returning is cleared. (GP-3578)
* _Debugger:Listing_. The items in the __Auto-Read Memory__ drop-down menu are now consistently ordered. (GP-3721)
* _Debugger:Modules_. Added a __Mapping__ column in the __Modules__ window. (GP-3436, Issue #5330)
* _Decompiler_. Decompiler now prints Equate values using `constant` syntax highlighting. (GP-3679, Issue #5059)
* _GUI_. Updated the Enum Editor to trim whitespace in the name field. (GP-3762, Issue #5650, #5679)
* _Languages_. Added Debugger GNU language mapping `mips:3000` to the `mips.ldefs` specification file in support of 32-bit MIPS processor (_default_ variant). (GP-3453, Issue #5337)
* _Version Tracking_. Improved Version Tracking function signature __Apply Markup__ action to work correctly when both the source and destination functions use custom storage. (GP-3662, Issue #5559)

### Bugs
* _Analysis_. Fixed x86 `CALL <nextaddr>; POP EBX` position-independent code issue that was replacing the branch with a data reference which caused bad code flow. (GP-3687)
* _Data Types_. Corrected issue related to setting architecture immediately after data type archive creation where data types were added. The architecture setting failed to be retained and the existing data types failed to be adjusted. (GP-3727)
* _Debugger_. Fixed issue with default launcher command line when binary name contains spaces. (GP-3553, Issue #5460)
* _Debugger:Agents_. Removed `MODULE_[UN]LOADED` events (these duplicate `elementsChanged` on the Modules node). Fixed `NullPointerException` log messages from library-load events in GDB connector. (GP-3666)
* _Debugger:Emulator_. Fixed display of p-code op listing in P-code Stepper when using Dark Mode. (GP-3592)
* _Debugger:Emulator_. Fixed issue launching emulator with certain architectures with multiple address spaces. (GP-3656, Issue #5556)
* _Debugger:Emulator_. Fixed indirect branching issue when operand size doesn't match PC size. (GP-3700, Issue #5609)
* _Debugger:GDB_. Using a better strategy for module base computation using memory mappings when available. (GP-2223, Issue #5284)
* _Debugger:Listing_. Fixed issue with overlapping module and PC labels in Dynamic Listing and memory viewers. (GP-3469)
* _Debugger:Listing_. Fixed hover in address field of Dynamic Listing with multiple address spaces. (GP-3661)
* _Debugger:Listing_. Fixed issue where address-tracking drop-down cannot be accessed when certain watches are configured; e.g., `(RSP+8)+8`. (GP-3720)
* _Debugger:Modules_. Fixed issue using Debugger with programs in a shared project. (GP-3664, Issue #5585)
* _Debugger:Watches_. Fixed bug where watches cannot be assigned a type without an active trace. (GP-3718)
* _Decompiler_. Fixed a bug preventing the Decompiler from simplifying double-precision shifts. (GP-3688, Issue #5473)
* _Decompiler_. The Decompiler no longer tries to infer a symbol reference for a constant if a function signature indicates the constant is not a pointer. (GP-3735)
* _Emulator_. Fixed another context flow issue in the Emulator's decoder. (GP-3716)
* _GUI_. Fixed the Flat Dark Theme color of the Version Tracking Matches table's filter field. (GP-3550, Issue #5560)
* _GUI_. Fixed general Structure Editor bugs when using `Tab` to navigate while editing. (GP-3647, Issue #5566)
* _GUI_. Fixed broken table navigation in the Function Tags dialog. (GP-3683, Issue #5613)
* _GUI_. Fixed incorrect rendering of delimiter fields in table filter options. (GP-3684, Issue #5614)
* _GUI_. Fixed an exception in the Function Call Graph when using the __Start Fully Zoomed In__ mode. (GP-3768)
* _Headless_. Fixed several OSGi-related exceptions that could be thrown when running many instances of `analyzeHeadless` in parallel. (GP-3653)
* _Languages_. Fixed ARM `vcvt` instruction semantics. (GP-3729)
* _Languages_. Removed `LDS/STS` instructions from AVR8 in preparation for AVRtiny support. (GP-3746, Issue #5231)
* _Processors_. Fixed issue with 6809 `pshu` sometimes pushing to the `S` register. (GP-3556, Issue #5467)
* _Processors_. Fixed regression in 6x09 compare instructions. (GP-3642)
* _Processors_. Fixed instruction operand parsing for AARCH64 `fcadd` and `fcmla` instructions. (GP-3652, Issue #5428)
* _Processors_. Fixed disassembly of x86 `LIDT`, `LGDT`, `SIDT`, and `SGDT` instructions. (GP-3655, Issue #5577)
* _Scripting_. Fixed a bug that could result in the Python scripting environment using invalid script bundle paths. (GP-3619)

# Ghidra 10.3.2 Change History (July 2023)

### Improvements
* _Debugger:Emulator_. Fixed bug when starting the Emulator for processors having small memory spaces. (GP-3437, Issue #5331)
* _Extensions_. Updated Extension installation to allow users to bypass the version compatibility check. (GP-3466, Issue #1193)
* _Importer:Mach-O_. The MachoLoader now supports the `__chain_starts` section. (GP-3568)
* _PDB_. Updated PDB maximum page size to 8 KB. (GP-3603)
* _Scripting_. Added `askPassword` method to `GhidraScript` API. (GP-3295)

### Bugs
* _Analysis_. Corrected an issue which could result in a duplicated imported symbol within the EXTERNAL memory block for what should be a default thunk function. (GP-3302)
* _Analysis_. Fixed problem with Branch/Return analysis infinite loop waffling on some ARM binaries. (GP-3582)
* _Analysis_. Fixed creation of incorrect function bodies which included addresses with data from flow into non-disassembled code. Also fixed PowerPC disassembly from computed flow in certain circumstances. (GP-3599, Issue #5441)
* _Analysis_. Very large functions that run out of address space IDs used for tracking constants will now only log one error message. (GP-3605)
* _API_. Corrected `CreateFunctionCmd` issue which could fail with the _"Function body must contain the entrypoint"_ error. (GP-3591, Issue #5412)
* _CParser_. Allow `pragma` keyword in more places, allow parentheses in `#pragma`, and fixed silent parse failures. (GP-2808, Issue #4692, #5454)
* _CParser_. Fixed CParser to handle multi-line `#pragma` directives. (GP-3611, Issue #5524)
* _CParser_. When using the CParser to parse header files directly into a program, the program's processor architecture is now used. (GP-3612, Issue #5502)
* _Debugger_. Cleaned up old Troubleshooting entries in Help. (GP-3468)
* _Debugger:Listing_. Fixed regression in dynamic disassembly of WoW64 targets. (GP-3583)
* _Debugger:Stack_. Fixed various stability and error reporting issues with stack unwinding and runtime value hovers. (GP-3407, Issue #5332)
* _Debugger:Stack_. Fixed several issues in Debugger/Emulator GUIs when using/emulating an architecture with a memory-mapped PC register. (GP-3572, Issue #5410)
* _Debugger:Stack_. Fixed `NullPointerException` when varnode has no high variable during stack unwinding. (GP-3576, Issue #5487)
* _Debugger:Watches_. Fixed restoration of Watch DataType when it comes from the restored Trace. (GP-3588)
* _Decompiler_. Fixed a bug in the Decompiler where combined constant assignments to an array or structure were incorrectly split out on big endian architectures. (GP-3609, Issue #5424)
* _Emulator_. Fixed issue in Emulator's instruction decoder regarding context. (GP-3571)
* _GUI_. Fixed exception when performing the __Convert to Class__ action in the Symbol Tree while the tree had a filter applied. (GP-3589, Issue #5480)
* _Importer:ELF_. Fixed incorrect error message during import regarding ELF build-ID length. (GP-3546)
* _Importer:ELF_. Corrected exception and ELF GOT allocation issue which could prevent import of X86-64 object modules which contain GOT-based relocations (e.g., `R_X86_64_GOTPCREL`). (GP-3610, Issue #5519)
* _Importer:Mach-O_. Fixed a regression in the Mach-O Loader that was causing incorrect `DYLD_CHAINED_PTR_64_KERNEL_CACHE` fixups. (GP-3598)
* _Importer:PE_. Fixed a timestamp encoding bug that caused PE symbol `.exports` files to not get matched and applied in some circumstances. (GP-3552, Issue #5351)
* _Importer:PE_. Failing to parse PE `ExceptionDataDirectory` no longer prevents the import from finishing. (GP-3584, Issue #5483, #5496)
* _Processors_. Fixed ARM Neon Thumb `vdup` instruction, which was using the wrong bits for register value. (GP-3524, Issue #5420)
* _Processors_. Fixed 6x09 `leax` and `leay` instructions to update zero flag. (GP-3525, Issue #5414)
* _Processors_. Corrected 6809 macros compare flags and two-byte push/pops in big endian architecture variant. (GP-3606, Issue #5508)
* _Processors_. Fixed flags for the 6809 processor left-shift instructions. (GP-3621, Issue #5523)

# Ghidra 10.3.1 Change History (June 2023)

### Improvements
* _Debugger:LLDB_. Upgraded SWIG-generated Java (plus docs) to LLVM/lldb 16.x. (GP-3442, Issue #5359)
* _Decompiler_. Added an option to the Decompiler, controlling the maximum size of jumptable that can be recovered. (GP-3266)
* _Decompiler_. Improved Decompiler function call-override to consider calling convention when differentiating function signatures. (GP-3268, Issue #5335)
* _Decompiler_. The Decompiler now respects tool options for shortening template strings within symbol names. (GP-3369)
* _Importer:ELF_. Added __Max Zero-Segment Discard Size__ import option to ELF Loader. Value was previously hard-coded to 255 bytes. (GP-3428, Issue #5273)
* _Importer:Mach-O_. Restored Mach-O indirect symbol creation when binding information is not present, such as when importing a `DYLIB` extracted from a `dyld_shared_cache`. (GP-3526)
* _Languages_. Added windows`__stdcall` calling convention as an alias to the default calling convention for `aarch64` and `x86-64`. (GP-3472)
* _Scripting_. Improved the `RecoverClassesFromRTTIScript` recognition of special vtables when they are in memory blocks not tied to imported file bytes. (GP-3463)
* _Scripting_. Mitigated a `RecoverClassesFromRTTIScript` issue where mangled typeinfo names were not always getting extracted from memory when more than one bad data type was created over the memory containing the mangled string. (GP-3467)

### Bugs
* _Analysis_. Fixed regression when functions are set as inline that can cause lockups: during analysis, with use of stack depth field, and for __Set Stack Depth Change__ action. (GP-3499, Issue #5378, #5400, #5401)
* _CParser_. Fixed C header file parsing of `pragma` lines when a comma is found outside of parentheses. (GP-3541, Issue #5427)
* _Data Types_. Corrected issues related to data organization retention and upgrade for data types. (GP-3506)
* _Debugger:GDB_. Reduced frenetic queries for module info at launch time. Fixed `00000000` values in module ranges. (GP-3448, Issue #4456, #5357)
* _Decompiler_. Fixed bug that could cause errors in constant calculations involving 128-bit or larger registers. (GP-3426, Issue #3492)
* _Decompiler_. Fixed a bug that could prevent recovery of a switch if the variable is written indirectly through a pointer alias. (GP-3441, Issue #5307)
* _Decompiler_. Corrected 10.3 regression when __Edit Function Signature__ is invoked from Decompiler, which may ignore the calling convention used with current function decompilation. (GP-3454, Issue #5367)
* _Decompiler_. Fixed hashing bug causing inconsistent results with __Force Field__ action in the Decompiler. (GP-3508, Issue #5372)
* _Documentation_. Fixed missing `return` in `termmines.c` exercise file. (GP-3444, Issue #5343)
* _Exporter_. Fixed a regression in the __Original File__ exporter that prevented it from working when unapplied relocations were present in the relocation table. (GP-3446, Issue #5346)
* _GUI_. Fixed bug where Ghidra did not prompt to save GUI Theme changes when exiting via a menu versus the window __X__ (_Close Window_) button. (GP-3477, Issue #5377)
* _GUI_. Updated the Python Interpreter prompt to use less space. (GP-3509, Issue #5379)
* _GUI_. Fixed issue with menu bar colors on Mac system when using __Mac Aqua Look and Feel__ while in dark mode. (GP-3528, Issue #4454)
* _Importer_. Fixed an exception that occurred when the `MzLoader` tried to split the `HEADER` overlay block. (GP-3447, Issue #5320)
* _Importer:ELF_. Corrected potential exception when processing invalid `ELF PT_NOTE` program header. (GP-3493, Issue #5384)
* _Importer:ELF_. Corrected bugs in ELF Android packed relocation processing and rendering of `sleb128` data type. (GP-3543)
* _Importer:Mach-O_. Fixed a regression in the Mach-O Loader that was causing incorrect `DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE` fixups. (GP-3474)
* _Importer:Mach-O_. Fixed an `AddressOutOfBoundsException` that could sometimes occur when importing the exports section of `dyld_shared_cache` files. (GP-3505, Issue #5392)
* _Importer:PE_. Fixed an `IllegalStateException` that could occur if both __Load Local Libraries From Disk__ and __Load System Libraries From Disk__ options are used during import and the same library is found in both local and system directories. (GP-3445)
* _Importer:PE_. Fixed a bug that caused PE symbol `.exports` files to always get deleted after import. (GP-3519, Issue #5348)
* _Languages_. Adjusted handling of PowerPC e500 small data area pointer. (GP-3480)
* _Processors_. Fixed operand count mismatch in some M68000 instructions. (GP-2779, Issue #4807, #4808)
* _Processors_. Corrected issue with M68000 `pea` instruction with address based on `SP`. (GP-2955, Issue #4795)
* _Processors_. Fixed flag issue in 6502 `TSX` instruction. (GP-2963, Issue #4838)
* _Processors_. Addressed multiple issues with 8048, including fixing the `movp`, `movp3`, and `jmpp` instructions and correcting the implementation of the memory bank selection. (GP-3009, Issue #2423, #4825)
* _Processors_. Fixed decoding of x86-64 `popf` and `pushf` instructions. (GP-3102, Issue #4980)
* _Processors_. Corrected pcode for PowerPC `e_stmvsprw` instruction. (GP-3325, Issue #4886)
* _Processors_. Fixed PowerPC instruction `eieio` decode for all valid variants. (GP-3432, Issue #4887)
* _Processors_. Fixed issue with AARCH64 `mla` instruction using erroneous registers. (GP-3478)
* _Processors_. Restored original M68000 calling convention to only use stack, and added an additional `.cspec` file for the optional _Register ABI_ calling convention for ColdFire. Also added bonus function start patterns identified during testing. (GP-3532, Issue #5390)
* _Sleigh_. Fixed SleighEditor to allow `2` to `n` arguments in `CPOOL` Sleigh operator. (GP-3534, Issue #2148)

# Ghidra 10.3 Change History (May 2023)

### New Features
* _Analysis_. Initial Golang binary analysis for Go 1.18. (GP-2114, Issue #2327)
* _Debugger_. Added breakpoint indicators to the Decompiler's margin, when used in the Debugger. (GP-1280)
* _Debugger_. Added Debugger control actions to global toolbar. (GP-1595, Issue #3742)
* _Debugger_. Created new independent launchers for Debugger agents. (GP-1999)
* _Debugger_. Added ability to set node timeout. (GP-2502)
* _Debugger_. Added class materials for the Debugger. (GP-2641)
* _Debugger_. Added hover tooltips for variable values in the Static Listing, Decompiler, and Dynamic Listing. Added __Unwind Stack__ action. (GP-2834, Issue #4732)
* _Debugger_. Added ability to set initial directory and other parameters. (GP-2839, Issue #4732)
* _Debugger_. Added a dedicated __Emulator__ tool. (GP-3074, Issue #4931)
* _Debugger_. Added ability to export/serve symbols and types as Volatility ISF JSON. (GP-3222)
* _Debugger:Emulator_. Added __Invalidate Emulator Cache__ action. (GP-2970)
* _Debugger:Emulator_. Added __Add Region__ and __Delete Regions__ actions to the __Regions__ window. (GP-3357)
* _Debugger:Objects_. Added commands __Advance__ to GDB, __Step/Trace to Address__ to dbgeng/model, and __Run to Address__ to LLDB in address context menus. (GP-1808, Issue #4056)
* _DWARF_. Added support for some Apple-specific DWARF tags. (GP-3175)
* _GUI_. Added theming support to Ghidra, including a dark theme. (GP-1981, Issue #4145)
* _GUI_. By default, programs will now open to their location when last closed. (GP-2939, Issue #1196)
* _Pcode_. Support for a new p-code operator `lzcount` has been introduced into SLEIGH, the Decompiler, emulation, etc. It returns the count of _leading_ zero bits in its operand. (GP-3155, Issue #2810)
* _Processors_. Added eBPF and BPF processors. (GP-2257, Issue #4258, #4378)
* _Project_. Added __Restore Previous Project__ option to the Front End Tool that controls whether or not the previously opened project is automatically restored on startup. (GP-2695, Issue #4650)
* _Scripting_. Created `AssociateExternalPELibrariesScript` that associates imported library files for PE programs in order to fix up external references from the program to the libraries. This is useful for users who forgot to load the libraries on program import and want to fix up the references after the fact. (GP-3098)
* _Version Tracking_. Updated the Version Tracking API to make extension of correlators easier. (GP-3199, Issue #4950)

### Improvements
* _Analysis_. Added support for pointer Typedef values passed as parameters to functions. (GP-2160)
* _Analysis_. Added identification and side-effect fixes for windows AARCH64 `__security_push_cookie` to fix poor Decompiler and stack reference results. (GP-3124, Issue #5018)
* _Analysis_. Added support for processing PE MinGW pseudo-relocations during auto-analysis immediately after import. (GP-3236, Issue #5155)
* _API_. Added ability to associate a specific program architecture with a datatype archive. This allows associated types to preserve proper type sizing and alignment characteristics based upon a designated architecture. Delivered archives will reflect the architecture they were created with instead of utilizing the default data organization. (GP-1633, Issue #4898)
* _API_. Changed `FunctionDefinition` and `FunctionSignature` to use calling convention names as strings instead of being limited to `GenericCallingConvention`. Also added `noreturn` support to these interfaces. (GP-2308, Issue #3267, #4537)
* _API_. Added methods to `TaskMonitor` to address spelling inconsistencies. (GP-2982, Issue #4870)
* _API_. Revised program Relocation table to include status and a more accurate length of affected bytes when applied. (GP-3013)
* _API_. Added by-name index method `SymbolTable.scanSymbolsByName(String startName)`. This has been utilized by the assembler UI to resolve a hang on large programs. (GP-3015, Issue #2630)
* _Basic Infrastructure_. Upgraded dependencies to guava 31.1-jre (from 19.0), baksmali 2.5.2 (from 1.4.0), and dex2jar 2.1 (from 2.0). (GP-3154)
* _Basic Infrastructure_. Improved error handling of module directories not being readable during launch. (GP-3347, Issue #5244)
* _Build_. Added support for building with Gradle 8. (GP-2476, Issue #3527, #5003)
* _Build_. The build now enforces a maximum-supported Gradle version. The current supported versions are Gradle 7.3 or later. (GP-3111)
* _Build_. Ghidra can now run from development/repository mode using Gradle's compiled jars, instead of just relying on Eclipse's compilation output. (GP-3140)
* _C Parsing_. Provided GDT archives have been updated to include new ProgramArchitecture settings for processor, data organization, and endianness. (GP-1377)
* _CParser_. Removed unnecessary `-D` defines related to wchar_t from CParser `prf` files and GDT parsing scripts. (GP-3294, Issue #5196)
* _Data Types_. Function definitions can now be applied from selected Category instead of only from an entire Archive. (GP-199)
* _Data Types_. Changed Structure/Union editor to show numbers in hex format by default. Also added `Shift-H` keybinding action for toggling hex/decimal view. (GP-2943)
* _Data Types_. Improved `DataTypeParser` to handle type names which include the `::` namespace delimiter. (GP-3003, Issue #4841)
* _Data Types_. Changed __Apply Data Archives__ analyzer to allow user to choose a data type archive to apply to their binary during analysis. (GP-3344, Issue #5184)
* _Debugger_. Added option to _memorize_ a program-module association when confirming mapped modules. (GP-1527, Issue #3641, #3675)
* _Debugger_. Improved the __Go To...__ dialog. It now accepts simple addresses or Sleigh expressions. (GP-1539)
* _Debugger_. Removed Guava from Debugger's dependencies. (GP-1542)
* _Debugger_. Replaced Guava's Cache. (GP-1545)
* _Debugger_. Improvements to allow dbgmodel kernel debugging. (GP-1768)
* _Debugger_. Upgraded protobuf to 3.21.8. (GP-2302, Issue #4415, #4540)
* _Debugger_. Improved default connector selection, based on current program and last successful connection. (GP-2623)
* _Debugger_. Added remote connectivity for LLDB. (GP-2709)
* _Debugger_. Made modifications in support of iPhone work. (GP-2870)
* _Debugger_. Better instructions for LLDB/Swig. (GP-3055, Issue #4774)
* _Debugger_. Made LLDB-related improvements in support of iPhone work. (GP-3063)
* _Debugger_. Changed `refresh` option from boolean to `RefreshBehavior` enum to allow opportunistic use of caches. (GP-3142)
* _Debugger_. Providing convenience script for LLDB builds. (GP-3247, Issue #5061)
* _Debugger_. Changed __Go To Time__ action to use the Time selection dialog. (GP-3317)
* _Debugger:Agents_. Limited debug agents to accept a single GADP connection and to terminate automatically when disconnected. (GP-1976)
* _Debugger:Agents_. API: Removed `TargetObject.add/removeListener()` in favor of `DebuggerObjectModel.add/removeModelListener()`. (GP-2752)
* _Debugger:Agents_. Enable opportunistic uses of caching. (GP-3162)
* _Debugger:Breakpoints_. Breakpoints window can now interact with the integrated emulator. It also supports custom Sleigh injections or conditions. (GP-2676)
* _Debugger:Emulator_. Dynamic views can now show (lazily) loaded bytes for pure emulation. (GP-2989)
* _Debugger:Emulator_. Moved new Emulator into its own module. (GP-3071)
* _Debugger:Listing_. Added visual indicator when `PC` (or other tracked location) is not located in the listing. (GP-2750)
* _Debugger:Registers_. Changed Registers and Watches to use pointer typedefs. This allows a user to specify the target space of a pointer, especially in Harvard architectures. (GP-2653)
* _Debugger:Registers_. Added consideration for aliases when matching target registers to Ghidra registers. (GP-2966)
* _Debugger:Threads_. Changed Threads, Stack, and Time panes to require double-click to activate the selection in the rest of the UI. (GP-3018)
* _Debugger:Trace_. Replaced `Range<T>` with `Lifespan`, `ULongSpan`, `KeySpan`, `FieldSpan`, etc. (GP-1543)
* _Decompiler_. Compiler specification (cspec) files allow more flexibility when describing overlapping parameter-passing storage locations. (GP-2544, Issue #4568)
* _Decompiler_. Decompiler analysis of functions with multiple switch statements is substantially faster in many cases. (GP-2560, Issue #4558)
* _Decompiler_. The Decompiler can now split a copy operation that simultaneously moves multiple fields in a structure or multiple elements of an array. (GP-2563, Issue #3884)
* _Decompiler_. The Decompiler propagates constants, in more situations, into blocks that are executed conditionally. (GP-2603, Issue #4527)
* _Decompiler_. Added `DecompilerStackProblemsFinderScript`, which searches the decompiled code for certain local variables that can be indicators of stack analysis issues. (GP-2697)
* _Decompiler_. Added Decompiler actions to convert constants to Double and Float. (GP-3001, Issue #3689)
* _Decompiler_. The Decompiler's Rename actions now allow the user to reclaim an automatically generated name on another symbol. (GP-3224, Issue #4863)
* _Diff_. Added ability to initiate a Program Diff with another program selected from a list of compatible open programs already open in the tool. (GP-2897)
* _DWARF_. Added support for ELF-compressed sections. (GP-2363, Issue #3659, #4460)
* _Eclipse Integration_. Eclipse now recognizes test source folders. (GP-3130)
* _ELF_. Added support for tagging ELF informational sections. Added support for Golang metadata in ELF binaries. (GP-2111)
* _Exporter_. The PE and ELF exporters have been replaced by a new Original File Exporter that will work on all programs that store original file bytes. The Original File Exporter has an option to export both user-modified bytes as well as original bytes. (GP-2770)
* _Graphing_. Upgraded jungrapht-visualization and jungrapht-layout to version 1.4. (GP-3249, Issue #5156)
* _GUI_. Improved support for Ghidra URLs and their use in comment annotations. (GP-2509)
* _GUI_. Updated the Navigation History Plugin's maximum history limit. (GP-2843)
* _GUI_. Improved table-sorting performance. (GP-2908, Issue #4782)
* _GUI_. Updated the Structure Editor to maintain the table selection during external updates. (GP-2945, Issue #4820)
* _GUI_. Added new feature where programs can automatically go to a newly discovered start symbol (e.g., "main") after analysis completes. If the user has navigated to another program location before analysis completes, a popup dialog will appear asking if the user would like to go to the new symbol. Both of these behaviors can be turned off via the __Navigation__ tool options. (GP-3064)
* _GUI_. Added ability for default tool launch (e.g., project file double-click) to reuse existing tool instead of always launching a new tool. This behavior controlled via Project Window __Default Tool Launch Mode__ option. (GP-3080)
* _GUI_. Updated the Memory Map table to use a fixed-width font for the Start, End, and Length columns. (GP-3103)
* _GUI_. Updated __Create Enums From Selection__ action to handle duplicate-named enum entries when merging selected enums together into a new enum. (GP-3204, Issue #5036)
* _GUI_. Added a Front End tool option to disable application-wide tooltip popups. (GP-3254, Issue #5095)
* _GUI_. Fixed several issues with enums and the GUI for editing them. The API supported both unsigned and signed enums, but the GUI only supported unsigned enums. Also added extra checking so that enums can't support negative values and large unsigned values at the same time. (GP-3255, Issue #3806)
* _GUI_. Clicking a sound icon in the Listing will now stop any currently playing sound. (GP-3393, Issue #5278)
* _Importer_. Headless Ghidra and the AutoImporter API now support loading more than one program, such as when importing a program results in additional libraries getting loaded. (GP-2877, Issue #4929)
* _Importer_. The OMF Loader now handles LPUBDEF symbols. (GP-2976, Issue #4854)
* _Importer_. The OMF Loader now handles unsupported/unknown record types more gracefully. (GP-2997, Issue #4856, #4857)
* _Importer_. Improved GZF/GDT import and export to allow unforced upgrade of older files. This is particularly important when a user has a version-sensitive issue and needs to have the project file triaged. (GP-3034)
* _Importer_. The OMF Loader now handles CEXTDEF symbols. Known functions are now also created by the OMF loader to improve analysis. (GP-3117, Issue #4912)
* _Importer_. Made improvements to the OMF Loader's relocation handler. (GP-3141, Issue #4909)
* _Importer_. Improved support for loading old-style DOS MZ binaries. (GP-3353, Issue #5229)
* _Importer:ELF_. Eliminated the public mutability and writing of ELF Headers whose implementation is not well suited for this in the absence of any ELF Linker support or related processor extension API. (GP-3152)
* _Importer:Mach-O_. Mach-O external libraries are now linked during analysis. (GP-2602)
* _Importer:PE_. The PE Loader has been updated to correctly recognize and mark the program compiler ID for MinGW programs. GNU Demangler has been updated to recognize and run on programs with GCC compiler option. (GP-1851, Issue #2208, #4513, #4514, #4520, #4906, #5155)
* _Importer:PE_. The PE Loader can now load sections that extend beyond the end of the imported file without error. (GP-2826, Issue #4705)
* _Importer:PE_. The PE Loader no longer rebases images to 0x10000 when the preferred image base is very large. (GP-2827, Issue #2361, #4710)
* _Importer:PE_. Improved PE header parsing so binaries with corrupt symbol/string tables do not prevent Ghidra from recognizing them as PE. (GP-2973)
* _Jython_. Improved Python interpreter code-completion behavior. (GP-2759, Issue #4678, #4699)
* _Languages_. Reverted disassembly of x86 two-byte `xchg ax,ax` back to `nop`. (GP-3372)
* _Listing_. Added __Simplify Template Names__ option (on by default) to simplify symbol and datatype names with complex template info as part of their name. This only affects the Listing display and doesn't affect the actual symbol or datatype name. (GP-388)
* _Listing_. Added options for the starting location of a program when it is opened, which will move the location to a specific function or label. See __Preferred Symbol Name__ under the __Navigation__ tool options. (GP-2141, Issue #4267)
* _Listing_. Changed overlapping markers to blend rather than occlude. (GP-2723)
* _Multi-User_. The Ghidra Server's temp directory can now be controlled by setting the `WRAPPER_TMPDIR` variable in `ghidraSvr(.bat)`. (GP-3053, Issue #4925)
* _Multi-User_. Upgraded YAJSW to 13.09. (GP-3119)
* _Processors_. Corrected treatment of x86 LOCK prefix. (GP-2487, Issue #4336)
* _Processors_. Added support for ARM v4T and v5T `bl lr` and `blx lr` pseudo-instructions. (GP-2872, Issue #4320)
* _Project_. Added support for Ghidra-URL-linked project files and folders. __Copy/Paste-Link__ actions are added to project file tree when copying from viewed repository or another project. (GP-2644)
* _Prototypes_. `PrototypeModel.getReturnAddress()` now returns the default return address of the compiler spec when a prototype does not define its own. (GP-2612, Issue #4611)
* _Scripting_. The `RecoverClassesFromRTTIScript` has been updated to recognize and process Windows PE programs compiled with GCC (i.e., MinGW, Cygwin programs). (GP-1856)
* _Scripting_. The `RecoverClassesFromRTTIScript` has a few improvements for GCC-compiled programs. (GP-2679, Issue #4414)
* _Scripting_. Added the `RTTI Found` RTTI Analyzer option to the program information, which is used to determine whether to rerun the analyzer and also to decide whether to run the RTTI script. (GP-3293)
* _Sleigh_. Improved Sleigh compiler warning and error messages. (GP-2913, Issue #4595)

### Bugs
* _Analysis_. Removed check for instruction falling into a location being considered for a shared return function. (GP-3044)
* _Analysis_. Added support for stack parameter tracking, PointerTypedef parameters, restrictions of parameter values to known pointer parameters, and a prototype-setting for propagation of pointer parameter types to memory. (GP-3077)
* _Analysis_. Fixed deadlock in Arm Analyzer waffling between overriding the return instruction as a return and branch. (GP-3150)
* _Analysis_. Removed duplicate references placed on different operands of instructions. (GP-3214)
* _Analysis_. Fixed issues related to analysis flag and how it affects asking the user to analyze a new program. (GP-3282)
* _Analysis_. By default, pointer-to-pointer analysis is turned off for ARM binaries in the Operand and Data Reference analyzers. This can result in fewer references created, and can be turned back on if your binaries use pointer data in memory instead of offset values from the current PC. (GP-3335)
* _API_. Fixed bug on pinned symbols when changing image base. (GP-3178, Issue #4290)
* _API_. Revised `ApplyFunctionSignatureCmd` to allow use where function should not get renamed when signature applied. (GP-3350)
* _Byte Viewer_. Fixed bug in Byte Viewer where the last byte in a block could not be selected if the field group size was larger than 1. (GP-1593)
* _CParser_. Fixed parsing of Windows `wdm.h` header file with multi-line strings passed as arguments to a macro. (GP-2809, Issue #4690)
* _CParser_. `CParser.parse(String)` method no longer throws an exception, and, when parsing a structure as a string, the return type will be the structure--not the last member of the structure. (GP-3183, Issue #4903)
* _CParser_. Removed `wchar_t` as a keyword when parsing header files. `wchar_t` will always use the built-in `wchar_t` datatype even if defined with a `typedef` within a header file. (GP-3215, Issue #5108)
* _CParser_. Fixed issue with CParser creating `#define` enum values if unsigned long is specified with parentheses around the value; for example, `#define X (4ul)`. (GP-3216, Issue #5069)
* _CParser_. Pressing __Cancel__ during parsing of header files is now more responsive. (GP-3284, Issue #5181)
* _CParser_. Enum constants are now created by the CParser when `#define` expressions ending in `ULL`, `LLU`, `LL`, and `LU` are found in parentheses. (GP-3285, Issue #5161)
* _CParser_. Fixed expansion of `#define` statements embedded in `#include` files and parsing of constants with `UL`/`LL` size specifications. (GP-3310, Issue #5207)
* _CParser_. Fixed CParser issues with forward-declared Enums and typedefs used within the body of functions. (GP-3371, Issue #3526, #5271)
* _CParser_. `Enum` sizes are now set to the size of an `int` for the processor (formerly 4), and `enum`s from `#define`s are set to the the smallest `enum` size that will fit the number (formerly 8). Future change will add packed `enum` sizes. (GP-3385)
* _Data_. Corrected handling of zero-length components in the form of Listing DataComponent CodeUnits. These were incorrectly reporting a length of 0 instead 1; all Listing Data, including DataComponents, must report a positive non-zero length. (GP-3314)
* _Data Types_. Automatically created class structures now respect the __Preferred Root Namespace Category__ property. (GP-1123, Issue #3196)
* _Data Types_. Added support for floating-point data types to parse decimal string representation. A significant refactor of FloatFormat and BigFloat was completed. BigFloat is now used as the value class for all float data types. Introduced `DataType.getAlignedLength()` method which was needed to differentiate between the _raw_ encoding size and the _aligned_ (i.e., padded) size used by a compiler when allocating storage (i.e., `sizeof`). Example: for x86-32 gcc, 80-bit float has an aligned-length of 12-bytes which reflects compiler's `sizeof(long double)`. (GP-1379)
* _Data Types_. Corrected 80-bit floating point support to include decode, encode, and computation via the FloatFormat and BigFloat support classes. (GP-3022, Issue #4853)
* _Debugger_. Fixed issue with default renaming of traces when auto-saving with conflicting names. (GP-1484)
* _Debugger_. Fixed bug in refresh logic. (GP-1884)
* _Debugger_. Fixed various errors in breakpoint logic for dbgeng/model. (GP-2177)
* _Debugger_. Fixed occasional stack trace in auto-saving traces when closing Debugger. (GP-2732)
* _Debugger_. Miscellaneous fixes for LLDB agent. (GP-2781)
* _Debugger_. Provided greater flexibility with library load error messages. (GP-3012)
* _Debugger_. __Emulate Program__ and __Map Identically__ actions now exclude EXTERNAL block. (GP-3087)
* _Debugger_. Removed __Tool Options: Colors__ sections from Debugger help. (GP-3218)
* _Debugger:Agents_. Fixed some issues with GADP agent `no-dep` jars. (GP-1007, Issue #3076)
* _Debugger:Agents_. Fixed a `NullPointerException` in `GadpValueUtils`. (GP-2915, Issue #4791)
* _Debugger:Agents_. Fixed GADP connectors to use the same JRE/JDK as Ghidra. (GP-2979)
* _Debugger:dbgeng.dll_. A register modification now updates the Stack and other windows. (GP-2636)
* _Debugger:Emulator_. The emulator will now halt when trying to decode an instruction from uninitialized memory. (GP-1529)
* _Debugger:Emulator_. Fixed Emulator for processors that use crossbuild. (GP-1904)
* _Debugger:Emulator_. Removed 4 unnecessary classes in emulator: `RequireHasKnownTraceCachedWriteBytesPcodeExecutorState`, `RequireHasKnownTraceCachedWriteBytesPcodeExecutorStatePiece`, `RequireIsKnownTraceCachedWriteBytesPcodeExecutorState`, and `RequireIsKnownTraceCachedWriteBytesPcodeExecutorStatePiece`. (GP-3280)
* _Debugger:GDB_. Fixed missing stack frames when single-stepping. (GP-1470)
* _Debugger:GDB_. Fixed unnecessary error popup when user rejects HostKey while connecting to GDB via SSH. (GP-1710)
* _Debugger:GDB_. Fixed _Erase In Line_ ANSI escape decoding issue for GDB on Windows. (GP-3135, Issue #3562, #5026)
* _Debugger:GDB_. Fixed issue launching binaries in GDB with spaces in the path. (GP-3311, Issue #5203)
* _Debugger:Listing_. Fixed a bug where closing a cloned Dynamic Listing resulted in an extraneous stale `PC` marker in the Static Listing. (GP-2991)
* _Debugger:Mappings_. __Map Identically__ and __Map Manually__ actions will now refuse to overwrite existing mappings. (GP-3086)
* _Debugger:Trace_. Fixed a bug that allowed the user to undo a trace's initial transaction. This would lead to a subsequent `NullPointerException`. (GP-3213)
* _Debugger:Trace_. Fixed issue with __Undo__ not being effective immediately. (GP-3358)
* _Decompiler_. Fixed a Decompiler decoding error that occurred when a pre-comment contained a null character. (GP-3002, Issue #4836)
* _Decompiler_. Line breaks in Decompiler output can no longer disable a comment annotation. (GP-3029)
* _Demangler_. Fixed missing use of `wchar_t`, `wchar16`, and `wchar32` primitives in Demanglers. (GP-3184, Issue #5080)
* _Documentation_. Made minor fixes and improvements to the Advanced Ghidra training class documentation. (GP-2944)
* _ELF_. Corrected ELF MIPS Relocation processing for R_MIPS_32. Added support for R_MIPS_PC21_S2 and R_MIPS_PC26_S2. (GP-3260, Issue #5160)
* _Exporter_. Corrected operand formatting issues with `ProgramTextWriter`, which affected HTML/ASCII exports. (GP-1868, Issue #793)
* _Framework_. Fixed an `IllegalStateException` that occurred while refreshing the Bundle Manager after the Code Browser tool had been closed. (GP-2711, Issue #4656)
* _Graphing_. Changed default Call Graph action to always use the isolated entry block model, which will give the best results most of the time. (GP-3250, Issue #5157)
* _Graphing_. Fixed stack trace when reusing graphs. (GP-3399)
* _GUI_. Updated tables to correctly take focus when pressing `F2` to start an edit. (GP-366)
* _GUI_. Fixed issue where add/edit label dialog would grow ridiculously large. (GP-543)
* _GUI_. Improved function-signature-parsing within Function Editor dialog to handled sized pointers. (GP-1100, Issue #3178)
* _GUI_. Fixed bug where symbol tree category nodes could not be closed when there was a filter in place. (GP-2187)
* _GUI_. Updated the Data Type Manager tree to maintain the tree selection when opening an archive for editing. (GP-2423)
* _GUI_. Fixed the Enum Editor to allow sorting on the Comments column. (GP-2776, Issue #4693)
* _GUI_. Updated the Equates Table to allow multiple selection. (GP-2887, Issue #4771)
* _GUI_. Added rapid Ghidra Server timeout during initial connection to avoid lengthy connection delay when the server system is offline. (GP-2935)
* _GUI_. Added support for HTML rendering in `TableChooserDialog`. (GP-2996, Issue #4880)
* _GUI_. Fixed bug that prevented editing of function variable data types in the __Edit Function__ dialog. (GP-3115, Issue #4970)
* _GUI_. Updated the __Function Signature__ dialog to allow editing the parameter table using only the keyboard. (GP-3173, Issue #3561)
* _GUI_. Fixed bug where scroll bar didn't appear when the view size was just slightly smaller than the actual text to be displayed. This affected the Listing, Bytes, and Decompiler views. (GP-3202, Issue #3938)
* _GUI_. Added the ability to copy details from the __Missing Processor Manual__ dialog. (GP-3205, Issue #4218)
* _GUI_. Fixed issue where opening multiple file datatype archives with the same name would not appear in the Datatypes tree. (GP-3281)
* _GUI_. Changed function custom storage editor to permit larger storage to be specified. Undefined datatype size will expand to match storage size up to 8 bytes. (GP-3286, Issue #4983)
* _GUI_. Fixed bug in Plate Comment that caused truncation during word wrapping. (GP-3403, Issue #5297, #5298)
* _Headless_. Fixed a bug that caused a program to have an invalid `Executable Location` property when the program was imported headlessly from a relative path. (GP-3054)
* _Importer_. The OMF Loader now parses COMMENT_CLASS_LIB correctly. (GP-3118, Issue #5016)
* _Importer_. Fixed an issue that could cause the Importer to not respect the __Load System Libraries From Disk__ and __Load Local Libraries From Disk__ options if the __Perform Library Ordinal Lookup__ option was used. (GP-3272, Issue #4849)
* _Importer:ELF_. Corrected ELF Loader issue which could improperly set memory blocks as read-only. (GP-2730)
* _Importer:ELF_. Added support for ELF X86-64 GOTPCREL relocation processing. Revised ELF relocation processing context API to utilize a single instance per import instead of one per relocation table. (GP-2984, Issue #4859)
* _Importer:ELF_. Corrected ELF Loader issue with INIT/FINI array processing when entries have relocations applied. (GP-3176, Issue #5039)
* _Importer:ELF_. Changed ELF relocation processing to avoid creating offset-pointers in memory blocks whch have execute permission or for section based relocations. (GP-3339, Issue #5238)
* _Importer:Mach-O_. Fixed Mach-O external symbol namespace issues that prevented demangling. (GP-2511)
* _Importer:Mach-O_. Fixed an exception that could occur while parsing DYLD chained fixups in some Mach-O binaries. (GP-3151)
* _Importer:Mach-O_. Fixed a bug that prevented the Mach-O loader from finding and loading libraries that reside in a Universal Binary file. (GP-3167)
* _Importer:Mach-O_. The Mach-O Loader now correctly handles DYLD_CHAINED_PTR_64_OFFSET fixups. (GP-3194, Issue #4986)
* _Importer:Mach-O_. Fixed an exception that occurred when importing Mach-O PowerPC binaries with relocations. (GP-3259)
* _Importer:PE_. Added a PE Loader __Show Debug Line Number Comments__ option to show/hide debug line number comments. (GP-714, Issue #1184)
* _Importer:PE_. Fixed some issues with parsing Windows Dialog resources. (GP-2821, Issue #3807, #3808)
* _Languages_. Added the `HALT` instruction to the Coldfire processor. (GP-3326, Issue #5194)
* _Multi-User_. Corrected issue where shared project creation would retain canonical server name instead of the original, specified hostname. (GP-3050, Issue #4924, #4928)
* _Multi-User_. Corrected issue which disallowed Ghidra Server user IDs starting with a 0-9 digit. (GP-3121)
* _PDB_. Overriding overzealous thunk detection on function creation when PDB knows better. (GP-3127)
* _PDB_. Stubbed in some structures to represent class Member Pointers. Details need to be determined with future research. (GP-3171, Issue #5055)
* _PDB_. A function is now created for a global label only if there are function indicators; otherwise, only a label is applied. Reverts the forced-function creation part of GP-2505. (GP-3200)
* _PDB_. Fixed PDB handling of same-named `__unnamed` anonymous data types with different definitions used within a common structure. These could be emitted by VS 2005. (GP-3279)
* _Processors_. Fixed issues with M68000 shift and rotate instruction behavior. (GP-2013, Issue #4217)
* _Processors_. Added missing x87 `FDESI`, `FENI`, `FNDESI`, and `FNENI` instructions. (GP-2093, Issue #4262)
* _Processors_. Added support for SuperH `fsrra`, `fsca`, and `movua.l` instructions. (GP-2374, Issue #4210)
* _Processors_. Added extended floating point instructions to V850 processor. (GP-2565, Issue #4453, #4481)
* _Processors_. Corrected 6809 and H6309 processors Jump address calculations and fixed issue with Extended Address bit-pattern disassembly. (GP-2650, Issue #4630)
* _Processors_. Corrected addresses for ARM Cortex interrupt vectors. (GP-2706, Issue #4638)
* _Processors_. Added support for MIPS `DSP` instructions. (GP-2775, Issue #4526)
* _Processors_. Fixed operand ordering for M68000 `abcd` and `sbcd` instructions. (GP-2880, Issue #4183, #4189)
* _Processors_. Fixed regression in x86 with disassembling the `pause` instruction. (GP-2892)
* _Processors_. Corrected semantics for TriCore `nor.t` instruction. (GP-2895, Issue #4775)
* _Processors_. Corrected issues in the SPARC language involving delay slots and ordering. (GP-2932, Issue #4805)
* _Processors_. Corrected implementation of PowerPC `fsel` instruction. (GP-2937, Issue #4664)
* _Processors_. Fixed semantics of 65C02 `TRB` and `TSB` instructions. (GP-3039, Issue #4921)
* _Processors_. Fixed operand parsing of ARM Neon `vld` and `vst` instructions. (GP-3043, Issue #4814)
* _Processors_. Corrected x86 `MOV REX, MOFFS64` disassembly with address size prefix. (GP-3078, Issue #4942)
* _Processors_. Corrected x86 `FBLD` instruction semantics. (GP-3079, Issue #2427)
* _Processors_. Fixed ARM neon `VMOV.U16` instruction decode. (GP-3096)
* _Processors_. Fixed issue with ARM Thumb `push {register_list}` not disassembling when the last two registers in the list are `r2` and `r3`. (GP-3132, Issue #5024)
* _Processors_. Supplied additional register field support to AARCH64 `MSR` instruction. (GP-3156)
* _Processors_. Fixed issue with ARM Thumb Neon `vqdmull` instruction not disassembling. (GP-3157, Issue #5053)
* _Processors_. Fixed issue with HCS12 `TSTA` instruction not clearing carry flag. (GP-3169, Issue #5067)
* _Processors_. Fixed issue with M68000 processor having a varnode of zero size. (GP-3187, Issue #5093, #5094)
* _Processors_. Corrected RISC-V `jal`/`jalr` instructions to be a call instead of `goto`, when link register is `T0`. (GP-3217, Issue #5092)
* _Processors_. Fixed PowerPC branch-conditional-and-link semantics for assigning `LR` register. (GP-3341, Issue #5218)
* _Processors_. Fixed stack alignment in x86 far call instructions (GP-3398, Issue #1715, #1723)
* _Scripting_. Fixed an issue that prevented the default script log file from getting used in the user's `.ghidra` directory. (GP-2936)
* _Scripting_. Fixed a bug in `FlatProgramAPI.getLastInstruction()`. (GP-3198, Issue #5090)
* _Scripting_. Improved how the interactive Python interpreter handles transactions. This fixed an uncaught exception that occurred when `GhidraScript.openProgram()` was called. (GP-3321, Issue #5215)
* _Search_. Increased performance related to Search Results table markers. (GP-2828)
* _Search_. Fixed exceptions in `ReferenceUtils` when searching for structure members with no size. (GP-3283)
* _Search_. Fixed bug that caused search highlights to sometimes disappear from the Listing when the user moves the cursor. (GP-3329)
* _Sleigh_. Addressed a bug in the SLEIGH compiler that allowed inconsistent exporting of sizeless varnodes. (GP-3186)

# Ghidra 10.2.3 Change History (February 2023)

### Improvements
* _Basic Infrastructure_. Addressed CVE-2023-22671 by removing `eval` usage from `launch.sh`. (GP-2987, Issue #4869, #4872)
* _Build_. Ghidra's Windows native binaries can now be built using Microsoft C++ Build Tools. (GP-2786, Issue #1733, #4647)
* _Build_. Providing better error reporting when a supported version of Visual Studio (2017+) cannot be found. (GP-2928)
* _Decompiler_. Added fail-fast logic to improve efficiency of switch analysis for software breakpoints. (GP-2866)
* _Decompiler_. Updated the limit of the Auto Fill in Structure action to take the larger of 0x1000 and the size of the structure. (GP-3020, Issue #4879)
* _GUI_. Updated the Front End Project Table to allow users to change selected rows by clicking any already-selected row. (GP-3051)
* _Processors_. Added ColdFire EMAC instruction variants. (GP-2197)
* _Processors_. Added `volatile` and `size` attributes to individual default_symbols/symbol elements in pspec files. Symbols with these volatile and size attributes are treated as volatile by the Decompiler. (GP-2606)

### Bugs
* _Analysis_. Corrected RISC-V function start patterns. The values of `totalbits` and `postbits` were set such that no patterns would ever match. Call instructions split into call/jump based on return addressing saving in `RA`. (GP-2878)
* _Analysis_. Corrected potentially bad constant propagation where the subtraction two unknown values can result in the placement of an erroneous memory reference. (GP-3066)
* _Assembler_. Fixed parsing of 64-bit unsigned immediates. (GP-2789, Issue #4688)
* _Assembler_. Fixed display and assembly of THUMB `tbb [pc, rm]` instruction. (GP-2946, Issue #4824)
* _Debugger:Watches_. Fixed endless read loop in Watches pane when read results in error. (GP-2815)
* _Decompiler_. Fixed Decompiler bug that can cause `Symbols... assigned to the same variable` exceptions. (GP-2859)
* _Decompiler_. Fixed regression in handling of spacebase register values that cause a stack trace in the Decompiler for RISC-V. Removed unnecessary spacebase settings in TriCore, MIPS, RISC-V. (GP-2905)
* _Decompiler_. Fixed bug preventing some format conversions of negative constants in the Decompiler window. (GP-2927, Issue #3747)
* _Decompiler_. Fixed error in dynamic hash algorithm which could cause the rename/retype actions in the Decompiler to fail. (GP-3014, Issue #193)
* _Decompiler_. Fixed Decompiler marshaling parsing error for function prototypes with an `unknown` stack purge. (GP-3065)
* _Decompiler_. Fixed bug causing switch analysis on x86 16-bit executables to fail. (GP-3075)
* _Decompiler_. Fixed bug causing `Expecting unsigned integer attribute` exceptions when decompiling for architectures with a word size greater than 1 byte. (GP-3088)
* _DWARF_. Fixed issue with DWARF not marking object-oriented methods as a `__thiscall`. (GP-2904)
* _Exporter:XML_. Corrected XML export bug that improperly output custom property values, such as Analysis Times, which was causing failure at time of subsequent import. (GP-1453)
* _GUI_. Updated the Structure Editor's Create Structure from Selection action to work around a focus issue experienced by some users. (GP-3069, Issue #4066)
* _Importer_. Improved support for loading old-style DOS MZ binaries. (GP-2210, Issue #1876, #1892, #254, #4318)
* _Importer:PE_. Fixed an issue that prevented PE ordinal symbols from getting their true names resolved during headless mode import. (GP-2947, Issue #4821)
* _Importer:PE_. Fixed an issue with label addresses in the PeLoader that occurred when sections had an uninitialized padding block appended to their initialized block. (GP-2948, Issue #4815)
* _Multi-User_. Fixed svrAdmin to handle projects that contain a space character in the name. (GP-2852, Issue #4750)
* _PDB_. Corrected a PDB Universal analysis regression error in Ghidra 10.2.2 that caused an internal anonymous function definition name to be set on a function instead of the function symbol name. (GP-2864, Issue #4842)
* _Processors_. Fixed pcode for the PowerPC `mtmsr` instruction. (GP-2245)
* _Processors_. Corrected flag updates for the z80 `adc` instruction. (GP-2882, Issue #4553)
* _Processors_. Set 8051 bit-mapped SFR register range to volatile. (GP-2910, Issue #3061)
* _Processors_. Fixed issue with x86 `VEX` prefix colliding with the `LDS` instruction. (GP-2959, Issue #4832)
* _Processors_. Corrected implementations of x86 `SHUFPS` and `PSHUFD` instructions in ia.sinc. (GP-3023, Issue #4868)
* _Processors_. Fixed ARM Thumb issues with `ldr` instructions disassembling as incorrect variants. (GP-3083, Issue #4959)
* _Version Tracking_. Fixed ArrayIndexOutOfBoundsException encountered when using HashedFunctionAddressCorrelation for version tracking. (GP-2758, Issue #4683)

# Ghidra 10.2.2 Change History (November 2022)

### Bugs
* _Debugger_. Improved error reporting for failed GADP-based Debugger connections. (GP-994)
* _Debugger:Breakpoints_. Fixed breakpoint margin display in the Listing for breakpoints spanning multiple lines (code units). (GP-2733)
* _Debugger:GDB_. Fixed parsing of AArch64 vector registers in GDB connector. (GP-1459, Issue #3541)
* _Disassembly_. Corrected regression error in Ghidra 10.2 which could prevent proper disassembly flow within overlay memory blocks. (GP-2800)
* _Graphing_. Corrected code flow graph node rendering issue which improperly displayed HTML tags. This was a regression error introduced with Ghidra 10.2. (GP-2842)
* _PDB_. Fixed logic for overriding primary, public symbols on functions. This will allow function definitions to be retrieved from mangled symbols when rich data types are not found with the global symbols. (GP-2838, Issue #4735)

# Ghidra 10.2.1 Change History (November 2022)

### Improvements
* _Data Types_. Added performance improvements for Structure build-up and resolution when simplifying assumptions can be made. (GP-2777)

### Bugs
* _DB_. Corrected database table key iterator regression error introduced with Ghidra 10.2 which could result in a NullPointerException. An internal long key iterator transition may fail under certain conditions when the iterator has already been exhausted. (GP-2805, Issue #4716)
* _Debugger_. Removed a timeout when prompting the user for Debugger launch options. (GP-2722)
* _Debugger:Agents_. Fixed error text rendering in Debugger agent windows. (GP-2724)
* _Decompiler_. Fixed a bug in the Decompiler preventing local variables outside of the normal stack region from being renamed or retyped. (GP-2818)
* _Disassembly_. Corrected regression error in Ghidra 10.2 which prevented proper disassembly flow within overlay memory blocks. (GP-2800)
* _GUI_. Fixed table column filtering to correctly match input data containing newline characters when using the Contains string column filter. (GP-2797, Issue #4722)
* _GUI_. Fixed the Front End's running Tool Button tooltip text to include the tool's title. (GP-2810)
* _Importer:Mach-O_. Fixed an issue that prevented some Mach-O binaries from being imported if there were unexpected issues while creating the Program Tree. (GP-2802, Issue #4724)
* _Importer:Mach-O_. Fixed an issue that prevented some Mach-O binaries from being imported if they did not define a __LINKEDIT segment. (GP-2803)
* _Importer:PE_. Fixed .Net/x86 disassembly protection code which prevents disassembly of CLI code in an x86 processor. (GP-2807)
* _Processors_. Corrected ARMv5 disassembly regression errors (GP-2812, Issue #4717)

# Ghidra 10.2 Change History (November 2022)

### New Features
* _Basic Infrastructure_. Ghidra now requires JDK 17 to run. (GP-2132, Issue #4316)
* _Build_. A CycloneDX Software Bill of Materials (SBOM) is now included with a Ghidra distribution. (GP-1782)
* _Data Types_. Added `getSelectedDatatypes()` method to DataTypeManagerService to get a list of selected data types in the data type tree. (GP-1631)
* _Debugger_. Added a basic Frida debugger connector. (GP-1681, Issue #3134)
* _Debugger_. Added cursor header to Plot columns in Debugger's experimental Model window. (GP-2067)
* _Debugger_. Added Choose Platform actions to Debugger. (GP-2163)
* _Debugger_. Enabled debugging using Frida on USB/remote devices. (GP-2312)
* _Debugger_. Added Map Manually action to Modules window. (GP-2474)
* _Debugger:Emulator_. Userops can be defined using Sleigh or Structured Sleigh. (GP-1205)
* _Debugger:Emulator_. Added Linux x86 (64- and 32-bit) `read`, `write`, `open`, `close`, `exit`, and `exit_group` syscalls to the emulation API. (GP-1208)
* _Debugger:Emulator_. Added Taint Analyzer (development prototype). (GP-1230)
* _Debugger:Emulator_. Added a skip instruction button to the emulator (Threads pane). (GP-2062)
* _Debugger:Emulator_. Added prototype `EmuDeskCheckScript` to emulate and produce a table of expression values for each step. (GP-2289)
* _Debugger:Listing_. Added toggle to automatically synchronize static and dynamic program selections; added actions to manually transfer selections between static and dynamic listings. (GP-1451)
* _Debugger:Listing_. Can now have the Dynamic Listing and Memory windows follow the address of a watch. (GP-2581)
* _Debugger:Trace_. Added Objects Manager to Trace API. (GP-1386)
* _Debugger:Trace_. Added API for user-defined property maps on traces. (GP-2191)
* _Debugger:Watches_. Added data type settings to Registers and Watches windows. (GP-1984)
* _Decompiler_. A new Decompiler highlight service has been added, allowing clients to create highlights in the form of background colors for the syntax tokens in the Decompiler UI. Highlights apply to a full token and not strings of text. To highlight a token, you create a `CTokenHighlightMatcher` and pass it to the `createHighlighter()` method of the highlighter service. There is no limit to the number of highlighters that may be installed, and if multiple highlights overlap, their colors will blend. (GP-1435, Issue #2313)
* _Decompiler_. The Decompiler now fully supports union data-types. (GP-1518)
* _Decompiler_. A new Create Relative Pointer action is available from the main Decompiler pop-up menu. It creates pointers that have an offset relative to another data-type--typically a structure. Applying the action, the Decompiler can then follow and label accesses into the structure. (GP-1645)
* _Decompiler_. The Format setting on a Typedef of an integer data-type now affects the display of constants in Decompiler output. A non-default setting forces the format for displaying constants of that data-type. (GP-1652, Issue #3004)
* _Decompiler_. Decompiler line number margin now has fixed horizontal position. (GP-2446)
* _Extensions_. A MachineLearning extension has been added. This contains a plugin for finding code and functions in a binary by training on functions which have already been found. (GP-2204)
* _Importer_. Updated support for Android version 12.x (S): OAT v199, Vendor Boot Image v4, and FPBK v2. (GP-1461)
* _Importer_. Created new Dump File Loader for Windows dump file formats. (GP-1864)
* _Importer_. Added support for APPORT-style crash dumps (Ubuntu) to Dump File Loader. (GP-2049)
* _Importer_. Added support for Android formats (ART, OAT, ODEX, DEX, CDEX, VDEX) and Dalvik VM Sleigh modules for each major Android release up to version 13.x (T). (GP-2060)
* _Listing_. Added right-click menu Patch Data action for modifying bytes in the listing according to the unit's data type. (GP-1684)
* _Scripting_. Added FlatDebuggerAPI interface for GhidraScripts to more easily access the Debugger's API. (GP-2189)

### Improvements
* _Analysis_. Added detection of `pop` to the PC as a return in ARM binaries. (GP-634)
* _Analysis_. PointerTypedefs are now used for Relative Pointers in the Objective_C2 small method data structures. Previously, the value was a DWORD and did not resolve to an address. (GP-1427)
* _Analysis_. The Variadic Function Signature Override Analyzer now handles offcut references to format strings. (GP-2048, Issue #4256)
* _Analysis_. Added to the list of known non-returning windows functions. (GP-2069, Issue #4181)
* _Analysis_. Improved branch-through-a-register return pattern for ARM processor thunk creation. (GP-2391)
* _Analysis_. Enabled Assume Contiguous Functions Only option in Shared Return Calls analyzer. Disabled by default for ARM processors because of use of `BL` for long jumps in Thumb mode. (GP-2534, Issue #4573, #678)
* _API_. Added the ability to search for enum member usage. (GP-1514, Issue #1967)
* _API_. Added recursive form of `Function.getFunctionThunkAddresses()` method. (GP-1692)
* _API_. Improved namespace-based data type searching. Also added ability to specify a preferred root category for such searches on the Program API, which can be manipulated via the Program Information options panel. (GP-1994)
* _API_. Eliminated methods from `AddressMap` interface which are intended for internal use only. (GP-2002)
* _API_. Removed deprecated methods from ProgramPlugin. (GP-2663)
* _Basic Infrastructure_. Updated Gson to 2.9.0. (GP-1909, Issue #3992)
* _Basic Infrastructure_. Updated commons-compress to 1.21. (GP-1910)
* _Basic Infrastructure_. Updated commons-io to 2.11.0. (GP-1911)
* _Basic Infrastructure_. Upgraded commons-text to 1.10.0 and commons-lang3 to 3.12.0. (GP-2753)
* _C Parsing_. Any open archives in the data type manager will be searched for any missing data types during parsing. In addition when parsing header files with open archives there are new options to Use, Don't Use, or Cancel parsing. (GP-1336, Issue #2119, #2885, #716)
* _Data Types_. Updated the Data Types view Paste action to work when pasting on a data type node. (GP-1627, Issue #3568)
* _Data Types_. Added a Home action to the Structure Editor to allow users to show the structure data type in the Data Types tree. Added the Show In Data Type Manager action to the data type nodes in the Data Types tree to allow users to associate types with an archive. (GP-1913)
* _Data Types_. Modified `DataType.clone(DatatypeManager)` method implementations for `StructureDB`, `UnionDB`, `FunctionDefinitionDB`, and `EnumDB` to adhere to method documentation which states that a datatype will return the instance itself if its `DataTypeManager` is the same as the parameter specified. (GP-2236)
* _DB_. Added persistent Name column to Breakpoints table. (GP-1559, Issue #3679)
* _Debugger_. Added GDB connector support for Windows (tested with GDB 11.1 on msys64). (GP-869, Issue #2908)
* _Debugger_. Debugger and Python Interpreter windows now support ANSI colors and styles. (GP-887, Issue #4176)
* _Debugger_. Revised Debugger icons for visual contrast and action clarity. (GP-1538)
* _Debugger_. Added Watch action to Listing, Memory, and Registers context menus. (GP-1560, Issue #3680)
* _Debugger_. Dynamic Listing, Bytes, Registers, and Watches windows all now support editing the machine state. Edits can be directed to the Target, the Trace, or the Emulator. (GP-1584)
* _Debugger_. Upgraded SWIG to match lldb v14. (GP-1760)
* _Debugger_. Added Symbol column to Watches window. (GP-1773)
* _Debugger_. Reworked the breakpoint state system and icons. (GP-1821)
* _Debugger_. Improved breakpoint initialization. (GP-1824)
* _Debugger_. Updated program user data to preserve command-line arguments. (GP-1886)
* _Debugger_. Minimized the number of registers read for dbgeng; eliminated error messages. (GP-1898)
* _Debugger_. Fixed issues with Debugger when dbgeng/dbgmodel connectors load/debug crash dumps. (GP-2023)
* _Debugger_. Improved launcher logic for detecting and remedying trace recording and module mapping failures. (GP-2036)
* _Debugger_. Added remote options to IN-VM dbgeng and dbgmodel connectors, like those for the GADP variants. (GP-2135)
* _Debugger_. Added Track Program Counter (by Stack) and Track Program Counter (by Register) options to Dynamic Listing and Dynamic Memory. (GP-2462)
* _Debugger:Breakpoints_. Improved error feedback for some failures in toggling/enabling (unmappable) breakpoints. (GP-2243)
* _Debugger:Emulator_. Userop library callbacks can now receive more context via annotated parameters. (GP-1203)
* _Debugger:Emulator_. Changed the display of the PcodeStepper window to look like the PCode field in the Listing windows. (GP-1535)
* _Debugger:GDB_. Updated the GDB connector to support version 12.1. Now parses flags for memory map. (GP-2089, Issue #4297)
* _Debugger:GDB_. Added GDB scripts for getting memory map of remote Wine win32 targets. (GP-2495, Issue #4546)
* _Debugger:GDB_. Ported GDB connector to use JNA. (GP-2619)
* _Debugger:Listing_. Added marker margin and overview to the Dynamic Listing window. (GP-1433)
* _Debugger:Listing_. Changed priority so that PC highlights are over breakpoint highlights. (GP-2294)
* _Debugger:Mappings_. Added Map Regions actions to Debugger. (GP-1231)
* _Debugger:Objects_. Creating fewer unsolicited error popups in Debugger by logging these errors to the console. (GP-1329, Issue #3452)
* _Debugger:Trace_. Made address encoding in traces more compact. (GP-2437)
* _Debugger:Trace_. Handling Trace version exceptions more gracefully. Presents a clearer error dialog. (GP-2452)
* _Debugger:Trace_. Simplified Trace database API: Register spaces are no longer a special interface. (GP-2479)
* _Debugger:Trace_. Optimized trace memory access for Dynamic Listing and Memory windows. (GP-2593)
* _Debugger:Trace_. Fixed a possible deadlock in the Trace database. (GP-2595)
* _Debugger:Watches_. Repr column is now modifiable in Registers and Watches windows for supported data types. (GP-1881)
* _Decompiler_. A prototype model, as defined by the  tag in a compiler specification, can now be assigned multiple names. The names can be used interchangeably when assigning a calling convention to a function. (GP-1653)
* _Decompiler_. The Decompiler now uses proper syntax when extracting small fields from packed structures. (GP-1683)
* _Decompiler_. Added Decompiler support for the address space attribute on pointer typedefs. (GP-1932)
* _Decompiler_. Updated windows calling convention on x64 to properly handle functions with both floating-point and integer/pointer arguments. Users should re-import and analyze programs with such functions. (GP-1954, Issue #1480, #2952)
* _Decompiler_. The Decompiler better simplifies multi-part boolean expressions that are built using a status register. (GP-2281, Issue #620)
* _Decompiler_. The Decompiler now supports simplification of more forms of optimized modulo/remainder calculations. (GP-2292, Issue #4322)
* _Decompiler_. The Decompiler now uses a new, more efficient protocol to communicate with the rest of Ghidra. (GP-2358)
* _Decompiler_. Auto-generated stack variable names in the Decompiler now show offsets in hexadecimal format. (GP-2486, Issue #4442)
* _Decompiler_. Changed the Decompiler Rename Function action so that if applied to a thunk, the underlying thunked function is renamed instead of the thunk itself. In most cases the rename should be applied to the thunked-function instead of the thunk itself. (GP-2520, Issue #4566)
* _Decompiler_. The Decompiler now displays reads from or writes to volatile variables using simple assignment syntax instead of functional syntax. (GP-2578)
* _Decompiler_. Improved handling of `_guard_dispatch_icall` and other functions that inject an indirect call into the Decompiler. (GP-2601, Issue #1719, #4591)
* _Demangler_. Added second-pass processing for non-standard Microsoft Demangler forms found in LLVM mangling scheme. (GP-1725, Issue #1162)
* _Demangler_. Improved post-analysis pop-up error messaging. (GP-2429)
* _Demangler_. Changed symbol demanglers to place anonymous function definitions into the `/Demangler/!_anon_funcs_` category using a revised naming convention consistent with PDB with a `_func_` name prefix. Changed DWARF to use this same anonymous function definition name prefix. (GP-2557)
* _Demangler_. Improved demangling after File -> Load PDB File... task by kicking off standard demangler analyzer instead of the DemanglerCmd. This should improve consistency in Demangler output across a program. (GP-2648)
* _DWARF_. Relaxed DWARF analyzer's requirement of a register-mapping file in order to allow attempted import of function definitions when missing. (GP-1833)
* _DWARF_. Added support for compressed DWARF sections. (GP-2106)
* _DWARF_. Improve DWARFs handling of explicitly sized data types (e.g., int32_t). Added Try To Pack Structs option to DWARF analyzer to enable packing of structure/union data types created by the analyzer. (GP-2526)
* _Eclipse Integration_. The GhidraDev Eclipse plugin now requires Java 17 and Eclipse 2021-12 4.22 or later. (GP-2398, Issue #4496)
* _Exporter_. Updated IDA Pro plugins compatibility for python 3. The plugins remain compatible with python 2. (GP-2567, Issue #1327, #1618, #2642)
* _Graphing_. Created Graph Data Flow action in Decompiler window menu and renamed existing graph action from Graph AST to Graph Control Flow. (GP-1704)
* _GUI_. Fixed dialog text and icon clipping seen on some Linux distributions. (GP-1534, Issue #1506)
* _GUI_. Updated Enum Editor to scroll while using the arrow keys when in edit mode. (GP-1553, Issue #3669)
* _GUI_. Fixed ordering of automatic comments in the Listing. (GP-1568, Issue #3648)
* _GUI_. Updated the UI to allow for setting equate values when an enum has more than one name mapped to a particular value. (GP-1572, Issue #3618)
* _GUI_. Add Shift-key modifier to Previous/Next toolbar buttons that invert the action to jump the cursor to functions, labels, data items, etc. (GP-1578)
* _GUI_. Updated the GTree to allow new nodes to be created while a filter is applied. (GP-1615)
* _GUI_. Added new Mark and Select action that allows users to create selections in a two-step process. The first time the action is invoked, the current location is marked. The next time the action is invoked, a selection is created from the marked location to the current location. (GP-1616)
* _GUI_. The Go To... dialog now supports navigating to file offsets with a `file(n)` search string, and a new File Offset field has been added to the Listing (disabled by default). (GP-1756)
* _GUI_. Created the new Script Quick Launcher Dialog. (GP-1826)
* _GUI_. Selecting nodes in the ProjectDataTreePanel was made more efficient. This is only noticeable when there is a very large number of programs in a project. (GP-1931)
* _GUI_. Added the Offset table column to the Structure Editor. This column is hidden by default, but can be added by right-clicking on the table's column header. (GP-1943, Issue #3850)
* _GUI_. To reduce memory consumption, revised Symbol Table GUI to avoid hanging onto symbol objects. In some cases this may reduce the speed with which the symbol table updates. (GP-2030)
* _GUI_. Changed Structure Editor Duplicate Component and Duplicate Multiple of Component... actions to select the last component; this allows for repeated uses of the action via key-binding. (GP-2095, Issue #4229)
* _GUI_. Updated the Data Type Manager's right-click menu Replace... action on a selected data type to have a clearer purpose by prompting the user to confirm the replace action. (GP-2405, Issue #4463)
* _GUI_. Updated popup menu key event processing to not apply to combo boxes. (GP-2491, Issue #4545)
* _GUI_. Added the new Does Not Match Regex table column filter to allow clients to show table rows that do not match the given regular expression. (GP-2582, Issue #4608)
* _GUI_. Added the `TableChooserExecutor.executeInBulk()` method to allow script writers to process multiple selected table rows themselves instead of one at a time. (GP-2583, Issue #4609)
* _GUI_. Updated the XRefs Dialog to allow users to show xrefs to thunk functions. (GP-2594, Issue #3851)
* _GUI_. Updated the Search Memory Dialog to allow users to paste hex values that begin with `0x`. (GP-2622, Issue #4623)
* _GUI_. Updated the Instruction Info window to allow users to select and copy cells from the table. (GP-2631, Issue #4626)
* _GUI_. Updated the Component Providers' drop-down button to allow users to add a keybinding to show the popup menu. (GP-2637, Issue #4625)
* _Importer_. Added support for Android Multi-DEX. Created new Android APK loader to load all DEX files at one time and link the `method_lookup` sections using external references. The APK loader uses the manifest file to determine the Android version. (GP-275, Issue #4276)
* _Importer_. Permanently removed the ContinuesInterceptor, which had allowed the import process to proceed past uncaught exceptions that could be encountered while parsing corrupted headers. (GP-1907)
* _Importer_. The NeLoader now creates memory blocks using the FileBytes API which enables the file offset Listing field and lookup in the Goto dialog. (GP-2521, Issue #4565, #4570)
* _Importer_. Redesigned the Importer's load library option set. The user now has finer-grained control over where libraries are loaded from, as well as how many libraries are loaded. (GP-2541)
* _Importer_. Redesigned the Importer's load library option set. The user now has finer-grained control over where already-imported libraries are searched for in the project, as well as where newly imported libraries are saved to in the project. (GP-2604)
* _Importer:ELF_. Added ELF import-processing of symbols defined in the `.gnu_debugdata` section. (GP-1592, Issue #1659)
* _Importer:ELF_. Improved ELF import-processing and logging of missing/truncated headers. (GP-1605, Issue #3507)
* _Importer:ELF_. Improved ELF Importer to handle extended program and section header counts `(e_phnum, e_shnum)` which may be encountered for large core/memory dump files in ELF format. (GP-1936, Issue #4149)
* _Importer:Mach-O_. We now discover more Mach-O functions via the LC_FUNCTION_STARTS load command. (GP-1460, Issue #3586, #3668)
* _Importer:Mach-O_. Improved symbols and exports in Mach-O and DYLD shared cache files. (GP-2008, Issue #2932)
* _Importer:Mach-O_. Improved the Program Tree for Mach-O, DYLD shared cache, and PRELINK files. (GP-2019)
* _Importer:Mach-O_. The Objective-C Class Analyzer now works with dyld_shared_cache files. (GP-2113)
* _Importer:Mach-O_. Improved processing to support changes in iOS 16 and macOS 13 dyld_shared_cache format. (GP-2176, Issue #4346, #4406)
* _Importer:PE_. The Thread Environment Block (TEB) is now automatically populated by an analyzer for PE format programs on x86. (GP-527)
* _Importer:PE_. Added label for `_tls_index`. (GP-2166, Issue #4285)
* _Jython_. Upgraded Jython to 2.7.3. (GP-2324, Issue #107)
* _Listing_. Added trailing comma on global arrays display. (GP-2165, Issue #4261, #4287)
* _Multi-User_. Improved svrAdmin command for controlling repository access. Eliminated `-admin` option while adding `-grant` and `-revoke` options. (GP-394, Issue #1703, #2467)
* _Multi-User_. Eliminated use of ganymed-ssh2 library in favor of Bouncy Castle library suite. Improved Ghidra Server SSH authentication error reporting. (GP-1769)
* _Multi-User_. The `svrAdmin(.bat)` script will now run under a JRE in addition to a JDK. (GP-2301, Issue #4394)
* _Multi-User_. Improved `Edit Shared Project Information` capability which now handles case where user may have checked-out files and is unable to checkin or terminate them when unable to connect to old server (e.g., server name or IP address has changed). (GP-2496)
* _Multi-User_. Upgraded Ghidra Server service wrapper (YAJSW) to 13.05. (GP-2754)
* _PDB_. Crafted additional mechanisms for determining segment addresses. (GP-1777, Issue #3993)
* _PDB_. When PDB has no type information, changed processing order so that mangled symbols become primary symbols, encouraging recovery of their limited type information. (GP-2385, Issue #4489)
* _PDB_. Improved PDB Universal function creation, to include `unknown` calling convention when a custom calling convention is indicated and `noreturn` when indicated for a function. Also added initial support for some MIPS and IA64 processors called out in PDB. (GP-2505)
* _Processors_. Implemented semantics for x86/64 `POPCNT` instruction. (GP-1780)
* _Processors_. Updated ARM Processor specification to V9.3. (GP-1790, Issue #4655)
* _Processors_. Added conditional assignment macro to x86 processor module. (GP-1819)
* _Processors_. Implemented Coldfire `bitrev`, `byterev`, and `ff1` instructions. (GP-2195, Issue #4270)
* _Processors_. Generalized the 6502 processor spec file. (GP-2332, Issue #1533, #3434)
* _Processors_. Added SLEIGH support for `inst_next2`, which can be used to implement conditional skip-next-instruction cases in the language spec. (GP-2480)
* _Processors_. Added `mips-eabi` compiler specification. (GP-2734, Issue #3633, #3634)
* _References_. Added support for use of `Pointer-Typedef` with Offset setting to signal creation of an OffsetReference. Modified ELF relocation handler to create such pointers for certain relocation types known to be associated which offset-data pointers. Improved Listing operand markup for rendering of OffsetReferences. Took special measures for such data references into the `EXTERNAL` memory block to remedy XRef and navigation issues. (GP-1036)
* _References_. Reference-finding actions in the Decompiler now work properly when applied to global variables. (GP-1880)
* _References_. `CALLOTHER_OVERRIDE_CALL` references now cause the inputs of the original CALLOTHER op to be discarded. (GP-2206, Issue #3665, #3936)
* _Scripting_. Upgraded Apache Felix to 7.0.3. (GP-1326, Issue #3450)
* _Scripting_. Improved class recovery discovery mechanisms for determining deleting destructors and clones. (GP-1581)
* _Scripting_. ApplyClassFunctionDefinitionUpdatesScript has been improved to allow users to choose function definition(s) from the Data Type Manager to apply updates from. Previously, users had to put a cursor somewhere in the related class and possibly get possibly unwanted updates from unchanged definitions in selected class(es). (GP-1660)
* _Scripting_. Added a search filter to `RunYARAFromGhidra.py` to include .yara files. (GP-1794)
* _Scripting_. `RecoverClassesFromRTTIScript` has been updated to make use of the new shifted pointer data types where applicable. (GP-1947)
* _Scripting_. Updated `RecoverClassesFromRTTIScript` to prevent it from running more than once on the same program. (GP-1962)
* _Scripting_. Added `FixElfExternalOffsetDataRelocationScript` to be used in updating EXTERNAL offset data relocations flagged by an ELF Relocation ERROR bookmark. These locations now support the use of an offset pointer-typedef and a resulting offset-reference. (GP-1963)
* _Scripting_. The `RecoverClassesFromRTTIScript` has been updated to make use of the new program setting allowing use of a preferred data type category for class structure assignment. Due to this change, there is no longer any need to remove existing class structures in order to use those created by this script, so all code related to replacing, other class structures, has been removed. (GP-2010)
* _Scripting_. Added `CallotherCensusScript`, which determines the most frequent instructions with (partially) unimplemented semantics in a single program or across an entire repository. (GP-2072)
* _Scripting_. Improved `RecoverClassesFromRTTIScript` to distinguish between and name deleting destructors as either scalar or vector ones or both in Windows programs. (GP-2075)
* _Scripting_. Updated the Script Manager to not close dialogs when the manager is closed. (GP-2216, Issue #4363)
* _Scripting_. Added `createNamespace` and `createClass` methods to `FlatProgramAPI` for Ghidra script use. (GP-2482, Issue #4446)
* _Search_. Added the ability to search for structure fields by offset. (GP-1556)
* _Search_. Added Navigate to Matching Byte Values action to the main toolbar to find the next matching byte value of the item under the cursor. (GP-1679)
* _Testing_. Upgraded hamcrest to 2.2. (GP-1993)
* _Testing_. Upgraded pcodetest build scripts to python 3. (GP-2138, Issue #4307)
* _Testing_. Upgraded Jacoco to 0.8.8. (GP-2208)

### Bugs
* _Analysis_. Fixed Windows x86 PE RTTI Analyzer to not duplicate labels on type_info vftables when PDB is present. (GP-854)
* _Analysis_. Fixed long-standing issue with incorrectly named RTTI Type Descriptor symbols; also added correct class namespace. (GP-1703)
* _Analysis_. Fixed issue where, when opening an non-analyzed program with one tool and that tool is connected to another tool, multiple ask-to-analyze dialogs would appear. (GP-1860)
* _Analysis_. The Java Analyzer now parses MethodParameters attributes and gracefully handles unknown or unsupported attributes instead of throwing a RuntimeException. (GP-2012, Issue #4089)
* _Analysis_. The Variadic Function Signature Override analyzer now handles wide-character format strings which are not defined data. (GP-2016, Issue #4165)
* _Analysis_. Improved heuristics used to find strings in the Variadic Function Signature Override analyzer. (GP-2070, Issue #4154, #4281)
* _Analysis_. Improved forced thunk creation from function start patterns files and fixed NullPointerException when thunk analysis got ahead of disassembly. (GP-2378, Issue #4369)
* _Analysis_. Fixed bug in Variadic Function Signature Override analyzer involving examining too many function arguments. (GP-2384, Issue #4478)
* _Analysis_. Changed Analysis to not mark class methods as noreturn unless they are included in the non returning function list as a mangled name. (GP-2471, Issue #2130, #4531)
* _Analysis_. Added switching function identification for ARM RealView compiler. (GP-2504)
* _Analysis_. Fixed an IllegalStateException in the FunctionStartAnalyzer that could occur for ARM thumb binaries. (GP-2543)
* _Analysis_. Corrected Decompiler Switch Analysis issue which could prevent proper function body fixup to include switch code. (GP-2554)
* _Analysis_. Fixed code to use the functions calling convention when computing the stack purge. X86 16-bit binaries now correctly display the correct value in the stack depth listing field. (GP-2683, Issue #4294)
* _API_. Fixed issue where storing a register context across the entire address space had issues if the image base was a non-zero value. There were also numerous other issues that were uncovered, related to this context/image-base issue change, that were also fixed. (GP-1778)
* _API_. Corrected improper instruction context read which could cause issues with delay-slot instructions that rely on context. (GP-2094, Issue #4259)
* _Assembler_. Fixed issue with assembler referring to external functions via the IAT or PLT. (GP-615, Issue #2670)
* _Assembler_. Refactored Assembler. Fixed issue assembling for x64 in 32-bit compatibility mode. (GP-1426)
* _Assembler_. Made Assembler fields obey Listing Display font settings. (GP-1664)
* _Basic Infrastructure_. Fixed an IllegalArgumentException that occurred when initializing 1-byte uninitialized memory blocks. (GP-2523)
* _C Parsing_. Fixed numerous errors in C-Parser, including updated C specification syntax, macros with varargs, anonymous arrays of function pointers, and array definitions. Also providing better error handling. In addition data types in open archives can be used during parsing. (GP-1979, Issue #1455, #1784, #1940, #3908, #3996, #4184, #4377, #4491, #4517)
* _CParser_. C-Parser handles arrays of function pointers and anonymous function signatures correctly. (GP-2258, Issue #3908, #4351)
* _CParser_. C-Parser now accepts `static_assert` keyword in more places, such as within structure definitions. (GP-2273, Issue #4401)
* _CParser_. C-Parser grammar fixed to parse `#pragma` keyword in more places such as within enum declarations. (GP-2646, Issue #4628)
* _CParser_. C-Parser now defines a placeholder structure name early in parsing. (GP-2692, Issue #3505)
* _CParser_. Fixed expansion of macros with missing arguments, concatenated string constants, const after type specification, and `#pragma` found in function calls. (GP-2746, Issue #2896, #4660, #4676, #4677)
* _Data Types_. Added support for pointer typedefs with various settings. (GP-1403)
* _Data Types_. Corrected issues within structure/union editor when specifying a component whose datatype is a pointer to the edited structure (i.e., pointer-to-self). (GP-2134, Issue #3721)
* _Data Types_. Added validation to EnumDataType.setLength(). (GP-2689, Issue #4654)
* _DB_. Corrected JVM shutdown issue which could cause database recovery files to be discarded. (GP-1787, Issue #3994)
* _Debugger_. Fixed occasional, spurious goto-PC when navigating in Debugger listing. (GP-385)
* _Debugger_. Eliminated redundant calls to startRecording. (GP-1443, Issue #3559)
* _Debugger_. Fixed compatibility issue with GDB 11 regarding module and section list. (GP-1666)
* _Debugger_. Corrected Debugger address space mismatch and NullPointerException errors. (GP-1757, Issue #4022, #4023, #4024, #4025)
* _Debugger_. Fixed for numerous failures in dbgeng. (GP-1812, Issue #4059)
* _Debugger_. Fixed problem with memory refresh in dbgeng/dbgmodel targets. (GP-1852, Issue #4059)
* _Debugger_. Fixed a DomainObject deadlock. (GP-1859)
* _Debugger_. Fixed consistency issues when saving/loading target-launch command-line options. (GP-1866, Issue #4106)
* _Debugger_. Fixed bug when refreshing target memory in dbgeng/dbgmodel connectors. (GP-1893, Issue #4112)
* _Debugger_. Fixed register-update failures. (GP-1971)
* _Debugger_. Fixed several bugs in the debug launch target monitor dialog. (GP-2102)
* _Debugger_. Made miscellaneous fixes for errors in the JDI debugger. (GP-2253)
* _Debugger_. Fixed a NullPointerException that occurred when closing the Debugger tool. (GP-2387)
* _Debugger_. Fixed issue with Debugger module list when connected to GDB 10.1 on Debian Bullseye. (GP-2533, Issue #4583)
* _Debugger_. Fixed issue in module list with gdb-11 and later. (GP-2727)
* _Debugger:Breakpoints_. Fixed a bug that caused unexpected behavior when toggling a breakpoint while the cursor is in the Bytes field of the Listing. (GP-2725)
* _Debugger:Breakpoints_. Fix address of watchpoints in GDB. (GP-2726)
* _Debugger:Emulator_. Fixed spurious `Emulate read from uninitialized state` warnings when P-Code Stepper window is active. (GP-1650)
* _Debugger:Emulator_. Fixed display of internal p-code labels in Pcode Stepper window. (GP-1883)
* _Debugger:Emulator_. Fixed NullPointerException that occurred when adjusting the register-tracking setting on the Dynamic Listing window. (GP-1905)
* _Debugger:Emulator_. Fix bug in Taint analyzer with INT_ZEXT and INT_SEXT. (GP-2489)
* _Debugger:Emulator_. Fixed issue with emulator writing values at space's max address. (GP-2490)
* _Debugger:GDB_. Fixed GDB connector, making it properly parse escaped strings. (GP-1953, Issue #4169)
* _Debugger:GDB_. Fixed AddressOutOfRange issues when GDB's `info proc mappings` fails on 32-bit and smaller targets. (GP-2241, Issue #4345)
* _Debugger:GDB_. Fixed GDB model so that patching PC updates the listing highlight. (GP-2635)
* _Debugger:Mappings_. Fixed address/range arithmetic in Static Mapping service. (GP-2011)
* _Debugger:Memory_. Fixed font coloring in Dynamic Memory window to indicate changes in the same manner as other Debugger windows. (GP-1890)
* _Debugger:Memory_. Fixed auto-read-memory to work with the Force Full View toggle. (GP-2033)
* _Debugger:Objects_. Fixed NullPointerException in ObjectTree. (GP-2004, Issue #4221)
* _Debugger:Trace_. Fixed Trace API to handle NO_ADDRESS. (GP-2430)
* _Decompiler_. Fixed stack trace sporadically encountered when clicking Decompiler brace tokens. (GP-1602)
* _Decompiler_. Fixed issue with re-data-typing a variable via the Decompiler window in a big-endian binary. (GP-1673, Issue #2809, #3776)
* _Decompiler_. Refactored handling of overlays in the Decompiler to address issues causing it to lose references and enumerations. (GP-1818, Issue #2680, #3900)
* _Decompiler_. Decompiler now appends a size suffix to integer tokens when necessary. (GP-1922, Issue #3592)
* _Decompiler_. The Decompiler now prevents over-propagation of register values that could misleadingly cause global variable assignments to be reordered. (GP-1997)
* _Decompiler_. Fixed a bug in the Decompiler variable hashing system that caused Rename and Retype actions in the Decompiler window to fail. (GP-2006)
* _Decompiler_. Fixed bug causing `Bad storage node` error when using the Split Out As New Variable action on register pairs. (GP-2027, Issue #4186)
* _Decompiler_. Added key bindings to allow users to navigate to enclosing braces in the Decompiler. See the Decompiler tool options for details. (GP-2090, Issue #4264)
* _Decompiler_. Improved switch analysis, specifically for when constants are stored on the stack. (GP-2359)
* _Decompiler_. Patched comparison error that could cause the Decompiler to crash during variable merging. (GP-2466, Issue #4450)
* _Decompiler_. Fixed bug preventing the Decompiler from seeing certain pointer aliases on to the stack in segmented architectures. (GP-2515, Issue #4529)
* _Demangler_. Fixed issue where changes to the Microsoft Demangler Apply Function Calling Conventions option were not being honored. (GP-2542, Issue #4590)
* _Diff_. Corrected Program Diff to properly ignore ordering differences of non-primary labels at a given address. (GP-2558)
* _Disassembly_. Fixed issue with disassembling an instruction that contains a delay slot that is at the end of an address space. (GP-1668, Issue #3840)
* _Documentation_. Renamed ReloadSleighLangauge.java script to ReloadSleighLanguage.java. (GP-1772)
* _DWARF_. Improved naming of DWARF anonymous structures and unions to fix .conflict-matching issues. (GP-1500)
* _DWARF_. Fixed bad ordering of function parameters when importing DWARF info. (GP-1682, Issue #3874)
* _DWARF_. Fixed DWARF analyzer to support Mach-O .o binaries. (GP-2698, Issue #4659)
* _Eclipse Integration_. Fixed an issue in the GhidraDev Eclipse plugin that could cause old extensions to incorrectly remain on the Ghidra project classpath after performing a Link Ghidra operation. (GP-1733)
* _FileSystems_. Enhanced Ghidra's zip file system to fall back to Java's built-in zip file support when 7-Zip's native libraries fail to load. (GP-1697, Issue #3904)
* _FileSystems_. Fixed issue with 7-Zip native library extraction during initialization that caused core dumps in other Ghidra processes running on the same host. (GP-1770)
* _FileSystems_. Fixed issue handling zip files that contain a file with a blank name. (GP-1944, Issue #4128)
* _FileSystems_. Fixed a `hash has changed` IOException that would sometimes occur when extracting .dylib files from a dyld_shared_cache file system. (GP-1986, Issue #4208)
* _FileSystems_. By disabling free space checking, fixed problem that occurred when trying to query the available free disk space when in a Linux/Unix chroot environment. (GP-2078, Issue #4291)
* _Graphing_. Updated the Function Call Graph to only save graph view information when visible. (GP-2514, Issue #4564)
* _Graphing_. Corrected potential HTML injection vulnerability for the Graph Service vertex labeling. (GP-2716)
* _GUI_. Fixed GUI lag issues on Windows in the file chooser that occurred when resizing the dialog in a directory with a large number of files. (GP-1634)
* _GUI_. Fixed Ghidra's file chooser to allow refreshing the root locations in `My Computer`. (GP-1635)
* _GUI_. Fixed bug that triggered a tool Save Tool - Possible Conflict dialog when using multiple tools. (GP-1637)
* _GUI_. Updated the Choose Program dialog to focus the filter field by default so users can start filtering when the dialog opens. (GP-1745)
* _GUI_. Updated the field at the bottom of the tool that displays the current instruction. Now, when the cursor is on a data item, the field shows the current datatype and size instead of being blank. (GP-1803)
* _GUI_. Fixed issue where newly opened programs didn't have their datatypes tree apply any existing filter. (GP-1897)
* _GUI_. Added Ctrl-C/V/X key bindings to the Motif Look and Feel text widgets. (GP-1972)
* _GUI_. Corrected bad action description in the Log Viewer window. (GP-1975, Issue #4198)
* _GUI_. Fixed NullPointerException that occurred when making a selection in the Table Chooser Dialog. (GP-1982, Issue #4204)
* _GUI_. Fixed bug in IntegerTextField when pasting text that doesn't pass internal validation. This could result in an internal corrupted state. (GP-2000)
* _GUI_. Improved the file chooser to not hang the GUI if there are slow file system root locations (drive letters) present. (GP-2059)
* _GUI_. Updated tree and table filters to support undo/redo via Ctrl-Z and Ctrl-Y. (GP-2186)
* _GUI_. Fixed rare exception seen while closing the tool just after a long reference search. (GP-2265)
* _GUI_. Fixed an issue that prevented the One Shot analyzers from being enabled when the Listing did not have focus. (GP-2318, Issue #4589)
* _GUI_. Fixed an IndexOutOfBoundsException in the Listing when the XREF Group by Function option is toggled on and Maximum Number of XREFs to Display is set to 1. (GP-2328, Issue #4445)
* _GUI_. Fixed a NullPointerException that occurred when using the Go To dialog. (GP-2388)
* _GUI_. Corrected Function Editor's Custom Storage editor dialog issues that prevented proper editing behavior. (GP-2483, Issue #4492)
* _GUI_. Fixed a NullPointerException in the Patch action's auto-complete text field. (GP-2616, Issue #4604)
* _Headless_. Fixed analyzeHeadless.bat reporting that `Maximum setlocal recursion level reached` when a large number of command line arguments were specified. (GP-1735)
* _Headless_. Fixed wildcard `'*'` path expansion not working properly when calling headless from Linux/macOS. (GP-2209, Issue #3409, #4500)
* _Help_. Fixed issue of help window not opening when help was missing. (GP-2409)
* _Importer_. Fixed NullPointerException in GzfLoader encountered when importing a GZF embedded in a ZIP file. (GP-1667)
* _Importer_. Fixed infinite loop in import dialog that occurred when verifying filename with leading tilde (~) character. (GP-1849, Issue #4034)
* _Importer_. When importing a file, the internal program name has been changed to reflect the name of the imported file and not the user-selected file name where Ghidra stores the program in the project. Ghidra programs have two names; the internal name and the file storage name. The file storage name must be unique within a project. The internal name can be retrieved using `program.getName()` and the storage name can be retrieved using `program.getDomainFile().getName()`. (GP-1876)
* _Importer_. External library links produced by the NeLoader are now working correctly. Libraries can now be discovered when loaders specify that library filename extensions are optional. (GP-2497, Issue #2063, #2233)
* _Importer_. Case-insensitive library lookup now works for already-imported libraries. (GP-2498, Issue #906)
* _Importer_. Libraries are now properly recursively imported. (GP-2510, Issue #110)
* _Importer_. Fixed OMF comment record parsing. (GP-2528, Issue #3780, #4560)
* _Importer:ELF_. Added `-applyArmElfRelocPCBias` import option for relative relocation processing to account for differences in how tool-chains factor in the bias value. (GP-2041)
* _Importer:ELF_. Corrected processing of ELF REL type relocations for `R_ARM_JUMP24, R_ARM_CALL and R_ARM_PLT32`. (GP-2350, Issue #4455)
* _Importer:ELF_. Fixed problem reading Elf32 binaries that were missing certain sections. (GP-2577, Issue #4605)
* _Importer:ELF_. Corrected MIPS ELF `.plt.got` markup error which could prevent import. (GP-2592, Issue #4602)
* _Importer:ELF_. Corrected ELF MIPS-64 bit data relocation processing issue for `R_MIPS_REL32` and `R_MIPS_32`. (GP-2678, Issue #4633)
* _Importer:ELF_. Corrected ELF relocation table processing to handle statically linked binaries. (GP-2703)
* _Importer:ELF_. Corrected ELF Import processing of symbol table when associated string table is missing. Previously caused exception. (GP-2744, Issue #4680)
* _Importer:ELF_. Added support for ELF `DT_GNU_XHASH` symbol hash table. (GP-2749, Issue #4649)
* _Importer:PE_. Fixed several bugs in the PE menu resource parser. (GP-1806, Issue #4017, #4018, #4020, #4021)
* _Importer:PE_. Fixed incorrect PE driver COFF symbol offsets. (GP-1933, Issue #3564, #4139, #4168)
* _Importer:PE_. Changed PE loader to label values found in PE header as `PE Property[propertyname]` instead of just bare `propertyname` when inserting the information into the program info list. (GP-2343, Issue #4452)
* _Importer:PE_. Fixed an issue in the PeLoader that sometimes prevented symbols imported by ordinal from getting correctly labeled with their name. (GP-2422, Issue #4474)
* _Importer:PE_. Fixed PE Header PdbInfo structure creation to have correct PDB pathname length. (GP-2428, Issue #4501)
* _Importer:PE_. PE DebugDirectory entries with type `IMAGE_DEBUG_TYPE_EX_DLLCHARACTERISTICS` are now supported. (GP-2453, Issue #4502)
* _Importer:PE_. Removed setting of TMode in PELoader for ARM PE files. Relying on the default setting of TMode from language variant selection at time of import. (GP-2525)
* _Listing_. Fixed bug that showed incorrect references when double-clicking the XREF text in the Listing. (GP-1891)
* _Listing_. Updated the Go To dialog to respect the tool option that restricts searches to the current program. (GP-2296)
* _Multi-User_. Corrected ConcurrentModificationException condition on Ghidra Server when cleaning-up stale connection registrations. (GP-2441)
* _PDB_. Fixed PDB Universal static local variable processing. (GP-1023)
* _PDB_. Fixed calculation of number of files contributing to a module. (GP-1775)
* _PDB_. Fixed a NullPointerException that would occur when a PDB did not have DebugInfo. (GP-1827)
* _Processors_. Added support for ELF PowerPC `R_PPC_EMB_SDA21` relocation and implemented `lq` instruction pcode. (GP-713, Issue #890)
* _Processors_. Corrected issue with avr32 `abs` instruction using the floating-point `abs` pcode operator. (GP-1165)
* _Processors_. Corrected semantics for ARM `vcvt` instruction. (GP-1503, Issue #3418)
* _Processors_. Fixed TriCore `jl` instruction semantics. (GP-1638, Issue #3552)
* _Processors_. Corrected carry flag semantics for the M68000 `addx` instruction. (GP-1644, Issue #3818)
* _Processors_. Reduced complexity of several PA-RISC floating-point instructions. (GP-1656)
* _Processors_. Corrected semantics for x86 `FST` instruction. (GP-1694, Issue #3894, #3895)
* _Processors_. Corrected missing register definition in V850 processor. (GP-1701, Issue #3865)
* _Processors_. Corrected register operand list for ARM `vsub` instruction. (GP-1712, Issue #3943, #3944)
* _Processors_. Added undocumented x86 `ffreep` instruction. (GP-1722, Issue #3883)
* _Processors_. Corrected ARM Neon `vraddhn` disassembly. (GP-1736, Issue #3978)
* _Processors_. Simplified the TriCore `st.t` instruction semantics. (GP-1746, Issue #2326)
* _Processors_. Fixed minor issue with TriCore sleigh file missing closing `endif` statement. (GP-1762, Issue #4029)
* _Processors_. Corrected semantics of ARM `bfi` instruction. (GP-1763, Issue #4011)
* _Processors_. Fixed some bugs involving JVM switch instructions and JVM switch analysis. (GP-1774, Issue #3980, #3981)
* _Processors_. Included VPFv4 instructions in the ARM language. (GP-1817, Issue #2498, #3222)
* _Processors_. Fixed punctuation consistency issue for ARM instructions with register lists. (GP-1837)
* _Processors_. Fixed disassembly of M68000 `fmod` caused by manual typo. (GP-1946, Issue #4131)
* _Processors_. Implemented previously unimplemented M68000 `pack` and `unpk` instructions. (GP-2014, Issue #4223)
* _Processors_. Fixed an issue with the RISC-V pattern constraints filename. (GP-2046, Issue #4002, #4003)
* _Processors_. Fixed incrementing of the stack pointer in 6502 `PLP` instruction. (GP-2092, Issue #4249)
* _Processors_. Fixed Coldfire `tpf` instruction to not consume trailing bytes, which may be valid instructions. (GP-2104)
* _Processors_. Fixed the TI MSP430 `RPT` instruction to use correct operand types. (GP-2112)
* _Processors_. Fixed RISCV 64-bit long datatype size and alignment. (GP-2161, Issue #2590)
* _Processors_. Fixed register zero reads in microMIPS and MIPS16. (GP-2162)
* _Processors_. Fixed x86 SLEIGH issues that caused disassembly errors in various instructions. (GP-2196, Issue #4344)
* _Processors_. Corrected semantics for SuperH `trapa` instruction to properly dereference the vector address. (GP-2344, Issue #4396, #4477)
* _Processors_. Renamed avr8 `W` register to `R25R24`. (GP-2499, Issue #4516)
* _Processors_. Corrected issue with ARM `ldrht`, `ldrsbt`, `ldrsht`, and `strht` not disassembling. (GP-2536, Issue #4582)
* _Processors_. Corrected port addresses in ATmega256 for `MAFCR0` and `MAFPA2L`. (GP-2538, Issue #4592)
* _Processors_. Corrected error in 6809 extended-address bit pattern. (GP-2562, Issue #4600)
* _Processors_. Corrected missing S bit in ARM thumb `BIC` instruction. (GP-2696)
* _Processors_. Added missing parentheses in 6502 indirect `JMP` instruction. (GP-2701, Issue #783)
* _Processors_. Corrected several instances of ARM instruction parse conflicts. (GP-2718)
* _References_. References in Byte-Mapped memory blocks will now be created correctly. (GP-2420)
* _Scripting_. Added the script `setReusePreviousChoices(boolean)` method to allow script writers to not reuse the last-entered values in the various `ask` dialogs. (GP-1743, Issue #3937)
* _Scripting_. Improved script error handling during load and initialization. (GP-2618)
* _Sleigh_. Fixed a bug causing incorrect p-code to be generated when implementing the behavior of a SLEIGH `bitrange` operator applied to a dynamic symbol. (GP-1583, Issue #3716)
* _Testing_. Fixed issue with pcodetest generation when test directory does not exist. (GP-2091, Issue #4239)
* _Version Tracking_. Fixed a bug in Version Tracking where calling conventions were no longer being applied when applying function signature markup from the source to the destination program. (GP-1045)

# Ghidra 10.1.5 Change History (July 2022)

### Improvements
* _Analysis_. Changed disassembly of interrupt vectors with pointers to be consistent with interrupt vectors with code, specifically for ARM-cortex-embedded binary disassembly. (GP-2080, Issue #4263)
* _Processors_. Added HC-12 processor support with a Flat 16-bit memory model by splitting HCS12X into HC-12, HCS-12, and HCS-12X processors. (GP-1716, Issue #1570, #4016)
* _Processors_. Added ability to specify byte-mapped and overlay memory blocks from processor specification (*.pspec). (GP-2133, Issue #2703)
* _Processors_. Added PowerPC e500 processor variant. (GP-2272)
* _Processors_. Added support for AARCH64 ilp32 variant. (GP-2355)

### Bugs
* _Analysis_. Fixed function purge setting for x86 16-bit functions using `RETF` to return. (GP-2103, Issue #4293)
* _Analysis_. Protected use of tmodeReg value in ArmAggressiveInstructionFinderAnalyzer when processor does not have a TMode register. (GP-2122)
* _Analysis_. Fixed constant reference analysis bug introduced from refactoring that would not use the Speculative reference min analyzer setting. (GP-2365, Issue #4257)
* _CParser_. Added support for the C11 `_Noreturn` keyword. (GP-2275, Issue #4273)
* _Debugger:Trace_. Fixed event type numbering issue in Traces, which was causing enormous resource waste. (GP-2153)
* _Decompiler_. Fixed bug that could cause the Decompiler to mislabel a switch case as `default`. (GP-2082, Issue #4268)
* _Decompiler_. Fixed exception in Decompiler when making a selection on a wrapped line. (GP-2097, Issue #4309)
* _Decompiler_. Fixed a memory error in the decompiler associated with data-types defined as a typedef of a structure. (GP-2178, Issue #4328)
* _Decompiler_. The Decompiler now further simplifies expressions involving return values, parameters, or other variables that are explicitly marked as boolean. (GP-2212, Issue #4338)
* _Decompiler_. Fixed a bug that could cause the Decompiler to crash in the hash method used to map Equate information and other dynamic annotations onto variables. (GP-2288, Issue #4410)
* _GUI_. Fixed GTree rendering bug exhibited on some Linux platforms. (GP-2047, Issue #4260)
* _GUI_. Fixed incorrect error message when pasting bytes. (GP-2164)
* _GUI_. Fixed exception in table column filters. (GP-2317)
* _Importer:ELF_. Corrected ELF import issue which could fail to create an uninitialized block for a `SHT_NOBITS` section with invalid file offsets. (GP-2098, Issue #4095)
* _Importer:ELF_. Corrected ELF issues related to treatment of absolute symbols (`SHN_ABS`). (GP-2330)
* _Importer:PE_. Fixed an issue with PE symbol table offset validation that prevented some binaries from being recognized as PE files. (GP-2322)
* _Multi-User:Merge_. Corrected long-standing regression bug affecting datatype merge, which was introduced in Ghidra 9.2. This severe error could surface during a datatype conflict merge with a shared project and could prevent a check-in to a Ghidra Server repository. (GP-2066)
* _Processors_. Refactored AVR8 to handle 24-bit memory and to correctly index the code address space as a byte or word. (GP-2213, Issue #4333)
* _Processors_. ELF PLT import processing changed to avoid static disassembly for ARM/MIPS due to possibility of alternative instruction set. Now relies on disassembly during analysis for such cases. (GP-2256)
* _Scripting_. Creating a new script via the Script Manager now properly handles the situation where the $HOME/ghidra_scripts directory does not exist. (GP-2282)
* _Sleigh_. Fixed a Sleigh Parser threading issue that could cause incorrect p-code generation for languages that use delay slots. (GP-2235, Issue #4332)

# Ghidra 10.1.4 Change History (May 2022)

### Improvements
* _Debugger:Listing_. Refresh button in Debugger's Dynamic Listing and Memory Bytes views now operates without a selection and is more thorough with respect to cache invalidation. (GP-1930)

### Bugs
* _Analysis_. Fixed an exception that occurred when loading programs created in previous versions where the analysis option's type had changed (String to Long). (GP-1738)
* _Analysis_. Constant reference propagation now uses pcode injection for segment and all userops. This affects 16-bit code and the HCS12 processor. (GP-1987, Issue #4252)
* _C Parsing_. Added C-Parser support for `static_assert and _Static_assert` keywords. (GP-1958, Issue #4038)
* _C Parsing_. Corrected C-Parser to parse `sizeof` structure members, both `sizeof(ptr->member)` and `sizeof(struct.member)`. (GP-1964, Issue #4173)
* _Decompiler_. Fixed bug causing the Decompiler to not label pointer references to the first parameter on the stack. (GP-2018)
* _GUI_. Fixed bug that caused some edited functions to appear twice in the Functions window. (GP-2025)
* _GUI_. Fixed potentially slow computer name lookup in the Error Dialog. (GP-2034)
* _Importer:COFF_. Fixed importing of non-Microsoft COFF files when any section crosses address 0x80. COFF sections marked as data that won't fit into the default data address space will be loaded in the code address space. (GP-2045)

# Ghidra 10.1.3 Change History (April 2022)

### Improvements
* _API_. Added the `getActiveGraphDisplay()` API method to GraphDisplayProvider to get the active graph. (GP-1804, Issue #4060)
* _Debugger_. Created better comment in Dynamic Listing Go To dialog so users don't default to `*:4 EAX` syntax. (GP-1820)
* _Debugger_. Created new navigation methods for Objects representing addresses. (GP-1822)
* _Debugger_. Switched to DomainFile name in Debugger dialogs to avoid confusion. (GP-1872)
* _Debugger:Trace_. Improved performance of trace database. (GP-1727)
* _FID_. Updated stale signatures in the FID database files. (GP-1853, Issue #2877)
* _Importer:ELF_. Added support for additional ELF ARM-32 relocations not previously handled (`R_ARM_THM_JUMP8`, `R_ARM_THM_JUMP11`, `R_ARM_THM_MOVW_ABS_NC`, `R_ARM_THM_MOVT_ABS`, `R_ARM_THM_MOVW_PREL_NC`, `R_ARM_THM_MOVT_PREL`, `R_ARM_THM_MOVW_BREL_NC`, `R_ARM_THM_MOVW_BREL`, `R_ARM_THM_MOVT_BREL`). (GP-1742, Issue #2794)
* _Processors_. Refactored the 6805/6809 processor to better allow variants of MC6800 processor line. (GP-1695, Issue #3673)
* _Processors_. Added 16-byte return values for AARCH64 in `X0`, `X1`. (GP-1739)
* _Scripting_. Improved RecoverClassesFromRTTIScript's method to validate GCC programs. (GP-1832)

### Bugs
* _Analysis_. Fixed FID Analyzer to run only once on programs with call-fixups or identified non-returning flow. (GP-1502)
* _Analysis_. Corrected the creation of Objective-C structures when structures collided with existing generic pointers laid down by chained-pointer processing during import. (GP-1841)
* _Analysis_. Corrected stack reference creation and the display of current instruction stack depth in the stack-depth browser field for MIPS 64-bit language processor with 32-bit addressing. (GP-1862)
* _Analysis_. Fixed placement of constant references when a parent register's value is built up using the smaller sub-registers (hi/low). This is common on MIPS and other 8-bit processors such as AVR8. This would occasionally cause a reference to be placed incorrectly on a previous function call. (GP-1942)
* _Basic Infrastructure_. Fixed a NoClassDefFoundError that occurred when launching Ghidra in single-jar mode. (GP-1741, Issue #3961)
* _C Parsing_. CParser fixes for `pragma(push)`, re-included header files, `#if/defined()` tests on define values, unicode BOM files, and full evaluation of macro expansion. Added more information to the CParserPlugin.out file prefixed with `///` comments which should enable easier diagnosis of parsing issues. Reparsed current standard data archives with correct 64/32 data organizations. Fixed issue where many data types had incorrect `pack()` values in Windows archives, such as `WNDCLASSEXW`. To make use of the corrected data types, programs data types will need to be re-synchronized if they depend on the included Windows or clib data type archives. Windows VS2022 and Windows 11 SDK header files can now parse and will be included in the next feature release. (GP-1744, Issue #3756)
* _Data Types_. Corrected UnsupportedOperationException error which could occur when dragging a datatype from one archive to another. (GP-1758)
* _Data Types_. Fixed Data Types filter not being applied when using the various Find actions. (GP-1799)
* _Debugger_. Fixed the defaults for log4j file locations; template patterns for empty values were crashing the process on Windows. (GP-1731, Issue #3965)
* _Debugger_. Fixed NullPointerException caused by Debugger Console's preferred height. (GP-1766)
* _Debugger_. Fixed race condition on right-click of non-selected tree node. (GP-1845, Issue #4093)
* _Debugger_. Fixed missing eflags in Register View for dbgeng. (GP-1873)
* _Debugger_. Fixed IllegalArgumentException in TraceObjectManager. (GP-1874)
* _Debugger:Breakpoints_. Fixed issue with toggling breakpoints from within the Dynamic Listing. (GP-1706)
* _Debugger:Memory_. Fixed timing issue where Debugger Memory view may have incorrect location label. (GP-1882)
* _Debugger:Trace_. Fixed issue with StringDataType null terminators in stale trace ranges. (GP-1737)
* _Decompiler_. Updated the Decompiler Find dialog's default text when showing the dialog with comment text selected. (GP-1721, Issue #3946)
* _Decompiler_. Fixed the Decompiler Find dialog's sometimes incorrect result highlighting. (GP-1765, Issue #3928)
* _Decompiler_. Fixed a bug in the Decompiler preventing prototype overrides from being applied to calls produced by Call-Fixup injection. (GP-1792, Issue #3319)
* _Decompiler_. Updated the Decompiler hover for structure fields to show the parent name and the offset in the parent. (GP-1793, Issue #3920)
* _Decompiler_. Eliminated infinite loop in the Decompiler encountered when applying convert/equate. (GP-1924, Issue #4121)
* _FID_. Fixed bug causing `Program ... has different compiler spec...` exception when populating FID signatures. (GP-1839, Issue #4042)
* _FileSystems_. Fixed problem opening files in paths that start with a UNC location (`\\location\path`). (GP-1696, Issue #3912)
* _Framework_. Fixed bug that could cause a NullPointerException when removing custom Compiler Specification extensions from a Program. (GP-1715, Issue #3906)
* _GUI_. Fixed default function Plate Comment formatting. (GP-1717)
* _GUI_. Fixed the Search Memory Dialog buttons to re-enable after closing a long-running search results table. (GP-1753, Issue #4014)
* _GUI_. Updated Symbol Edit dialog to not allow namespaces editing with a blank name. (GP-1754, Issue #4015)
* _GUI_. Fixed table CSV export of boolean values. (GP-1764, Issue #3947, #4026)
* _Headless_. Corrected potential NullPointerException for Headless Analyzer when a specified filename to process does not exist in a searched project folder. (GP-1916)
* _Help_. Fixed Help Viewer Find feature, clearing search result highlights when the search dialog is closed. (GP-1718)
* _Importer:ELF_. Corrected MIPS type 5/6 relocation calculation. Previously, the `LO16` value, extracted as an addend from the instruction, was not sign-extended. (GP-1834)
* _Importer:PE_. Fixed a bug that prevented certain types of PE files from being recognized by the PeLoader. (GP-1713, Issue #3830, #3902)
* _Importer:PE_. Detect .NET managed code in mixed Native/MangedCode binaries and only disassemble the correct x86 or CLR routines based on the current processor. (GP-1938, Issue #4159)
* _Processors_. ARM `BL` conditional call instruction, which calls to the next instruction, has been changed to a branch instead of a call. Calling the next instruction on ARM is generally only to get the `LR` register loaded for PIC code. (GP-1752)
* _Processors_. Fix bug in MIPS `rdhwr` instruction to use correct hardware registers. (GP-1879)
* _Scripting_. Fixed the Bytes table column rendering in the scripting TableChooserDialog. (GP-1714)
* _Scripting_. Fixed two bugs in RecoverClassesFromRTTIScript.java encountered when creating class structures. (GP-1781)
* _Scripting_. OSGI jar bundles now correctly load on Windows. (GP-1846, Issue #3995)
* _Sleigh_. Fixed bug preventing prototype model extensions with p-code from being imported. (GP-1915)

# Ghidra 10.1.2 Change History (January 2022)

### Improvements
* _Basic Infrastructure_. Upgraded Gson to 2.8.9. (GP-1632, Issue #3802)
* _Basic Infrastructure_. Upgraded log4j to 2.17.1. (GP-1641)
* _Build_. Increased minimum supported Gradle version from 6.4 to 6.8. (GP-1680)
* _Debugger:Emulator_. Emulator's PcodeStepper now displays the decoded instruction. (GP-1474)
* _Debugger:Watches_. Double-clicking a pointer value in the Watches window navigates to the pointer rather than its address. (GP-1469)
* _Listing_. Updated the Listing Operands field to support word-wrapping for enum data types. (GP-1665, Issue #3812)
* _Scripting_. Improved the RecoverClassesFromRTTIScript to create function definitions for multi-inheritance and single virtual inheritance classes in the correct ancestor class data type folders. (GP-1663)
* _Scripting_. Updated RecoverClassesFromRTTI script for GCC programs to only create `typeinfo` structures in non-executable memory. (GP-1686)

### Bugs
* _Analysis_. Fixed another bug with recovering Objective-C method names. (GP-1642, Issue #3817)
* _Analysis_. Certain switch cases using the AARCH64 CSEL instruction will now recover correctly. Previously internal CBRANCH instructions could cause switch flow recovery failure in the decompiler switch analyzer. (GP-1687)
* _Analysis_. Fixed unused Microsoft Demangler options. (GP-1688, Issue #3892)
* _Analysis_. Reverted change (GP-1575) introduced with Ghidra 10.1 which improperly factored image-base into analysis of ELF LSDA GCC exception records. (GP-1702)
* _Build_. Fixed `gradle buildGhidra` issue where a second build doesn't include all the files. This issue appears to be a bug introduced in Gradle 7. (GP-1648, Issue #3827)
* _Data Types_. Fixed display of multiple Enum values. (GP-1657, Issue #3810)
* _Debugger_. Now invalidating caches for dbgeng/dbgmodel in the GADP variants so the memory is not left stale. (GP-846)
* _Debugger_. Fixed exception when cancelling password entry for GDBOverSSH. (GP-1655, Issue #3578)
* _Debugger:Memory_. Fixed Debugger Memory background colors during emulation. (GP-1590)
* _Debugger:Trace_. Fixed issue where emulated state leaked into recorded state. (GP-1620)
* _Debugger:Trace_. Fixed NullPointerException when disassembling stale memory. (GP-1646)
* _Decompiler_. Fixed the Decompiler Retype Field action to not rename the field. (GP-1654, Issue #3783)
* _Decompiler_. Decompiler now recovers jump tables that use PIC mechanisms or other forms relying on injected p-code. (GP-1659)
* _Demangler_. Fixed demangling bug that produced incorrect types such as `unsigned_short`. (GP-1662)
* _GUI_. Fixed incorrect tool option reference in the Create Table From Selection action. (GP-1676, Issue #3858)
* _GUI_. Fixed the Decompiler Find Text dialog's auto-complete feature to not change the default text entry added to the dialog. (GP-1685, Issue #3890)
* _Importer:Mach-O_. Fixed an IllegalArgumentException that occurred when loading some kernelcache images. (GP-1675, Issue #2487)
* _Importer:PE_. Fixed an exception that occurred when re-parsing PE programs with a `.pdata` section from memory. (GP-1636, Issue #3347, #3800, #3805)
* _PDB_. Fixed incorrect bounds on item type iteration; one effect of the fix is that the user might notice more `unsupported PDB data type` messages in the log. (GP-1677)
* _Processors_. Fixed issue with Motorola 6809 immediate operands being set to zero. (GP-1611, Issue #2116, #3755)
* _Processors_. Corrected PowerPC `efscmp*` and `efstst*` instructions condition register usage. (GP-1639, Issue #2528)
* _Processors_. Fixed the target of `JUMP` and `JSR` for the 6809 to use [target] instead of jumping directly to target which incorrectly jumped to the address of the unique variable. Also fixed a compile issue in the half-finished 6309 `EXG` and `TFR` instructions. (GP-1690, Issue #3825)
* _Scripting_. Fixed the ApplyClassFunctionDefinitionUpdatesScript and the ApplyClassFunctionSignatureUpdatesScript to work correctly with the recent RecoverClassesForRTTI changes to function definitions. (GP-1601)
* _Scripting_. Fixed bug in a class recovery helper class that was causing an exception in some cases when trying to replace a component in a structure. (GP-1670)
* _Scripting_. Removed a misplaced space character in the name passed to setLabel in RecoverClassesForRTTIScript. (GP-1671)
* _Sleigh_. Fixed bug that could cause erroneous decompilation of functions in overlays. (GP-1661, Issue #3828)

# Ghidra 10.1.1 Change History (December 2021)

### Improvements
* _Analysis_. Fixed headless analysis exception related to running UI code from the GNU Demangler analyzer. (GP-1613, Issue #3765)
* _Basic Infrastructure_. Upgrade logging dependency to use _log4j_ 2.17.0 (GP-1621)
* _Debugger:Memory_. Added New Memory Bytes View to Window->Debugger menu. (GP-1465)
* _Debugger:Memory_. Fixed issue with Debugger Memory view scrolling. (GP-1591)
* _GUI_. Removed restriction that prevented renaming tree nodes while the tree is filtered. (GP-1507)
* _GUI_. Fixed issue where renaming a symbol in the symbol tree could result in the symbol appearing more than once (under different organizational nodes) (GP-1587)
* _Help_. Fixed NullPointerException when using the help system with animation disasbled. (GP-1612, Issue #3767)

### Bugs
* _Basic Infrastructure_. Fixed the _"ERROR StatusLogger Reconfiguration failed"_ message that appeared in the log when Ghidra was launched with _support/ghidraDebug_ script. (GP-1607)
* _Debugger_. Fixed null pointer exception in Debugger when opening a program from a shared project. (GP-1490)
* _Debugger_. Fixed issue with context menus on the trace selector tabs in Debugger Threads window. (GP-1494)
* _Debugger_. Fix for font resizing (GP-1597, Issue #3752)
* _Debugger_. Fixes null-pointer exceptions in lldb (GP-1600, Issue #3645)
* _Debugger:Listing_. Fixed default configuration problem when cloning the Debugger Listing window. (GP-1479)
* _Importer_. Fix issue importing NE binaries that have a segment number greater than 127. (GP-1576, Issue #3715)

# Ghidra 10.1 Change History (December 2021)

### New Features
* _Build_. Ghidra now builds on 64-bit Linux ARM and macOS M1 platforms. (GP-1106, Issue #3197)
* _Build_. Native binaries for the current platform can now be built/rebuilt from within a release using the support/buildNatives(.bat) script. Please see the "Building Ghidra Native Components" section of the Installation Guide for additional information. (GP-1209, Issue #3387)
* _Data Types_. DataType API: Added `encodeValue` and `encodeRepresentation` methods which facilitate patching. (GP-1265)
* _Debugger_. Added Memory view (raw bytes) to the Debugger. (GP-80)
* _Debugger_. Added new agent for LLDB on macOS and Linux. (GP-1005, Issue #2591, #2967)
* _Debugger_. Added Copy Into Current Program and Copy Into New Program actions to Debugger. (GP-1214)
* _Debugger_. Added Compare action to Dynamic Listing to compare points in time. (GP-1222)
* _Debugger_. Added Events/Exceptions to Objects View. (GP-1288, Issue #3049)
* _Debugger:Emulator_. Added Emulate Program and Add Emulated Thread actions for loading a program into a purely emulated trace. (GP-660)
* _Decompiler_. Added support for `else if` syntax in Decompiler output. (GP-1172, Issue #1609)
* _Importer_. Added support for Android formats (ART, OAT, ODEX, DEX, CDEX, VDEX) and Dalvik VM Sleigh modules for each major Android release up to version 12.x (S). (GP-1247)
* _Scripting_. Created RunYARAFromGhidra.py to map YARA rules to Ghidra comments. (GP-1199)

### Improvements
* _Analysis_. The called `___chkstk_ms()` function is now properly recognized and handled with a call fixup for windows x86-64. (GP-1347, Issue #1888, #1889)
* _Analysis_. Added support for Objective-C small methods. (GP-1397, Issue #2719, #2732)
* _Analysis_. Fixed several memory usage issues with constant propagation for very large functions, resulting in an average 10-20 percent time savings for constant propagation and stack analysis. (GP-1418, Issue #3508)
* _API_. Updated API methods of the DataTypeChooserDialog. (GP-1349, Issue #3140)
* _Basic Infrastructure_. Symbol performance in Ghidra was significantly improved. Specifically, new database indexes were created to improve finding primary symbols as well as improving lookups by combinations of name, namespace, and address. (GP-1082)
* _Basic Infrastructure_. Added optional columns in the Functions table for several boolean-valued function attributes. (GP-1393)
* _Basic Infrastructure_. Upgraded log4j dependency from 2.12.1 to 2.15.0 to resolve a security vulnerability. (GP-1588)
* _Build_. Extension builds can now declare jar dependencies from standard Gradle repositories such as Maven Central. (GP-1144, Issue #2219, #2226)
* _Build_. Increased minimum supported Gradle version from 6.0 to 6.4. (GP-1521, Issue #3650)
* _Data Types_. Added support for zero-element arrays and zero-length components within structures and unions. Eliminated flex-array API methods and added/improved other Structure methods to handle multiple components which share the same offset. (GP-943)
* _Data Types_. Added the ability to set comments on enum values. (GP-1316, Issue #1680, #2421)
* _Data Types_. Updated Windows and generic clib data type archives to take advantage of improved CParser including changes to handle sizeof() correctly. (GP-1551, Issue #615)
* _Debugger_. Respond to CLI-driven memory changes in dbgeng. (GP-853)
* _Debugger_. User can now override the Debugger's processor selection when manually activating the Record (R) action. (GP-1233)
* _Debugger_. User can now double-click in Listing margin to toggle breakpoints. (GP-1395)
* _Debugger_. Adjusted alignment of Description tag in Debugger's Connect dialog. (GP-1416)
* _Debugger:Emulator_. Added more accessor methods to PcodeThread, Machine, Executor, and similar classes. (GP-1223)
* _Debugger:Emulator_. Added more accessor methods to PairedCodeArithmetic, ExecutorState, ExecutorStatePiece, and similar classes. (GP-1224)
* _Debugger:Emulator_. Emulator now responds better to memory and register edits. (GP-1486)
* _Debugger:Emulator_. Registers window can now modify emulated register values. (GP-1530)
* _Debugger:GDB_. GDB manager handles `=cmd-param-changed` events. (GP-1330)
* _Debugger:GDB_. Ported GDB's SSH connector to JSch. (GP-1387)
* _Debugger:LLDB_. Improved build scripts for LLDB Java language bindings. (GP-1477)
* _Debugger:Memory_. Added Force Full View override toggle to Debugger's Regions window. (GP-1447)
* _Debugger:Stack_. Fixed various `NullPointerExceptions` among the Debugger Stack and Threads windows. (GP-1475)
* _Debugger:Trace_. Trace API now supports Overlay spaces. (GP-484)
* _Decompiler_. Added the Rename Label Decompiler action to allow label name editing. (GP-1195, Issue #1751)
* _Decompiler_. The Decompiler now recognizes typedef relationships between data-types when determining if casts are necessary. (GP-1297, Issue #2393, #3249)
* _Decompiler_. Improved the Decompiler's analysis of pointer calculations affected by common subexpression elimination. (GP-1312)
* _Decompiler_. Added methods to ClangTokenGroup to facilitate iteration and filtering over the Decompiler's output tokens. (GP-1317, Issue #2040)
* _DWARF_. Relaxed DWARF symbol name mangling to allow colons and forward slashes; changed space mangling to use underscores. (GP-1122, Issue #2014, #2043)
* _DWARF_. Improved DWARF analyzer to handle MIPSPro 64-bit file format oddity. (GP-1171, Issue #3223)
* _DWARF_. Improved DWARF analyzer to import DWARF data from PE binaries. (GP-1192, Issue #1267)
* _DWARF_. Add support for DWARF external debug files. (GP-1286, Issue #3513)
* _DWARF_. Added support for DWARF noreturn function attribute. (GP-1390)
* _Eclipse Integration_. Eclipse Python breakpoints now work when Eclipse installs PyDev in .p2 bundle pool directory. (GP-1338, Issue #3453, #3454)
* _Exporter_. Updated the DataTypeWriter to emit enum comments. Furthermore, the enum data type has been updated to return names sorted by enum value, which is now the order in which enum values will be emitted by the DataTypeWriter. (GP-1374, Issue #1664)
* _Exporter_. The PE Exporter no longer forces files to be saved with a .exe extension. (GP-1385, Issue #3391)
* _Extensions_. Building extensions now fails gracefully if an unsupported Gradle version is used. (GP-1189, Issue #3313)
* _FileSystems_. Temporary files created by GFilesystem implementations are now obfuscated when written to disk. (GP-253)
* _FileSystems_. Added support for opening password-protected zip files. (GP-725, Issue #377)
* _FileSystems_. Add support for opening HFS+ volume images. Improved support for ISO9660 images by using 7-Zip library. (GP-807)
* _Graphing_. Created concept of graph types that define specific vertex and edge types so that color and shape attributes can be assigned indirectly to vertices and edges. Created tool options for setting/changing the display attributes for these types. (GP-773)
* _GUI_. Added new layouts to the Function Graph. Each new layout is using one of the Jungrapht layouts. (GP-926)
* _GUI_. Added option to change the background color of the Function Call Graph. (GP-1014)
* _GUI_. Added menu support for the following navigation keys: Page Up, Page Down, Home, End, and number keys 1-9. (GP-1081, Issue #2811)
* _GUI_. Added an option to group the XRef field in the Listing by function. (GP-1093, Issue #1305)
* _GUI_. Symbol tree has been changed to improve its behavior in the presence of large scale changes such as analysis, loading PDB, etc. It now will auto-close the label or function category if the internal organization becomes too much out of balance. This will also improve the analysis performance when the root category nodes are closed. (GP-1198)
* _GUI_. Improved composite interior selection of components with shared offset such as bit-fields. Previous behavior was forcing selection of multiple components. (GP-1261)
* _GUI_. Fixed ClassCastException due to the Patch action incorrectly being added to the Function Graph context menu. (GP-1334, Issue #3288)
* _GUI_. Updated the Search Memory dialog to allow the user to enter a single wildcard character to search for any byte value. Previously, two consecutive wildcard characters were required. (GP-1358, Issue #3351)
* _GUI_. Updated auto-comments to show user-defined repeatable comments from the reference destination. (GP-1361, Issue #2475)
* _GUI_. Changed the Context column to allow for filtering of special characters in the results table of the Find Uses of action. (GP-1370, Issue #3473)
* _GUI_. Updated the CodeBlockIterator interface to extend Iterable. This allows the iterator to be used in Java's foreach loops. (GP-1381, Issue #3478)
* _GUI_. Added Find Structures by Offset... and Find Structures by Size... actions to the Data Type Manager window. (GP-1382, Issue #759)
* _GUI_. Added the ability to remove a non-default symbol by setting the Edit Label dialog text to the empty string; added an action to the Decompiler to remove non-default labels. (GP-1383, Issue #3285)
* _GUI_. Fixed the Function Editor's Storage Address Editor dialog to ensure that the Cancel button will not allow data type changes to be passed through to the primary editor. (GP-1398, Issue #3490)
* _GUI_. Updated the Comments Dialog to allow the Shift-Enter keystroke to insert a newline at the cursor position. (GP-1428, Issue #3548)
* _GUI_. Updated the Symbol Table to allow users to enter optional namespaces when editing a symbol name. (GP-1430)
* _GUI_. Fixed issue with shared actions across windows sometimes getting the wrong (non-focused) context. This was mostly related to windows with snapshot components. (GP-1440)
* _GUI_. Updated the Data Types context menu to include all actions when showing the menu from the keyboard via Shift-F10. (GP-1566, Issue #3678)
* _Importer_. Added support for new Mach-O load commands and file types. (GP-398, Issue #2487, #3572)
* _Importer_. Added method to Memory to find addresses where a specific byte from a loaded FileBytes object is used in memory. (GP-1166)
* _Importer:Mach-O_. The Mach-O loader now outputs a warning when it encounters encrypted sections. (GP-1406, Issue #1935)
* _Importer:Mach-O_. Added support for the new iOS 15 and macOS Monterey dyld_shared_cache format. (GP-1524, Issue #3345, #3666)
* _Importer:PE_. Added support for long section names (e.g., "/1234" indicates offset into string table where actual section name is found) in PE binaries. (GP-1177, Issue #1267)
* _Multi-User_. Upgraded YAJSW to 13.01-beta. Ghidra Server can now run with JDK 17. (GP-1266, Issue #3406)
* _PDB_. Improved processing time on huge PDBs, especially when many labels are seen at the same address, such as with Identical COMDAT Folding. This change also allows some additional valid labels to be applied at these addresses. (GP-1298)
* _Processors_. Added pcodetests for ARM version 5, which does not support thumb mode. (GP-1078)
* _Processors_. Added 65C02 opcodes to the 6502 processor. (GP-1112, Issue #1261, #3170)
* _Processors_. Made numerous improvements to the SPARC language module. (GP-1135)
* _Processors_. Improved and fixed several issues involving the SuperH4 language module. (GP-1212)
* _Processors_. Updated manual index page numbers for AMD VMX instructions. (GP-1219, Issue #2923)
* _Processors_. Updated x86 and AARCH64 processor manual index files. (GP-1234)
* _Processors_. Added `longMode` bit to x64 language spec for mixed 32-/64-bit use cases; e.g., WoW64. (GP-1255)
* _Processors_. Made minor improvements to the RISC-V language module. (GP-1409)
* _Processors_. Corrected `swap` instruction semantics for PIC-24,30,33 processors. (GP-1565, Issue #3670)
* _Scripting_. Improved RecoverClassesFromRTTIScript to better define virtual function data definitions to be more generically used by all related class structures. (GP-1311, Issue #3417)
* _Scripting_. Added options to allow removal of replaced class structure data types when replaced with ones created by RecoverClassesFromRTTIScript. (GP-1315, Issue #3443)
* _Scripting_. Changed class structures created by RecoverClassesfromRTTI so that the vftable pointers are separated from the class data structures inside a derived class. This allows the derived class vftables structures to be accessed correctly by the Decompiler. (GP-1408)
* _Sleigh_. Modeled undocumented encoding of `REP` prefix for x86 instructions. (GP-1294, Issue #731)
* _Version Tracking_. Updated Version Tracking to address multiple performance issues. (GP-1421, Issue #3221)
* _Version Tracking_. Slightly relaxed score thresholds for the reference correlator portions of auto version tracking to enable discovery of more high scoring matches. (GP-1448)

### Bugs
* _Analysis_. Fixed a bug that would result in the COFF Header Annotation analyzer running on PIC binaries when it was not intended to. (GP-1366, Issue #3386)
* _Analysis_. The Objective-C analyzer no longer crashes when encountering categories with an implementation in an external binary. (GP-1413, Issue #3510)
* _Analysis_. Fixed a stack overflow in the Objective-C 2 Class analyzer. (GP-1420, Issue #2378)
* _Analysis_. Fixed a bug with recovering Objective-C method names. (GP-1548, Issue #3611)
* _Analysis_. Corrected a potential infinite loop in stack analysis and constant propagation due to recurring call-fixup injection to the same location. (GP-1554, Issue #3683)
* _Analysis_. Fixed certain ELF exception records in ELF binaries marked as `DW_EH_PE_absptr` that are not relocated correctly when the binary is loaded in an alternate image base. (GP-1575)
* _API_. Fixed issues related to moving memory blocks where the source and/or destination have pinned symbols. This could have resulted in addresses with symbols where no symbol is primary or having multiple symbols at an address that are primary. It could also have resulted in pinned symbols being moved from the destination to the source address range. (GP-1103)
* _API_. Fixed an issue with the SymbolManager method getClassNamespaces() where it was only returning class namespaces in the global namespace. (GP-1346)
* _API_. Critical Ghidra 10.1-BETA Issue: Corrected external function bug introduced in Ghidra 10.1-BETA which caused new functions to not be marked as primary. This is a critical bug which could impact most programs imported with 10.1-BETA. Such imports should be re-imported with this fix in place. (GP-1525)
* _C Parsing_. Several issues parsing C header files have been fixed including ternary macro expression evaluation, #line preprocessor markup within functions and structures, far/near recognized as a keyword, and handling of __asm syntax. (GP-1335, Issue #1069, #1082, #2667, #464, #929)
* _Debugger_. Fixed program actions (Save, Close, Undo, etc.) to work properly in the Debugger. (GP-508)
* _Debugger_. Fixed issue getting registers on ARM targets with GDB where command exceeded 4096 characters. (GP-1356, Issue #3297, #3509)
* _Debugger_. Fixed several issues with the GDB connector's use existing session option. (GP-1365)
* _Debugger_. Fixed a NullPointerException from canceling a debug launch. (GP-1442)
* _Debugger_. Fixed Select Addresses button for Debugger Modules pane. (GP-1450)
* _Debugger_. Fixed issue with duplicate selection actions in the Debugger tool. (GP-1452)
* _Debugger_. Fixed a bug in emulation where read/write ranges include the max address. (GP-1493)
* _Debugger_. Fixed exception behavior for toggled Continue/Handled options. (GP-1558, Issue #3049)
* _Debugger:Emulator_. Fixed Debugger integration and trace emulation for WoW64. (GP-1245)
* _Debugger:Emulator_. Relaxed and corrected some logging of UNKNOWN/uninitialized values during emulation. (GP-1488)
* _Debugger:Emulator_. Fixed several issues in Emulator with respect to Harvard architectures, memory-mapped registers, and word-addressable systems. (GP-1540)
* _Debugger:GDB_. Fixed issue with GDB/GADP hang in development mode. (GP-1360)
* _Debugger:GDB_. Fixed issue interrupting GDB targets launched without temporary breakpoint on main. (GP-1362)
* _Debugger:GDB_. Fixed issues parsing and displaying various types of GDB breakpoints. (GP-1364)
* _Debugger:GDB_. Fixed problem passing arguments to GDB in IN-VM and SSH modes. (GP-1368)
* _Debugger:GDB_. Fixed a NullPointerException when terminating GDB. Changed PtySession API to prevent future occurrence. (GP-1399, Issue #3487)
* _Debugger:Listing_. Fixed stack trace when switching to trace of a different processor language. (GP-1547)
* _Debugger:Trace_. Fixed 'ram' not in this trace/language error. (GP-1411, Issue #3509)
* _Decompiler_. Fixed a corner case in the manipulation of integer ranges by the Decompiler. (GP-1243, Issue #3064)
* _Decompiler_. Fixed a bug in the Decompiler's renaming algorithm that could cause memory corruption in rare cases. (GP-1380, Issue #3429)
* _Demangler_. Fixed GNU Demangling bug encountered when Address Table types have spaces in the parent namespace name. (GP-1051)
* _DWARF_. Fixed check for invalid function addresses. (GP-1573)
* _Eclipse Integration_. Fixed an exception in the GhidraDev Eclipse plugin that occurred when performing a Link Ghidra operation on projects that use a Gradle classpath container. (GP-1149, Issue #3087, #3088)
* _Exporter_. IDA exporter no longer fails when function stack variables have comments. (GP-1190, Issue #2350, #3309, #748)
* _Exporter_. Fixed an issue with the ElfExporter not correctly undoing relocations when they spanned partially file-backed memory blocks. (GP-1570, Issue #3696)
* _FileSystems_. Fixed Ext4 handling of longer symlink paths and added support for inline data. (GP-1088)
* _FileSystems_. Fixed Ext4 file system to handle volumes with blocksize 1024 and a first data block value of 1. Also added support for old style block maps. (GP-1094, Issue #1877)
* _Framework_. Fixed error causing exception in the Specification Extensions panel when importing a new callotherfixup. (GP-1414, Issue #3502)
* _GUI_. Fixed potential infinite loop in Function Graph edge painting. (GP-1019, Issue #2114)
* _GUI_. Fixed minor memory leak encountered when using Search -> For Address Tables. (GP-1030, Issue #3013)
* _GUI_. Fixed bug that prevented the Decompiler scalar hover tooltip from showing. (GP-1071, Issue #3142)
* _GUI_. Fixed NullPointerException in File System Browser when closing the current project. (GP-1096, Issue #3179)
* _GUI_. Fixed the script console to not lock the GUI when a large amount of text is being written. (GP-1148, Issue #3251)
* _GUI_. Fixed long GUI hang when attempting to Set External Program on an import within in a large Ghidra project. (GP-1155, Issue #3245)
* _GUI_. Fixed UI freeze when connecting to a large remote project. (GP-1200, Issue #3305)
* _GUI_. Tweaked enablement of several search actions so that instead of being disabled when on a restricted view provider (e.g., Decompiler, FunctionGraph), they instead are enabled, but apply to the global listing provider. (GP-1259)
* _GUI_. Fixed stack trace in the Function Call Graph when using the Show Incoming Level Edges action. (GP-1302, Issue #3327)
* _GUI_. Fixed the Search Memory dialog issue that caused odd resize behavior when using the Advanced button. (GP-1333, Issue #3158)
* _GUI_. Fixed tracking of Favorite data types when switching between multiple open programs. (GP-1391)
* _GUI_. Fixed user list scrollbar in shared project dialog when there is a large number of users. (GP-1410)
* _GUI_. Fixed bug that cause a structure field name to change when using the Retype Field action without picking a new data type. (GP-1429, Issue #3483)
* _GUI_. Fixed issue when attempting to rename a datatype that has the same name as a category in the same parent cateogory. The rename would attempt to rename the category instead of the datatype. (GP-1445)
* _Importer_. Fixed issue with Extract and Import action trying to create invalid filenames. (GP-1024, Issue #3114)
* _Importer_. Fixed Extract and Import action when highlighting bytes in the debugger view. (GP-1449)
* _Importer:ELF_. Corrected ELF importer error which could occur when processing memory section overlay blocks caused by AddressOutOfBoundsException exception. (GP-1052, Issue #3128)
* _Importer:ELF_. Corrected various markup issues related to packed ELF Android relocations. Added missing ELF Arm 32-bit RELR relocation support. (GP-1352, Issue #3462)
* _PDB_. Fixed short timeout values when downloading PDB files. (GP-1105, Issue #3184)
* _PDB_. Fixed the Load PDB dialog to better handle missing or incomplete metadata. (GP-1180, Issue #3289)
* _PDB_. Fixed NullPointerException encountered for a particular array of enums scenario where the enum definition processing had not completed. (GP-1456, Issue #3484)
* _Processors_. Corrected return type for MIPS32 `JIC` instruction. (GP-938, Issue #3022)
* _Processors_. Corrected pcode for ARM/ARM-Thumb `adcs` and `sbcs` carry and overflow flag updates. (GP-1043)
* _Processors_. Corrected flag handling for some 6502 instructions. (GP-1054, Issue #3096)
* _Processors_. Fixed issues with PPC register overwrites. (GP-1075, Issue #1672)
* _Processors_. Fixed 6502 `bit` instruction semantics. (GP-1115, Issue #2558, #3095)
* _Processors_. Fixed MIPS 32-bit little endian floating point register ordering. (GP-1129, Issue #3212)
* _Processors_. Corrected PowerPC ISA instruction manual index page numbers. (GP-1218, Issue #2927)
* _Processors_. Updated Tricore manual index file to match correct page numbers. (GP-1220, Issue #2926)
* _Processors_. Fixed bug in SuperH `moveml.l` instruction which caused a load instead of store register. (GP-1263, Issue #3379)
* _Processors_. Corrected semantics for MIPS `INS` instruction. (GP-1290, Issue #3405)
* _Processors_. Corrected MIPS64 `DINS` instruction semantics. (GP-1291, Issue #2232)
* _Processors_. Corrected semantics of PA-RISC shift conditions, which was incorrectly using the register size in bytes, as opposed to bits. (GP-1292)
* _Processors_. Corrected ARM neon `vmrs` instruction disassembly. (GP-1322, Issue #3446)
* _Processors_. Corrected SuperH `bld` and `movemu` instruction semantics. (GP-1331, Issue #3449)
* _Processors_. Removed deprecated ARM condition code 15. (GP-1332)
* _Processors_. Corrected issue with x86 `call` instructions when stack pointer is used as a reference. (GP-1357, Issue #3455)
* _Processors_. Corrected MIPS pcodeop error in `tlbr` instruction. (GP-1363, Issue #3463)
* _Processors_. Corrected ARM Thumb conditional instruction `it` to allow the `al` (always) conditional. (GP-1402, Issue #3499)
* _Processors_. Removed extraneous `sb` from ARM `ldrsb` instruction. (GP-1412, Issue #3522)
* _Processors_. Implemented M68000 `CHK`, `CHK2`, and `CMP2` instructions. (GP-1478, Issue #2856, #3616)
* _Processors_. Corrected SuperH `trapa` instruction to use a `call` p-code op instead of a `goto`. (GP-1504, Issue #3600)
* _Processors_. Corrected x86 instruction parse and semantics for `RDRAND` and `RDSEED`. (GP-1564)
* _ProgramDB_. Corrected language upgrade issue which could result in lost memory reference due to `RefType` change. (GP-1392)
* _Scripting_. RecoverClassesFromRTTIScript now consistently applies its class structures in programs that have PDB information applied. Also, an option was added so users can decide whether to replace existing class data in thiscall functions regardless of whether they originated as PDB or not. (GP-1464)
* _Scripting_. Fixed an issue where some GhidraScript print methods were not getting output to the script log file. (GP-1541, Issue #3657)
* _Sleigh_. Corrected sleigh-language endian-mismatch error-message formatting. (GP-1132, Issue #3215)
* _Sleigh_. Made numerous fixes to the PowerPC SLEIGH language module. Note: minor language version upgrade. (GP-1250)
* _Version Tracking_. Fixed UnsupportedOperationException in Version Tracking when attempting to find references to register or stack addresses. (GP-1084, Issue #1152)
* _Version Tracking_. Fixed Version Tracking Swap button to not trigger the reloading of programs. (GP-1183)

# Ghidra 10.0.4 Change History (September 2021)

### Improvements
* _Multi-User_. Added class serialization filter to Ghidra Server as a security measure. (GP-1314)

### Bugs
* _C Parsing_. Changes to the CParser have been made to successfully parse a greater number of header files. The CParser will now correctly evaluate the truth of expanded macro substitutions in `#if` statements. Operator precedence has been corrected and support for additional operators added for constant simplification that is used to specify array sizes during parse. In addition, C17 structure initialization syntax and multiple type casts are now parsed. (GP-1295, Issue #1652, #2665, #2666, #3410)
* _Debugger_. Changed Track Program Counter, etc., to re-track even when clicking them doesn't change the current setting. (GP-1282)
* _Debugger:GDB_. Fixed issue with CRLF using GDB/SSH from Windows. (GP-1309, Issue #3426)
* _Decompiler_. Fixed a NullPointerException encountered when hovering over the name of an Undefined Function in the Decompiler window. (GP-1260)
* _Decompiler_. Fixed bug causing the `Missing userop attribute in segmentop tag` error message in the Decompiler for Z80 executables. (GP-1305, Issue #3329)
* _Decompiler_. The Decompiler now handles small dynamically sized data types, like `Alignment`. (GP-1327, Issue #3399)
* _GUI_. Fixed an AssertException in the Default Graph Display encountered when loading a saved graph layout. (GP-1313, Issue #3441)
* _Headless_. Corrected NullPointerException for headless when no opinion results are found. (GP-1323)
* _Importer:PE_. Fixed a regression with parsing COFF Aux symbols for PE/MZ loaders. (GP-1174, Issue #3442)
* _Multi-User_. Corrected and improved specification of TLS version restrictions for client use via `launch.properties` and Ghidra Server use via `server.conf`. (GP-1287)
* _Processors_. Corrected endianness mix-up in MIPS function start bit-patterns. (GP-1310, Issue #3421)

# Ghidra 10.0.3 Change History (September 2021)

### New Features
* _Debugger:Watches_. Added ability to modify target memory and registers via the Watches window. (GP-1264, Issue #2866)

### Improvements
* _Analysis_. Improved SH4 constant reference analysis for PIC code, reference placement for jumps/calls, and non-return function analysis. General constant reference analysis has also been improved. (GP-1258)
* _Basic Infrastructure_. Removed usage of the `--illegal-access=permit` JVM argument for improved JDK 17 runtime support. The Ghidra Server continues to require JDK 11 to successfully run at this time. (GP-1193, Issue #3355)
* _Debugger_. Debugger Agent windows now display log messages. (GP-507)
* _Debugger_. Changed Debugger's Launch action to propose the current program as the command line. (GP-1176)
* _Debugger_. Providing broader defaults for recording GDB-supported architectures. (GP-1237)
* _Debugger:GDB_. GDB connector's Use existing session prompts with more instructions. (GP-1076)
* _Debugger:GDB_. Added use starti option to GDB launcher. (GP-1158)
* _Debugger:Mappings_. Added Map Identically action to Modules window. (GP-1232)
* _GUI_. Changed analysis options to always show current program options when accessed via Edit -> Options for <program>.... Also added warning if the user makes changes to the analysis options and then changes the combo box without saving the changes first. (GP-1188)
* _Importer_. The ContinuesInterceptor, which allows the import process to proceed past uncaught exceptions that can be encountered while parsing corrupted headers, has been disabled by default. Its usage is now deprecated and will be removed in a future Ghidra release. It can be temporarily re-enabled in support/launch.properties. (GP-1248)
* _Importer:ELF_. Added support for additional ELF AARCH64 relocations such as `R_AARCH64_LDST64_ABS_LO12_NC`. (GP-1278, Issue #3352)
* _Processors_. Corrected semantics for x86/x64 `FXSAVE` and related instructions. (GP-1228)
* _Processors_. Added semantics for several x86/x64 vector operations. (GP-1262)

### Bugs
* _Byte Viewer_. Fixed stack overflow issue in ByteViewer. (GP-1276)
* _C Parsing_. Eliminated static variables that caused follow-on CParser tasks to error because they started in a bad state. (GP-1251, Issue #1421, #3350)
* _Debugger_. Fixed NullPointerException in Objects window's Import/Export actions. (GP-1047)
* _Debugger_. Fixed NullPointerException in DBTraceStack. (GP-1059)
* _Debugger_. Fixed a rare deadlock involving DBTrace.addListener. (GP-1154)
* _Debugger_. Track PC action now scrolls to cursor even if the cursor is already at PC. (GP-1175)
* _Debugger_. Created better mapping of GDB ARM architecture names to Ghidra languages for the Debugger. (GP-1221, Issue #3333)
* _Debugger_. Capture Memory button is more aggressive in finding the correct region to capture, reducing bad region errors. (GP-1227)
* _Debugger_. Fixed delay slot disassembly in Debugger dynamic listing. (GP-1246, Issue #3358)
* _Debugger:Emulator_. Fixed cache-reading issue in trace emulation. (GP-1187)
* _Debugger:Emulator_. Fixed a critical typo in PairedPcodeArithmetic. (GP-1191)
* _Debugger:Trace_. Dynamic listing now updates immediately when changing data type settings. (GP-1215)
* _Debugger:Trace_. Removed `Missing Instruction Prototype` exception in favor of using InvalidPrototype. (GP-1226)
* _Debugger:Trace_. Adding context fields to Register viewer no longer throws an exception. (GP-1256)
* _Decompiler_. Fixed a bug that could cause an infinite loop in the Decompiler when using bonded register pairs. (GP-1270, Issue #3105)
* _Decompiler_. Fixed a bug causing `Exceeded maximum restarts with more pending` warnings in the Decompiler. (GP-1277, Issue #3104)
* _Disassembly_. Fixed an IllegalArgumentException in the Non-Returning Functions analyzer caused by processor specifications without a defined context, such as Sparc and SH4. (GP-1216)
* _DWARF_. Corrected potential random errors in DWARF parsing caused by modifications to a shared global static DWARF decoder. (GP-1272)
* _Exporter_. Exporters with empty default extension names will no longer append a dot to the output filename. (GP-1201, Issue #3325)
* _GUI_. Fixed the missing mnemonic of the Graph menu. (GP-1244, Issue #3330)
* _Processors_. Corrected carry flag semantics for the 6502 processor's `SBC` instruction. (GP-1109, Issue #3189, #3190)

# Ghidra 10.0.2 Change History (August 2021)

### New Features
* _Scripting_. Created an example script which demonstrates how to use the FileBytes class to do a binary export of the current program. (GP-1157)

### Improvements
* _Data Types_. When creating a substructure from existing components, the new structure will adopt the pack setting of the parent structure from which it was created. Note that a packed structure may still move based upon component alignment rules. (GP-1111, Issue #3193)
* _Decompiler_. Added E key binding to the Decompiler's Equate action. (GP-1146, Issue #3195)
* _GUI_. Added Apply button to analysis options dialog. Also added a last chance save/cancel dialog that is shown when a user cancels an options dialog that has unsaved changes. (GP-1169, Issue #3274)
* _Scripting_. For stripped GCC binaries, improved prototype RecoverClassesFromRTTIScript identification of vtables and simple class data, constructors, and destructors. (GP-1055, Issue #3266)

### Bugs
* _Basic Infrastructure_. Fixed regression that prevented Ghidra from launching on Windows when its path contained spaces. (GP-1113, Issue #3201, #3205)
* _Data Types_. Fixed IllegalArgumentException error message when adding a duplicate enumerate name for EnumDataType. (GP-1173, Issue #3246)
* _Debugger_. Changed diagnostics to write GDB.log to user directory, not installation. Clarified an error message. (GP-1133, Issue #3218)
* _Debugger_. Improved error reporting when failing to start a Debugger GADP agent. (GP-1136, Issue #3175)
* _Debugger_. Added system property to toggle alternative icons/colors for breakpoints. (GP-1139, Issue #3204)
* _Debugger_. Applying a default everything memory map for GDB targets if info proc mappings fails or produces an empty list. (GP-1142, Issue #3071, #3074, #3161, #3169)
* _Debugger_. Fixed issue with Debugger ignoring JAVA_HOME when launching child JVM. (GP-1143, Issue #3231)
* _Debugger_. Fixed command-reply matching issue when using GDB via SSH. (GP-1153, Issue #3238)
* _Debugger:Emulator_. Fixed bug in Trace Emulation causing ArrayIndexOutOfBoundsExceptions. (GP-1058)
* _Decompiler_. Fixed issue causing `Offset must be between...` AddressOutOfBoundsException, when decompiling real-mode x86 programs. (GP-1163, Issue #239, #2948)
* _Decompiler_. The decompiler now shows results when a HighGlobal has no associated symbol reference in the program. (GP-1184)
* _DWARF_. Changed processing to ignore incomplete DWARF parameter lists in Rust binaries. (GP-1121, Issue #3060)
* _Exporter_. The C/C++ Exporter now emits semicolons after function prototypes when using the Create Header File option. (GP-1145, Issue #1644)
* _Framework_. Corrected address comparison for 64-bit signed address spaces (e.g., stack space, constant space) which could produce non-transitive comparison results. (GP-1178, Issue #3302)
* _Graphing_. Corrected graph magnification behavior when using a high resolution mouse wheel. (GP-1181, Issue #3281, #3284)
* _GUI_. Fixed NullPointerException when Hovering in Decompiler over a function that is not in memory. (GP-1131)
* _GUI_. Fixed bug in Find References to search results that prevented '<' characters from being rendered. (GP-1137, Issue #3217)
* _GUI_. Fixed issue where duplicate label names could cause the symbol tree to become unstable, evidenced by broken display and scrolling actions. Also, improved grouping algorithm. (GP-1159, Issue #3263)
* _GUI_. Fixed Enter key in Set Equates dialog to choose the selected table row. Updated the Function Signature Editor dialog to allow the Cancel key to close the dialog when the focus is in the top text editor. (GP-1162, Issue #3235)
* _Headless_. Fixed a regression in analyzeHeadless.bat that prevented the headless analyzer from running on Windows in some cases. (GP-1156, Issue #3261)
* _Importer_. The MzLoader now populates the relocation table when relocations are performed. (GP-1160)
* _Importer:ELF_. Corrected dynamic GOT/PLT markup problem for images which do not contain section headers. In cases where image does not define symbols within the PLT, analysis may be relied upon for its disassembly. ELF Importer's goal is to migrate symbols which may be defined within the PLT to the External symbol space. (GP-1110, Issue #3198)
* _Importer:Mach-O_. The Mach-O importer now correctly interprets indirect symbols as references to symbols within another .dylib. (GP-1120)
* _Importer:PE_. Improved ControlFlowGuard markup and creation of functions (GP-1179, Issue #1547, #1565)
* _Processors_. Fixed bug in SuperH4 `fmov.s` pcode. (GP-1152)
* _Processors_. The ARM instruction semantics for the mulitple-single-element forms of the `vld1`/`vst1` vector instructions have been corrected. (GP-1167)
* _Sleigh_. Fixed a string formatting error in the sleigh compiler. (GP-1124, Issue #3168)

# Ghidra 10.0.1 Change History (July 2021)

### New Features
* _Decompiler_. The Decompiler now supports conversion (hex, dec, bin, oct, char) and equate actions directly on constant tokens in the Decompiler window. To the extent possible, these actions also affect matching scalar operands in the listing. (GP-1053, Issue #21)

### Improvements
* _Basic Infrastructure_. Ghidra now gracefully fails to launch when its path contains an exclamation point. (GP-1057, Issue #1817)
* _FileSystems_. Can now handle multi-level Ext4 extent nodes when reading a file. (GP-1070)

### Bugs
* _Build_. No longer building and distributing the Debugger native test binaries. (GP-1080, Issue #3160, #3177)
* _Debugger_. Corrected potential deadlock condition within Debugger which could occur under some circumstances during a breakpoint or while stepping. (GP-1072)
* _Decompiler_. Fixed a bug in the Decompiler causing `Overriding symbol with different type size` exceptions. (GP-1041)
* _Exporter_. PE and ELF exporters no longer error out when processing non-file-backed relocations. (GP-1091)
* _FileSystems_. Corrected problem mounting Ext4 file systems when the container file is larger than the file system. (GP-1067)
* _Importer:ELF_. Corrected ELF relocation error reporting, including error bookmarks, when relocation handler extension is missing. (GP-1097)
* _Jython_. Added `__file__ attribute` support in Jython scripts. (GP-1099, Issue #3181)
* _PDB_. Fixed bug that prevented constructor signatures from being created properly. (GP-1086)
* _PDB_. Fixed bug in PDB CLI processing that could kill analysis for binaries imported with older versions of Ghidra. (GP-1104)
* _Processors_. Added ELF Relocation handler for SuperH processors. Only a few common relocation types have been added. (GP-1090)
* _Scripting_. Fixed a potential NullPointerException that could occur when trying to run a script that doesn't exist. (GP-1074, Issue #2742)
* _Scripting_. Improved graphing of class hierarchy in RecoverClassesFromRTTIScript and the GraphClassesScript to handle duplicate class names, class namespace delimiters, and to make better vertex descriptions. (GP-1095)
* _Scripting_. Fixed a flaw in the RecoverClassesFromRTTIScript that was not using PDB information to create data member names in class data structures. (GP-1101)

# Ghidra 10.0 Change History (June 2021)

### New Features
* _Debugger_. Introduced the Debugger, along with GDB and dbgeng.dll connectors for debugging user-mode applications on Linux and Windows, respectively. The UI includes threads, timeline, modules, memory, registers, watches, etc., for examining and controlling debug targets. See Help -> Contents -> What's New for more details. (GP-986)
* _Exporter_. For programs imported with the PE and ELF loaders, new exporters are available that write back to the original file layout. Any file-backed bytes that were modified by the user in the program database will be reflected in the written file (except on relocations). Writing back a modified Memory Map is not supported. (GP-786, Issue #1501, #1505, #19)
* _Graphing_. Added Graph -> Data  actions to the Code Browser, allowing visualization of specified pointer relationships in a graph. (GP-194)
* _Scripting_. Added prototype RecoverClassesFromRTTIScript and that uses RTTI information to enhance Ghidra's knowledge of class hierarchy, class member function types (constructors, destructors, deleting destructors, clones) and class member data. The script will label and put member functions into correct class namespace and apply new class structures created either using PDB information, if available, or Decompiler pcode information. (GP-339)
* _Scripting_. Added an example script, LocateMemoryAddressForFileOffset, to demonstrate mapping of a location in the original imported file to the program memory address. Useful for cases where the original file offset is known; for example, a YARA rule match. (GP-782)
* _Scripting_. Created a script to allow users to search for image base offsets to the current cursor location in 32-bit and 64-bit programs. (GP-863)

### Improvements
* _Analysis_. Function signatures, including return types and argument data types, are now decoded from CLI Metadata for .NET binaries. (GP-327)
* _Analysis_. Switched #Strings table processing from ASCII to UTF-8 for CIL binaries. (GP-330, Issue #423)
* _Analysis_. Added Constant, Assembly, and AssemblyRef blob processing for CIL binaries. (GP-465)
* _Analysis_. Added the Variadic Function Signature Override analyzer, which identifies functions that take a format string as a parameter and applies the correct signature override at each call site. (GP-516)
* _Analysis_. Added ability to save and easily reuse analysis options in customer-defined configurations. (GP-544, Issue #2182, #312)
* _Analysis_. Ghidra analysis is now aware of more PE/Windows non-returning functions. (GP-733, Issue #2111)
* _Analysis_. `ResolveX86orX64LinuxSyscallsScript` now properly marks non-returning syscalls. (GP-868, Issue #2761)
* _API_. Revised Structure and Union API, and associated editor, to eliminate the use of the terms Unaligned/Aligned in favor of a packing enablement designation. Also corrected various change notification issues which may improve archive synchronization and merge behavior. (GP-862, Issue #2681)
* _API_. Renamed `Datatype.isDynamicallySized()` to `DataType.hasLanguageDependantLength()` to avoid confusion. This method is used internally to differentiate between fixed-length types and those whose length is determined by the compiler specification's data organization (e.g., pointers). (GP-932)
* _Basic Infrastructure_. Improved error reporting when trying to launch Ghidra from the git repo without Eclipse having compiled it. (GP-815, Issue #2872)
* _Build_. Command `gradle -I gradle/support/fetchDependencies.gradle init` now downloads the Function ID datasets from the ghidra-data GitHub repository so they will be automatically included in development mode and custom builds. (GP-678, Issue #1007)
* _Build_. Performing a `gradle clean` no longer deletes downloaded dependencies. The top-level flatRepo directory has been replaced with the dependencies directory. (GP-811, Issue #1663)
* _Build_. Ghidra now requires Gradle 6.0 or later to build. Gradle 7.x is now supported. (GP-849, Issue #2949)
* _Build_. Made changes to gradle code to remove warnings. (GP-993, Issue #3039)
* _Data Types_. Added support for hexadecimal byte offset display within composite bitfield view. (GP-910, Issue #2959)
* _Decompiler_. Decompiler analysis now automatically identifies and displays loop variables using standard for-loop syntax. When a loop variable is discovered, a condition, iteration, and optional initializer statement are displayed at the top of the loop. (GP-565)
* _Decompiler_. Added the Max Instructions per Function Decompiler tool option, specifying the maximum number of instructions the Decompiler will decode in a single function before throwing an exception. Previously, this had been a hard-coded limit. (GP-767, Issue #2557)
* _Decompiler_. The Decompiler now propagates datatypes across signed comparison operations, so constant integer and enum values display correctly. (GP-802, Issue #2565)
* _Demangler_. Updated the GNU Demangler Analyzer options to provide a list of available formats from which to choose. (GP-94, Issue #2214)
* _Demangler_. Updated the GNU Demangler's Namespace-building to improve analysis performance. (GP-706, Issue #2509)
* _Demangler_. Improved Demangler error checking and reporting to give underlying cause of failure. (GP-850)
* _Documentation_. Added basic instructions on how to install, build, and develop Ghidra to README.md. (GP-847)
* _DWARF_. Improved speed and memory usage when importing large DWARF binaries. (GP-419)
* _DWARF_. Added M68000/SVR4 DWARF register mappings. (GP-556, Issue #1610)
* _DWARF_. Improved handling of zero-length structure components during DWARF processing. (GP-851, Issue #2191)
* _Exporter_. Made various improvements and bug fixes and to the IDA Pro exporter. (GP-831, Issue #1897, #2788, #2882, #2891)
* _FileSystems_. Added support for recognizing unencrypted DMG files. (GP-845)
* _Framework_. Added support for program-specific extensions to a compiler specification. Users can now define their own calling conventions and call-fixups to integrate into decompilation and other analysis (see help for Specification Extensions). (GP-653)
* _Graphing_. Added capability to collapse and expand nodes in the default graph display. (GP-371)
* _Graphing_. Upgraded jungrapht to version 1.1. (GP-377)
* _Graphing_. Refactored graph exporters into a more extensible framework. (GP-440)
* _Graphing_. Graph layout algorithms can now be chosen programmatically. (GP-551)
* _Graphing_. Created additional modified versions of the MinCross layout algorithms, all named to start with Vertical Hierarchical Min-Cross, so that they accept a favoredEdge predicate. When an edge is favored, a pass though the graph layers attempts to align those edges vertically. (GP-625)
* _Graphing_. Added an option to change the background color of the Function Graph window. (GP-760, Issue #1324)
* _Graphing_. Updated Function Graph edge routing when applying the Use Condensed Layout option to reduce edges being clipped by vertices. (GP-768)
* _Graphing_. Added option to disable the lightening of edges in the Function Graph. (GP-769, Issue #1106)
* _Graphing_. Added a distinct visual edge highlight beyond just a different color for graph edge selection. (GP-793, Issue #2953)
* _Graphing_. Added Display as Graph action to the Data Type Manager, allowing visualization of embedded and referenced types of the selected types. (GP-808)
* _Graphing_. Fixed function graph bug that prevented the satellite view from showing the primary view lens. Fixed a layout bug that allowed some vertices to get clipped when condensing the graph. (GP-940)
* _Graphing_. Added graph API method to set descriptions (tooltips) on vertices and edges. (GP-949)
* _Graphing_. Added Vertex and Edge attributes to GraphML export format. (GP-957, Issue #2958)
* _GUI_. Added new Copy Special actions: Python Byte String, Python List, and C Array. (GP-210, Issue #744)
* _GUI_. Updated the Listing to allow structure members to display Plate Comments. (GP-421, Issue #2091)
* _GUI_. Copy/Pasting and Dragging data types now uses a progress monitor. (GP-422, Issue #2379)
* _GUI_. Added right-click menu Data -> Save Image action to allow user to export embedded graphic resource images. (GP-426)
* _GUI_. Changed Symbol Comment Annotation to use the existing symbol when available. This allows for the direct navigation of that symbol's address instead of using the search feature of the Go To Service. (GP-675)
* _GUI_. Added the Shift-F10 keybinding to allow users to show the popup context menu over the currently focused item. The Menu Key can also be used on supporting keyboards. (GP-732, Issue #2790)
* _GUI_. Fixed/Improved the behavior of global menu items and toolbar items with respect to which windows they appear in. These actions can now easily be configured to be either 1) only in menu bar and tool bar of the main window, 2) in the menu bar and tool bar of all windows, or 3) only in the windows that have components that generate the type of context that the action consumes. Added methods to the ActionBuilder class to support these three options. Also, updated numerous actions to make sure they appear in the appropriate windows. (GP-759)
* _GUI_. Improved overall UI responsiveness when performing analysis with the Symbol Table open. (GP-788)
* _GUI_. Updated the Function Tags table column so that it may be used in most Ghidra tables. (GP-816, Issue #2873)
* _GUI_. Updated the Defined Strings view to reload less frequently during auto-analysis. (GP-835, Issue #2889)
* _GUI_. Updated function hovering in the Decompiler to find the correct function tooltip when multiple functions exist with the same name. (GP-959, Issue #2604)
* _Importer:ELF_. Added markup to ELF import for `.note.gnu.build-id` and `.gnu_debuglink` sections. (GP-468)
* _Importer:ELF_. Added ELF import support for SHN_MIPS_TEXT and SHN_MIPS_DATA symbol section index values and provided ability for other processor-specific ELF extensions to resolve ELF symbol memory addresses. (GP-664)
* _Importer:ELF_. Changed various ELF relocations to detect and mark unsupported data relocations which refer to the EXTERNAL block. Applied EXTERNAL data relocations, which have a non-zero offset from the external symbol, will still be incorrect but will have an error bookmark to flag the condition. The relocation addend will not be applied in this case to avoid references to a completely irrelevant symbol in the EXTERNAL block. (GP-1029)
* _Importer:Mach-O_. Improved support for Mach-O object files. (GP-700)
* _Importer:PE_. CustomAttrib blobs in CLI/.NET metadata are now decoded. (GP-414)
* _Importer:PE_. Created proper external references for PE Delay Load Imports. (GP-674, Issue #2554, #2623)
* _Importer:PE_. PeLoader can now read and interpret the `.pdata` section of PE files that include exception handling data. (GP-729)
* _Importer:PE_. Added .exports XML files for the mfc71.dll and mfc71u.dll libraries. Having them allows Ghidra to translate ordinal imports from applications compiled against MFC 7.1 (from Visual Studio .NET 2003) to class and function names with parameters. (GP-1010, Issue #3051)
* _Listing_. Improved Listing view performance, especially noticeable on functions with excessively large stack frames. (GP-268, Issue #109, #2351)
* _Listing_. Added a tool option to hide function auto-comments that appear, trailing a function call in the Listing. (GP-752)
* _PDB_. Improved Ghidra's ability to find and pull PDB files from symbol servers and symbol storage locations. (GP-42)
* _Processors_. Simplified PIC24 return instruction semantics. (GP-647)
* _Processors_. Added support for register alias specification within processor spec (*.pspec). Added `WREG` register aliases for PIC24 processor variants. (GP-901, Issue #2956)
* _Processors_. Fixed issue with the `PPAGE` register not being properly restored after `CALL` instructions in the HCS12 processor. (GP-920, Issue #1099)
* _Processors_. Fixed HCS12 `IDX1` addressing with negative immediate values. (GP-937, Issue #3008)
* _Processors_. Fixed V850 multiply-by-immediate calculation that produced an incorrect value when the fifth bit was set. (GP-939, Issue #2970)
* _References_. Improved performance of reference management for special cases when large a number of references from the same address exist (e.g., entry point designation). (GP-696)
* _Scripting_. ExportImageScript now exports all images within a user-selected region to files within a user-selected folder. (GP-231)
* _Scripting_. Improved TableChooserDialog, allowing multiple rows to be processed at once. (GP-676)
* _Scripting_. Updated the TableChooserDialog to allow clients to set the default column sort. (GP-792)
* _Scripting_. Added Python script comment block support. (GP-843, Issue #1484, #2846)
* _Scripting_. Added ApplyClassFunctionSignatureUpdatesScript and ApplyClassFunctionDefinitionUpdatesScript fix-up scripts that can be applied if a user makes changes to a virtual function recovered by the RecoverClassesFromRTTIScript. Both scripts identify differences between Function Signatures in the Listing and Function Definitions in the Data Type Manager, but the first script fixes all changes to match the signature and the second to match the definition. (GP-973, Issue #3081)
* _Sleigh_. Debug info for Sleigh constructors now includes source file names. (GP-233)
* _Sleigh_. The Sleigh compiler now issues a warning if it generates a temporary varnode which might be large enough to overlap another temporary varnode. (GP-520)
* _Sleigh_. While register names should remain case-sensitive within a Sleigh spec during compilation/parse, register names must not duplicate in a case-insensitive manner since the Program API provides a case-insensitive register lookup by name. The Sleigh Compiler now enforces this. (GP-927)

### Bugs
* _Analysis_. Fixed how managed code entry points in .NET binaries with CIL entry points are detected and labeled. (GP-319)
* _Analysis_. Can now process implementation-specific data structures for Microsoft CIL compilers. (GP-461)
* _Analysis_. Corrected processing for pointers, function pointers, custom modifiers, ValueTypes, static methods, MethodRefs, MethodDefs, and PInvokes found in .NET mixed binaries. (GP-656)
* _Analysis_. Improved constant analysis speed when processing large binaries with a large amount of code not in defined functions, such as exception handlers. (GP-746, Issue #2509)
* _Analysis_. When OverlayAddressSpace was refactored and Decompiler made aware of it for Ghidra 9.2, the VarnodeContext was not aware of the overlays. This was fixed and should eliminate the NullPointerException caused when the Symbolic Propagator calls the Varnode constructor. (GP-751, Issue #2785, #2787)
* _Assembler_. Fixed assembler issue with delay-slotted instructions. (GP-587)
* _Assembler_. Fixed assemble Patch Instruction action to work on listings other than the primary static listing. (GP-623)
* _Assembler_. Modified assembler Patch Instruction action to ignore external symbols which produced bad offsets for instructions. (GP-645)
* _Basic Infrastructure_. Fixed an issue with Ghidra and its supporting launch scripts not being able to run correctly on Windows when an ampersand was in the path. Also fixed an issue with svrAdmin.bat and buildGhidraJar.bat not working if the Ghidra path contained a space. (GP-693, Issue #1726, #1728)
* _Basic Infrastructure_. Corrected _"LaunchSupport expected 2 to 4 arguments but got 1" _ error when starting Ghidra on Windows. (GP-1050, Issue #2176, #3122)
* _Build_. Building of pdb.exe on Windows now works if the path to the Ghidra repository contains a space. (GP-916, Issue #2998)
* _Build_. Corrected GPL DMG module build to properly utilize the jar dependencies included within the repository and distribution. (GP-934)
* _Build_. Corrected an issue with `gradle prepDev` when the Ghidra repository is on a different drive than the user's home directory on Windows OS. (GP-970, Issue #3047, #3062)
* _Build_. Fixed a bug that prevented Ghidra from launching in Single Jar Mode when its path contained a space. (GP-1039)
* _C Parsing_. The C-Parser bitfield parsing has been relaxed to allow declared bitfield sizes to exceed the base datatype size. The effective bitfield size may be clamped based upon the current data organization while preserving the declared size. (GP-558)
* _Data Types_. Fixed a NullPointerException that occurred when trying to edit a function datatype in a datatype archive when there was no open program in the tool. (GP-356, Issue #2407)
* _Data Types_. Corrected the retention of datatype archive search paths, which did not properly remember disabled paths. (GP-639)
* _Data Types_. Fixed potential deadlock encountered when working with the DataTypes tree. (GP-774, Issue #2832)
* _Decompiler_. Fixed endianness issue for joined, two-register returns of `longlong` values for MIPS 32-bit little endian variants. (GP-513)
* _Decompiler_. The Decompiler no longer emits comments in the middle of conditional expressions. (GP-621, Issue #1670)
* _Decompiler_. Fixed `Redefinition of structure...` exceptions in the Decompiler caused by a PNG Image and other opaque datatypes. (GP-820, Issue #2734)
* _Decompiler_. Fixed infinite loop in the Decompiler when analyzing return values. (GP-821, Issue #2851)
* _Decompiler_. Fixed bug in the Decompiler's handling of enumerated datatypes causing `Shared type id` exceptions. (GP-895, Issue #2909)
* _DWARF_. Fixed and consolidated DEX and DWARF implementations of LEB128. (GP-444, Issue #2512)
* _DWARF_. Fixed unnecessary ELF header parsing when DWARF analyzer checks if it needs to run. Improved DWARF analyzer's run-once logic. (GP-695)
* _DWARF_. Fixed issue with DWARF data type importing that could omit the definition of a structure. (GP-929)
* _Eclipse Integration_. Fixed a GhidraDev bug that prevented Ghidra projects from recognizing extensions installed in the user's ~/.ghidra/.ghidra_<version>/Extensions directory. (GP-873)
* _Extensions_. Changed classpath configuration to not contain paths of removed extension libraries. (GP-522, Issue #2637)
* _FileSystems_. Fixed several issues with extracting and importing DYLIB files contained within a DYLD file system. (GP-719, Issue #2934, #682)
* _FileSystems_. Fixed SevenZipFileSystem to correctly fail when opening password-protected archives. (GP-730)
* _FileSystems_. Fixed Ext4 file system to correctly handle sparse files. (GP-871)
* _Graphing_. Fixed IllegalArgumentException when showing a graph popup window after the source component was hidden. (GP-756, Issue #1643)
* _Graphing_. Fixed bug that caused all address in a function graph node to be colored when only the entry point address had a color applied. (GP-757, Issue #1080)
* _Graphing_. Fixed bug in graph dominance algorithm that could cause the Select -> Scoped Flow actions to go into an infinite loop. (GP-776, Issue #2836)
* _GUI_. Fixed UI lock-up issue related to the Function Tags table. (GP-266, Issue #2366)
* _GUI_. Fixed missing spaces in Front End multi-line log messages. (GP-463, Issue #2534)
* _GUI_. Fixed the following modal dialog issues: z-order changing when showing a modal dialog over a detached window; focusing the incorrect window after showing a modal dialog; script progress dialog not getting placed behind input dialog; script dialogs appearing over different windows. (GP-628, Issue #2398, #2480)
* _GUI_. Fixed NullPointerException encountered when creating a new category in the Data Types tree while the tree is filtered. (GP-745, Issue #2799)
* _GUI_. Fixed Right Alt key that did not work for Ghidra actions on some Windows systems. (GP-747, Issue #2008)
* _GUI_. Fixed Function Graph bug that caused some vertex text to get clipped when using wide address format width. (GP-755, Issue #1008)
* _GUI_. Fixed bug in the Listing scroll bar that caused some screen reader software to deadlock. (GP-772, Issue #2820)
* _GUI_. Fixed bug that caused the UI to freeze when clicking in the Program Tree UI. The bug manifested depending upon the contents of the system clipboard. (GP-775)
* _GUI_. Updated tooltip code to limit data types name length and updated formatting to place pertinent information at the top of the tooltip. (GP-836, Issue #2029)
* _GUI_. Fixed exception triggered when the Bookmarks table failed to remove a deleted symbol. (GP-989, Issue #3066)
* _GUI_. Fixed exception encountered when double-clicking a structure in an archive in the `closed for edit` state. (GP-998)
* _GUI_. Fixed Function Graph stack trace encountered when changing the graph's background color option after showing and then closing the graph. (GP-1013, Issue #3058)
* _Importer:ELF_. Added support for additional PIC30 ELF relocations (4, 5, 6) and improved register symbol resolution and markup. (GP-710, Issue #2792)
* _Importer:ELF_. Changed processing of ELF absolute symbols (section ID 0xfff1) to treat them as constants by defining equates instead of memory symbols. (GP-902)
* _Importer:ELF_. Corrected EXTERNAL symbol alignment for PIC24, PIC30, PIC33 during ELF import. The improperly aligned symbol addresses would cause incorrect external symbol references to appear on instructions (e.g., `RCALL`). (GP-906)
* _Importer:PE_. Fixed error when importing a PE file with an uninitialized `.textbss` section. (GP-397, Issue #2496)
* _Importer:PE_. Fixed a bug processing RUNTIME_INFO structures that caused a failure to load PE files under certain conditions when the list is empty. (GP-924, Issue #2995)
* _Importer:PE_. Fixed an issue in the PeLoader that prevented PE files with 0 data directories from being imported. (GP-997, Issue #2858)
* _Installation_. Renamed database `db.Record` class to `db.DBRecord` to avoid naming conflict with `java.lang.Record` class and potential import issues. (GP-193)
* _Jython_. Fixed pasting multi-line strings into the Python interpreter panel. (GP-487, Issue #2456)
* _Listing_. A default thunk function now reflects the namespace of the thunked function similar to the way it reflects its name. This change also allows thunk functions of a `this_call` to have the correct `this` pointer parameter. Symbol table queries based upon name and/or namespace will always exclude default thunk functions. (GP-17)
* _Listing_. Fixed #US table processing to correctly interpret the string as UTF-16LE for CIL binaries. (GP-318)
* _Listing_. Fixed a sporadic listing operand hover stacktrace bug. (GP-987)
* _PDB_. Escaped more character strings in MSDIA pdb.exe XML output. (GP-578, Issue #1690)
* _Processors_. Fixed various issues pertaining to x86 instruction prefixes. (GP-220, Issue #2286, #2297)
* _Processors_. Refactored PPC interrupt returns to include return pcode statement. (GP-703)
* _Processors_. Fixed issue with ARM `VMRS` instruction parsing in thumb. (GP-735, Issue #2750)
* _Processors_. Corrected issue with M68000 floating point dynamic k-factor instruction semantics. (GP-736, Issue #2754)
* _Processors_. Fixed instruction semantics for x86 `MOVUPS` instruction. (GP-744, Issue #2789)
* _Processors_. Simplified SuperH `div1` instruction. Corrected several SuperH instructions to set flags properly around the delay slot. (GP-753, Issue #2863, #2864)
* _Processors_. Corrected issue with ARM co-processor registers and the `MCR` instruction. (GP-761, Issue #2451)
* _Processors_. Fixed issued with x86 `INSx.rep` and `OUTSx.rep` pcode ordering. (GP-766, Issue #2829)
* _Processors_. Corrected addresses for PIC24 `TBLPAG` and `PSVPAG` registers. (GP-798, Issue #2844, #2855)
* _Processors_. Corrected decoding of some `MODR/M` opcode bytes in x86. (GP-800, Issue #2504)
* _Processors_. Updated 8085 processor definition to disassemble `XRA HL` instruction. (GP-818, Issue #2447)
* _Processors_. Corrected missing optional `rex.w` prefix for x86 conditional jump instructions. (GP-837, Issue #1163)
* _Processors_. Added `CALLW`, `ASRF`, `LSLF`, and `LSRF` instructions to PIC16 language. (GP-841, Issue #1362)
* _Processors_. Fixed ARM Thumb instructions which update the status flags to now correctly append an `s` to the instruction mnemonic. (GP-881)
* _Processors_. Made corrections to `wr` instruction for SPARC which in some cases did not write to the appropriate ASR register. (GP-928)
* _Processors_. Corrected issue with x86-64 `CALL` and `RET` instructions with `0x67` prefix pushing/popping the wrong address size from the stack. (GP-954, Issue #2976)
* _Processors_. Fixed issue with delay slots modifying some instructions in SuperH processor. (GP-969, Issue #2863)
* _Processors_. Corrected pcode for x86-64 `RDMSR` instruction. (GP-982, Issue #3046)
* _Processors_. Corrected size of 20-bit signed immediate value in PPC VLE `e_li` instruction. (GP-1060)
* _Scripting_. Fixed scripting bug where showing a TableChooserDialog while having `AnalysisMode.DISABLED` in use caused the dialog to be closed. (GP-1018, Issue #3103)
* _Sleigh_. Fixed multiple errors in x64 vector operation semantics. (GP-799)

# Ghidra 9.2.4 Change History (April 2021)

### Improvements
* _Basic Infrastructure_. Improved support running under JDK 16. Note that Ghidra still only officially supports JDK 11 LTS. (GP-824, Issue #2879, #2888)

### Bugs
* _API_. Corrected error condition which could occur if overlay memory block duplicates another memory space name or overlay block name in a case-insensitive manner. The names are intended to be case-sensitive. (GP-839, Issue #2898)
* _Demangler_. Improved handling of mangled names on thunk functions which were previously left unmangled and could prevent name of underlying thunked function from appearing. (GP-809)

# Ghidra 9.2.3 Change History (March 2021)

### Improvements
* _Analysis_. Added check for vftable entries in `.NEP` section and relaxed the requirement that the code must have a return. (GP-649)
* _Analysis_. Corrected flaw in RTTI analyzer determination of size of vftables. (GP-688)
* _Basic Infrastructure_. Updated TLS protocol preference to use the most preferred/recent version available to both sides of an SSL connection (e.g., TLSv1.3) instead of forcing use of TLSv1.2. (GP-622)
* _Build_. Corrected build issues which had prevented users from building Ghidra on an Apple M1 (OS X, AARCH64 architecture). (GP-600, Issue #2653)
* _Demangler_. Increased Gnu Demangler parsing performance by changing some regular expressions. (GP-705)
* _Eclipse Integration_. Updated SleighEditor to support new endian tag on define token definitions. (GP-721)
* _GUI_. Updated the Choose Data Type dialog to apply data types in the same manner as dragging types from the Data Types window. This provides users more control when choosing how to overwrite existing types. (GP-521)
* _Importer:ELF_. Added support for ELF relocation `R_X86_64_IRELATIVE`. (GP-651, Issue #1189)
* _Importer:ELF_. Sped up loading of ELF files with large symbol tables. (GP-697)

### Bugs
* _Analysis_. The RTTI analyzer now runs prior to Reference analysis so that references into vftables are not turned into code or data before the vftables are created. (GP-517)
* _API_. `Function.getCalledFunctions(TaskMonitor)` and `Function.getCallingFunctions(TaskMonitor)` now support passing `null` for the task monitor parameter, which previously would have thrown an exception. (GP-589, Issue #2643)
* _Data Types_. Corrected segmented 32-bit pointer datatype address generation for 16:16 x86 far pointers. (GP-534, Issue #2548)
* _Decompiler_. Fixed Decompiler issue where, when a function name extends beyond the line limit, an end-of-line comment could wrap around to additional lines without including additional `//` comment indicators. (GP-473)
* _Decompiler_. Corrected an exception that could occur when attempting to edit function signature from the Decompiler. (GP-597, Issue #2601)
* _Demangler_. Changed return type applied to constructors by Demangler from `void` to `Undefined`, allowing the Decompiler to determine the type. (GP-790)
* _DWARF_. Improved handling of empty DWARF compile units. (GP-743)
* _DWARF_. Improved handling of DWARF function signatures when parameter info contains unsupported location opcodes or failed to resolve datatypes. (GP-794)
* _Eclipse Integration_. When installing the SleighEditor into Eclipse, the plugin will now show up under the Ghidra category. Previously the Group Items by Category option had to be turned off before the SleighEditor would appear as a visible entry. (GP-564)
* _Eclipse Integration_. Fixed an issue with Eclipse PyDev breakpoints not catching. (GP-668, Issue #2713)
* _Eclipse Integration_. Fixed an Eclipse GhidraDev exception that occurred when creating a new Ghidra scripting project if a ~/ghidra_scripts directory did not exist. (GP-669)
* _Emulator_. Replaced Java floating point emulation to fix multiple rounding issues. (GP-357, Issue #2414)
* _Graphing_. Fixed issue with graph filters not updating satellite view when changing edge filters. (GP-557)
* _Graphing_. Fixed Function Graph keybindings that did not work when docked in the main Code Browser window. (GP-586, Issue #2641)
* _GUI_. Fixed NullPointerException due to using Go To action when there was no open program in the Listing. (GP-66)
* _GUI_. Fixed bug in Reference Code Viewer options that caused an exception. (GP-620, Issue #2672)
* _Importer_. Fixed exception caused when importing previously exported XML data where the bookmark override option was turned off. (GP-667)
* _Importer:ELF_. Fixed a NullPointerException caused by importing an ELF with an uninitialized `.got` section. (GP-360, Issue #2416)
* _Importer:ELF_. Added Support for ELF `R_ARM_MOVW_ABS_NC` and `R_ARM_MOVT_ABS ELF` Relocations for ARM. (GP-555, Issue #2510)
* _Importer:ELF_. Corrected ELF processing of `.init_array` and `.fini_array` which was incorrectly overadjusting entries for an image base change. (GP-699)
* _Importer:Mach-O_. Corrected Mach-O fat-binary library import issue and resolved error related to unnamed Mach-O segment. (GP-652, Issue #2702)
* _Importer:Mach-O_. Fixed an issue with DYLD Load Command data structures being created in the wrong locations. (GP-689, Issue #2624)
* _Importer:Mach-O_. Fixed an exception that occurred when importing Mach-O files that define zero `LC_BUILD_VERSION` tool entries. (GP-702, Issue #2192)
* _PDB_. Fixed createPdbXmlFiles.bat to permit spaces in the path name of Ghidra installation folder and the batch argument name. (GP-575, Issue #2167)
* _PDB_. Fixed PDB Universal analyzer to set the run-once flag when finished. (GP-724)
* _PDB_. Changed return type applied to constructors by PDB Universal from `void` to `Undefined`, allowing the Decompiler to determine the type. (GP-791)
* _Processors_. Added missing `RFE` instruction in MIPS up to version R3000. (GP-33, Issue #1766)
* _Processors_. ARM instruction `VMUL` now decodes correctly. (GP-627, Issue #2677)
* _Processors_. Added missing `CFINV` instruction to AARCH64 processor specification and added definitions for locals in neon instructions. (GP-655, Issue #2710)
* _Scripting_. Fixed analyzeHeadless `-scriptPath` option that didn't work for Python and other non-Java scripts located in non-default directories. (GP-528, Issue #2561)
* _Scripting_. Fixed concurrency issue with management of scripting bundle paths. (GP-576)
* _Scripting_. Corrected handling for Ghidra Script files which are symlinks that were broken in Ghidra 9.2. (GP-650, Issue #2698)
* _Scripting_. Fixed the analyzeHeadless `-scriptPath` option to correctly parse `$GHIDRA_HOME` and `$USER_HOME`. (GP-781)

# Ghidra 9.2.2 Change History (December 2020)

### Bugs
* _Graphing_. Fixed issue with Graph filters not working and satellite view sometimes not matching graph. (GP-526)
* _Importer:Mach-O_. Mach-O DYLD cache incorrect offset use has been fixed. (GP-550, Issue #2560)
* _Listing_. Fixed issue where Edit Label action (L key) did not work on primary function symbols. (GP-537)
* _Multi-User_. Corrected Ghidra Server build issue for version 9.2.1 which had an improperly generated classpath.frag file. Issue caused server to fail startup with a ClassNotFoundException. (GP-542)
* _Processors_. The V850 `JMP` instruction has been corrected not to use the PC in the address calculation. (GP-548, Issue #2570)
* _Processors_. Removed erroneous VST4 variant, most likely from a copy/paste error. This fixes the ARM Thumb BL instruction disassembly with a negative offset. (GP-549, Issue #2559)

# Ghidra 9.2.1 Change History (December 2020)

### Improvements
* _Analysis_. Updated RTTI analyzer to find `type_info` vftable when it cannot be found with its mangled name. This will enable many more Windows programs to have their RTTI structures created that were unable to be parsed in previous Ghidra versions. (GP-141)
* _API_. Relaxed memory block naming restrictions and restored ability to have spaces in memory block names. However, if a memory block is flagged as an overlay, the associated overlay space name may be modified to ensure validity and uniqueness. The DuplicateNameException has been removed from all memory block API methods since this was entirely an overlay space concern. Memory block GUI has also been changed eliminate the duplicate block name restriction. (GP-420, Issue #2465)
* _Build_. Eliminated the need for installation of bison and flex when performing source-based gradle build of Ghidra or the Decompiler module. The generated files are now included with source files and maintained in source control. A separate `gradle Decompiler:generateParsers` task, which still requires bison and flex, must be used, explicitly, when changes are made to lex/yacc source files. (GP-467)
* _Graphing_. Fixed issue with exporting graphs to DOT format due to invalid vertex IDs. (GP-280)
* _Graphing_. Improved graphing where it did not navigate when clicking on external function nodes. Now it will navigate to the fake function location in the program, which is the location of the pointer to the external function. (GP-493)
* _Listing:Symbols_. Removed restriction for naming labels that resemble default label names. (GT-3185, Issue #1057)
* _PDB_. Crafted PDB type ID records `0x1608` and `0x1609` with presumed class and struct types and follow-on application of these types. Also fixed up some fall-back data type logic and improved some warning messages to reflect the cause of the conditions. (GP-474, Issue #2523)
* _Scripting_. Removed unnecessary 1-second delay when launching a script. (GP-443)

### Bugs
* _Analysis_. Fixed the processing of CIL metadata that express arrays of non-primitive types. (GP-331)
* _API_. WrappedMemBuffer methods `getInt`, `getShort`, `getLong`, and `getBigInteger` have been fixed when allocated at a non-zero offset, wrapping another MemBuffer such as DumbMemBufferImpl. (GP-486)
* _Decompiler_. Fixed issue with the Auto Create/Fill Structure command that caused it to silently miss some pointer accesses. (GP-344)
* _Decompiler_. Jump table recovery now takes into account encoded bits, like ARM/THUMB mode transition, that may be present in address tables. (GP-387, Issue #2420)
* _Decompiler_. Fixed a bug in the Decompiler renaming action when applied to function references. (GP-477, Issue #2415)
* _Decompiler_. Corrected 8-byte return value storage specification in compiler-spec affecting `longlong` and `double` return values. Endianness ordering of `r0`/`r1` was incorrect. (GP-512, Issue #2547)
* _Graphing_. Fixed the Function Graph's drag-to-select-nodes feature. (GP-430)
* _Graphing_. Fixed issue where the graph in the satellite view is sometimes truncated. (GP-469)
* _Graphing_. Fixed a stack trace issue caused by reusing a graph display window to show a graph that is larger than is allowed. (GP-492)
* _Graphing_. Fixed issue where graph satellite view did not reflect main graph when graph vertices are hidden using hide actions or filters. (GP-514)
* _GUI_. Fixed stack overflow in TableChooserDialogs. (GP-460, Issue #2536)
* _PDB_. Corrected PDB parser selection bug affecting PDB load/download on Windows. (GP-390)
* _Processors_. Fixed handling of certain ARM/THUMB switch calculation functions. (GP-389)

# Ghidra 9.2 Change History (November 2020)

### New Features
* _Graphing_. A new graph service and implementation was created. The graph service provides basic graphing capabilities. It was also used to generate several different types of graphs including code block graphs, call graphs, and AST graphs. In addition, an export graph service was created that supports various formats. (GP-211)
* _PDB_. Added a new, prototype, platform-independent PDB analyzer that processes and applies data types and symbols to a program from a raw (non-XML-converted) PDB file, allowing users to more easily take advantage of PDB information. (GT-3112)
* _Processors_. Added M8C SLEIGH processor specification. (GT-3052)
* _Processors_. Added support for the RISC-V processor. (GT-3389, Issue #932)
* _Processors_. Added support for the Motorola 6809 processor. (GT-3390, Issue #1201)
* _Processors_. Added CP1600-series processor support. (GT-3426, Issue #1383)
* _Processors_. Added V850 processor module. (GT-3523, Issue #1430)

### Improvements
* _Analysis_. Increased the speed of the Embedded Media Analyzer, which was especially poor for large programs, by doing better checking and reducing the number of passes over the program. (GT-3258)
* _Analysis_. Improved the performance of the RTTI analyzer. (GT-3341, Issue #10)
* _Analysis_. The handling of Exception records found in GCC-compiled binaries has been sped up dramatically. In addition, incorrect code disassembly has been corrected. (GT-3374)
* _Analysis_. Updated Auto-analysis to preserve work when encountering recoverable exceptions. (GT-3599)
* _Analysis_. Improved efficiency when creating or checking for functions and namespaces which overlap. (GP-21)
* _Analysis_. Added partial support of Clang for Windows. (GP-64)
* _Analysis_. RTTI structure processing speed has been improved with a faster technique for finding the root RTTI type descriptor. (GP-168, Issue #2075)
* _API_. The performance of adding large numbers of data types to the same category has been improved. (GT-3535)
* _API_. Added the BigIntegerNumberInputDialog that allows users to enter integer values larger than `Integer.MAX_VALUE` (2147483647). (GT-3607)
* _API_. Made JSON more available using GSON. (GP-89, Issue #1982)
* _Basic Infrastructure_. Introduced an extension point `priority` annotation so users can control extension point ordering. (GT-3350, Issue #1260)
* _Basic Infrastructure_. Changed file names in launch.bat to always run executables from System32. (GT-3614, Issue #1599)
* _Basic Infrastructure_. Unknown platforms now default to 64-bit. (GT-3615, Issue #1499)
* _Basic Infrastructure_. Updated sevenzipjbinding library to version 16.02-2.01. (GP-254)
* _Build_. Ghidra's native Windows binaries can now be built using Visual Studio 2019. (GT-3277, Issue #999)
* _Build_. Extension builds now exclude gradlew artifacts from zip file. (GT-3631, Issue #1763)
* _Build_. Reduced the number of duplicated help files among the build jar files. (GP-57, Issue #2144)
* _Build_. Git commit hash has been added to application.properties file for every build (not just releases). (GP-67)
* _Contrib_. Extensions are now installed to the user's settings directory, not the Ghidra installation directory. (GT-3639, Issue #1960)
* _Data Types_. Added mutability data settings (constant, volatile) for Enum datatype. (GT-3415)
* _Data Types_. Improved Structure Editor's Edit Component action to work on array pointers. (GP-205, Issue #1633)
* _Decompiler_. Added Secondary Highlights to the Decompiler. This feature allows the user to create a highlight for a token to show all occurrences of that token. Further, multiple secondary highlights are allowed at the same time, each using a unique color. See the Decompiler help for more information. (GT-3292, Issue #784)
* _Decompiler_. Added heuristics to the Decompiler to better distinguish whether a constant pointer refers to something in the CODE or DATA address space, for Harvard architectures. (GT-3468)
* _Decompiler_. Improved Decompiler analysis of local variables with small data types, eliminating unnecessary casts and mask operations. (GT-3525)
* _Decompiler_. Documentation for the Decompiler, accessible from within the Code Browser, has been rewritten and extended. (GP-166)
* _Decompiler_. The Decompiler can now display the namespace path (or part of it) of symbols it renders. With the default display configuration, the minimal number of path elements necessary are printed to fully resolve the symbol within the current scope. (GP-236)
* _Decompiler_. The Decompiler now respects the Charset and Translate settings for string literals it displays. (GP-237)
* _Decompiler_. The Decompiler's analysis of array accesses is much improved. It can detect more and varied access patterns produced by optimized code, even if the base offset is not contained in the array. Multi-dimensional arrays are detected as well. (GP-238, Issue #461, #1348)
* _Decompiler_. Extended the Decompiler's support for analyzing class methods. The class data type is propagated through the this pointer even in cases where the full prototype of the method is not known. The methods `isThisPointer()` and `isHiddenReturn()` are now populated in HighSymbol objects and are accessible in Ghidra scripts. (GP-239, Issue #2151)
* _Decompiler_. The Decompiler will now infer a string pointer from a constant that addresses the interior of a string, not just the beginning. (GP-240, Issue #1502)
* _Decompiler_. The Decompiler now always prints the full precision of floating-point values, using the minimal number of characters in either fixed point or scientific notation. (GP-241, Issue #778)
* _Decompiler_. The Decompiler's Auto Create Structure command now incorporates into new structures data-type information from function prototypes. The Auto Fill in Structure variant of the command will override undefined and other more general data-types with discovered data-types if they are more specific. (GP-242)
* _Demangler_. Modified Microsoft Demangler (MDMang) to handle symbols represented by MD5 hash codes when their normal mangled length exceeds 4096. (GT-3409, Issue #1344)
* _Demangler_. Upgraded the GNU Demangler to version 2.33.1. Added support for the now-deprecated GNU Demangler version 2.24 to be used as a fallback option for demangling. (GT-3481, Issue #1195, #1308, #1451, #1454)
* _Demangler_. The Demangler now more carefully applies information if generic changes have been made. Previously if the function signature had changed in any way from default, the demangler would not attempt to apply any information including the function name. (GP-12)
* _Demangler_. Changed MDMang so cast operator names are complete within the qualified function name, effecting what is available from internal API. (GP-13)
* _Demangler_. Added additional MDMang Extended Types such as `char8_t`, `char16_t`, and `char32_t`. (GP-14)
* _Documentation_. Removed Eclipse BuildShip instructions from the DevGuide. (GT-3634, Issue #1735)
* _FID_. Regenerated FunctionID databases. Added support for Visual Studio versions 2017 and 2019. (GP-170)
* _Function Diff_. Users may now add functions ad-hoc to existing function comparison panels. (GT-2229)
* _Function Graph_. Added Navigation History Tool option for Function Graph to signal it to produce fewer navigation history entries. (GT-3233, Issue #1115)
* _GUI_. Users can now view the Function Tag window to see all functions associated with a tag, without having to inspect the Listing. (GT-3054)
* _GUI_. Updated the Copy Special action to work on the current address when there is no selection. (GT-3155, Issue #1000)
* _GUI_. Significantly improved the performance of filtering trees in the Ghidra GUI. (GT-3225)
* _GUI_. Added many optimizations to increase the speed of table sorting and filtering. (GT-3226, Issue #500)
* _GUI_. Improved performance of bit view component recently introduced to Structure Editor. (GT-3244, Issue #1141)
* _GUI_. Updated usage of timestamps in the UI to be consistent. (GT-3286)
* _GUI_. Added tool actions for navigating to the next/previous functions in the navigation history. (GT-3291, Issue #475)
* _GUI_. Filtering now works on all tables in the Function Tag window. (GT-3329)
* _GUI_. Updated the Ghidra File Chooser so that users can type text into the list and table views in order to quickly jump to a desired file. (GT-3396)
* _GUI_. Improved the performance of the Defined Strings table. (GT-3414, Issue #1259)
* _GUI_. Updated Ghidra to allow users to set a key binding to perform an equivalent operation to double-clicking the `XREF` field in the Listing. See the Show Xrefs action in the Tool Options... Key Bindings section. (GT-3446)
* _GUI_. Improved mouse wheel scrolling in Listing and Byte Viewers. (GT-3473)
* _GUI_. Ghidra's action context mechanism was changed so that actions that modify the program are not accidentally invoked in the wrong context, thus possibly modifying the program in ways the user did not want or without the user knowing that it happened. This also fixed an issue where the navigation history drop-down menu did not represent the locations that would be used if the next/previous buttons were pressed. (GT-3485)
* _GUI_. Updated Ghidra tables to defer updating while analysis is running. (GT-3604)
* _GUI_. Updated Font Size options to allow the user to set any font size. (GT-3606, Issue #160, #1541)
* _GUI_. Added ability to overlay text on an icon. (GP-41)
* _GUI_. Updated Ghidra options to allow users to clear default key binding values. (GP-61, Issue #1681)
* _GUI_. ToggleDirectionAction button now shows in snapshot windows. (GP-93)
* _GUI_. Added a new action to the Symbol Tree to allow users to convert a Namespace to a Class. (GP-225, Issue #2301)
* _Importer_. Updated the XML Loader to parse symbol names for namespaces. (GT-3293)
* _Importer:ELF_. Added support for processing Android packed ELF Relocation Tables. (GT-3320, Issue #1192)
* _Importer:ELF_. Added ELF import opinion for ARM BE8. (GT-3642, Issue #1187)
* _Importer:ELF_. Added support for ELF RELR relocations, such as those produced for Android. (GP-348)
* _Importer:Mach-O_. DYLD Loader can now load x86_64 DYLD from macOS. (GT-3611, Issue #1566)
* _Importer:PE_. Improved parsing of Microsoft ordinal map files produced with `DUMPBIN /EXPORTS` (see Ghidra/Features/Base/data/symbols/README.txt). (GT-3235)
* _Jython_. Upgraded Jython to version 2.7.2. (GP-109)
* _Listing_. In the PCode field of the Listing, accesses of varnodes in the `unique` space are now always shown with the size of the access. Fixed bug which would cause the PCode emulator to reject valid pcode in rare instances. (GP-196)
* _Listing:Data_. Improved handling and display of character sequences embedded in operands or integer values. (GT-3347, Issue #1241)
* _Multi-User:Ghidra Server_. Added ability to specify initial Ghidra Server user password (`-a0` mode only) for the svrAdmin add and reset commands. (GT-3640, Issue #321)
* _Processors_. Updated AVR8 ATmega256 processor model to reflect correct memory layout specification. (GT-933)
* _Processors_. Implemented semantics for `vstmia/db` `vldmia/db`, added missing instructions, and fixed shift value for several instructions for the ARM/Thumb NEON instruction set. (GT-2567)
* _Processors_. Added the XMEGA variant of the AVR8 processor with general purpose registers moved to a non-memory-mapped register space. (GT-2909)
* _Processors_. Added support for x86 `SALC` instruction. (GT-3367, Issue #1303)
* _Processors_. Implemented pcode for 6502 `BRK` instruction. (GT-3375, Issue #1049)
* _Processors_. Implemented x86 `PTEST` instruction. (GT-3380, Issue #1295)
* _Processors_. Added missing instructions to ARM language module. (GT-3394)
* _Processors_. Added support for `RDRAND` and `RDSEED` instructions to x86-32. (GT-3413)
* _Processors_. Improved x86 breakpoint disassembly. (GT-3421, Issue #872)
* _Processors_. Added manual index file for the M6809 processor. (GT-3449, Issue #1414)
* _Processors_. Corrected issues related to retained instruction context during a language upgrade. In some rare cases this retained context could interfere with the instruction re-disassembly. This context-clearing mechanism is controlled by a new pspec property: `resetContextOnUpgrade`. (GT-3531)
* _Processors_. Updated PIC24/PIC30 index file to match latest manual. Added support for dsPIC33C. (GT-3562)
* _Processors_. Added missing call-fixup to handle call side-effects for 32 bit GCC programs for `get_pc_thunk.ax/si`. (GP-10)
* _Processors_. Added `ExitProcess` to PEFunctionsThatDoNotReturn. (GP-35)
* _Processors_. External Disassembly field in the Listing now shows Thumb disassembly when appropriate TMode context has been established on a memory location. (GP-49)
* _Processors_. Changed RISC-V jump instructions to the more appropriate `goto` instead of `call`. (GP-54, Issue #2120)
* _Processors_. Updated AARCH64 to v8.5, including new MTE instructions. (GP-124)
* _Processors_. Added support for floating point params and return for SH4 processor calling conventions. (GP-183, Issue #2218)
* _Processors_. Added semantic support for many AARCH64 neon instructions. Addresses for register lanes are now precalculated, reducing the amount of p-code generated. (GP-343)
* _Processors_. Updated RISCV processor to include reorganization, new instructions, and fixes to several instructions. (GP-358, Issue #2333)
* _Program API_. Improved multi-threaded ProgramDB access performance. (GT-3262)
* _Scripting_. Improved ImportSymbolScript.py to import functions in addition to generic labels. (GT-3249, Issue #946)
* _Scripting_. Python scripts can now call protected methods from the GhidraScript API. (GT-3334, Issue #1250)
* _Scripting_. Updated scripting feature with better change detection, external jar dependencies, and modularity. (GP-4)
* _Scripting_. Updated the GhidraDev plugin (v2.1.1) to support Python Debugging when PyDev is installed via the Eclipse dropins directory. (GP-186, Issue #1922)
* _Sleigh_. Error messages produced by the SLEIGH compiler have been reformatted to be more consistent in layout as well as more descriptive and more consistent in providing line number information. (GT-3174)

### Bugs
* _Analysis_. Function start patterns found at 0x0, function signatures applied from the Data Type Manager at 0x0, and DWARF debug symbols applied at 0x0 will no longer cause stack traces. In addition, DWARF symbols with zero length address range no longer stack trace. (GT-2817, Issue #386, #1560)
* _Analysis_. Constant propagation will treat an OR with zero (0) as a simple copy. (GT-3548, Issue #1531)
* _Analysis_. Corrected Create Structure from Selection, which failed to use proper data organization during the construction process. This could result in improperly sized components such as pointers and primitive types. (GT-3587)
* _Analysis_. Fixed an issue where stored context is initializing the set of registers constantly. (GP-25)
* _Analysis_. Fixed an RTTI Analyzer regression when analyzing RTTI0 structures with no RTTI4 references to them. (GP-62, Issue #2153)
* _Analysis_. Fixed an issue where the RTTI analyzer was not filling out RTTI3 structures in some cases. (GP-111)
* _API_. Fixed NullPointerException when attempting to delete all bookmarks from a script. (GT-3405)
* _API_. Updated the Class Searcher so that Extension Points found in the Ghidra/patch directory get loaded. (GT-3547, Issue #1515)
* _Build_. Updated dependency fetch script to use HTTPS when downloading CDT. (GP-69, Issue #2173)
* _Build_. Fixed resource leak in Ghidra jar builder. (GP-342)
* _Byte Viewer_. Fixed Byte Viewer to correctly load the middle-mouse highlight color options change. (GT-3471, Issue #1464, #1465)
* _Data Types_. Fixed decoding of static strings that have a character set with a smaller character size than the platform's character size. (GT-3333, Issue #1255)
* _Data Types_. Correctly handle Java character sets that do not support the encoding operation. (GT-3407, Issue #1358)
* _Data Types_. Fixed bug that caused Data Type Manager Editor key bindings to get deleted. (GT-3411, Issue #1355)
* _Data Types_. Updated the DataTypeParser to handle data type names containing templates. (GT-3493, Issue #1417)
* _Data Types_. Corrected pointer data type `isEquivalent()` method to properly check the equivalence of the base data type. The old implementation could cause a pointer to be replaced by a conflicting pointer with the same name whose base datatype is not equivalent. This change has a negative performance impact associated with it and can cause additional conflict datatypes due to the rigid datatype relationships. (GT-3557)
* _Data Types_. Improved composite conflict resolution performance and corrected composite merge issues when composite bitfields and/or flexible arrays are present. (GT-3571)
* _Data Types_. Fixed bug in SymbolPathParser naive parse method that caused a less-than-adequate fall-back parse when angle bracket immediately followed the namespace delimiter. (GT-3620)
* _Data Types_. Corrected size of `long` for AARCH64 per LP64 standard. (GP-175)
* _Decompiler_. Fixed bug causing the Decompiler to miss symbol references when they are stored to the heap. (GT-3267)
* _Decompiler_. Fixed bug in the Decompiler that caused `Deleting op with descendants` exception. (GT-3506)
* _Decompiler_. Decompiler now correctly compensates for integer promotion on shift, division, and remainder operations. (GT-3572)
* _Decompiler_. Fixed handling of 64-bit implementations of alloca_probe in the Decompiler. (GT-3576)
* _Decompiler_. Default Decompiler options now minimize the risk of losing code when renaming or retyping variables. (GT-3577)
* _Decompiler_. The Decompiler no longer inherits a variable name from a subfunction if that variable incorporates additional data-flow unrelated to the subfunction. (GT-3580)
* _Decompiler_. Fixed the Decompiler Override Signature action to be enabled on the entire C-code statement. (GT-3636, Issue #1589)
* _Decompiler_. Fixed frequent ClassCast and IllegalArgument exceptions when performing Auto Create Structure or Auto Create Class actions in the Decompiler. (GP-119)
* _Decompiler_. Fixed a bug in the Decompiler that caused different variables to be assigned the same name in rare instances. (GP-243, Issue #1995)
* _Decompiler_. Fixed a bug in the Decompiler that caused `PTRSUB off of non-pointer type` exceptions. (GP-244, Issue #1826)
* _Decompiler_. Fixed a bug in the Decompiler that caused load operations from volatile memory to be removed as dead code. (GP-245, Issue #393, #1832)
* _Decompiler_. Fixed a bug causing the Decompiler to miss a stack alias if its offset was, itself, stored on the stack. (GP-246)
* _Decompiler_. Fixed a bug causing the Decompiler to lose Equate references to constants passed to functions that were called indirectly. (GP-247)
* _Decompiler_. Addressed various situations where the Decompiler unexpectedly removes active instructions as dead code after renaming or retyping a stack location. If the location was really an array element or structure field, renaming forced the Decompiler to treat the location as a distinct variable. Subsequently, the Decompiler thought that indirect references based before the location could not alias any following stack locations, which could then by considered dead. As of the 9.2 release, the Decompiler's renaming action no longer switches an annotation to `forcing` if it wasn't already. A retyping action, although it is `forcing`, won't trigger alias blocking for atomic data-types (this is configurable). (GP-248, Issue #524, #873)
* _Decompiler_. Fixed decompiler memory issues reported by a community security researcher. (GP-267)
* _Decompiler_. Fix for Decompiler error: `Pcode: XML comms: Missing symref attribute in <high> tag`. (GP-352, Issue #2360)
* _Decompiler_. Fixed bug preventing the Decompiler from seeing Equates attached to compare instructions. (GP-369, Issue #2386)
* _Demangler_. Fixed the GnuDemangler to parse the full namespace for `operator` symbols. (GT-3474, Issue #1441, #1448)
* _Demangler_. Fixed numerous GNU Demangler parsing issues. Most notable is the added support for C++ Lambda functions. (GT-3545, Issue #1457, #1569)
* _Demangler_. Updated the GNU Demangler to correctly parse and apply C++ strings using the `unnamed type` syntax. (GT-3645)
* _Demangler_. Fixed duplicate namespace entry returned from `getNamespaceString()` on DemangledVariable. (GT-3646, Issue #1729)
* _Demangler_. Fixed a GnuDemangler ClassCastException when parsing a `typeinfo` string containing `operator` text. (GP-160, Issue #1870, #2267)
* _Demangler_. Added stdlib.h include to the GNU Demangler to fix a build issue on some systems. (GP-187, Issue #2294)
* _DWARF_. Corrected DWARF relocation handling where the address image base adjustment was factored in twice. (GT-3330)
* _File Formats_. Fixed a potential divide-by-zero exception in the EXT4 file system. (GT-3400, Issue #1342)
* _File Formats_. Fixed date and time parsing of dates in cdrom `iso9660` image files. (GT-3451, Issue #1403)
* _Graphing_. Fixed a ClassCastException sometimes encountered when performing Select -> Scoped Flow -> Forward Scoped Flow. (GP-180)
* _GUI_. Fixed inconsistent behavior with the interactive python interpreter's key bindings. (GT-3282)
* _GUI_. Fixed Structure Editor bug that prevented the F2 Edit action from editing the correct table cell after using the arrow keys. (GT-3308, Issue #703)
* _GUI_. Updated the Structure Editor so the Delete action is put into a background task to prevent the UI from locking. (GT-3352)
* _GUI_. Fixed IndexOutOfBoundsException when invoking column filter on Key Bindings table. (GT-3445)
* _GUI_. Fixed the analysis log dialog to not consume all available screen space. (GT-3610)
* _GUI_. Fixed issue where Location column, when used in the column filters, resulted in extraneous dialogs popping up. (GT-3623)
* _GUI_. Fixed Data Type Preview copy action so that newlines are preserved; updated table export to CSV to escape quotes and commas. (GT-3624)
* _GUI_. Fixed tables in Ghidra to copy the text that is rendered. Some tables mistakenly copied the wrong value, such as the Functions Table's Function Signature Column. (GT-3629, Issue #1628)
* _GUI_. Structure editor name now updates in title bar and tab when structure is renamed. (GP-19)
* _GUI_. Fixed an issue where drag-and-drop import locks the Windows File Explorer source window until the import dialog is closed by the user. (GP-27)
* _GUI_. Fixed an issue in GTreeModel where fireNodeChanged had no effect. This could result in stale node information and truncation of the text associated with a node in a GTree. (GP-30)
* _GUI_. Fixed an issue where the file chooser directory list truncated filenames with ellipses on HiDPI Windows. (GP-31)
* _GUI_. Fixed an uncaught exception when double-clicking on `UndefinedFunction_` in Decompiler window. (GP-40)
* _GUI_. Updated error handling to only show one dialog when a flurry of errors is encountered. (GP-65, Issue #2185)
* _GUI_. Fixed an issue where Docking Windows are restored incorrectly if a snapshot is present. (GP-92)
* _GUI_. Fixed a File Chooser bug causing a NullPointerException for some users. (GP-171, Issue #1706)
* _GUI_. Fixed an issue that caused the script progress bar to appear intermittently. (GP-179, Issue #1819)
* _GUI_. Fixed a bug that caused Call Tree nodes to go missing when showing more than one function with the same name. (GP-213, Issue #1682)
* _GUI:Project Window_. Fixed Front End copy action to allow for the copy of program names so that users can paste those names into external applications. (GT-3403, Issue #1257)
* _Headless_. Headless Ghidra now properly honors the `-processor` flag, even if the specified processor is not a valid opinion. (GT-3376, Issue #1311)
* _Importer_. Corrected an NeLoader flags parsing error. (GT-3381, Issue #1312)
* _Importer_. Fixed the File -> Add to Program... action to not show a memory conflict error when the user is creating an overlay. (GT-3491, Issue #1376)
* _Importer_. Updated the XML Importer to apply repeatable comments. (GT-3492, Issue #1423)
* _Importer_. Fixed issue in Batch Import where only one item of a selection was removed when attempting to remove a selection of items. (GP-138)
* _Importer_. Corrected various issues with processing crushed PNG images. (GP-146, Issue #1854, #1874, #1875, #2252)
* _Importer_. Fixed RuntimeException occurrence when trying to load NE programs with unknown resources. (GP-182, Issue #1596, #1713, #2012)
* _Importer_. Fixed batch import to handle IllegalArgumentExceptions thrown by loaders. (GP-227, Issue #2328)
* _Importer:ELF_. Corrected ELF relocation processing for ARM BE8 (mixed-endian). (GT-3527, Issue #1494)
* _Importer:ELF_. Corrected ELF relocation processing for `R_ARM_PC24` (Type: 1) that was causing improper flow in ARM disassembly. (GT-3654)
* _Importer:ELF_. Corrected ELF import processing of `DT_JMPREL` relocations and markup of associated PLT entries. (GP-252, Issue #2334)
* _Importer:PE_. Fixed an IndexOutOfBoundsException in the PeLoader that occurred when the size of a section extends past the end of the file. (GT-3433, Issue #1371)
* _Listing:Comments_. Fixed bug in Comment field that prevented navigation when clicking on an address or symbol where tabs were present in the comment. (GT-3440)
* _Memory_. Fixed bug where sometimes random bytes are inserted instead of `0x00` when expanding a memory block. (GT-3465)
* _Processors_. Corrected the offset in SuperH instructions generated by sign-extending a 20-bit immediate value composed of two sub-fields. (GT-3251, Issue #1161)
* _Processors_. Fixed AVR8 addition/subtraction flag macros. (GT-3276)
* _Processors_. Corrected `XGATE` `ROR` instruction semantics. (GT-3278)
* _Processors_. Corrected semantics for SuperH `movi20` and `movi20s` instructions. (GT-3337, Issue #1264)
* _Processors_. Corrected SuperH floating point instruction token definition. (GT-3340, Issue #1265)
* _Processors_. Corrected SuperH `movu.b` and `movu.w` instruction semantics. (GT-3345, Issue #1271)
* _Processors_. Corrected AVR8 `lpm` and `elpm` instruction semantics. (GT-3346, Issue #631)
* _Processors_. Corrected pcode for the 6805 `BSET` instruction. (GT-3366, Issue #1307)
* _Processors_. Corrected ARM constructors for instructions `vnmla`, `vnmls`, and `vnmul`. (GT-3368, Issue #1277)
* _Processors_. Corrected bit-pattern for ARM `vcvt` instruction. (GT-3369, Issue #1278)
* _Processors_. Corrected TriCore `abs` instructions. (GT-3379, Issue #1286)
* _Processors_. Corrected x86 `BT` instruction semantics. (GT-3423, Issue #1370)
* _Processors_. Fixed issue where CRC16C `LOAD`/`STOR` with `abs20` were not mapped correctly. (GT-3529, Issue #1518)
* _Processors_. Fixed M68000 `MOVE USP,x` and `MOVE x,USP` opcodes. (GT-3594, Issue #1593)
* _Processors_. Fixed the ARM/Thumb `TEQ` instruction pcode to be an XOR. (GP-23, Issue #1802)
* _Processors_. Emulation was broken by a regression in version 9.1.2. Emulation and Sleigh Pcodetests now work correctly. (GP-24, Issue #1579)
* _Processors_. Fixed carry flag issue for 6502 `CMP`, `CPX`, and `CPY` instructions. (GP-34)
* _Processors_. Corrected the SuperH high-order bit calculation for the `rotr` instruction. (GP-47)
* _Processors_. Corrected ELF ARM relocation processing for type 3 (`R_ARM_REL32`) and added support for type 42 (`R_ARM_PREL31`). (GP-164, Issue #2261, #2276)
* _Scripting_. Moved Jython cache directory out of tmp. (GP-36)
* _Scripting_. Fixed a NoClassDefFoundError when compiling GhidraScript under JDK14. (GP-59, Issue #2152)
* _Scripting_. Fixed issues with null result when searching for the script directory. (GP-103, Issue #2187)
* _Scripting_. Fixed scripting issue where, if there were non-ASCII characters in the user path, Jython would not work. (GP-204, Issue #1890)
* _Sleigh_. Corrected IndexOutOfBoundsException in SLEIGH when doing simple assignment in disassembly actions block. (GT-3382, Issue #745)
* _Symbol Tree_. Fixed the Symbol Tree so that clicking an already-selected symbol node will still trigger a Listing navigation. (GT-3436, Issue #453)
* _Symbol Tree_. Fixed the Symbol Tree to not continuously rebuild while performing Auto-analysis. (GT-3542)
* _Version Tracking_. Fixed Version Tracking Create Manual Match action. (GT-3305, Issue #2215)
* _Version Tracking_. Fixed a NullPointerException encountered when changing the Version Tracking options for the Listing Code Comparison when no data was loaded. (GT-3437, Issue #1143)
* _Version Tracking_. Fixed Version Tracking exception triggered in the Exact Functions Instructions Match correlator encountered when the two functions being compared differed in their number of instructions. (GT-3438, Issue #1352)

# Ghidra 9.1.2 Change History (February 2020)

### Bugs
* _Data Types_. Improved PDB composite reconstruction to attempt `pack(1)` alignment if default alignment fails. (GT-3401)
* _Data Types_. Added missing support for multi-user merge of unions and structures containing bitfields or a trailing flexible array member. (GT-3479)
* _Data Types_. Corrected structure editor save button enablement issue when editing bitfields within a non-packed structure. (GT-3519, Issue #1297)
* _Disassembly_. Corrected potential infinite loop with disassembler caused by branch to self with invalid delay slot instruction. (GT-3511, Issue #1486)
* _GUI_. Corrected processor manual display for Microsoft Windows users, which was not displaying processor manual and was, instead, rendering a blank page in web browser. (GT-3444)
* _GUI:Bitfield Editor_. Added field comment support to composite bitfield editor. (GT-3410)
* _Importer:Mach-O_. A Mach-O loader regression, in Ghidra 9.1.1, when laying down symbols at the correct location, has been fixed. (GT-3487, Issue #1446)
* _Multi-User:Ghidra Server_. Corrected Ghidra Server remote interface errors that occur when running with Java 11.0.6 (and later) release, which would throw RemoteException `Method is not Remote` errors. (GT-3521, Issue #1440)
* _PDB_. Corrected PDB XML generation for zero-length classes and structures and resolved various datatype dependency issues encountered during PDB Analysis. Changed line numbers from hex to decimal. (GT-3462, Issue #1410)
* _Processors_. Corrected mnemonic for ARM thumb `RSB.w` instruction. (GT-3420, Issue #1365)
* _Processors_. Corrected issue in M68000 with some move instructions not creating correct array assignments. (GT-3429, Issue #1394)
* _Processors_. Updated x86 processor manual index file with latest Intel and AMD manuals. (GT-3489, Issue #1078)

# Ghidra 9.1.1 Change History (December 2019)

### Improvements
* _Importer:Mach-O_. Improved import/load time of DYLD shared cache files. (GT-3261)
* _Program API_. Cached the addresses that correspond to executable memory to improve analysis performance. (GT-3260)

### Bugs
* _Analysis_. Fixed a symbol name error that occurred in the Objective-C analyzer. (GT-3321, Issue #1200)
* _Analysis_. Constant references are now computed correctly within functions in overlay spaces. (GT-3373)
* _Build_. Corrected build of DMG.jar which was improperly built within Ghidra 9.1 release. (GT-3364)
* _Decompiler_. Fixed bug causing `Pcode: XML comms: Badly formed address` errors when decompiling HCS12 `XGATE` code. (GT-3297)
* _Decompiler_. Fixed `Array DataType must be Fixed length` exceptions related to function pointer data types. (GT-3309)
* _Decompiler_. Fixed bug causing decompiler to drop statements, assigning string constants to global variables. (GT-3315)
* _Decompiler_. Fixed issue with enum name strings causing `Low-level Error: XML error: syntax error` in the decompiler. (GT-3387, Issue #1329)
* _GUI_. Fixed a potential ConcurrentModificationException in the interactive python interpreter. (GT-3280)
* _Importer:PE_. Fixed an exception in the PeLoader that occurred when the size of the memory block for the headers is larger than the file size. (GT-3344, Issue #1266)
* _Listing_. Fixed missing scroll bar in listing. (GT-3290)
* _Listing_. Fixed issue that was causing a stack trace to be generated when contiguous addresses were cleared for a range greater than `Integer.MAX`. (GT-3357)
* _Listing:References_. Corrected Create Default Reference action bug which did not handle composite/array data components properly. (GT-3371)
* _Processors_. Corrected Sparc floating point instruction pcode implementation. (GT-3202)
* _Processors_. Corrected the semantics of the PowerPC `e_cmpi` instruction. (GT-3228, Issue #1127)
* _Processors_. Corrected bit generation for PowerPC instructions `se_bclri`, `se_bgeni`, `se_bseti`, and `se_btsti`. (GT-3232, Issue #967)
* _Processors_. Corrected register definitions for x86 `RDRAND` instruction. (GT-3253, Issue #1169)
* _Processors_. Corrected signed immediate calculation for some powerPC VLE offsets being incorrect. (GT-3254, Issue #1160)
* _Processors_. Resolved issue with x86 escape opcodes preventing certain instruction patterns from decoding. (GT-3256)
* _Processors_. Corrected bug in `XGATE` `LDH` instruction shifting out high bits. (GT-3268)
* _Processors_. Corrected processing of `R_MIPS_REL32`, `R_X86_64_RELATIVE`, and `R_X86_64_RELATIVE64` ELF relocations affecting relocatable binaries which have non-zero section/segment load addresses. (GT-3349)

# Ghidra 9.1 Change History (October 2019)

### New Features
* _Data Types_. Added bit-field support to Structure and Union editor. An additional Bit-field Editor was also added for explicit bit-field placement within non-packed structures. (GT-559)
* _Eclipse Integration_. Added new GhidraSleighEditor Eclipse plugin in the installation directory under Extensions/Eclipse. (GT-113)
* _GUI_. Added method for turning off table sorting by control-clicking the only sorted table column. (GT-2763, Issue #87)
* _GUI_. Hovering on an address will now show where the byte at that address came from in the imported file. (GT-3016, Issue #154)
* _Importer:Mach-O_. Added new importer/loader for DYLD-shared cache files. (GT-2343)
* _Memory_. Added new API to preserve imported program's original bytes and how they map to memory blocks. (GT-2845)
* _Processors_. Implemented Intel MCS-96 processor module. (GT-2350)
* _Processors_. Added SH1/2/2a sleigh processor specification. (GT-3029, Issue #715)
* _Processors_. Added Tricore processor specification. (GT-3041, Issue #567)
* _Processors_. Added HCS12X processor specification. (GT-3049)
* _Processors_. Added HCS05 and HCS08 sleigh processor specifications. (GT-3050)
* _Processors_. Added SH4 sleigh processor specification. (GT-3051, Issue #37)
* _Processors_. Added MCS-48 processor specification. (GT-3058, Issue #638)
* _Program API_. Added Bit-field support for structures and unions.
Warning: Version upgrade will be forced on all modified programs and data type archives that are open for update. (GT-557)
* _Sleigh_. Added two new extension modules (SleighDevTools and GnuDisassembler) in support of processor module development. Added support for pcode junit tests which utilize emulation of cross-compiled C test code to verify sleigh pcode (i.e., instruction semantics). The SleighDevTools extension provides the pcode test C source and associated build scripts, as well as external disassembler support for aiding in the validation of disassembled instruction syntax. (GT-3067)

### Improvements
* _Analysis_. Added example script, ResolveX86orX64LinuxSyscallsScript.java, for decompiling Linux system calls in x86 and x64. Added syscall-related exercises to Advanced class. (GT-3113)
* _Basic Infrastructure_. Made bash scripts more portable, allowing Ghidra to be launched on additional platforms. (GT-2742, Issue #347)
* _Build_. Created a new Gradle task that automates some installation procedures defined in DevGuide.md. (GT-2897)
* _Build_. The build now allows newer versions of Gradle to be used. (GT-3017, Issue #737)
* _Data Types_. All DataType archives have been regenerated to support the new bit-field functionality. (GT-2878)
* _Data Types_. CategoryPath now accepts forward slashes in its components. (GT-2961)
* _Data Types_. Fixed Structure Editor bug that caused the Data Type field of a row to be edited after a successful name field edit. (GT-3109, Issue #703)
* _Decompiler_. Most forms of unnecessary or redundant copy statements are now removed from the decompiler output. (GT-2839)
* _Decompiler_. Added ability to double-click a Decompiler brace syntax token to navigate to the matching brace. (GT-2846)
* _Decompiler_. Updated the Decompiler to navigate to the label of a `goto` statement when that label is double-clicked. (GT-2847)
* _Decompiler_. Updated the Decompiler's Copy action to copy the symbol under the cursor when there is no selection. (GT-2914, Issue #411)
* _Decompiler_. Fixed broken External Navigation: Navigate to External Program option found in Edit -> Tool Options.... (GT-2932)
* _Decompiler_. The decompiler's logic for handling optimized division has been updated to recognize forms typically found in executables generated with more recent 64-bit compilers. (GT-2968, Issue #668)
* _Decompiler_. Implemented call-fixup for x64 `__chkstk` function. (GT-3006, Issue #670, #671)
* _Decompiler_. The decompiler simplifies many new sign-bit extraction forms used in optimized division and comparison expressions. (GT-3036)
* _Decompiler_. Ghidra now supports protected mode addressing when analyzing 16-bit x86 programs. This is the default variant when analyzing NE format executables, but it can also be used for MZ (and other) formats. (GT-3090, Issue #98)
* _Decompiler_. Added the Show References to Address and Find References to _Symbol_ actions to the Decompiler. Added Find Uses of _Field_ action to the Structure Editor. (GT-3115, Issue #474, #542, #543)
* _Decompiler_. Updated the Decompiler's Edit Data Type action to work on more fields. (GT-3116, Issue #275, #511)
* _Decompiler_. Renaming a single parameter within the decompiler window no longer prevents the data types of parameters from floating. Retyping a single parameter locks the data type for that parameter but no longer prevents the data types of other parameters from floating. (GT-3162)
* _Documentation_. Fixed typos and other errors in GitHub-related documentation. (GT-2748, Issue #345, #361, #370, #375, #398)
* _Documentation_. Added documentation to the DevGuide.md on how to run unit/integration tests. (GT-3046, Issue #815, #832)
* _DWARF_. Corrected DWARF analysis to handle binaries that are imported at non-default locations. (GT-2963, Issue #637)
* _Emulator_. Added improved emulation support at the API level including a simplified API exposed via the EmulatorHelper class. Sample GhidraScripts, which utilize this API, have been provided. (GT-3066)
* _Function Graph_. Updated the Function Graph to show the current program selection when zoomed out. (GT-2735)
* _Function Graph_. Added an option to the Function Graph to allow more complex edge routing that will go around non-incident vertices. See the Tool Options for more information and to enable this feature. (GT-3019, Issue #811)
* _Function Graph_. Fixed Function Graph edge layout bugs that caused some edges to get clipped by vertices. (GT-3161)
* _GUI_. Added listener to Script Table Chooser Dialog that will get notified when the dialog closes. (GT-2216)
* _GUI_. Fixed global Tool auto-save option so that it persists between Ghidra sessions. (GT-2818, Issue #231)
* _GUI_. Added the apple.laf.useScreenmenuBar option to hoist the menu bar out of the window on macOS. The option is off by default but can be activated in support/launch.properties. (GT-2859, Issue #562)
* _GUI_. Updated the Repeat Text Search/Repeat Memory Search menu items to show the search dialog for long searches. (GT-2872, Issue #585)
* _GUI_. Updated Structure Editor to allow user key bindings to work. (GT-2894, Issue #504)
* _GUI_. Python interpreter key bindings for sending reset and interrupt commands are now configurable. (GT-2901, Issue #588)
* _GUI_. Tweaked default graphic settings in support/launch.properties to support a wider range of displays out-of-the-box. (GT-2913, Issue #341)
* _GUI_. Added the ability to assign key bindings to activate individual component providers. (GT-2925, Issue #539)
* _GUI_. Fixed rendering issue in the Search Results table's Preview column. (GT-2942, Issue #550)
* _GUI_. Updated the Function Signature Editor's Data Type Chooser dialog to allow for keyboard navigation. (GT-3110, Issue #636)
* _GUI_. Fixed NullPointerException in the DB Viewer component. (GT-3163, Issue #1023)
* _Importer_. Updated x86 16-bit processor binding for IDA. (GT-3004, Issue #771)
* _Importer:ELF_. Improved ELF loader ability to cope with malformed headers including negative file offsets and missing section names. (GT-2933, Issue #35)
* _Importer:PE_. PeLoader better accounts for section alignment when laying out memory blocks, allowing additional bytes from the file to be loaded into memory. (GT-2827, Issue #327, #418)
* _Importer:PE_. Removed out-of-place call to demangler and laying down of types from PeLoader. This fix enables demangling and other analyzers to be applied correctly and in the proper order. (GT-2849)
* _Importer:PE_. PeLoader now adds TLS callback functions as entry points. (GT-2898, Issue #102)
* _Listing_. Updated Listing to support horizontal scrolling by holding the Shift key when using the mouse wheel. (GT-3105, Issue #451)
* _Listing:References_. Created new overriding reference types, which improve and extend the ability to override calls, jumps, and callothers. (GT-2885)
* _Multi-User_. Added a script to allow repository admins the ability to terminate multiple file checkouts belonging to an individual user on a shared project. (GT-2893)
* _Multi-User:Ghidra Server_. Added additional Ghidra Server authentication modes including: Active Directory via Kerberos and JAAS. The JAAS framework can facilitate use of LDAP, PAM, and other JAAS-supported extensions which utilize a login name and password. (GT-2658)
* _Multi-User:Ghidra Server_. Changed Ghidra Server repositories storage to ignore file/folder names which start with a period. This will impose a restriction on naming of Ghidra projects where they can no longer start with a period. (GT-3218)
* _PDB_. Now using HTTPS for Microsoft symbol server URL. (GT-2819, Issue #369)
* _PDB_. PDB processing can now store data types that contain forward slashes under a CategoryPath. (GT-2974, Issue #94, #182)
* _PDB_. PDB Analyzer no longer automatically includes the PDB path specified in the program's PE header when searching for the PDB. However, the filename in this path is considered during the search. The analyzer's Unsafe: Include PE PDB Path in PDB Search option allows the user to revert to the original PDB search algorithm. (GT-3076, Issue #277)
* _Processors_. Added new Task Monitor service to better handle user experience when there are delays in building languages. (GT-2376)
* _Processors_. Corrected ARM/Thumb instruction parsing for Thumb `bl` and `add` instructions. (GT-2744, Issue #362)
* _Processors_. Added AVR8 manual index file. (GT-2828, Issue #346)
* _Processors_. Improved support for ARM on Windows. (GT-2880)
* _Processors_. M68000 `LSL.W`, `ASL.B`, `LSL.B`, and `ASL.W` instructions now correctly set the `CF` flag. (GT-2907, Issue #619)
* _Processors_. Updated x86 manual index files. (GT-2943, Issue #366)
* _Processors_. Improved macro label-related error reporting in slaspec files. (GT-2995, Issue #522)
* _Processors_. Added MIPS special `0x1f` patterns. (GT-3005, Issue #709)
* _Processors_. Added proper updating of the `X` condition flag register for the M68000 processor `lsl` and `lsr` instructions. (GT-3137, Issue #983)
* _Processors_. Implemented PowerPc VLE Interrupt Handler Efficiency Instructions. (GT-3143, Issue #935)
* _Processors_. Ghidra now correctly models SPARC 64-bit stack bias. (GT-3201)
* _Processors_. Updated AVR32 instruction manual index to latest version. (GT-712)
* _Program API_. Added SHA256 hash to Program metadata and API. (GT-2753, Issue #331)
* _Scripting_. Updated Script Table Chooser Dialog: to fix bug with tracking work items, to add new API methods for item removal and dialog closed notification, and to prevent the same item from being worked on more than once. (GT-2724, Issue #307)
* _Scripting_. Fixed MultiInstructionMemReference Ghidra script to place the reference correctly on instructions with a delay slot. (GT-2906)
* _Sleigh_. The sleigh compiler now reports line numbers for the `-n` NOP command line option. (GT-2905, Issue #561)
* _Sleigh_. SLEIGH compiler now warns when building an operand in a constructor may unintentionally overwrite another operand. (GT-3085)
* _Testing:Junits_. `test.gradle getLogFileUrl()` no longer searches user .dir for log4j properties file. (GT-2834, Issue #499)
* _Testing:Junits_. Added new Gradle task to run integration tests and generate an HTML report. (GT-3060, Issue #870)
* _Tool_. Fixed bug that caused an exported tool to exclude plugin configuration settings. (GT-3193, Issue #1065)

### Bugs
* _Analysis_. Fixed an exception in the EmbeddedMediaAnalyzer that occurred when media was discovered at the very end of the address space. (GT-2890)
* _Analysis_. Recognition and disassembly of the `FMA`, `F16C`, and several missing `AVX` instructions have been added to the base x86 processor specification. The pcode for these instructions is pseudo-op and not a full pcode implementation. (GT-3168)
* _Basic Infrastructure_. Updated the apache-commons-lang3 library to version 3.9 which supports Java 11. (GT-2879)
* _Basic Infrastructure_. Prevented Ghidra from launching with 32-bit Java installations. (GT-3146, Issue #882)
* _Data Types_. Corrected string data default label generation when defined within uninitialized memory, which will now render as `STRING__address_`. (GT-2715, Issue #272)
* _Data Types_. Improved ASCII string data handling for processors with a char size greater than one (1). (GT-2842)
* _Data Types_. Changed BooleanDataType to extend AbstractIntegerDataType including support as a bit-field. (GT-3170)
* _DbViewer_. Corrected concurrent modification issue within DbViewer resulting in NullPointerException. (GT-3192, Issue #1076)
* _Decompiler_. Fixed aliasing issue where the decompiler would sometimes drop initialization or other code writing to the stack. (GT-2369)
* _Decompiler_. Fixed bug causing the decompiler to incorrectly omit the display of infinite loops when they contained switch statements. (GT-2852, Issue #443)
* _Decompiler_. Integer extension casts are no longer printed in the decompiler if the extension is implied. (GT-2857)
* _Decompiler_. Improved handling of overlay spaces. In particular, the decompiler is now able to handle references into overlays defined on the OTHER space. Added SLEIGH version numbers. (GT-2873)
* _Decompiler_. Updated the Decompiler to place the cursor on the function signature when a function is decompiled. (GT-2882)
* _Decompiler_. Fixed a common source of `Data type does not fit` errors when using the Retype actions in the decompiler. (GT-2956)
* _Decompiler_. Fixed `equals()` method in Varnode AST. (GT-2959, Issue #677)
* _Decompiler_. Users can no longer rename undefined functions from the decompiler. (GT-3043, Issue #753)
* _Decompiler_. Fixed a bug that did not allow the prototype for a specific CALL to an external function to be overridden in the decompiler. (GT-3145)
* _Decompiler_. Restricted Auto Fill in Structure command to operate only on pointer variables. (GT-3182)
* _Decompiler_. Fixed bug in the analysis of stack variables for SPARC, which caused extraneous local variables and missed stack parameters in the decompiler. (GT-3200)
* _Decompiler_. Fixed one source of `Type propagation algorithm not settling` warnings in the decompiler. (GT-3213, Issue #839)
* _Decompiler:Java_. Updated Decompiler's hovers to show preview for data types on variables and return types. (GT-2629)
* _Decompiler:Java_. Fixed error involving decompilation of certain `invokedynamic` instructions in JVM class files. Made numerous minor improvements to decompilation of JVM bytecode. (GT-2757, Issue #287)
* _Demangler_. Fixed a NullPointerException in DemangledFunctionPointer. (GT-2948, Issue #609)
* _DWARF_. Empty DWARF compilation unit sections will now be ignored. (GT-2939, Issue #690)
* _Exporter_. Negative memory references in idaxml.py no longer cause errors. (GT-2696, Issue #213, #885)
* _Exporter_. Fixed Intel Hex Exporter to not ignore the Address Space option value. (GT-2749)
* _Exporter_. Fixed cancellation behavior of the C/C++ exporter. (GT-2881, Issue #591)
* _File Formats_. Fixed an out-of-memory error in the CPIO file system. (GT-2912)
* _File Formats_. DmgClientFileSystem no longer falsely matches zlib compressed files. (GT-2926, Issue #583)
* _File System Browser_. Fixed NullPointerException when clicking Get Info on a directory in a zip file in the file system browser when the element was a directory that did not have a corresponding entry in the zip file. Changed the Get Info action to show information about both the highlighted file and any file system mounted from that file. (GT-2758)
* _File System Browser_. Fixed dialog stacking problem in File System Browser when double-clicking a container file to open the filesystem inside it. (GT-2764)
* _File System Browser_. Reduced the disk usage of the DYLD-shared cache file system. (GT-2887)
* _Function Graph_. Fixed exception encountered when a Function Graph's entry node was put into a group node. (GT-3074)
* _Function Graph_. Fixed Function Graph edge routing bug that sometimes caused edge flowing upward to route unexpectedly. (GT-3153, Issue #994)
* _GUI_. Fixed stack trace when deleting large memory block that is in its own address space. (GT-2699)
* _GUI_. Changed Data Type Preview to allow adding string data types. (GT-2832)
* _GUI_. Fixed display of operand scalar values in tooltip popup of Decompiler and Listing windows. (GT-2836, Issue #120)
* _GUI_. Fixed bug in Data Type Preview that caused a rendering error in Structures as primitive types were deleted. (GT-2844)
* _GUI_. Fixed Symbol Tree ClassCastException that happened when clicking a node while the tree was still loading. (GT-2870, Issue #96)
* _GUI_. Fixed bug that prevented the XRef's Ref Type column from sorting correctly. (GT-2892)
* _GUI_. Fixed Listing bug so that the cursor gets restored to the previous location on Ghidra startup. (GT-2927, Issue #505)
* _GUI_. Updated Edit Function Signature dialog to have focus in the signature field when first opened. Also added undo/redo support. (GT-2947, Issue #635)
* _GUI_. Fixed exception in the References Editor encountered when closing the editor with an active edit in the table. (GT-2951)
* _GUI_. Fixed bug where the Ghidra menu mnemonic was not being set by the ampersand ('&') character in the last field of the menu path. (GT-2954)
* _GUI_. Updated the Component Provider's Close button to allow for key bindings. (GT-2971, Issue #533)
* _GUI_. Fixed tool navigation button enablement when using snapshot windows. (GT-2973)
* _GUI_. Corrected Function Editor issue where parsed signature text resulted in incorrect type sizes which impacted custom storage selection. Also added support for parsing signatures which reference types from an open datatype archive. (GT-3059)
* _GUI_. Updated resizing in Select Bytes dialog. (GT-3072)
* _GUI_. Fixed bug where listing would jump to random location when opening or closing a large structure or array. (GT-3088)
* _GUI_. Fixed bug that caused some tables (e.g., the Symbol Table) to sort twice during their initial loading of data. (GT-3142)
* _GUI_. Drag-and-Drop bug causing incorrect drop highlighting has been fixed. (GT-3219, Issue #1093)
* _Help_. Fixed NullPointerException when navigating the Help UI. (GT-2830, Issue #493)
* _Importer_. Fixed issues in the MapLoader that prevented .map files from being added to an existing program. (GT-2972, Issue #762)
* _Importer_. For batch import, fixed issue where last character of directory name was truncated on Windows workstations. (GT-3012, Issue #797)
* _Importer_. Fixed a bug in how the NE importer creates External Function symbols for the procedures it imports, allowing the decompiler to properly access any available information. (GT-3140, Issue #770)
* _Importer_. Fixed a bug that prevented some old-style Windows executables from getting loaded by the MzLoader. (GT-3180, Issue #1054)
* _Importer:ELF_. Added ELF relocation handler for `R_AARCH64_JUMP26`. (GT-2999, Issue #775)
* _Importer:ELF_. Improved ELF MIPS support for GP-relative relocations encountered in PIC compiled binaries. Also added support for `R_MIPS_RPREL32` relocation. (GT-3026, Issue #764)
* _Importer:ELF_. ELF x86-64 relocations `R_X86_64_GOT32`, `R_X86_64_PLT32`, `R_X86_64_SIZE32`, `R_X86_64_SIZE64`, and `R_X86_64_GOTPC32` have been fixed to relocate correctly. Additional ELF x86-64 relocations, found mostly in unlinked .o files, have been added. (GT-3089, Issue #910)
* _Importer:PE_. Fixed a problem in the PeLoader that would result in section names being incorrectly used as primary symbols. This could result in function names being wrong. (GT-3195, Issue #761, #1051)
* _Listing_. Fixed potential infinite loop when editing long comments. (GT-2824, Issue #437)
* _Listing_. Fixed potential ClassCastException in Listing comments. (GT-3023)
* _Listing_. Cursor in the listing now stays in the proper column after editing a field. (GT-3045, Issue #702)
* _Listing_. Fixed a problem with register highlighting that could occur on certain register/sub-register combinations. (GT-3071, Issue #810)
* _Multi-User_. Corrected terminate checkout from viewed checkout list which was always terminating first row range based upon number of selected rows and not the actual selected rows. (GT-2903)
* _Multi-User_. Corrected ability for user to cancel checkin/checkout to Ghidra Server. (GT-3208)
* _Multi-User:Ghidra Server_. Added proper Ghidra Server interface binding with new `-i` option. Corrected `-ip` option to strictly convey remote access hostname to clients. The updated server will only accept connections from Ghidra 9.1 and later clients due to the registry port now employing TLS. (GT-2685, Issue #101, #645)
* _Multi-User:Ghidra Server_. Fixed argument-passing bug in svrAdmin script. (GT-3082, Issue #907)
* _Multi-User:Merge_. Corrected merge problem affecting modified Function Definition datatypes which could result in a NullPointerException. (GT-2922)
* _PDB_. Added `char16_t` and `char32_t` to PDB `BASIC_TYPE_STRINGS`. (GT-2952, Issue #685)
* _PDB_. Addressed memory leaks and string handling issues in pdb.exe. (GT-2975, Issue #674, #597, #598, #599, #600)
* _PDB_. Can now recover stack variables from more recent Visual Studio version PDBs. (GT-3014)
* _PDB_. Fixed PDB validation logic, which caused a more severe error message to be created, masking the real issue. (GT-3209, Issue #198, #1024)
* _Processors_. Utilized `FLOAT_NEG` pcodeop to simplify PowerPC `fneg` instructions. (GT-2781, Issue #387)
* _Processors_. Added 6502 `I` status bit save and restore. (GT-2826, Issue #469)
* _Processors_. Corrected alternate register definitions in z80 processor. (GT-2876, Issue #520)
* _Processors_. Reviewed all processor modules for GhidraSleighEditor syntax errors. (GT-2902)
* _Processors_. Added support for `RD`, `WR`, `FS`, and `GSBASE` instructions in x86. (GT-2940, Issue #554, #555)
* _Processors_. Added fixes for sign extension of `ADD`, `AND`, `CMP`, and `SUB` instructions on x86-64bit. (GT-2955, Issue #881)
* _Processors_. Updated PIC-30 division pcode to correct decompilation issue. (GT-3008)
* _Processors_. Fixed x86 `AAM` instruction. (GT-3015)
* _Processors_. Corrected x86 decode of `MOVBE` instruction. (GT-3039, Issue #822)
* _Processors_. Corrected M68000 `mov3q` instruction decode and semantics. (GT-3080, Issue #905)
* _Processors_. The JVM instruction `I2D` now correctly pushes an 8-byte double on the stack. (GT-3081)
* _Processors_. Fixed problem displaying processor manuals in Windows Firefox. (GT-3084)
* _Processors_. Encoding of `MOV` into debug registers has been relaxed. (GT-3117)
* _Processors_. Corrected behavior of PowerPC `vectorPermute` pcodeop for emulation. (GT-3148)
* _Processors_. Corrected MIPS relocation computation for `R_MIPS_26`, `R_MIPS16_26`, and `R_MICROMIPS_26_S1`. (GT-3154, Issue #1001)
* _Processors_. Corrected the bit patterns for PowerPC VLE `rlwimi` and `rlwinm` instructions. (GT-3159, Issue #752)
* _Processors_. Corrected instruction semantics for AARCH64 `BLR` instruction. (GT-3191)
* _Processors_. Corrected fall-through override semantics for cases where pcode simply drops into the next address. (GT-3196, Issue #1083)
* _Processors_. Corrected the semantics of the PowerPC `se_bmaski` instruction. (GT-3230, Issue #1123)
* _Program API_. Corrected parameter storage which failed to properly refresh after undo/redo. (GT-3130, Issue #960)
* _Program API_. Corrected function parameter ordinal numbering when more than one auto-parameter is present. (GT-3214)
* _Project Manager_. Fixed a problem with creating Ghidra projects in Windows root directories (e.g., Z:\). (GT-2585)
* _Project Manager_. Fixed a path-traversal vulnerability that could occur when restoring a malicious project archive. (GT-3001, Issue #789)
* _Scripting_. `GhidraScript.askDomainFile()` now correctly throws a CancelledException when the cancel button is clicked. (GT-2841)
* _Scripting_. Removed deprecated scripting methods older than 5 releases. (GT-2949)
* _Security_. Removed use of nonsecure XMLEncoder/XMLDecoder from Ghidra code base. (GT-3198, Issue #1090)
* _Sleigh_. Corrected Sleigh compiler bug which performed improper bounds checking for named register offset specification when space wordsize is not one (1). (GT-3034, Issue #831)
* _Testing:CUnits_. Fixed error logging in pcodetest for reporting an error when running a compile command. (GT-3199, Issue #1089)
* _Version Tracking_. Fixed NullPointerException in Version Tracking hashing algorithm. (GT-2976)

# Ghidra 9.0.4 Change History (May 2019)

### Bugs
* _Multi-User:Ghidra Server_. Corrected severe script error in svrAdmin.bat introduced with 9.0.3 build. (GT-2874)
* _GUI_. Restored the default 'p' key binding for creating pointers within the listing display. (GT-2854)

# Ghidra 9.0.3 Change History (April 2019)

### New Features
* _GUI_. Function tags are now viewable from Functions Window table using new column. (GT-2114)

### Improvements
* _Decompiler_. Improved modeling of CFG on Windows 10. (GT-2755, Issue #340)
* _Patcher_. Renamed patch directory to /Ghidra/patch and added README.txt that explains how the patch directory is used. (GT-2734)
* _Search_. Updated the Decompiler Data Type Finder to find references inside of nested array access in a line of Decompiler C output. (GT-2756, Issue #416)
* _Sleigh_. Improved error reporting for SLEIGH compiler. (GT-2820, Issue #364)

### Bugs
* _Analysis_. Code that checks for thunks no longer throws an exception if the PC is not set for the processor. (GT-2730)
* _Analysis_. Made a fix to enable Apply button when changing tool options. (GT-2801, Issue #40)
* _Data Types_. Fixed concurrent modification exception when replacing one datatype for another that results in some other datatype being renamed. (GT-2736)
* _Decompiler_. Fixed dynamic variables and equates in 16-bit x86 programs. (GT-2745, Issue #336)
* _Decompiler:Java_. Fixed DEX decompilation regression issue. (GT-2743, Issue #350)
* _Eclipse Integration_. Fixed exception in Eclipse GhidraDev plugin that occurred when performing certain actions on a Ghidra project that was imported from a previously exported Archive File. (GT-2721, Issues #283, #383)
* _GUI_. Improved documentation on how to deal with HiDPI monitor issues in Linux. In the _<ghidra_installation>_/support/launch.properties file, change VMARGS=-Dsun.java2d.xrender from false to true.
* _Importer_. Fixed an exception that occurred when batch importing APK files. (GT-2767, Issue #426)
* _Multi-User:Ghidra Server_. Restored ability to execute svrAdmin script in development mode. (GT-2740)
* _Processors_. The 6502 Zero page indexed addressing has been corrected to only access the Zero page. (GT-2759, Issue #201)
* _Processors_. The M68000 BCD arithmetic instructions now have pcode semantics that allow disassembly to continue. (GT-2807, Issue #227)
* _Search_. Fixed NullPointerException in Decompiler Data Type Reference Finder. (GT-2754, Issue #407)

# Ghidra 9.0.2 Change History (April 2019)

### Bugs
* _Analysis_. Constant reference analysis boundary controls for speculative references has been fixed. Speculative references are references created from computed constants passed as parameters, stored to a location, or from indexed offsets from a register. (GT-2723, Issue #228)
* _Decompiler_. Fixed Decompiler handling of Function Definition data types. (GT-2704, Issue #247)
* _Decompiler_. Fixed rendering bug in the Decompiler when the "Find" dialog is closed. (GT-2716, Issue #282)
* _Decompiler_. Fixed "Free Varnode" exception in RuleConditionalMove. (GT-2726, Issue #294)
* _Diff_. Fixed exceptions that can occur in the Diff View for programs with overlays. (GT-2706)
* _Documentation_. Corrected the spelling of "listener" throughout the source code. (GT-2702, Issue #235)
* _Exporter_. Exporting a selection as Intel Hex will now allow a selection of any length. Previously this was restricted to multiples of 16 bytes. (GT-2703, Issue #260)
* _GUI_. Fixed exception that occurs after disabling MyProgramChangesDisplayPlugin. (GT-2712)
* _GUI_. Updated the "Open Program" dialog to disallow file drop operations. (GT-2705, Issue #252)
* _Multi-User:Ghidra Server_. Corrected bug introduced into ghidraSvr.bat which could prevent Ghidra Server startup. (GT-2717, Issue #279)
* _Processors_. The ARM Thumb CMP.W and LSL instructions have been changed to correctly decode. There are still issues to work out with Unpredictable execution when Rd is the PC. (GT-2722, Issue #280)
* _Scripting_. MultiInstructionMemReference script has been corrected to consider input and output registers when placing a reference on an instruction. (GT-2723)

### Security
* _Basic Infrastructure_. Added a property to support/launch.properties to prevent log4j from using jansi.dll on Windows. (GT-2725, Issue #286)

# Ghidra 9.0.1 Change History (March 2019)

### New Features
* _Scripting_. Created ShowEquatesInSelectionScript to show all equates within the current selection. (GT-2651, Issue #111)

### Improvements
* _Basic Infrastructure_. Updated commons-compress library to version 1.18. (GT-2657, Issue #171)
* _Eclipse Integration_. Ghidra now connects to the Eclipse GhidraDev plugin on 127.0.0.1 rather than localhost. (GT-2691)
* _GUI_. Turned on font anti-aliasing by default for Linux. (GT-2674, Issue #212)
* _GUI_. Fixed Options Dialog slow scrolling speed. (GT-2679, Issue #27)
* _Importer:ELF_. Corrected bug in ELF loader which can improperly process the GOT, PLT and relocations when multiple symbol tables exist within the ELF binary. (GT-2646, Issue #52)
* _Multi-User:Ghidra Server_. Corrected the Ghidra Server service wrapper (YAJSW) configuration for Mac OS X to prevent a startup timeout condition which could occur. (GT-2637)
* _Processors_. Added ARM/Thumb SRS instruction decodes for undefined modes. (GT-2676, Issue #216)

### Bugs
* _API_. Fixed equals method on Varnode class. (GT-2648, Issue #97)
* _API_. Fixed a bug in MaskImpl.complementMask(). (GT-2694, Issue #187)
* _Basic Infrastructure_. Fixed special character handling in idaxml.py. (GT-2669, Issue #75)
* _Basic Infrastructure_. Ghidra now forces the locale to en_US by default. Only the en_US is currently supported. This fixes certain unexpected exceptions. (GT-2680, Issue #209)
* _Diff_. Fixed exception occasionally encountered when starting a Diff session. (GT-2672, Issue #211)
* _Documentation_. Fixed javadoc search box redirecting to broken links. (GT-2655, Issue #129)
* _Function Graph_. Fixed Function Graph exception when generating tooltip. (GT-2650, Issue #65)
* _GUI_. Updated window placement to keep windows on screen. (GT-1516, Issue #41)
* _GUI_. Add/Edit References dialog now restricts users to creating refs in valid memory address spaces. (GT-2638)
* _GUI_. Fixed exception when exiting Ghidra while a table is being edited. (GT-2642, Issue #51)
* _GUI_. Fixed some touchpad scrolling issues. (GT-2647, Issue #2)
* _GUI_. Fixed stack trace in the Data Type Manager's tooltip generation. (GT-2656, Issue #133)
* _GUI_. User key binding settings for the Recently Used and Define Pointer actions no longer lost after re-launching tool. (GT-2659, Issue #152)
* _GUI_. Toolbar buttons now respond to fast clicking. (GT-2689)
* _Importer:Mach-O_. The Mach-O loader can now find import libraries found in Universal Binary files. (GT-2663, Issue #136)
* _Importer:PE_. The PeLoader now correctly parses the GuardCFFunctionTable when table entries are more than 4 bytes each. (GT-2671, Issue #220)
* _Multi-User:Ghidra Server_. Removed support for native OS authentication from Ghidra Server (removed modes -a2 and -a3) due to incompatibility with newer OS releases including Windows 10 and Windows Server 2016. Re-introduction of this will be considered for a future release. (GT-2653)
* _PDB_. Corrected NullPointerException when processing PDB files. (GT-2673, Issues #138, #188)
* _Processors_. Added missing PowerPC VLE conditional branch instructions: e_bdnz and e_bdz. (GT-2652, Issue #103)
* _Processors_. Fixed instruction semantics for several instructions and added Control Flow Enforcement, NOP variants, CMP variants, UD1, and prefixed call instructions to X86 processor specification. (GT-2660, Issues #22, #53, #158, #157)
* _Processors_. The M68000 MOVE instruction now correctly sets the CF and VF flags. (GT-2661, Issue #163)
* _Processors_. Added four missing MOVEM instruction variants to the M68000 processor. (GT-2675, Issue #219)
* _Processors_. An incorrect usage of X instead of Y in indexed mode for the 6502 has been corrected. (GT-2677, Issue #201)
* _Processors_. PPC VLE now disassembles base PPC instructions that are valid in VLE mode. (GT-2681, Issue #127)
* _Processors_. Added support for ARM Thumb half BL instruction on processor variants prior to v6. (GT-2684, Issue #39)
* _Scripting_. Fixed a bug in ImportSymbolsScript.py that prevented it from running. (GT-2668, Issue #170)

### Security
* _Basic Infrastructure_. Running Ghidra in debug mode no longer opens remotely accessible ports by default. (GT-2641, Issue #6)
* _GUI_. The Defined Strings plugin no longer renders HTML in its table. (GT-2686, Issue #45)
* _Project Manager_. Fixed an XXE vulnerability affecting projects and many other saved components. (GT-2643, Issue #71)
