/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.InstrumentationVisitor;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.data.ProjectContext;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassSignatureFilter;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

public class InstrumentationStrategy {
    private static final List<ClassSignatureFilter> ourFilters = FilterUtils.createClassSignatureFilters();

    /*
     * WARNING - void declaration
     */
    static ClassVisitor createInstrumenter(ProjectData projectData, String className, ClassReader cr, ClassVisitor cw2, ProjectContext projectContext, CoverageDataAccess dataAccess) {
        void var3_8;
        ClassVisitor cw2;
        void var2_4;
        InstrumentationData context = new InstrumentationData((ProjectContext)projectContext);
        context.put(Key.PROJECT_DATA, projectData);
        context.put(Key.CLASS_READER, var2_4);
        context.put(Key.CLASS_NAME, projectContext.getFromPool((String)((Object)className)));
        context.put(Key.CLASS_INTERNAL_NAME, ClassNameUtil.convertToInternalName((String)((Object)className)));
        for (ClassSignatureFilter classSignatureFilter : ourFilters) {
            if (!classSignatureFilter.shouldIgnore(context)) continue;
            return null;
        }
        TestTrackingMode testTrackingMode = projectContext.getOptions().testTrackingMode;
        if (testTrackingMode != null) {
            void var1_3;
            cw2 = var1_3.createInstrumenter(cw2, context);
        }
        cw2 = new InstrumentationVisitor(projectData, context, cw2, (CoverageDataAccess)dataAccess);
        for (ClassFilter cv : FilterUtils.createClassFilters()) {
            void var0_2;
            if (!cv.isApplicable(context)) continue;
            cv.initFilter(cw2, context);
            cw2 = var0_2;
        }
        return var3_8;
    }
}

