/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Composite;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java2d.AnimatingSurface;

public class ACrules
extends AnimatingSurface {
    private static String[] compNames = new String[]{"Src", "SrcOver", "SrcIn", "SrcOut", "SrcAtop", "Clear", "Dst", "DstOver", "DstIn", "DstOut", "DstAtop", "Xor"};
    private static final AlphaComposite[] compObjs = new AlphaComposite[]{AlphaComposite.Src, AlphaComposite.SrcOver, AlphaComposite.SrcIn, AlphaComposite.SrcOut, AlphaComposite.SrcAtop, AlphaComposite.Clear, AlphaComposite.Dst, AlphaComposite.DstOver, AlphaComposite.DstIn, AlphaComposite.DstOut, AlphaComposite.DstAtop, AlphaComposite.Xor};
    private static final int NUM_RULES = compObjs.length;
    private static final int HALF_NUM_RULES = NUM_RULES / 2;
    private int fadeIndex;
    private static float[][] fadeValues = new float[][]{{1.0f, -0.1f, 0.0f, 1.0f, 0.0f, 1.0f}, {0.0f, 0.1f, 1.0f, 1.0f, -0.1f, 0.0f}, {1.0f, 0.0f, 1.0f, 0.0f, 0.1f, 1.0f}};
    private static String[] fadeNames = new String[]{"Src => transparent, Dest opaque", "Src => opaque, Dest => transparent", "Src opaque, Dest => opaque"};
    private static Font f = new Font("serif", 0, 10);
    private float srca;
    private float dsta;
    private String fadeLabel;
    private BufferedImage statBI;
    private BufferedImage animBI;
    private int PADLEFT;
    private int PADRIGHT;
    private int HPAD;
    private int PADABOVE;
    private int PADBELOW;
    private int VPAD;
    private int RECTWIDTH;
    private int RECTHEIGHT;
    private int PADDEDHEIGHT;
    private GeneralPath srcpath;
    private GeneralPath dstpath;
    private LineMetrics lm;
    private BufferedImage dBI;
    private BufferedImage sBI;
    private GradientPaint gradientDst;
    private GradientPaint gradientSrc;

    public ACrules() {
        this.srca = fadeValues[this.fadeIndex][0];
        this.dsta = fadeValues[this.fadeIndex][3];
        this.fadeLabel = fadeNames[0];
        this.srcpath = new GeneralPath();
        this.dstpath = new GeneralPath();
        this.setBackground(Color.white);
    }

    @Override
    public void reset(int w, int h) {
        this.setSleepAmount(400L);
        FontRenderContext frc = new FontRenderContext(null, false, false);
        this.lm = f.getLineMetrics(compNames[0], frc);
        this.PADLEFT = w < 150 ? 10 : 15;
        this.PADRIGHT = w < 150 ? 10 : 15;
        this.HPAD = this.PADLEFT + this.PADRIGHT;
        this.PADBELOW = h < 250 ? 1 : 2;
        this.PADABOVE = this.PADBELOW + (int)this.lm.getHeight();
        this.VPAD = this.PADABOVE + this.PADBELOW;
        this.RECTWIDTH = w / 4 - this.HPAD;
        this.RECTWIDTH = this.RECTWIDTH < 6 ? 6 : this.RECTWIDTH;
        this.RECTHEIGHT = (h - this.VPAD) / HALF_NUM_RULES - this.VPAD;
        this.RECTHEIGHT = this.RECTHEIGHT < 6 ? 6 : this.RECTHEIGHT;
        this.PADDEDHEIGHT = this.RECTHEIGHT + this.VPAD;
        this.srcpath.reset();
        this.srcpath.moveTo(0.0f, 0.0f);
        this.srcpath.lineTo(this.RECTWIDTH, 0.0f);
        this.srcpath.lineTo(0.0f, this.RECTHEIGHT);
        this.srcpath.closePath();
        this.dstpath.reset();
        this.dstpath.moveTo(0.0f, 0.0f);
        this.dstpath.lineTo(this.RECTWIDTH, this.RECTHEIGHT);
        this.dstpath.lineTo(this.RECTWIDTH, 0.0f);
        this.dstpath.closePath();
        this.dBI = new BufferedImage(this.RECTWIDTH, this.RECTHEIGHT, 2);
        this.sBI = new BufferedImage(this.RECTWIDTH, this.RECTHEIGHT, 2);
        this.gradientDst = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 0.0f, 0.0f, 1.0f), 0.0f, this.RECTHEIGHT, new Color(1.0f, 0.0f, 0.0f, 0.0f));
        this.gradientSrc = new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 1.0f, 1.0f), this.RECTWIDTH, 0.0f, new Color(0.0f, 0.0f, 1.0f, 0.0f));
        this.statBI = new BufferedImage(w / 2, h, 1);
        this.statBI = this.drawCompBI(this.statBI, true);
        this.animBI = new BufferedImage(w / 2, h, 1);
    }

    @Override
    public void step(int w, int h) {
        if (this.getSleepAmount() == 5000L) {
            this.setSleepAmount(200L);
        }
        this.srca += fadeValues[this.fadeIndex][1];
        this.dsta += fadeValues[this.fadeIndex][4];
        this.fadeLabel = fadeNames[this.fadeIndex];
        if (this.srca < 0.0f || (double)this.srca > 1.0 || this.dsta < 0.0f || (double)this.dsta > 1.0) {
            this.setSleepAmount(5000L);
            this.srca = fadeValues[this.fadeIndex][2];
            this.dsta = fadeValues[this.fadeIndex][5];
            if (this.fadeIndex++ == fadeValues.length - 1) {
                this.fadeIndex = 0;
            }
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        if (this.statBI == null || this.animBI == null) {
            return;
        }
        g2.drawImage((Image)this.statBI, 0, 0, null);
        g2.drawImage((Image)this.drawCompBI(this.animBI, false), w / 2, 0, null);
        g2.setColor(Color.black);
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout("AC Rules", g2.getFont(), frc);
        tl.draw(g2, 15.0f, (float)tl.getBounds().getHeight() + 3.0f);
        tl = new TextLayout(this.fadeLabel, f, frc);
        float x = (float)((double)w * 0.75 - tl.getBounds().getWidth() / 2.0);
        if ((double)x + tl.getBounds().getWidth() > (double)w) {
            x = (float)((double)w - tl.getBounds().getWidth());
        }
        tl.draw(g2, x, (float)tl.getBounds().getHeight() + 3.0f);
    }

    private BufferedImage drawCompBI(BufferedImage bi, boolean doGradient) {
        Graphics2D big = bi.createGraphics();
        big.setColor(this.getBackground());
        big.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        big.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.AntiAlias);
        big.setFont(f);
        Graphics2D gD = this.dBI.createGraphics();
        gD.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.AntiAlias);
        Graphics2D gS = this.sBI.createGraphics();
        gS.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.AntiAlias);
        int x = 0;
        int y = 0;
        int yy = (int)this.lm.getHeight() + this.VPAD;
        for (int i = 0; i < compNames.length; ++i) {
            y = i == 0 || i == HALF_NUM_RULES ? yy : y + this.PADDEDHEIGHT;
            x = i >= HALF_NUM_RULES ? bi.getWidth() / 2 + this.PADLEFT : this.PADLEFT;
            big.translate(x, y);
            gD.setComposite(AlphaComposite.Clear);
            gD.fillRect(0, 0, this.RECTWIDTH, this.RECTHEIGHT);
            gD.setComposite(AlphaComposite.Src);
            if (doGradient) {
                gD.setPaint(this.gradientDst);
                gD.fillRect(0, 0, this.RECTWIDTH, this.RECTHEIGHT);
            } else {
                gD.setPaint(new Color(1.0f, 0.0f, 0.0f, this.dsta));
                gD.fill(this.dstpath);
            }
            gS.setComposite(AlphaComposite.Clear);
            gS.fillRect(0, 0, this.RECTWIDTH, this.RECTHEIGHT);
            gS.setComposite(AlphaComposite.Src);
            if (doGradient) {
                gS.setPaint(this.gradientSrc);
                gS.fillRect(0, 0, this.RECTWIDTH, this.RECTHEIGHT);
            } else {
                gS.setPaint(new Color(0.0f, 0.0f, 1.0f, this.srca));
                gS.fill(this.srcpath);
            }
            gD.setComposite(compObjs[i]);
            gD.drawImage((Image)this.sBI, 0, 0, null);
            big.drawImage((Image)this.dBI, 0, 0, null);
            big.setColor(Color.black);
            big.drawString(compNames[i], 0.0f, -this.lm.getDescent());
            big.drawRect(0, 0, this.RECTWIDTH, this.RECTHEIGHT);
            big.translate(-x, -y);
        }
        gD.dispose();
        gS.dispose();
        big.dispose();
        return bi;
    }

    public static void main(String[] argv) {
        ACrules.createDemoFrame(new ACrules());
    }
}

