/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.interpreter.OffsetClosure;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

class InterpreterFrameClosure
implements OffsetClosure {
    private static final boolean DEBUG = false;
    private Frame fr;
    private AddressVisitor f;
    private int maxLocals;
    private int maxStack;

    InterpreterFrameClosure(Frame fr, int maxLocals, int maxStack, AddressVisitor f) {
        this.fr = fr;
        this.maxLocals = maxLocals;
        this.maxStack = maxStack;
        this.f = f;
    }

    @Override
    public void offsetDo(int offset) {
        if (offset < this.maxLocals) {
            Address addr = this.fr.addressOfInterpreterFrameLocal(offset);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(AddressOps.gte(addr, this.fr.getSP()), "must be inside the frame");
            }
            this.f.visitAddress(addr);
        } else {
            Address addr = this.fr.addressOfInterpreterFrameExpressionStackSlot(offset - this.maxLocals);
            boolean inStack = this.fr.getInterpreterFrameExpressionStackDirection() > 0 ? AddressOps.lte(addr, this.fr.addressOfInterpreterFrameTOS()) : AddressOps.gte(addr, this.fr.addressOfInterpreterFrameTOS());
            if (inStack) {
                this.f.visitAddress(addr);
            }
        }
    }
}

