/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.CachedRealmModel;

public class LoAUtil {
    private static final Logger logger = Logger.getLogger(LoAUtil.class);

    public static int getCurrentLevelOfAuthentication(AuthenticatedClientSessionModel clientSession) {
        String clientSessionLoaNote = clientSession.getNote("level-of-authentication");
        return clientSessionLoaNote == null ? -1 : Integer.parseInt(clientSessionLoaNote);
    }

    public static Stream<Integer> getLoAConfiguredInRealmBrowserFlow(RealmModel realm) {
        Map<Integer, Integer> loaMaxAges = LoAUtil.getLoaMaxAgesConfiguredInRealmBrowserFlow(realm);
        if (loaMaxAges.isEmpty()) {
            return Stream.of(0, 1);
        }
        return Stream.concat(Stream.of(Integer.valueOf(0)), loaMaxAges.keySet().stream());
    }

    public static Map<Integer, Integer> getLoaMaxAgesConfiguredInRealmBrowserFlow(RealmModel realm) {
        return LoAUtil.getLoaMaxAgesConfiguredInRealmFlow(realm, realm.getBrowserFlow().getId());
    }

    public static Map<Integer, Integer> getLoaMaxAgesConfiguredInRealmFlow(RealmModel realm, String flowId) {
        List<AuthenticationExecutionModel> loaConditions = AuthenticatorUtil.getExecutionsByType(realm, flowId, "conditional-level-of-authentication");
        if (loaConditions.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Integer, Integer> loas = loaConditions.stream().map(authExecution -> realm.getAuthenticatorConfigById(authExecution.getAuthenticatorConfig())).filter(Objects::nonNull).filter(authConfig -> LoAUtil.getLevelFromLoaConditionConfiguration(authConfig) != null).collect(Collectors.toMap(LoAUtil::getLevelFromLoaConditionConfiguration, LoAUtil::getMaxAgeFromLoaConditionConfiguration));
        return loas;
    }

    public static Integer getLevelFromLoaConditionConfiguration(AuthenticatorConfigModel loaConditionConfig) {
        String levelAsStr = (String)loaConditionConfig.getConfig().get("loa-condition-level");
        try {
            return Integer.parseInt(levelAsStr);
        }
        catch (NullPointerException | NumberFormatException e) {
            logger.warnf("Invalid level '%s' configured for the configuration of LoA condition with alias '%s'. Level should be number.", (Object)levelAsStr, (Object)loaConditionConfig.getAlias());
            return null;
        }
    }

    public static int getMaxAgeFromLoaConditionConfiguration(AuthenticatorConfigModel loaConditionConfig) {
        try {
            return Integer.parseInt((String)loaConditionConfig.getConfig().get("loa-max-age"));
        }
        catch (NullPointerException | NumberFormatException e) {
            String storeLoaInUserSession = (String)loaConditionConfig.getConfig().get("loa-store-in-user-session");
            if (storeLoaInUserSession != null) {
                int maxAge = Boolean.parseBoolean(storeLoaInUserSession) ? 36000 : 0;
                logger.warnf("Max age not configured for condition '%s' in the authentication flow. Fallback to %d based on the configuration option %s from previous version", (Object)loaConditionConfig.getAlias(), (Object)maxAge, (Object)"loa-store-in-user-session");
                return maxAge;
            }
            logger.errorf("Invalid max age configured for condition '%s'. Fallback to 0", (Object)loaConditionConfig.getAlias());
            return 0;
        }
    }

    public static Map<String, Integer> getCredentialTypesToLoAMap(KeycloakSession session, RealmModel realm, AuthenticationFlowModel topFlow) {
        ConcurrentHashMap cachedWith;
        Map result;
        String cacheKey = "flow:" + topFlow.getId();
        if (realm instanceof CachedRealmModel && (result = (Map)(cachedWith = ((CachedRealmModel)realm).getCachedWith()).get(cacheKey)) != null) {
            return result;
        }
        HashMap<String, Integer> result2 = new HashMap<String, Integer>();
        AtomicReference<Integer> currentLevel = new AtomicReference<Integer>(-1);
        Set<String> availableCredentialTypes = AuthenticatorUtil.getCredentialProviders(session).map(CredentialProvider::getType).collect(Collectors.toSet());
        LoAUtil.fillCredentialsToLoAMap(session, realm, topFlow, availableCredentialTypes, currentLevel, result2);
        logger.tracef("Computed credential types to LoA map for authentication flow '%s' in realm '%s'. Mapping: %s", (Object)topFlow.getAlias(), (Object)realm.getName(), result2);
        if (realm instanceof CachedRealmModel) {
            ConcurrentHashMap cachedWith2 = ((CachedRealmModel)realm).getCachedWith();
            cachedWith2.put(cacheKey, result2);
        }
        return result2;
    }

    private static void fillCredentialsToLoAMap(KeycloakSession session, RealmModel realm, AuthenticationFlowModel authFlow, Set<String> availableCredentialTypes, AtomicReference<Integer> currentLevel, Map<String, Integer> result) {
        realm.getAuthenticationExecutionsStream(authFlow.getId()).forEachOrdered(execution -> {
            if (execution.isAuthenticatorFlow()) {
                AuthenticationFlowModel subFlow = realm.getAuthenticationFlowById(execution.getFlowId());
                int levelWhenExecuted = (Integer)currentLevel.get();
                LoAUtil.fillCredentialsToLoAMap(session, realm, subFlow, availableCredentialTypes, currentLevel, result);
                currentLevel.set(levelWhenExecuted);
            } else if ("conditional-level-of-authentication".equals(execution.getAuthenticator())) {
                AuthenticatorConfigModel loaConditionConfig = realm.getAuthenticatorConfigById(execution.getAuthenticatorConfig());
                Integer level = LoAUtil.getLevelFromLoaConditionConfiguration(loaConditionConfig);
                if (level != null) {
                    currentLevel.set(level);
                }
            } else {
                AuthenticatorFactory factory = (AuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, execution.getAuthenticator());
                if (factory == null) {
                    return;
                }
                if (factory.getReferenceCategory() != null && availableCredentialTypes.contains(factory.getReferenceCategory())) {
                    result.put(factory.getReferenceCategory(), (Integer)currentLevel.get());
                }
            }
        });
    }
}

