/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.HardcodedAttributeMapper;

public class HardcodedAttributeMapperFactory
extends AbstractLDAPStorageMapperFactory {
    public static final String PROVIDER_ID = "hardcoded-attribute-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    @Override
    public String getHelpText() {
        return "This mapper will hardcode any model user attribute and some property (like emailVerified or enabled) when importing user from ldap.";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)config).checkRequired("user.model.attribute", "Attribute Name").checkRequired("attribute.value", "Attribute Value");
        if (config.get("user.model.attribute").equalsIgnoreCase("username") || config.get("user.model.attribute").equalsIgnoreCase("email")) {
            throw new ComponentValidationException("Attribute Name cannot be set to username or email", new Object[0]);
        }
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new HardcodedAttributeMapper(mapperModel, federationProvider);
    }

    static {
        ProviderConfigProperty attrName = HardcodedAttributeMapperFactory.createConfigProperty("user.model.attribute", "User Model Attribute Name", "Name of the model attribute, which will be added when importing user from ldap", "UserProfileAttributeList", null, true);
        ProviderConfigProperty attrValue = HardcodedAttributeMapperFactory.createConfigProperty("attribute.value", "Attribute Value", "Value of the model attribute, which will be added when importing user from ldap.", "String", null, true);
        configProperties.add(attrName);
        configProperties.add(attrValue);
    }
}

