/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class MethodElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance(MethodElement.class);

    public MethodElement() {
        super(METHOD);
    }

    protected MethodElement(IElementType type) {
        super(type);
    }

    @Override
    public int getTextOffset() {
        ASTNode name2 = this.findChildByType(IDENTIFIER);
        return name2 != null ? name2.getStartOffset() : this.getStartOffset();
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode semicolon;
        if (first == last && first.getElementType() == JavaElementType.CODE_BLOCK && (semicolon = TreeUtil.findChildBackward(this, SEMICOLON)) != null) {
            this.deleteChildInternal(semicolon);
        }
        return super.addInternal(first, last, anchor, before);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            MethodElement.$$$reportNull$$$0(0);
        }
        if (child.getElementType() == CODE_BLOCK) {
            ASTNode prevWS = TreeUtil.prevLeaf(child);
            if (prevWS != null && prevWS.getElementType() == TokenType.WHITE_SPACE) {
                this.removeChild(prevWS);
            }
            super.deleteChildInternal(child);
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            LeafElement semicolon = Factory.createSingleLeafElement(SEMICOLON, ";", 0, 1, treeCharTab, this.getManager());
            this.addInternal(semicolon, semicolon, null, Boolean.TRUE);
        } else {
            if (child.getElementType() == PARAMETER_LIST) {
                throw new IllegalArgumentException("Deleting parameter list is prohibited");
            }
            super.deleteChildInternal(child);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 7: {
                return PsiImplUtil.findDocComment(this);
            }
            case 8: {
                return this.findChildByType(MODIFIER_LIST);
            }
            case 245: {
                return this.findChildByType(TYPE_PARAMETER_LIST);
            }
            case 9: {
                return this.findChildByType(IDENTIFIER);
            }
            case 10: {
                return this.findChildByType(TYPE);
            }
            case 17: {
                return this.findChildByType(CODE_BLOCK);
            }
            case 14: {
                return this.findChildByType(PARAMETER_LIST);
            }
            case 16: {
                return this.findChildByType(THROWS_LIST);
            }
            case 22: {
                return TreeUtil.findChildBackward(this, SEMICOLON);
            }
            case 85: 
        }
        return this.findChildByType(DEFAULT_KEYWORD);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            MethodElement.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaDocElementType.DOC_COMMENT) {
            return this.getChildRole(child, 7);
        }
        if (i2 == MODIFIER_LIST) {
            return 8;
        }
        if (i2 == TYPE_PARAMETER_LIST) {
            return 245;
        }
        if (i2 == CODE_BLOCK) {
            return 17;
        }
        if (i2 == PARAMETER_LIST) {
            return 14;
        }
        if (i2 == THROWS_LIST) {
            return 16;
        }
        if (i2 == TYPE) {
            return this.getChildRole(child, 10);
        }
        if (i2 == IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i2 == SEMICOLON) {
            return this.getChildRole(child, 22);
        }
        if (i2 == DEFAULT_KEYWORD) {
            return 85;
        }
        return 0;
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "child";
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/MethodElement";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteChildInternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

