/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.components;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.TimePickerSettings;
import com.github.lgooddatepicker.optionalusertools.PickerUtilities;
import com.github.lgooddatepicker.optionalusertools.TimeChangeListener;
import com.github.lgooddatepicker.optionalusertools.TimeVetoPolicy;
import com.github.lgooddatepicker.zinternaltools.CalculateMinimumTimeFieldSize;
import com.github.lgooddatepicker.zinternaltools.CustomPopup;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import com.github.lgooddatepicker.zinternaltools.TimeChangeEvent;
import com.github.lgooddatepicker.zinternaltools.TimeMenuPanel;
import com.github.lgooddatepicker.zinternaltools.TimeSpinnerTimer;
import com.privatejgoodies.forms.factories.CC;
import com.privatejgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.time.LocalTime;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TimePicker
extends JPanel
implements CustomPopup.CustomPopupCloseListener {
    private boolean enableArrowKeys = true;
    private Instant lastPopupCloseTime = Instant.now();
    private LocalTime lastValidTime = null;
    private CustomPopup popup = null;
    private TimePickerSettings settings;
    private boolean skipTextFieldChangedFunctionWhileTrue = false;
    private ArrayList<TimeChangeListener> timeChangeListeners = new ArrayList();
    private TimeMenuPanel timeMenuPanel;
    private TimeSpinnerTimer decreaseTimer = this.zCreateTimeSpinnerTimer(-1);
    private TimeSpinnerTimer increaseTimer = this.zCreateTimeSpinnerTimer(1);
    private JTextField timeTextField;
    private JButton toggleTimeMenuButton;
    private JPanel spinnerPanel;
    private JButton increaseButton;
    private JButton decreaseButton;

    public TimePicker() {
        this((TimePickerSettings)null);
    }

    public TimePicker(TimePickerSettings settings) {
        settings = settings == null ? new TimePickerSettings() : settings;
        settings.setParentTimePicker(this);
        this.settings = settings;
        this.initComponents();
        this.toggleTimeMenuButton.setText("\u25bc");
        this.toggleTimeMenuButton.setMargin(new Insets(4, 4, 4, 4));
        this.decreaseButton.setBorder(new MatteBorder(1, 1, 1, 1, new Color(122, 138, 153)));
        this.increaseButton.setBorder(new MatteBorder(1, 1, 1, 1, new Color(122, 138, 153)));
        this.decreaseButton.setMargin(new Insets(0, 0, 0, 0));
        this.increaseButton.setMargin(new Insets(0, 0, 0, 0));
        this.zInstallSpinnerButtonListener(this.decreaseButton);
        this.zInstallSpinnerButtonListener(this.increaseButton);
        this.zAddTextChangeListener();
        settings.yApplyNeededSettingsAtTimePickerConstruction();
        this.zAddKeyListenersToTextField();
        this.toggleTimeMenuButton.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent event) {
                if (TimePicker.this.timeMenuPanel != null) {
                    TimePicker.this.timeMenuPanel.mouseDraggedFromToggleButton();
                }
            }
        });
        this.toggleTimeMenuButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                Point mousePositionOnScreen = MouseInfo.getPointerInfo().getLocation();
                Rectangle toggleBoundsOnScreen = TimePicker.this.getComponentToggleTimeMenuButton().getBounds();
                toggleBoundsOnScreen.setLocation(TimePicker.this.getComponentToggleTimeMenuButton().getLocationOnScreen());
                if (toggleBoundsOnScreen.contains(mousePositionOnScreen)) {
                    return;
                }
                if (TimePicker.this.timeMenuPanel != null) {
                    TimePicker.this.timeMenuPanel.mouseReleasedFromToggleButtonOutsideButton();
                }
            }
        });
        this.zDrawTextFieldIndicators();
        this.zSetAppropriateTextFieldMinimumWidth();
    }

    public void addTimeChangeListener(TimeChangeListener listener) {
        this.timeChangeListeners.add(listener);
    }

    public void clear() {
        this.setTime(null);
    }

    public void closePopup() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }

    @Override
    public int getBaseline(int width, int height) {
        if (this.timeTextField.isVisible()) {
            return this.timeTextField.getBaseline(width, height);
        }
        return super.getBaseline(width, height);
    }

    public JButton getComponentDecreaseSpinnerButton() {
        return this.decreaseButton;
    }

    public JButton getComponentIncreaseSpinnerButton() {
        return this.increaseButton;
    }

    public JPanel getComponentSpinnerPanel() {
        return this.spinnerPanel;
    }

    public JTextField getComponentTimeTextField() {
        return this.timeTextField;
    }

    public JButton getComponentToggleTimeMenuButton() {
        return this.toggleTimeMenuButton;
    }

    public boolean getEnableArrowKeys() {
        return this.enableArrowKeys;
    }

    public LocalTime getTime() {
        return this.lastValidTime;
    }

    public ArrayList<TimeChangeListener> getTimeChangeListeners() {
        return new ArrayList<TimeChangeListener>(this.timeChangeListeners);
    }

    public String getTimeStringOrEmptyString() {
        LocalTime time = this.getTime();
        return time == null ? "" : time.toString();
    }

    public String getTimeStringOrSuppliedString(String emptyTimeString) {
        LocalTime time = this.getTime();
        return time == null ? emptyTimeString : time.toString();
    }

    public TimePickerSettings getSettings() {
        return this.settings;
    }

    public String getText() {
        return this.timeTextField.getText();
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    public boolean isPopupOpen() {
        return this.popup != null;
    }

    public boolean isTextFieldValid() {
        return this.isTextValid(this.timeTextField.getText());
    }

    public boolean isTextValid(String text) {
        if (text == null) {
            return false;
        }
        if ((text = text.trim()).isEmpty()) {
            return this.settings.getAllowEmptyTimes();
        }
        LocalTime parsedTime = InternalUtilities.getParsedTimeOrNull(text, this.settings.getFormatForDisplayTime(), this.settings.getFormatForMenuTimes(), this.settings.formatsForParsing, this.settings.getLocale());
        if (parsedTime == null) {
            return false;
        }
        TimeVetoPolicy vetoPolicy = this.settings.getVetoPolicy();
        return !InternalUtilities.isTimeVetoed(vetoPolicy, parsedTime);
    }

    public boolean isTimeAllowed(LocalTime time) {
        return this.settings.isTimeAllowed(time);
    }

    public void openPopup() {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.settings.getDisplayToggleTimeMenuButton()) {
            return;
        }
        if (!this.timeTextField.hasFocus()) {
            this.timeTextField.requestFocusInWindow();
        }
        this.timeMenuPanel = new TimeMenuPanel(this, this.settings);
        this.popup = new CustomPopup((Component)this.timeMenuPanel, SwingUtilities.getWindowAncestor(this), this, this.settings.borderTimePopup);
        this.popup.setMinimumSize(new Dimension(this.getSize().width + 1, this.timeMenuPanel.getSize().height));
        int defaultX = this.timeTextField.getLocationOnScreen().x;
        int defaultY = this.timeTextField.getLocationOnScreen().y + this.timeTextField.getSize().height - 1;
        DatePicker.zSetPopupLocation(this.popup, defaultX, defaultY, this, this.timeTextField, -1, 1);
        this.popup.show();
        this.timeMenuPanel.requestListFocus();
    }

    public void removeTimeChangeListener(TimeChangeListener listener) {
        this.timeChangeListeners.remove(listener);
    }

    public void setEnableArrowKeys(boolean enableArrowKeys) {
        this.enableArrowKeys = enableArrowKeys;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.closePopup();
        }
        this.setTextFieldToValidStateIfNeeded();
        super.setEnabled(enabled);
        this.toggleTimeMenuButton.setEnabled(enabled);
        this.timeTextField.setEnabled(enabled);
        this.zDrawTextFieldIndicators();
    }

    public void setText(String text) {
        this.zInternalSetTimeTextField(text);
        this.timeTextField.requestFocusInWindow();
    }

    public void setTextFieldToValidStateIfNeeded() {
        String textFieldString;
        String standardTimeString = this.zGetStandardTextFieldTimeString(this.lastValidTime);
        if (!standardTimeString.equals(textFieldString = this.timeTextField.getText())) {
            this.setTime(this.lastValidTime);
        }
    }

    public void setTime(LocalTime optionalTime) {
        String textFieldString;
        String standardTimeString = this.zGetStandardTextFieldTimeString(optionalTime);
        if (!standardTimeString.equals(textFieldString = this.timeTextField.getText())) {
            this.zInternalSetTimeTextField(standardTimeString);
        }
    }

    public void setTimeToNow() {
        this.setTime(LocalTime.now(this.settings.getClock()));
    }

    @Override
    public String toString() {
        return this.getTimeStringOrEmptyString();
    }

    public void togglePopup() {
        if (Instant.now().toEpochMilli() - this.lastPopupCloseTime.toEpochMilli() < 200L) {
            return;
        }
        this.openPopup();
    }

    private void zAddKeyListenersToTextField() {
        this.timeTextField.addKeyListener(new KeyAdapter(){
            boolean upPressed = false;
            boolean downPressed = false;

            @Override
            public void keyPressed(KeyEvent e) {
                if (TimePicker.this.enableArrowKeys && e.isActionKey() && e.getKeyCode() == 39) {
                    e.consume();
                    TimePicker.this.openPopup();
                    if (TimePicker.this.popup != null) {
                        TimePicker.this.timeMenuPanel.selectFirstEntry();
                    }
                }
                if (TimePicker.this.enableArrowKeys && e.isActionKey() && e.getKeyCode() == 38) {
                    e.consume();
                    if (this.upPressed || !TimePicker.this.isEnabled()) {
                        return;
                    }
                    this.upPressed = true;
                    if (TimePicker.this.getTime() == null) {
                        TimePicker.this.setTime(LocalTime.NOON);
                    }
                    TimePicker.this.zInternalTryChangeTimeByIncrement(1);
                    TimePicker.this.increaseTimer.start();
                }
                if (TimePicker.this.enableArrowKeys && e.isActionKey() && e.getKeyCode() == 40) {
                    e.consume();
                    if (this.downPressed || !TimePicker.this.isEnabled()) {
                        return;
                    }
                    this.downPressed = true;
                    if (TimePicker.this.getTime() == null) {
                        TimePicker.this.setTime(LocalTime.NOON);
                    }
                    TimePicker.this.zInternalTryChangeTimeByIncrement(-1);
                    TimePicker.this.decreaseTimer.start();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isActionKey() && e.getKeyCode() == 38) {
                    e.consume();
                    this.upPressed = false;
                    TimePicker.this.increaseTimer.stop();
                }
                if (e.isActionKey() && e.getKeyCode() == 40) {
                    e.consume();
                    TimePicker.this.decreaseTimer.stop();
                    this.downPressed = false;
                }
            }
        });
    }

    private void zAddTextChangeListener() {
        this.timeTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TimePicker.this.zEventTextFieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TimePicker.this.zEventTextFieldChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TimePicker.this.zEventTextFieldChanged();
            }
        });
    }

    private TimeSpinnerTimer zCreateTimeSpinnerTimer(int changeAmountMinutes) {
        return new TimeSpinnerTimer(this, changeAmountMinutes);
    }

    public void zDrawTextFieldIndicators() {
        if (!this.isEnabled()) {
            this.timeTextField.setBackground(this.settings.getColor(TimePickerSettings.TimeArea.TextFieldBackgroundDisabled));
            this.timeTextField.setFont(this.settings.fontValidTime);
            return;
        }
        this.timeTextField.setBackground(this.settings.getColor(TimePickerSettings.TimeArea.TextFieldBackgroundValidTime));
        this.timeTextField.setForeground(this.settings.getColor(TimePickerSettings.TimeArea.TimePickerTextValidTime));
        this.timeTextField.setFont(this.settings.fontValidTime);
        String timeText = this.timeTextField.getText();
        boolean textIsEmpty = timeText.trim().isEmpty();
        if (textIsEmpty) {
            if (!this.settings.getAllowEmptyTimes()) {
                this.timeTextField.setBackground(this.settings.getColor(TimePickerSettings.TimeArea.TextFieldBackgroundDisallowedEmptyTime));
            }
            return;
        }
        LocalTime parsedTime = InternalUtilities.getParsedTimeOrNull(timeText, this.settings.getFormatForDisplayTime(), this.settings.getFormatForMenuTimes(), this.settings.formatsForParsing, this.settings.getLocale());
        if (parsedTime == null) {
            this.timeTextField.setBackground(this.settings.getColor(TimePickerSettings.TimeArea.TextFieldBackgroundInvalidTime));
            this.timeTextField.setForeground(this.settings.getColor(TimePickerSettings.TimeArea.TimePickerTextInvalidTime));
            this.timeTextField.setFont(this.settings.fontInvalidTime);
            return;
        }
        TimeVetoPolicy vetoPolicy = this.settings.getVetoPolicy();
        boolean isTimeVetoed = InternalUtilities.isTimeVetoed(vetoPolicy, parsedTime);
        if (isTimeVetoed) {
            this.timeTextField.setBackground(this.settings.getColor(TimePickerSettings.TimeArea.TextFieldBackgroundVetoedTime));
            this.timeTextField.setForeground(this.settings.getColor(TimePickerSettings.TimeArea.TimePickerTextVetoedTime));
            this.timeTextField.setFont(this.settings.fontVetoedTime);
        }
    }

    @Override
    public void zEventCustomPopupWasClosed(CustomPopup popup) {
        popup = null;
        if (this.timeMenuPanel != null) {
            this.timeMenuPanel.clearParent();
        }
        this.timeMenuPanel = null;
        this.lastPopupCloseTime = Instant.now();
    }

    private String zGetStandardTextFieldTimeString(LocalTime time) {
        String standardTimeString = "";
        if (time == null) {
            return standardTimeString;
        }
        standardTimeString = time.format(this.settings.getFormatForDisplayTime());
        return standardTimeString;
    }

    private void zInstallSpinnerButtonListener(Component spinnerButton) {
        spinnerButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (!TimePicker.this.isEnabled()) {
                    return;
                }
                if (TimePicker.this.getTime() == null) {
                    TimePicker.this.setTime(LocalTime.NOON);
                }
                if (event.getSource() == TimePicker.this.getComponentDecreaseSpinnerButton()) {
                    TimePicker.this.setTime(TimePicker.this.getTime().plusMinutes(-1L));
                    TimePicker.this.decreaseTimer.start();
                } else {
                    TimePicker.this.setTime(TimePicker.this.getTime().plusMinutes(1L));
                    TimePicker.this.increaseTimer.start();
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.getSource() == TimePicker.this.getComponentDecreaseSpinnerButton()) {
                    TimePicker.this.decreaseTimer.stop();
                } else {
                    TimePicker.this.increaseTimer.stop();
                }
            }
        });
    }

    private void zInternalSetLastValidTimeAndNotifyListeners(LocalTime newTime) {
        LocalTime oldTime = this.lastValidTime;
        this.lastValidTime = newTime;
        if (!PickerUtilities.isSameLocalTime(oldTime, newTime)) {
            for (TimeChangeListener timeChangeListener : this.timeChangeListeners) {
                TimeChangeEvent timeChangeEvent = new TimeChangeEvent(this, oldTime, newTime);
                timeChangeListener.timeChanged(timeChangeEvent);
            }
            this.firePropertyChange("time", oldTime, newTime);
        }
    }

    private void zInternalSetTimeTextField(String text) {
        this.skipTextFieldChangedFunctionWhileTrue = true;
        if (this.settings.useLowercaseForDisplayTime && text != null) {
            text = text.toLowerCase(this.settings.getLocale());
        }
        this.timeTextField.setText(text);
        this.skipTextFieldChangedFunctionWhileTrue = false;
        this.zEventTextFieldChanged();
    }

    public void zInternalTryChangeTimeByIncrement(int changeAmountMinutes) {
        LocalTime timeToTry = this.getTime().plusMinutes(changeAmountMinutes);
        if (!InternalUtilities.isTimeVetoed(this.settings.getVetoPolicy(), timeToTry)) {
            this.setTime(timeToTry);
        }
    }

    public void zSetAppropriateTextFieldMinimumWidth() {
        Integer programmerSuppliedWidth = this.settings.getSizeTextFieldMinimumWidth();
        int minimumWidthPixels = CalculateMinimumTimeFieldSize.getFormattedTimeWidthInPixels(this.settings.getFormatForDisplayTime(), this.settings.fontValidTime, 0);
        if (programmerSuppliedWidth != null) {
            minimumWidthPixels = this.settings.getSizeTextFieldMinimumWidthDefaultOverride() ? Math.max(programmerSuppliedWidth, minimumWidthPixels) : programmerSuppliedWidth;
        }
        Dimension newMinimumSize = this.timeTextField.getMinimumSize();
        newMinimumSize.width = minimumWidthPixels;
        this.timeTextField.setMinimumSize(newMinimumSize);
        Dimension newPreferredSize = this.timeTextField.getPreferredSize();
        newPreferredSize.width = minimumWidthPixels;
        this.timeTextField.setPreferredSize(newPreferredSize);
        this.validate();
    }

    private void zEventTextFieldChanged() {
        if (this.skipTextFieldChangedFunctionWhileTrue) {
            return;
        }
        String timeText = this.timeTextField.getText();
        boolean textIsEmpty = timeText.trim().isEmpty();
        TimeVetoPolicy vetoPolicy = this.settings.getVetoPolicy();
        boolean nullIsAllowed = this.settings.getAllowEmptyTimes();
        LocalTime parsedTime = null;
        if (!textIsEmpty) {
            parsedTime = InternalUtilities.getParsedTimeOrNull(timeText, this.settings.getFormatForDisplayTime(), this.settings.getFormatForMenuTimes(), this.settings.formatsForParsing, this.settings.getLocale());
        }
        boolean timeIsVetoed = false;
        if (parsedTime != null) {
            timeIsVetoed = InternalUtilities.isTimeVetoed(vetoPolicy, parsedTime);
        }
        if (textIsEmpty && nullIsAllowed) {
            this.zInternalSetLastValidTimeAndNotifyListeners(null);
        }
        if (!textIsEmpty && parsedTime != null && !timeIsVetoed) {
            this.zInternalSetLastValidTimeAndNotifyListeners(parsedTime);
        }
        this.zDrawTextFieldIndicators();
        this.firePropertyChange("text", null, this.timeTextField.getText());
    }

    private void zEventToggleTimeMenuButtonMousePressed(MouseEvent e) {
        this.togglePopup();
    }

    private void initComponents() {
        this.timeTextField = new JTextField();
        this.toggleTimeMenuButton = new JButton();
        this.spinnerPanel = new JPanel();
        this.increaseButton = new JButton();
        this.decreaseButton = new JButton();
        this.setLayout(new FormLayout("pref:grow, 3*(pref)", "fill:pref:grow"));
        this.timeTextField.setMargin(new Insets(1, 3, 2, 2));
        this.timeTextField.setBorder(new CompoundBorder(new MatteBorder(1, 1, 1, 1, new Color(122, 138, 153)), new EmptyBorder(1, 3, 2, 2)));
        this.timeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TimePicker.this.setTextFieldToValidStateIfNeeded();
            }
        });
        this.add((Component)this.timeTextField, CC.xy(1, 1));
        this.toggleTimeMenuButton.setText("v");
        this.toggleTimeMenuButton.setFocusPainted(false);
        this.toggleTimeMenuButton.setFocusable(false);
        this.toggleTimeMenuButton.setFont(new Font("Segoe UI", 0, 8));
        this.toggleTimeMenuButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TimePicker.this.zEventToggleTimeMenuButtonMousePressed(e);
            }
        });
        this.add((Component)this.toggleTimeMenuButton, CC.xy(3, 1));
        this.spinnerPanel.setLayout(new FormLayout("default", "fill:pref:grow, fill:default:grow"));
        ((FormLayout)this.spinnerPanel.getLayout()).setRowGroups(new int[][]{{1, 2}});
        this.increaseButton.setFocusPainted(false);
        this.increaseButton.setFocusable(false);
        this.increaseButton.setFont(new Font("Arial", 0, 8));
        this.increaseButton.setText("+");
        this.spinnerPanel.add((Component)this.increaseButton, CC.xy(1, 1));
        this.decreaseButton.setFocusPainted(false);
        this.decreaseButton.setFocusable(false);
        this.decreaseButton.setFont(new Font("Arial", 0, 8));
        this.decreaseButton.setText("-");
        this.spinnerPanel.add((Component)this.decreaseButton, CC.xy(1, 2));
        this.add((Component)this.spinnerPanel, CC.xy(4, 1));
    }
}

