#pragma once

#include <ws2tcpip.h>
#pragma comment (lib, "Ws2_32.lib")

/**
	This module is a plain C class emulation. The POC written by decoder was in cpp and used some classes
	in  particular for the local negotiator.
	See https://stackoverflow.com/questions/40992945/convert-a-cpp-class-cpp-file-into-a-c-structure-c-file
	for how I emulated a class in pure C.

	This class defines a base server object. Inheritance will be emulated in order to create a
	Rogue WinRM service and a simple http server derived from this class.
*/

struct _Server;

typedef void (*serviceConstructor) (struct _Server*, char*, char*);
typedef void (*serviceDestructor) (struct _Server*);
typedef void (*starter) (struct _Server*);
typedef void (*cleaner) (struct _Server*, SOCKET, char*);

typedef struct _Server
{
	// Methods as pointer to functions
	serviceConstructor construct;
	serviceDestructor destruct;
	starter listenerStart;
	cleaner serverStop;

	// Arguments
	char* listen_port;	// Trivial
	char* listen_address;  // Trivial
	SOCKET socket;	// Trivial
	struct addrinfo hints;	// Temporary variables used to compute
	struct addrinfo* socketInfos;
} Server;


// Constructor and destructor
void initService(Server* this, char* listen_address, char* listen_port);
void destructService(Server* this);

// Class methods
static void startListener(Server* this);
static void SocketError(Server* this, SOCKET Socket, char* error_message);

// Static functions
void hexDump_if_debug_env(char* desc, void* addr, int len);
