/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.TestTrigger;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.SkippingStreamCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

class AESNativeCTR
implements StreamCipher,
SkippingStreamCipher,
MultiBlockCipher {
    private static byte[] key = Hex.decode("000102030405060708090a0b0c0d0e0f");
    private static byte[] enc = Hex.decode("c6a13b37878f5b826f4f8162a1c8d8797346139595c0b41e497bbde365f42d0a");
    private static TestTrigger trigger = new TestTrigger();
    private CTRRefWrapper referenceWrapper = null;

    private AESNativeCTR() {
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), byArray, n, this.getBlockSize(), byArray2, n2);
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeCTR.getMultiBlockSize(this.referenceWrapper.getReference());
    }

    @Override
    public int processBlocks(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        int n4 = this.getBlockSize() * n2;
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), byArray, n, n4, byArray2, n3);
    }

    @Override
    public long skip(long l) {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.skip(this.referenceWrapper.getReference(), l);
    }

    @Override
    public long seekTo(long l) {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.seekTo(this.referenceWrapper.getReference(), l);
    }

    @Override
    public long getPosition() {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.getPosition(this.referenceWrapper.getReference());
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof ParametersWithIV) {
            int n;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            int n2 = this.getBlockSize();
            int n3 = n = 8 > n2 / 2 ? n2 / 2 : 8;
            if (n2 - byArray.length > n) {
                throw new IllegalArgumentException("CTR mode requires IV of at least: " + (n2 - n) + " bytes.");
            }
            if (this.referenceWrapper == null) {
                this.referenceWrapper = new CTRRefWrapper(AESNativeCTR.makeNative());
            }
            if (parametersWithIV.getParameters() == null) {
                AESNativeCTR.init(this.referenceWrapper.getReference(), null, byArray);
            } else {
                byte[] byArray2 = ((KeyParameter)parametersWithIV.getParameters()).getKey();
                switch (byArray2.length) {
                    case 16: 
                    case 24: 
                    case 32: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid key length, key must be 16,24 or 32 bytes");
                    }
                }
                AESNativeCTR.init(this.referenceWrapper.getReference(), byArray2, byArray);
            }
        } else {
            throw new IllegalArgumentException("CTR mode requires ParametersWithIV");
        }
        this.reset();
    }

    static native long makeNative();

    @Override
    public String getAlgorithmName() {
        return "AES/CTR";
    }

    @Override
    public byte returnByte(byte by) {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.returnByte(this.referenceWrapper.getReference(), by);
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), byArray, n, n2, byArray2, n3);
    }

    @Override
    public void reset() {
        if (this.referenceWrapper == null) {
            return;
        }
        AESNativeCTR.reset(this.referenceWrapper.getReference());
    }

    private static native long getPosition(long var0);

    private static native int getMultiBlockSize(long var0);

    private static native long skip(long var0, long var2);

    private static native long seekTo(long var0, long var2);

    static native void init(long var0, byte[] var2, byte[] var3);

    private static native byte returnByte(long var0, byte var2);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native void reset(long var0);

    static native void dispose(long var0);

    static AESNativeCTR newInstance() {
        AESNativeCTR aESNativeCTR = new AESNativeCTR();
        if (trigger.triggerTest()) {
            return SelfTestExecutor.validate(FipsAES.CTR.getAlgorithm(), aESNativeCTR, new BasicKatTest<AESNativeCTR>(){

                @Override
                public boolean hasTestPassed(AESNativeCTR aESNativeCTR) throws Exception {
                    byte[] byArray = new byte[32];
                    byte[] byArray2 = new byte[32];
                    byte[] byArray3 = new byte[16];
                    aESNativeCTR.init(true, new ParametersWithIV(new KeyParameterImpl(key), byArray3));
                    aESNativeCTR.processBlocks(byArray, 0, 2, byArray2, 0);
                    if (!Arrays.areEqual(enc, byArray2)) {
                        return false;
                    }
                    aESNativeCTR.init(false, new ParametersWithIV(new KeyParameterImpl(key), byArray3));
                    aESNativeCTR.processBlocks(enc, 0, 2, byArray2, 0);
                    return Arrays.areEqual(byArray, byArray2);
                }
            });
        }
        return aESNativeCTR;
    }

    private static class CTRRefWrapper
    extends NativeReference {
        public CTRRefWrapper(long l) {
            super(l);
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            AESNativeCTR.dispose(l);
        }
    }
}

