/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.text.StringLocated;

public class ReadLineWithYamlHeader
implements ReadLine {
    private final ReadLine source;
    private List<String> yamlHeader;
    private final Map<String, String> metadata = new LinkedHashMap<String, String>();

    public ReadLineWithYamlHeader(ReadLine source) {
        this.source = source;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public StringLocated readLine() throws IOException {
        StringLocated line = this.source.readLine();
        if (this.yamlHeader == null) {
            this.yamlHeader = new ArrayList<String>();
            if (ReadLineWithYamlHeader.isSeparator(line)) {
                while ((line = this.source.readLine()) != null && !ReadLineWithYamlHeader.isSeparator(line)) {
                    String tmp = line.getString();
                    this.yamlHeader.add(tmp);
                    int idx = tmp.indexOf(58);
                    if (idx <= 0) continue;
                    this.metadata.put(tmp.substring(0, idx).trim(), tmp.substring(idx + 1).trim());
                }
                line = this.source.readLine();
            }
        }
        return line;
    }

    private static boolean isSeparator(StringLocated line) {
        return line.getString().equals("---");
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public static List<StringLocated> removeYamlHeader(List<StringLocated> input) {
        if (input.size() > 1 && ReadLineWithYamlHeader.isSeparator(input.get(1))) {
            ArrayList<StringLocated> result = new ArrayList<StringLocated>();
            result.add(input.get(0));
            for (int i = 2; i < input.size(); ++i) {
                if (!ReadLineWithYamlHeader.isSeparator(input.get(i))) continue;
                result.addAll(input.subList(i + 1, input.size()));
                return result;
            }
        }
        return input;
    }
}

