from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

FARSI_LANG_MODEL = {
    40: {  # 'ء'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.NEGATIVE,  # 'ئ'
        1: SequenceLikelihood.LIKELY,  # 'ا'
        10: SequenceLikelihood.UNLIKELY,  # 'ب'
        9: SequenceLikelihood.UNLIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.UNLIKELY,  # 'د'
        30: SequenceLikelihood.NEGATIVE,  # 'ذ'
        3: SequenceLikelihood.UNLIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.NEGATIVE,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.UNLIKELY,  # 'ل'
        8: SequenceLikelihood.UNLIKELY,  # 'م'
        5: SequenceLikelihood.UNLIKELY,  # 'ن'
        6: SequenceLikelihood.UNLIKELY,  # 'ه'
        7: SequenceLikelihood.UNLIKELY,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.NEGATIVE,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.NEGATIVE,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.UNLIKELY,  # 'ی'
    },
    24: {  # 'آ'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.UNLIKELY,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.LIKELY,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.POSITIVE,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.LIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.LIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    35: {  # 'أ'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.UNLIKELY,  # 'ا'
        10: SequenceLikelihood.UNLIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.UNLIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.UNLIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.LIKELY,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.NEGATIVE,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.LIKELY,  # 'ی'
    },
    42: {  # 'ؤ'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.LIKELY,  # 'ا'
        10: SequenceLikelihood.UNLIKELY,  # 'ب'
        9: SequenceLikelihood.UNLIKELY,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.NEGATIVE,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.UNLIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.UNLIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.NEGATIVE,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.NEGATIVE,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.UNLIKELY,  # 'ن'
        6: SequenceLikelihood.UNLIKELY,  # 'ه'
        7: SequenceLikelihood.LIKELY,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.NEGATIVE,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.LIKELY,  # 'ی'
    },
    43: {  # 'إ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.NEGATIVE,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.NEGATIVE,  # 'ئ'
        1: SequenceLikelihood.UNLIKELY,  # 'ا'
        10: SequenceLikelihood.UNLIKELY,  # 'ب'
        9: SequenceLikelihood.UNLIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.UNLIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.UNLIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.UNLIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.UNLIKELY,  # 'ه'
        7: SequenceLikelihood.UNLIKELY,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.NEGATIVE,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.NEGATIVE,  # 'ّ'
        23: SequenceLikelihood.NEGATIVE,  # 'پ'
        27: SequenceLikelihood.NEGATIVE,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.NEGATIVE,  # 'گ'
        2: SequenceLikelihood.UNLIKELY,  # 'ی'
    },
    33: {  # 'ئ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.LIKELY,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.LIKELY,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.NEGATIVE,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    1: {  # 'ا'
        40: SequenceLikelihood.LIKELY,  # 'ء'
        24: SequenceLikelihood.LIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.POSITIVE,  # 'ئ'
        1: SequenceLikelihood.LIKELY,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.POSITIVE,  # 'ث'
        21: SequenceLikelihood.POSITIVE,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.POSITIVE,  # 'ص'
        28: SequenceLikelihood.POSITIVE,  # 'ض'
        26: SequenceLikelihood.POSITIVE,  # 'ط'
        31: SequenceLikelihood.POSITIVE,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.POSITIVE,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.POSITIVE,  # 'ً'
        44: SequenceLikelihood.LIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.POSITIVE,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.LIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    10: {  # 'ب'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.LIKELY,  # 'ص'
        28: SequenceLikelihood.LIKELY,  # 'ض'
        26: SequenceLikelihood.POSITIVE,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    9: {  # 'ت'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.LIKELY,  # 'آ'
        35: SequenceLikelihood.POSITIVE,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.POSITIVE,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.POSITIVE,  # 'ص'
        28: SequenceLikelihood.LIKELY,  # 'ض'
        26: SequenceLikelihood.LIKELY,  # 'ط'
        31: SequenceLikelihood.POSITIVE,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.POSITIVE,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.LIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    32: {  # 'ث'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.UNLIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.LIKELY,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    21: {  # 'ج'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.LIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.LIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.LIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    22: {  # 'ح'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.POSITIVE,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.LIKELY,  # 'ش'
        25: SequenceLikelihood.POSITIVE,  # 'ص'
        28: SequenceLikelihood.POSITIVE,  # 'ض'
        26: SequenceLikelihood.LIKELY,  # 'ط'
        31: SequenceLikelihood.LIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.LIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    18: {  # 'خ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.POSITIVE,  # 'ص'
        28: SequenceLikelihood.LIKELY,  # 'ض'
        26: SequenceLikelihood.POSITIVE,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.LIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    4: {  # 'د'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.LIKELY,  # 'آ'
        35: SequenceLikelihood.LIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.LIKELY,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.LIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.LIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.LIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    30: {  # 'ذ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.UNLIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.NEGATIVE,  # 'ط'
        31: SequenceLikelihood.NEGATIVE,  # 'ظ'
        19: SequenceLikelihood.LIKELY,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.UNLIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.LIKELY,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    3: {  # 'ر'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.POSITIVE,  # 'آ'
        35: SequenceLikelihood.LIKELY,  # 'أ'
        42: SequenceLikelihood.LIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.POSITIVE,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.POSITIVE,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.POSITIVE,  # 'ص'
        28: SequenceLikelihood.POSITIVE,  # 'ض'
        26: SequenceLikelihood.POSITIVE,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.POSITIVE,  # 'پ'
        27: SequenceLikelihood.POSITIVE,  # 'چ'
        34: SequenceLikelihood.POSITIVE,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    15: {  # 'ز'
        40: SequenceLikelihood.LIKELY,  # 'ء'
        24: SequenceLikelihood.LIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.LIKELY,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.LIKELY,  # 'ط'
        31: SequenceLikelihood.LIKELY,  # 'ظ'
        19: SequenceLikelihood.LIKELY,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    11: {  # 'س'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.LIKELY,  # 'أ'
        42: SequenceLikelihood.LIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.POSITIVE,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.LIKELY,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.LIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.POSITIVE,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.POSITIVE,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.LIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    14: {  # 'ش'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.LIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.LIKELY,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.LIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.LIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.LIKELY,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    25: {  # 'ص'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.POSITIVE,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.LIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.LIKELY,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    28: {  # 'ض'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.NEGATIVE,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.LIKELY,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.NEGATIVE,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.LIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.UNLIKELY,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    26: {  # 'ط'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.UNLIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.UNLIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.LIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    31: {  # 'ظ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.NEGATIVE,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.UNLIKELY,  # 'د'
        30: SequenceLikelihood.NEGATIVE,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.NEGATIVE,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.LIKELY,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.NEGATIVE,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    19: {  # 'ع'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.POSITIVE,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.LIKELY,  # 'ش'
        25: SequenceLikelihood.LIKELY,  # 'ص'
        28: SequenceLikelihood.POSITIVE,  # 'ض'
        26: SequenceLikelihood.LIKELY,  # 'ط'
        31: SequenceLikelihood.LIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    29: {  # 'غ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.POSITIVE,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.LIKELY,  # 'ش'
        25: SequenceLikelihood.LIKELY,  # 'ص'
        28: SequenceLikelihood.LIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.LIKELY,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.LIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    16: {  # 'ف'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.LIKELY,  # 'ص'
        28: SequenceLikelihood.POSITIVE,  # 'ض'
        26: SequenceLikelihood.LIKELY,  # 'ط'
        31: SequenceLikelihood.POSITIVE,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.LIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    20: {  # 'ق'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.POSITIVE,  # 'ص'
        28: SequenceLikelihood.LIKELY,  # 'ض'
        26: SequenceLikelihood.POSITIVE,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    13: {  # 'ل'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.LIKELY,  # 'آ'
        35: SequenceLikelihood.LIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.LIKELY,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.LIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.LIKELY,  # 'ط'
        31: SequenceLikelihood.LIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.LIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    8: {  # 'م'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.LIKELY,  # 'آ'
        35: SequenceLikelihood.LIKELY,  # 'أ'
        42: SequenceLikelihood.LIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.POSITIVE,  # 'ث'
        21: SequenceLikelihood.POSITIVE,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.POSITIVE,  # 'ص'
        28: SequenceLikelihood.LIKELY,  # 'ض'
        26: SequenceLikelihood.POSITIVE,  # 'ط'
        31: SequenceLikelihood.LIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.POSITIVE,  # 'پ'
        27: SequenceLikelihood.POSITIVE,  # 'چ'
        34: SequenceLikelihood.LIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    5: {  # 'ن'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.LIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.POSITIVE,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.POSITIVE,  # 'ص'
        28: SequenceLikelihood.LIKELY,  # 'ض'
        26: SequenceLikelihood.POSITIVE,  # 'ط'
        31: SequenceLikelihood.POSITIVE,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.POSITIVE,  # 'چ'
        34: SequenceLikelihood.LIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    6: {  # 'ه'
        40: SequenceLikelihood.LIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.LIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.LIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    7: {  # 'و'
        40: SequenceLikelihood.LIKELY,  # 'ء'
        24: SequenceLikelihood.LIKELY,  # 'آ'
        35: SequenceLikelihood.LIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.POSITIVE,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.POSITIVE,  # 'ص'
        28: SequenceLikelihood.POSITIVE,  # 'ض'
        26: SequenceLikelihood.POSITIVE,  # 'ط'
        31: SequenceLikelihood.LIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.POSITIVE,  # 'پ'
        27: SequenceLikelihood.POSITIVE,  # 'چ'
        34: SequenceLikelihood.POSITIVE,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    36: {  # 'ً'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.NEGATIVE,  # 'ئ'
        1: SequenceLikelihood.LIKELY,  # 'ا'
        10: SequenceLikelihood.UNLIKELY,  # 'ب'
        9: SequenceLikelihood.UNLIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.UNLIKELY,  # 'د'
        30: SequenceLikelihood.NEGATIVE,  # 'ذ'
        3: SequenceLikelihood.UNLIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.NEGATIVE,  # 'ط'
        31: SequenceLikelihood.NEGATIVE,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.UNLIKELY,  # 'ل'
        8: SequenceLikelihood.UNLIKELY,  # 'م'
        5: SequenceLikelihood.UNLIKELY,  # 'ن'
        6: SequenceLikelihood.UNLIKELY,  # 'ه'
        7: SequenceLikelihood.UNLIKELY,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.UNLIKELY,  # 'ی'
    },
    44: {  # 'ٌ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.NEGATIVE,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.NEGATIVE,  # 'ئ'
        1: SequenceLikelihood.UNLIKELY,  # 'ا'
        10: SequenceLikelihood.UNLIKELY,  # 'ب'
        9: SequenceLikelihood.UNLIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.NEGATIVE,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.NEGATIVE,  # 'د'
        30: SequenceLikelihood.NEGATIVE,  # 'ذ'
        3: SequenceLikelihood.UNLIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.NEGATIVE,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.NEGATIVE,  # 'ط'
        31: SequenceLikelihood.NEGATIVE,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.NEGATIVE,  # 'ق'
        13: SequenceLikelihood.UNLIKELY,  # 'ل'
        8: SequenceLikelihood.UNLIKELY,  # 'م'
        5: SequenceLikelihood.UNLIKELY,  # 'ن'
        6: SequenceLikelihood.UNLIKELY,  # 'ه'
        7: SequenceLikelihood.NEGATIVE,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.NEGATIVE,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.NEGATIVE,  # 'گ'
        2: SequenceLikelihood.UNLIKELY,  # 'ی'
    },
    45: {  # 'ٍ'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.NEGATIVE,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.NEGATIVE,  # 'ئ'
        1: SequenceLikelihood.UNLIKELY,  # 'ا'
        10: SequenceLikelihood.NEGATIVE,  # 'ب'
        9: SequenceLikelihood.UNLIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.NEGATIVE,  # 'ج'
        22: SequenceLikelihood.NEGATIVE,  # 'ح'
        18: SequenceLikelihood.NEGATIVE,  # 'خ'
        4: SequenceLikelihood.UNLIKELY,  # 'د'
        30: SequenceLikelihood.NEGATIVE,  # 'ذ'
        3: SequenceLikelihood.UNLIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.NEGATIVE,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.NEGATIVE,  # 'ط'
        31: SequenceLikelihood.NEGATIVE,  # 'ظ'
        19: SequenceLikelihood.NEGATIVE,  # 'ع'
        29: SequenceLikelihood.NEGATIVE,  # 'غ'
        16: SequenceLikelihood.NEGATIVE,  # 'ف'
        20: SequenceLikelihood.NEGATIVE,  # 'ق'
        13: SequenceLikelihood.UNLIKELY,  # 'ل'
        8: SequenceLikelihood.UNLIKELY,  # 'م'
        5: SequenceLikelihood.NEGATIVE,  # 'ن'
        6: SequenceLikelihood.NEGATIVE,  # 'ه'
        7: SequenceLikelihood.UNLIKELY,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.NEGATIVE,  # 'َ'
        41: SequenceLikelihood.NEGATIVE,  # 'ُ'
        38: SequenceLikelihood.NEGATIVE,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.NEGATIVE,  # 'پ'
        27: SequenceLikelihood.NEGATIVE,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.NEGATIVE,  # 'گ'
        2: SequenceLikelihood.NEGATIVE,  # 'ی'
    },
    37: {  # 'َ'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.LIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.LIKELY,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.LIKELY,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.LIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.LIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.LIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.LIKELY,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.LIKELY,  # 'ی'
    },
    41: {  # 'ُ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.UNLIKELY,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.UNLIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.LIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.LIKELY,  # 'ر'
        15: SequenceLikelihood.LIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.LIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.LIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.LIKELY,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.NEGATIVE,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.UNLIKELY,  # 'ی'
    },
    38: {  # 'ِ'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.LIKELY,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.LIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.LIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.UNLIKELY,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.NEGATIVE,  # 'َ'
        41: SequenceLikelihood.NEGATIVE,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.LIKELY,  # 'ی'
    },
    39: {  # 'ّ'
        40: SequenceLikelihood.UNLIKELY,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.LIKELY,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.LIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.UNLIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.LIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.LIKELY,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.NEGATIVE,  # 'َ'
        41: SequenceLikelihood.NEGATIVE,  # 'ُ'
        38: SequenceLikelihood.NEGATIVE,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.NEGATIVE,  # 'چ'
        34: SequenceLikelihood.NEGATIVE,  # 'ژ'
        12: SequenceLikelihood.UNLIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.LIKELY,  # 'ی'
    },
    23: {  # 'پ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.UNLIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.LIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.POSITIVE,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.LIKELY,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.LIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.LIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    27: {  # 'چ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.UNLIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.LIKELY,  # 'ط'
        31: SequenceLikelihood.NEGATIVE,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.LIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    34: {  # 'ژ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.NEGATIVE,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.UNLIKELY,  # 'ب'
        9: SequenceLikelihood.UNLIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.UNLIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.UNLIKELY,  # 'ذ'
        3: SequenceLikelihood.LIKELY,  # 'ر'
        15: SequenceLikelihood.UNLIKELY,  # 'ز'
        11: SequenceLikelihood.LIKELY,  # 'س'
        14: SequenceLikelihood.UNLIKELY,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.NEGATIVE,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.UNLIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.LIKELY,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.LIKELY,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.NEGATIVE,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.NEGATIVE,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.UNLIKELY,  # 'ِ'
        39: SequenceLikelihood.NEGATIVE,  # 'ّ'
        23: SequenceLikelihood.UNLIKELY,  # 'پ'
        27: SequenceLikelihood.UNLIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.LIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    12: {  # 'ک'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.UNLIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.LIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.LIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.LIKELY,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    17: {  # 'گ'
        40: SequenceLikelihood.NEGATIVE,  # 'ء'
        24: SequenceLikelihood.UNLIKELY,  # 'آ'
        35: SequenceLikelihood.NEGATIVE,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.NEGATIVE,  # 'إ'
        33: SequenceLikelihood.UNLIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.LIKELY,  # 'ب'
        9: SequenceLikelihood.LIKELY,  # 'ت'
        32: SequenceLikelihood.UNLIKELY,  # 'ث'
        21: SequenceLikelihood.LIKELY,  # 'ج'
        22: SequenceLikelihood.UNLIKELY,  # 'ح'
        18: SequenceLikelihood.UNLIKELY,  # 'خ'
        4: SequenceLikelihood.LIKELY,  # 'د'
        30: SequenceLikelihood.POSITIVE,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.UNLIKELY,  # 'ص'
        28: SequenceLikelihood.UNLIKELY,  # 'ض'
        26: SequenceLikelihood.UNLIKELY,  # 'ط'
        31: SequenceLikelihood.UNLIKELY,  # 'ظ'
        19: SequenceLikelihood.UNLIKELY,  # 'ع'
        29: SequenceLikelihood.UNLIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.UNLIKELY,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.LIKELY,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.NEGATIVE,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.UNLIKELY,  # 'َ'
        41: SequenceLikelihood.UNLIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.UNLIKELY,  # 'ّ'
        23: SequenceLikelihood.LIKELY,  # 'پ'
        27: SequenceLikelihood.LIKELY,  # 'چ'
        34: SequenceLikelihood.UNLIKELY,  # 'ژ'
        12: SequenceLikelihood.LIKELY,  # 'ک'
        17: SequenceLikelihood.UNLIKELY,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
    2: {  # 'ی'
        40: SequenceLikelihood.LIKELY,  # 'ء'
        24: SequenceLikelihood.LIKELY,  # 'آ'
        35: SequenceLikelihood.LIKELY,  # 'أ'
        42: SequenceLikelihood.UNLIKELY,  # 'ؤ'
        43: SequenceLikelihood.UNLIKELY,  # 'إ'
        33: SequenceLikelihood.LIKELY,  # 'ئ'
        1: SequenceLikelihood.POSITIVE,  # 'ا'
        10: SequenceLikelihood.POSITIVE,  # 'ب'
        9: SequenceLikelihood.POSITIVE,  # 'ت'
        32: SequenceLikelihood.LIKELY,  # 'ث'
        21: SequenceLikelihood.POSITIVE,  # 'ج'
        22: SequenceLikelihood.POSITIVE,  # 'ح'
        18: SequenceLikelihood.POSITIVE,  # 'خ'
        4: SequenceLikelihood.POSITIVE,  # 'د'
        30: SequenceLikelihood.LIKELY,  # 'ذ'
        3: SequenceLikelihood.POSITIVE,  # 'ر'
        15: SequenceLikelihood.POSITIVE,  # 'ز'
        11: SequenceLikelihood.POSITIVE,  # 'س'
        14: SequenceLikelihood.POSITIVE,  # 'ش'
        25: SequenceLikelihood.LIKELY,  # 'ص'
        28: SequenceLikelihood.LIKELY,  # 'ض'
        26: SequenceLikelihood.POSITIVE,  # 'ط'
        31: SequenceLikelihood.LIKELY,  # 'ظ'
        19: SequenceLikelihood.POSITIVE,  # 'ع'
        29: SequenceLikelihood.LIKELY,  # 'غ'
        16: SequenceLikelihood.POSITIVE,  # 'ف'
        20: SequenceLikelihood.POSITIVE,  # 'ق'
        13: SequenceLikelihood.POSITIVE,  # 'ل'
        8: SequenceLikelihood.POSITIVE,  # 'م'
        5: SequenceLikelihood.POSITIVE,  # 'ن'
        6: SequenceLikelihood.POSITIVE,  # 'ه'
        7: SequenceLikelihood.POSITIVE,  # 'و'
        36: SequenceLikelihood.UNLIKELY,  # 'ً'
        44: SequenceLikelihood.UNLIKELY,  # 'ٌ'
        45: SequenceLikelihood.UNLIKELY,  # 'ٍ'
        37: SequenceLikelihood.LIKELY,  # 'َ'
        41: SequenceLikelihood.LIKELY,  # 'ُ'
        38: SequenceLikelihood.LIKELY,  # 'ِ'
        39: SequenceLikelihood.LIKELY,  # 'ّ'
        23: SequenceLikelihood.POSITIVE,  # 'پ'
        27: SequenceLikelihood.POSITIVE,  # 'چ'
        34: SequenceLikelihood.POSITIVE,  # 'ژ'
        12: SequenceLikelihood.POSITIVE,  # 'ک'
        17: SequenceLikelihood.POSITIVE,  # 'گ'
        2: SequenceLikelihood.POSITIVE,  # 'ی'
    },
}

# Character Mapping Table(s):
CP720_FARSI_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: 0,  # 'à'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: 39,  # 'ّ'
    146: CharacterCategory.SYMBOL,  # 'ْ'
    147: 0,  # 'ô'
    148: CharacterCategory.SYMBOL,  # '¤'
    149: 0,  # 'ـ'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 40,  # 'ء'
    153: 24,  # 'آ'
    154: 35,  # 'أ'
    155: 42,  # 'ؤ'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 43,  # 'إ'
    158: 33,  # 'ئ'
    159: 1,  # 'ا'
    160: 10,  # 'ب'
    161: 0,  # 'ة'
    162: 9,  # 'ت'
    163: 32,  # 'ث'
    164: 21,  # 'ج'
    165: 22,  # 'ح'
    166: 18,  # 'خ'
    167: 4,  # 'د'
    168: 30,  # 'ذ'
    169: 3,  # 'ر'
    170: 15,  # 'ز'
    171: 11,  # 'س'
    172: 14,  # 'ش'
    173: 25,  # 'ص'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 28,  # 'ض'
    225: 26,  # 'ط'
    226: 31,  # 'ظ'
    227: 19,  # 'ع'
    228: 29,  # 'غ'
    229: 16,  # 'ف'
    230: 0,  # 'µ'
    231: 20,  # 'ق'
    232: 0,  # 'ك'
    233: 13,  # 'ل'
    234: 8,  # 'م'
    235: 5,  # 'ن'
    236: 6,  # 'ه'
    237: 7,  # 'و'
    238: 0,  # 'ى'
    239: 0,  # 'ي'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: 36,  # 'ً'
    242: 44,  # 'ٌ'
    243: 45,  # 'ٍ'
    244: 37,  # 'َ'
    245: 41,  # 'ُ'
    246: 38,  # 'ِ'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP720_FARSI_MODEL = SingleByteCharSetModel(
    charset_name="CP720",
    language="Farsi",
    char_to_order_map=CP720_FARSI_CHAR_TO_ORDER,
    language_model=FARSI_LANG_MODEL,
    typical_positive_ratio=0.9812778147522896,
    keep_ascii_letters=False,
    alphabet="ءآأؤإئابتثجحخدذرزسشصضطظعغفقلمنهوًٌٍَُِّپچژکگی",
)

CP864_FARSI_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '٪'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '°'
    129: CharacterCategory.SYMBOL,  # '·'
    130: CharacterCategory.SYMBOL,  # '∙'
    131: CharacterCategory.SYMBOL,  # '√'
    132: CharacterCategory.SYMBOL,  # '▒'
    133: CharacterCategory.SYMBOL,  # '─'
    134: CharacterCategory.SYMBOL,  # '│'
    135: CharacterCategory.SYMBOL,  # '┼'
    136: CharacterCategory.SYMBOL,  # '┤'
    137: CharacterCategory.SYMBOL,  # '┬'
    138: CharacterCategory.SYMBOL,  # '├'
    139: CharacterCategory.SYMBOL,  # '┴'
    140: CharacterCategory.SYMBOL,  # '┐'
    141: CharacterCategory.SYMBOL,  # '┌'
    142: CharacterCategory.SYMBOL,  # '└'
    143: CharacterCategory.SYMBOL,  # '┘'
    144: 0,  # 'β'
    145: CharacterCategory.SYMBOL,  # '∞'
    146: 0,  # 'φ'
    147: CharacterCategory.SYMBOL,  # '±'
    148: CharacterCategory.DIGIT,  # '½'
    149: CharacterCategory.DIGIT,  # '¼'
    150: CharacterCategory.SYMBOL,  # '≈'
    151: CharacterCategory.SYMBOL,  # '«'
    152: CharacterCategory.SYMBOL,  # '»'
    153: 0,  # 'ﻷ'
    154: 0,  # 'ﻸ'
    155: CharacterCategory.UNDEFINED,  # None
    156: CharacterCategory.UNDEFINED,  # None
    157: 0,  # 'ﻻ'
    158: 0,  # 'ﻼ'
    159: CharacterCategory.UNDEFINED,  # None
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.CONTROL,  # '\xad'
    162: 0,  # 'ﺂ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'ﺄ'
    166: CharacterCategory.UNDEFINED,  # None
    167: CharacterCategory.UNDEFINED,  # None
    168: 0,  # 'ﺎ'
    169: 0,  # 'ﺏ'
    170: 0,  # 'ﺕ'
    171: 0,  # 'ﺙ'
    172: CharacterCategory.SYMBOL,  # '،'
    173: 0,  # 'ﺝ'
    174: 0,  # 'ﺡ'
    175: 0,  # 'ﺥ'
    176: CharacterCategory.DIGIT,  # '٠'
    177: CharacterCategory.DIGIT,  # '١'
    178: CharacterCategory.DIGIT,  # '٢'
    179: CharacterCategory.DIGIT,  # '٣'
    180: CharacterCategory.DIGIT,  # '٤'
    181: CharacterCategory.DIGIT,  # '٥'
    182: CharacterCategory.DIGIT,  # '٦'
    183: CharacterCategory.DIGIT,  # '٧'
    184: CharacterCategory.DIGIT,  # '٨'
    185: CharacterCategory.DIGIT,  # '٩'
    186: 0,  # 'ﻑ'
    187: CharacterCategory.SYMBOL,  # '؛'
    188: 0,  # 'ﺱ'
    189: 0,  # 'ﺵ'
    190: 0,  # 'ﺹ'
    191: CharacterCategory.SYMBOL,  # '؟'
    192: CharacterCategory.SYMBOL,  # '¢'
    193: 0,  # 'ﺀ'
    194: 0,  # 'ﺁ'
    195: 0,  # 'ﺃ'
    196: 0,  # 'ﺅ'
    197: 0,  # 'ﻊ'
    198: 0,  # 'ﺋ'
    199: 0,  # 'ﺍ'
    200: 0,  # 'ﺑ'
    201: 0,  # 'ﺓ'
    202: 0,  # 'ﺗ'
    203: 0,  # 'ﺛ'
    204: 0,  # 'ﺟ'
    205: 0,  # 'ﺣ'
    206: 0,  # 'ﺧ'
    207: 0,  # 'ﺩ'
    208: 0,  # 'ﺫ'
    209: 0,  # 'ﺭ'
    210: 0,  # 'ﺯ'
    211: 0,  # 'ﺳ'
    212: 0,  # 'ﺷ'
    213: 0,  # 'ﺻ'
    214: 0,  # 'ﺿ'
    215: 0,  # 'ﻁ'
    216: 0,  # 'ﻅ'
    217: 0,  # 'ﻋ'
    218: 0,  # 'ﻏ'
    219: CharacterCategory.SYMBOL,  # '¦'
    220: CharacterCategory.SYMBOL,  # '¬'
    221: CharacterCategory.SYMBOL,  # '÷'
    222: CharacterCategory.SYMBOL,  # '×'
    223: 0,  # 'ﻉ'
    224: 0,  # 'ـ'
    225: 0,  # 'ﻓ'
    226: 0,  # 'ﻗ'
    227: 0,  # 'ﻛ'
    228: 0,  # 'ﻟ'
    229: 0,  # 'ﻣ'
    230: 0,  # 'ﻧ'
    231: 0,  # 'ﻫ'
    232: 0,  # 'ﻭ'
    233: 0,  # 'ﻯ'
    234: 0,  # 'ﻳ'
    235: 0,  # 'ﺽ'
    236: 0,  # 'ﻌ'
    237: 0,  # 'ﻎ'
    238: 0,  # 'ﻍ'
    239: 0,  # 'ﻡ'
    240: 0,  # 'ﹽ'
    241: 39,  # 'ّ'
    242: 0,  # 'ﻥ'
    243: 0,  # 'ﻩ'
    244: 0,  # 'ﻬ'
    245: 0,  # 'ﻰ'
    246: 0,  # 'ﻲ'
    247: 0,  # 'ﻐ'
    248: 0,  # 'ﻕ'
    249: 0,  # 'ﻵ'
    250: 0,  # 'ﻶ'
    251: 0,  # 'ﻝ'
    252: 0,  # 'ﻙ'
    253: 0,  # 'ﻱ'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.UNDEFINED,  # None
}

CP864_FARSI_MODEL = SingleByteCharSetModel(
    charset_name="CP864",
    language="Farsi",
    char_to_order_map=CP864_FARSI_CHAR_TO_ORDER,
    language_model=FARSI_LANG_MODEL,
    typical_positive_ratio=0.0,
    keep_ascii_letters=False,
    alphabet="ءآأؤإئابتثجحخدذرزسشصضطظعغفقلمنهوًٌٍَُِّپچژکگی",
)

ISO_8859_6_FARSI_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.UNDEFINED,  # None
    162: CharacterCategory.UNDEFINED,  # None
    163: CharacterCategory.UNDEFINED,  # None
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.UNDEFINED,  # None
    166: CharacterCategory.UNDEFINED,  # None
    167: CharacterCategory.UNDEFINED,  # None
    168: CharacterCategory.UNDEFINED,  # None
    169: CharacterCategory.UNDEFINED,  # None
    170: CharacterCategory.UNDEFINED,  # None
    171: CharacterCategory.UNDEFINED,  # None
    172: CharacterCategory.SYMBOL,  # '،'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.UNDEFINED,  # None
    175: CharacterCategory.UNDEFINED,  # None
    176: CharacterCategory.UNDEFINED,  # None
    177: CharacterCategory.UNDEFINED,  # None
    178: CharacterCategory.UNDEFINED,  # None
    179: CharacterCategory.UNDEFINED,  # None
    180: CharacterCategory.UNDEFINED,  # None
    181: CharacterCategory.UNDEFINED,  # None
    182: CharacterCategory.UNDEFINED,  # None
    183: CharacterCategory.UNDEFINED,  # None
    184: CharacterCategory.UNDEFINED,  # None
    185: CharacterCategory.UNDEFINED,  # None
    186: CharacterCategory.UNDEFINED,  # None
    187: CharacterCategory.SYMBOL,  # '؛'
    188: CharacterCategory.UNDEFINED,  # None
    189: CharacterCategory.UNDEFINED,  # None
    190: CharacterCategory.UNDEFINED,  # None
    191: CharacterCategory.SYMBOL,  # '؟'
    192: CharacterCategory.UNDEFINED,  # None
    193: 40,  # 'ء'
    194: 24,  # 'آ'
    195: 35,  # 'أ'
    196: 42,  # 'ؤ'
    197: 43,  # 'إ'
    198: 33,  # 'ئ'
    199: 1,  # 'ا'
    200: 10,  # 'ب'
    201: 0,  # 'ة'
    202: 9,  # 'ت'
    203: 32,  # 'ث'
    204: 21,  # 'ج'
    205: 22,  # 'ح'
    206: 18,  # 'خ'
    207: 4,  # 'د'
    208: 30,  # 'ذ'
    209: 3,  # 'ر'
    210: 15,  # 'ز'
    211: 11,  # 'س'
    212: 14,  # 'ش'
    213: 25,  # 'ص'
    214: 28,  # 'ض'
    215: 26,  # 'ط'
    216: 31,  # 'ظ'
    217: 19,  # 'ع'
    218: 29,  # 'غ'
    219: CharacterCategory.UNDEFINED,  # None
    220: CharacterCategory.UNDEFINED,  # None
    221: CharacterCategory.UNDEFINED,  # None
    222: CharacterCategory.UNDEFINED,  # None
    223: CharacterCategory.UNDEFINED,  # None
    224: 0,  # 'ـ'
    225: 16,  # 'ف'
    226: 20,  # 'ق'
    227: 0,  # 'ك'
    228: 13,  # 'ل'
    229: 8,  # 'م'
    230: 5,  # 'ن'
    231: 6,  # 'ه'
    232: 7,  # 'و'
    233: 0,  # 'ى'
    234: 0,  # 'ي'
    235: 36,  # 'ً'
    236: 44,  # 'ٌ'
    237: 45,  # 'ٍ'
    238: 37,  # 'َ'
    239: 41,  # 'ُ'
    240: 38,  # 'ِ'
    241: 39,  # 'ّ'
    242: CharacterCategory.SYMBOL,  # 'ْ'
    243: CharacterCategory.UNDEFINED,  # None
    244: CharacterCategory.UNDEFINED,  # None
    245: CharacterCategory.UNDEFINED,  # None
    246: CharacterCategory.UNDEFINED,  # None
    247: CharacterCategory.UNDEFINED,  # None
    248: CharacterCategory.UNDEFINED,  # None
    249: CharacterCategory.UNDEFINED,  # None
    250: CharacterCategory.UNDEFINED,  # None
    251: CharacterCategory.UNDEFINED,  # None
    252: CharacterCategory.UNDEFINED,  # None
    253: CharacterCategory.UNDEFINED,  # None
    254: CharacterCategory.UNDEFINED,  # None
    255: CharacterCategory.UNDEFINED,  # None
}

ISO_8859_6_FARSI_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-6",
    language="Farsi",
    char_to_order_map=ISO_8859_6_FARSI_CHAR_TO_ORDER,
    language_model=FARSI_LANG_MODEL,
    typical_positive_ratio=0.9812778147522896,
    keep_ascii_letters=False,
    alphabet="ءآأؤإئابتثجحخدذرزسشصضطظعغفقلمنهوًٌٍَُِّپچژکگی",
)

WINDOWS_1256_FARSI_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: 23,  # 'پ'
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'ٹ'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: 27,  # 'چ'
    142: 34,  # 'ژ'
    143: 0,  # 'ڈ'
    144: 17,  # 'گ'
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: 12,  # 'ک'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'ڑ'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.CONTROL,  # '\u200c'
    158: CharacterCategory.CONTROL,  # '\u200d'
    159: 0,  # 'ں'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '،'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ھ'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: CharacterCategory.SYMBOL,  # '؛'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '؟'
    192: 0,  # 'ہ'
    193: 40,  # 'ء'
    194: 24,  # 'آ'
    195: 35,  # 'أ'
    196: 42,  # 'ؤ'
    197: 43,  # 'إ'
    198: 33,  # 'ئ'
    199: 1,  # 'ا'
    200: 10,  # 'ب'
    201: 0,  # 'ة'
    202: 9,  # 'ت'
    203: 32,  # 'ث'
    204: 21,  # 'ج'
    205: 22,  # 'ح'
    206: 18,  # 'خ'
    207: 4,  # 'د'
    208: 30,  # 'ذ'
    209: 3,  # 'ر'
    210: 15,  # 'ز'
    211: 11,  # 'س'
    212: 14,  # 'ش'
    213: 25,  # 'ص'
    214: 28,  # 'ض'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 26,  # 'ط'
    217: 31,  # 'ظ'
    218: 19,  # 'ع'
    219: 29,  # 'غ'
    220: 0,  # 'ـ'
    221: 16,  # 'ف'
    222: 20,  # 'ق'
    223: 0,  # 'ك'
    224: 0,  # 'à'
    225: 13,  # 'ل'
    226: 0,  # 'â'
    227: 8,  # 'م'
    228: 5,  # 'ن'
    229: 6,  # 'ه'
    230: 7,  # 'و'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ى'
    237: 0,  # 'ي'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 36,  # 'ً'
    241: 44,  # 'ٌ'
    242: 45,  # 'ٍ'
    243: 37,  # 'َ'
    244: 0,  # 'ô'
    245: 41,  # 'ُ'
    246: 38,  # 'ِ'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 39,  # 'ّ'
    249: 0,  # 'ù'
    250: CharacterCategory.SYMBOL,  # 'ْ'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: CharacterCategory.CONTROL,  # '\u200e'
    254: CharacterCategory.CONTROL,  # '\u200f'
    255: 0,  # 'ے'
}

WINDOWS_1256_FARSI_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1256",
    language="Farsi",
    char_to_order_map=WINDOWS_1256_FARSI_CHAR_TO_ORDER,
    language_model=FARSI_LANG_MODEL,
    typical_positive_ratio=0.9786295507239238,
    keep_ascii_letters=False,
    alphabet="ءآأؤإئابتثجحخدذرزسشصضطظعغفقلمنهوًٌٍَُِّپچژکگی",
)
