from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

IRISH_LANG_MODEL = {
    25: {  # 'A'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.POSITIVE,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.LIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.LIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.NEGATIVE,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    30: {  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.LIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.LIKELY,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    24: {  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.LIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.LIKELY,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    31: {  # 'D'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.LIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.LIKELY,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    38: {  # 'E'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.LIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    34: {  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.LIKELY,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    32: {  # 'G'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.LIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    44: {  # 'H'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    28: {  # 'I'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        32: SequenceLikelihood.LIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    53: {  # 'J'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.NEGATIVE,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    52: {  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    35: {  # 'L'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.LIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    29: {  # 'M'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.LIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.LIKELY,  # 'é'
        17: SequenceLikelihood.LIKELY,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    33: {  # 'N'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.LIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.LIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    40: {  # 'O'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.LIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.NEGATIVE,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.LIKELY,  # 'í'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        21: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    36: {  # 'P'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.LIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.LIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    62: {  # 'Q'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.NEGATIVE,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.NEGATIVE,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    37: {  # 'R'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.LIKELY,  # 'á'
        19: SequenceLikelihood.LIKELY,  # 'é'
        17: SequenceLikelihood.LIKELY,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    27: {  # 'S'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.LIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.LIKELY,  # 'á'
        19: SequenceLikelihood.LIKELY,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    26: {  # 'T'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        32: SequenceLikelihood.LIKELY,  # 'G'
        44: SequenceLikelihood.LIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.LIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.LIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.LIKELY,  # 'é'
        17: SequenceLikelihood.LIKELY,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    45: {  # 'U'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        33: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.NEGATIVE,  # 'é'
        17: SequenceLikelihood.LIKELY,  # 'í'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        21: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    48: {  # 'V'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.LIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    47: {  # 'W'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.NEGATIVE,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    59: {  # 'X'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.NEGATIVE,  # 'á'
        19: SequenceLikelihood.NEGATIVE,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    58: {  # 'Y'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    61: {  # 'Z'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    1: {  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.LIKELY,  # 'j'
        41: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.POSITIVE,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        39: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    18: {  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        8: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.NEGATIVE,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    10: {  # 'c'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    12: {  # 'd'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    6: {  # 'e'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.POSITIVE,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.POSITIVE,  # 'x'
        39: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    20: {  # 'f'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    13: {  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.POSITIVE,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    4: {  # 'h'
        25: SequenceLikelihood.POSITIVE,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.LIKELY,  # 'Á'
        46: SequenceLikelihood.POSITIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    2: {  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.LIKELY,  # 'j'
        41: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.LIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.POSITIVE,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.LIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    57: {  # 'j'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.NEGATIVE,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    41: {  # 'k'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        4: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        8: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    11: {  # 'l'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    14: {  # 'm'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.POSITIVE,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    3: {  # 'n'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.POSITIVE,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.LIKELY,  # 'j'
        41: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    9: {  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.LIKELY,  # 'j'
        41: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.POSITIVE,  # 'v'
        43: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    23: {  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    60: {  # 'q'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.NEGATIVE,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.NEGATIVE,  # 'á'
        19: SequenceLikelihood.NEGATIVE,  # 'é'
        17: SequenceLikelihood.NEGATIVE,  # 'í'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        21: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    5: {  # 'r'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    7: {  # 's'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.LIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    8: {  # 't'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.POSITIVE,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.POSITIVE,  # 'á'
        19: SequenceLikelihood.POSITIVE,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        21: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    15: {  # 'u'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.LIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.POSITIVE,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    42: {  # 'v'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.LIKELY,  # 'é'
        17: SequenceLikelihood.LIKELY,  # 'í'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    43: {  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    49: {  # 'x'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    39: {  # 'y'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        8: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    50: {  # 'z'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    54: {  # 'Á'
        25: SequenceLikelihood.NEGATIVE,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.NEGATIVE,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        39: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.NEGATIVE,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    46: {  # 'É'
        25: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.NEGATIVE,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.LIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        61: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        20: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.NEGATIVE,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    56: {  # 'Í'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.NEGATIVE,  # 'I'
        53: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        61: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        20: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        4: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        57: SequenceLikelihood.NEGATIVE,  # 'j'
        41: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        39: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.NEGATIVE,  # 'á'
        19: SequenceLikelihood.NEGATIVE,  # 'é'
        17: SequenceLikelihood.NEGATIVE,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    51: {  # 'Ó'
        25: SequenceLikelihood.NEGATIVE,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        20: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        57: SequenceLikelihood.NEGATIVE,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.NEGATIVE,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        8: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        42: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        39: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.NEGATIVE,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.NEGATIVE,  # 'á'
        19: SequenceLikelihood.NEGATIVE,  # 'é'
        17: SequenceLikelihood.NEGATIVE,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    55: {  # 'Ú'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        61: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        20: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        57: SequenceLikelihood.NEGATIVE,  # 'j'
        41: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.NEGATIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        42: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        39: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.NEGATIVE,  # 'á'
        19: SequenceLikelihood.NEGATIVE,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    16: {  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        61: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    19: {  # 'é'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        8: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.NEGATIVE,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.NEGATIVE,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    17: {  # 'í'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        61: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.LIKELY,  # 'ú'
    },
    22: {  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.NEGATIVE,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        61: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.UNLIKELY,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.NEGATIVE,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    21: {  # 'ú'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        32: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        28: SequenceLikelihood.UNLIKELY,  # 'I'
        53: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        35: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        33: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        61: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        4: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        57: SequenceLikelihood.UNLIKELY,  # 'j'
        41: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        3: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        23: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        8: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        42: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        39: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        54: SequenceLikelihood.UNLIKELY,  # 'Á'
        46: SequenceLikelihood.NEGATIVE,  # 'É'
        56: SequenceLikelihood.UNLIKELY,  # 'Í'
        51: SequenceLikelihood.UNLIKELY,  # 'Ó'
        55: SequenceLikelihood.UNLIKELY,  # 'Ú'
        16: SequenceLikelihood.UNLIKELY,  # 'á'
        19: SequenceLikelihood.UNLIKELY,  # 'é'
        17: SequenceLikelihood.UNLIKELY,  # 'í'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        21: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
}

# Character Mapping Table(s):
CP037_IRISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 16,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 19,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 17,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 54,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 46,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 56,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 18,  # 'b'
    131: 10,  # 'c'
    132: 12,  # 'd'
    133: 6,  # 'e'
    134: 20,  # 'f'
    135: 13,  # 'g'
    136: 4,  # 'h'
    137: 2,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 57,  # 'j'
    146: 41,  # 'k'
    147: 11,  # 'l'
    148: 14,  # 'm'
    149: 3,  # 'n'
    150: 9,  # 'o'
    151: 23,  # 'p'
    152: 60,  # 'q'
    153: 5,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 7,  # 's'
    163: 8,  # 't'
    164: 15,  # 'u'
    165: 42,  # 'v'
    166: 43,  # 'w'
    167: 49,  # 'x'
    168: 39,  # 'y'
    169: 50,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 25,  # 'A'
    194: 30,  # 'B'
    195: 24,  # 'C'
    196: 31,  # 'D'
    197: 38,  # 'E'
    198: 34,  # 'F'
    199: 32,  # 'G'
    200: 44,  # 'H'
    201: 28,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 22,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 53,  # 'J'
    210: 52,  # 'K'
    211: 35,  # 'L'
    212: 29,  # 'M'
    213: 33,  # 'N'
    214: 40,  # 'O'
    215: 36,  # 'P'
    216: 62,  # 'Q'
    217: 37,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 0,  # 'ù'
    222: 21,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 27,  # 'S'
    227: 26,  # 'T'
    228: 45,  # 'U'
    229: 48,  # 'V'
    230: 47,  # 'W'
    231: 59,  # 'X'
    232: 58,  # 'Y'
    233: 61,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 51,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 0,  # 'Ù'
    254: 55,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_IRISH_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Irish",
    char_to_order_map=CP037_IRISH_CHAR_TO_ORDER,
    language_model=IRISH_LANG_MODEL,
    typical_positive_ratio=0.9814850489255669,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚáéíóú",
)

CP437_IRISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 30,  # 'B'
    67: 24,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 34,  # 'F'
    71: 32,  # 'G'
    72: 44,  # 'H'
    73: 28,  # 'I'
    74: 53,  # 'J'
    75: 52,  # 'K'
    76: 35,  # 'L'
    77: 29,  # 'M'
    78: 33,  # 'N'
    79: 40,  # 'O'
    80: 36,  # 'P'
    81: 62,  # 'Q'
    82: 37,  # 'R'
    83: 27,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 48,  # 'V'
    87: 47,  # 'W'
    88: 59,  # 'X'
    89: 58,  # 'Y'
    90: 61,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 10,  # 'c'
    100: 12,  # 'd'
    101: 6,  # 'e'
    102: 20,  # 'f'
    103: 13,  # 'g'
    104: 4,  # 'h'
    105: 2,  # 'i'
    106: 57,  # 'j'
    107: 41,  # 'k'
    108: 11,  # 'l'
    109: 14,  # 'm'
    110: 3,  # 'n'
    111: 9,  # 'o'
    112: 23,  # 'p'
    113: 60,  # 'q'
    114: 5,  # 'r'
    115: 7,  # 's'
    116: 8,  # 't'
    117: 15,  # 'u'
    118: 42,  # 'v'
    119: 43,  # 'w'
    120: 49,  # 'x'
    121: 39,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 19,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 46,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 16,  # 'á'
    161: 17,  # 'í'
    162: 22,  # 'ó'
    163: 21,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_IRISH_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Irish",
    char_to_order_map=CP437_IRISH_CHAR_TO_ORDER,
    language_model=IRISH_LANG_MODEL,
    typical_positive_ratio=0.9821278769358992,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚáéíóú",
)

CP500_IRISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 16,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 19,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 17,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 54,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 46,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 56,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 18,  # 'b'
    131: 10,  # 'c'
    132: 12,  # 'd'
    133: 6,  # 'e'
    134: 20,  # 'f'
    135: 13,  # 'g'
    136: 4,  # 'h'
    137: 2,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 57,  # 'j'
    146: 41,  # 'k'
    147: 11,  # 'l'
    148: 14,  # 'm'
    149: 3,  # 'n'
    150: 9,  # 'o'
    151: 23,  # 'p'
    152: 60,  # 'q'
    153: 5,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 7,  # 's'
    163: 8,  # 't'
    164: 15,  # 'u'
    165: 42,  # 'v'
    166: 43,  # 'w'
    167: 49,  # 'x'
    168: 39,  # 'y'
    169: 50,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 25,  # 'A'
    194: 30,  # 'B'
    195: 24,  # 'C'
    196: 31,  # 'D'
    197: 38,  # 'E'
    198: 34,  # 'F'
    199: 32,  # 'G'
    200: 44,  # 'H'
    201: 28,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 22,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 53,  # 'J'
    210: 52,  # 'K'
    211: 35,  # 'L'
    212: 29,  # 'M'
    213: 33,  # 'N'
    214: 40,  # 'O'
    215: 36,  # 'P'
    216: 62,  # 'Q'
    217: 37,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 0,  # 'ù'
    222: 21,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 27,  # 'S'
    227: 26,  # 'T'
    228: 45,  # 'U'
    229: 48,  # 'V'
    230: 47,  # 'W'
    231: 59,  # 'X'
    232: 58,  # 'Y'
    233: 61,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 51,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 0,  # 'Ù'
    254: 55,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_IRISH_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Irish",
    char_to_order_map=CP500_IRISH_CHAR_TO_ORDER,
    language_model=IRISH_LANG_MODEL,
    typical_positive_ratio=0.9814850489255669,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚáéíóú",
)

CP850_IRISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 30,  # 'B'
    67: 24,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 34,  # 'F'
    71: 32,  # 'G'
    72: 44,  # 'H'
    73: 28,  # 'I'
    74: 53,  # 'J'
    75: 52,  # 'K'
    76: 35,  # 'L'
    77: 29,  # 'M'
    78: 33,  # 'N'
    79: 40,  # 'O'
    80: 36,  # 'P'
    81: 62,  # 'Q'
    82: 37,  # 'R'
    83: 27,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 48,  # 'V'
    87: 47,  # 'W'
    88: 59,  # 'X'
    89: 58,  # 'Y'
    90: 61,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 10,  # 'c'
    100: 12,  # 'd'
    101: 6,  # 'e'
    102: 20,  # 'f'
    103: 13,  # 'g'
    104: 4,  # 'h'
    105: 2,  # 'i'
    106: 57,  # 'j'
    107: 41,  # 'k'
    108: 11,  # 'l'
    109: 14,  # 'm'
    110: 3,  # 'n'
    111: 9,  # 'o'
    112: 23,  # 'p'
    113: 60,  # 'q'
    114: 5,  # 'r'
    115: 7,  # 's'
    116: 8,  # 't'
    117: 15,  # 'u'
    118: 42,  # 'v'
    119: 43,  # 'w'
    120: 49,  # 'x'
    121: 39,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 19,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 46,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 16,  # 'á'
    161: 17,  # 'í'
    162: 22,  # 'ó'
    163: 21,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 54,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: 0,  # 'ı'
    214: 56,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 51,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 55,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_IRISH_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Irish",
    char_to_order_map=CP850_IRISH_CHAR_TO_ORDER,
    language_model=IRISH_LANG_MODEL,
    typical_positive_ratio=0.9814850489255669,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚáéíóú",
)

CP858_IRISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 30,  # 'B'
    67: 24,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 34,  # 'F'
    71: 32,  # 'G'
    72: 44,  # 'H'
    73: 28,  # 'I'
    74: 53,  # 'J'
    75: 52,  # 'K'
    76: 35,  # 'L'
    77: 29,  # 'M'
    78: 33,  # 'N'
    79: 40,  # 'O'
    80: 36,  # 'P'
    81: 62,  # 'Q'
    82: 37,  # 'R'
    83: 27,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 48,  # 'V'
    87: 47,  # 'W'
    88: 59,  # 'X'
    89: 58,  # 'Y'
    90: 61,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 10,  # 'c'
    100: 12,  # 'd'
    101: 6,  # 'e'
    102: 20,  # 'f'
    103: 13,  # 'g'
    104: 4,  # 'h'
    105: 2,  # 'i'
    106: 57,  # 'j'
    107: 41,  # 'k'
    108: 11,  # 'l'
    109: 14,  # 'm'
    110: 3,  # 'n'
    111: 9,  # 'o'
    112: 23,  # 'p'
    113: 60,  # 'q'
    114: 5,  # 'r'
    115: 7,  # 's'
    116: 8,  # 't'
    117: 15,  # 'u'
    118: 42,  # 'v'
    119: 43,  # 'w'
    120: 49,  # 'x'
    121: 39,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 19,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 46,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 16,  # 'á'
    161: 17,  # 'í'
    162: 22,  # 'ó'
    163: 21,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 54,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 56,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 51,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 55,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_IRISH_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Irish",
    char_to_order_map=CP858_IRISH_CHAR_TO_ORDER,
    language_model=IRISH_LANG_MODEL,
    typical_positive_ratio=0.9814850489255669,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚáéíóú",
)

ISO_8859_1_IRISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 30,  # 'B'
    67: 24,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 34,  # 'F'
    71: 32,  # 'G'
    72: 44,  # 'H'
    73: 28,  # 'I'
    74: 53,  # 'J'
    75: 52,  # 'K'
    76: 35,  # 'L'
    77: 29,  # 'M'
    78: 33,  # 'N'
    79: 40,  # 'O'
    80: 36,  # 'P'
    81: 62,  # 'Q'
    82: 37,  # 'R'
    83: 27,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 48,  # 'V'
    87: 47,  # 'W'
    88: 59,  # 'X'
    89: 58,  # 'Y'
    90: 61,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 10,  # 'c'
    100: 12,  # 'd'
    101: 6,  # 'e'
    102: 20,  # 'f'
    103: 13,  # 'g'
    104: 4,  # 'h'
    105: 2,  # 'i'
    106: 57,  # 'j'
    107: 41,  # 'k'
    108: 11,  # 'l'
    109: 14,  # 'm'
    110: 3,  # 'n'
    111: 9,  # 'o'
    112: 23,  # 'p'
    113: 60,  # 'q'
    114: 5,  # 'r'
    115: 7,  # 's'
    116: 8,  # 't'
    117: 15,  # 'u'
    118: 42,  # 'v'
    119: 43,  # 'w'
    120: 49,  # 'x'
    121: 39,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 54,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 46,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 56,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 51,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 55,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 16,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 19,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 17,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 22,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 21,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_1_IRISH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Irish",
    char_to_order_map=ISO_8859_1_IRISH_CHAR_TO_ORDER,
    language_model=IRISH_LANG_MODEL,
    typical_positive_ratio=0.9814850489255669,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚáéíóú",
)

ISO_8859_14_IRISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 30,  # 'B'
    67: 24,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 34,  # 'F'
    71: 32,  # 'G'
    72: 44,  # 'H'
    73: 28,  # 'I'
    74: 53,  # 'J'
    75: 52,  # 'K'
    76: 35,  # 'L'
    77: 29,  # 'M'
    78: 33,  # 'N'
    79: 40,  # 'O'
    80: 36,  # 'P'
    81: 62,  # 'Q'
    82: 37,  # 'R'
    83: 27,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 48,  # 'V'
    87: 47,  # 'W'
    88: 59,  # 'X'
    89: 58,  # 'Y'
    90: 61,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 10,  # 'c'
    100: 12,  # 'd'
    101: 6,  # 'e'
    102: 20,  # 'f'
    103: 13,  # 'g'
    104: 4,  # 'h'
    105: 2,  # 'i'
    106: 57,  # 'j'
    107: 41,  # 'k'
    108: 11,  # 'l'
    109: 14,  # 'm'
    110: 3,  # 'n'
    111: 9,  # 'o'
    112: 23,  # 'p'
    113: 60,  # 'q'
    114: 5,  # 'r'
    115: 7,  # 's'
    116: 8,  # 't'
    117: 15,  # 'u'
    118: 42,  # 'v'
    119: 43,  # 'w'
    120: 49,  # 'x'
    121: 39,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ḃ'
    162: 0,  # 'ḃ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: 0,  # 'Ċ'
    165: 0,  # 'ċ'
    166: 0,  # 'Ḋ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ẁ'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ẃ'
    171: 0,  # 'ḋ'
    172: 0,  # 'Ỳ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ÿ'
    176: 0,  # 'Ḟ'
    177: 0,  # 'ḟ'
    178: 0,  # 'Ġ'
    179: 0,  # 'ġ'
    180: 0,  # 'Ṁ'
    181: 0,  # 'ṁ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: 0,  # 'Ṗ'
    184: 0,  # 'ẁ'
    185: 0,  # 'ṗ'
    186: 0,  # 'ẃ'
    187: 0,  # 'Ṡ'
    188: 0,  # 'ỳ'
    189: 0,  # 'Ẅ'
    190: 0,  # 'ẅ'
    191: 0,  # 'ṡ'
    192: 0,  # 'À'
    193: 54,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 46,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 56,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ŵ'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 51,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: 0,  # 'Ṫ'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 55,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Ŷ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 16,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 19,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 17,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ŵ'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 22,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: 0,  # 'ṫ'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 21,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'ŷ'
    255: 0,  # 'ÿ'
}

ISO_8859_14_IRISH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-14",
    language="Irish",
    char_to_order_map=ISO_8859_14_IRISH_CHAR_TO_ORDER,
    language_model=IRISH_LANG_MODEL,
    typical_positive_ratio=0.9814850489255669,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚáéíóú",
)

ISO_8859_15_IRISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 30,  # 'B'
    67: 24,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 34,  # 'F'
    71: 32,  # 'G'
    72: 44,  # 'H'
    73: 28,  # 'I'
    74: 53,  # 'J'
    75: 52,  # 'K'
    76: 35,  # 'L'
    77: 29,  # 'M'
    78: 33,  # 'N'
    79: 40,  # 'O'
    80: 36,  # 'P'
    81: 62,  # 'Q'
    82: 37,  # 'R'
    83: 27,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 48,  # 'V'
    87: 47,  # 'W'
    88: 59,  # 'X'
    89: 58,  # 'Y'
    90: 61,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 10,  # 'c'
    100: 12,  # 'd'
    101: 6,  # 'e'
    102: 20,  # 'f'
    103: 13,  # 'g'
    104: 4,  # 'h'
    105: 2,  # 'i'
    106: 57,  # 'j'
    107: 41,  # 'k'
    108: 11,  # 'l'
    109: 14,  # 'm'
    110: 3,  # 'n'
    111: 9,  # 'o'
    112: 23,  # 'p'
    113: 60,  # 'q'
    114: 5,  # 'r'
    115: 7,  # 's'
    116: 8,  # 't'
    117: 15,  # 'u'
    118: 42,  # 'v'
    119: 43,  # 'w'
    120: 49,  # 'x'
    121: 39,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 54,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 46,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 56,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 51,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 55,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 16,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 19,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 17,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 22,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 21,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_15_IRISH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Irish",
    char_to_order_map=ISO_8859_15_IRISH_CHAR_TO_ORDER,
    language_model=IRISH_LANG_MODEL,
    typical_positive_ratio=0.9814850489255669,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚáéíóú",
)

MACROMAN_IRISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 30,  # 'B'
    67: 24,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 34,  # 'F'
    71: 32,  # 'G'
    72: 44,  # 'H'
    73: 28,  # 'I'
    74: 53,  # 'J'
    75: 52,  # 'K'
    76: 35,  # 'L'
    77: 29,  # 'M'
    78: 33,  # 'N'
    79: 40,  # 'O'
    80: 36,  # 'P'
    81: 62,  # 'Q'
    82: 37,  # 'R'
    83: 27,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 48,  # 'V'
    87: 47,  # 'W'
    88: 59,  # 'X'
    89: 58,  # 'Y'
    90: 61,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 10,  # 'c'
    100: 12,  # 'd'
    101: 6,  # 'e'
    102: 20,  # 'f'
    103: 13,  # 'g'
    104: 4,  # 'h'
    105: 2,  # 'i'
    106: 57,  # 'j'
    107: 41,  # 'k'
    108: 11,  # 'l'
    109: 14,  # 'm'
    110: 3,  # 'n'
    111: 9,  # 'o'
    112: 23,  # 'p'
    113: 60,  # 'q'
    114: 5,  # 'r'
    115: 7,  # 's'
    116: 8,  # 't'
    117: 15,  # 'u'
    118: 42,  # 'v'
    119: 43,  # 'w'
    120: 49,  # 'x'
    121: 39,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 0,  # 'Ç'
    131: 46,  # 'É'
    132: 0,  # 'Ñ'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 16,  # 'á'
    136: 0,  # 'à'
    137: 0,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 0,  # 'ç'
    142: 19,  # 'é'
    143: 0,  # 'è'
    144: 0,  # 'ê'
    145: 0,  # 'ë'
    146: 17,  # 'í'
    147: 0,  # 'ì'
    148: 0,  # 'î'
    149: 0,  # 'ï'
    150: 0,  # 'ñ'
    151: 22,  # 'ó'
    152: 0,  # 'ò'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 21,  # 'ú'
    157: 0,  # 'ù'
    158: 0,  # 'û'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 0,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 0,  # 'Â'
    230: 0,  # 'Ê'
    231: 54,  # 'Á'
    232: 0,  # 'Ë'
    233: 0,  # 'È'
    234: 56,  # 'Í'
    235: 0,  # 'Î'
    236: 0,  # 'Ï'
    237: 0,  # 'Ì'
    238: 51,  # 'Ó'
    239: 0,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 55,  # 'Ú'
    243: 0,  # 'Û'
    244: 0,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_IRISH_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Irish",
    char_to_order_map=MACROMAN_IRISH_CHAR_TO_ORDER,
    language_model=IRISH_LANG_MODEL,
    typical_positive_ratio=0.9814850489255669,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚáéíóú",
)

WINDOWS_1252_IRISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 30,  # 'B'
    67: 24,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 34,  # 'F'
    71: 32,  # 'G'
    72: 44,  # 'H'
    73: 28,  # 'I'
    74: 53,  # 'J'
    75: 52,  # 'K'
    76: 35,  # 'L'
    77: 29,  # 'M'
    78: 33,  # 'N'
    79: 40,  # 'O'
    80: 36,  # 'P'
    81: 62,  # 'Q'
    82: 37,  # 'R'
    83: 27,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 48,  # 'V'
    87: 47,  # 'W'
    88: 59,  # 'X'
    89: 58,  # 'Y'
    90: 61,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 10,  # 'c'
    100: 12,  # 'd'
    101: 6,  # 'e'
    102: 20,  # 'f'
    103: 13,  # 'g'
    104: 4,  # 'h'
    105: 2,  # 'i'
    106: 57,  # 'j'
    107: 41,  # 'k'
    108: 11,  # 'l'
    109: 14,  # 'm'
    110: 3,  # 'n'
    111: 9,  # 'o'
    112: 23,  # 'p'
    113: 60,  # 'q'
    114: 5,  # 'r'
    115: 7,  # 's'
    116: 8,  # 't'
    117: 15,  # 'u'
    118: 42,  # 'v'
    119: 43,  # 'w'
    120: 49,  # 'x'
    121: 39,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 54,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 46,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 56,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 51,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 55,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 16,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 19,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 17,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 22,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 21,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

WINDOWS_1252_IRISH_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Irish",
    char_to_order_map=WINDOWS_1252_IRISH_CHAR_TO_ORDER,
    language_model=IRISH_LANG_MODEL,
    typical_positive_ratio=0.9814850489255669,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚáéíóú",
)
