/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.tomcat.util.res.StringManager;

public class KeyedReentrantReadWriteLock {
    private final Map<String, CountedLock> locksMap = new HashMap<String, CountedLock>();

    public ReadWriteLock getLock(String string) {
        return new ReadWriteLockImpl(this.locksMap, string);
    }

    private static class ReadWriteLockImpl
    implements ReadWriteLock {
        private final Map<String, CountedLock> locksMap;
        private final String key;
        private volatile Lock readLock;
        private volatile Lock writeLock;

        ReadWriteLockImpl(Map<String, CountedLock> map, String string) {
            this.locksMap = map;
            this.key = string;
        }

        @Override
        public Lock readLock() {
            if (this.readLock == null) {
                this.readLock = new LockImpl(this.locksMap, this.key, ReentrantReadWriteLock::readLock);
            }
            return this.readLock;
        }

        @Override
        public Lock writeLock() {
            if (this.writeLock == null) {
                this.writeLock = new LockImpl(this.locksMap, this.key, ReentrantReadWriteLock::writeLock);
            }
            return this.writeLock;
        }
    }

    private static class CountedLock {
        AtomicInteger count = new AtomicInteger();
        ReentrantReadWriteLock reentrantLock = new ReentrantReadWriteLock();

        private CountedLock() {
        }
    }

    private static class LockImpl
    implements Lock {
        private static final StringManager sm = StringManager.getManager(LockImpl.class);
        private final Map<String, CountedLock> locksMap;
        private final String key;
        private final Function<ReentrantReadWriteLock, Lock> function;

        LockImpl(Map<String, CountedLock> map, String string, Function<ReentrantReadWriteLock, Lock> function) {
            this.locksMap = map;
            this.key = string;
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            CountedLock countedLock2 = null;
            Map<String, CountedLock> map = this.locksMap;
            synchronized (map) {
                countedLock2 = this.locksMap.compute(this.key, (string, countedLock) -> countedLock == null ? new CountedLock() : countedLock);
                countedLock2.count.incrementAndGet();
            }
            this.function.apply(countedLock2.reentrantLock).lock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            CountedLock countedLock = null;
            Map<String, CountedLock> map = this.locksMap;
            synchronized (map) {
                countedLock = this.locksMap.get(this.key);
            }
            if (countedLock == null) {
                throw new IllegalStateException(sm.getString("lockImpl.unlockWithoutLock"));
            }
            this.function.apply(countedLock.reentrantLock).unlock();
            map = this.locksMap;
            synchronized (map) {
                if (countedLock.count.decrementAndGet() == 0) {
                    this.locksMap.remove(this.key);
                }
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

